/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.natives;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import oracle.ide.natives.DirectoryWatcher;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFileSystem;

public class FileWatcher {
    private URL _fileURL;
    private String _filename;
    private FileListener _listener;
    private boolean _active;
    private static final boolean DEBUG_VERBOSE = false;
    static Object WATCH_LOCK = DirectoryWatcher.WATCH_LOCK;
    private static List _watchEntryList = new ArrayList();

    public static FileWatcher createFileWatcher(URL uRL, FileListener fileListener) {
        return FileWatcher.createFileWatcherImpl(uRL, fileListener);
    }

    public static void destroyFileWatcher(FileWatcher fileWatcher) {
        FileWatcher.destroyFileWatcherImpl(fileWatcher);
    }

    private FileWatcher(URL uRL, String string, FileListener fileListener) {
        this._fileURL = uRL;
        this._filename = string;
        this._listener = fileListener;
        this._active = true;
    }

    public URL getFileURL() {
        return this._fileURL;
    }

    public String getFileName() {
        return this._filename;
    }

    public boolean isActive() {
        return this._active;
    }

    public String toString() {
        String string = URLFileSystem.getPlatformPathName(this.getFileURL());
        return "FW: " + string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static FileWatcher createFileWatcherImpl(URL uRL, FileListener fileListener) {
        if (uRL == null) {
            return null;
        }
        URL uRL2 = uRL;
        while (JarUtil.isJarURL(uRL2)) {
            uRL2 = FileWatcher.getFileURLFor(uRL2);
        }
        URL uRL3 = FileWatcher.getRootURLFor(uRL2);
        if (!"file".equals(uRL2.getProtocol())) {
            return null;
        }
        Object object = WATCH_LOCK;
        synchronized (object) {
            WatchEntry watchEntry = FileWatcher.findWatchEntry(uRL3);
            if (watchEntry == null) {
                WatchEntry watchEntry2 = new WatchEntry(new ArrayList(), uRL3, null);
                DirectoryWatcher directoryWatcher = DirectoryWatcher.createDirectoryWatcherImpl(uRL3, false, watchEntry2);
                if (directoryWatcher == null) {
                    FileWatcher fileWatcher = null;
                    return fileWatcher;
                }
                WatchEntry.wa$dirWatcher(watchEntry2, directoryWatcher);
                watchEntry = watchEntry2;
                _watchEntryList.add(watchEntry);
            }
            String string = URLFileSystem.getFileName(uRL2);
            FileWatcher fileWatcher = new FileWatcher(uRL, string, fileListener);
            WatchEntry.ra$watchers(watchEntry).add(fileWatcher);
            FileWatcher fileWatcher2 = fileWatcher;
            return fileWatcher2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void destroyFileWatcherImpl(FileWatcher fileWatcher) {
        Object object = WATCH_LOCK;
        synchronized (object) {
            fileWatcher._active = false;
            URL uRL = FileWatcher.getRootURLFor(fileWatcher.getFileURL());
            WatchEntry watchEntry = FileWatcher.findWatchEntry(uRL);
            if (watchEntry != null) {
                WatchEntry.ra$watchers(watchEntry).remove(fileWatcher);
                if (WatchEntry.ra$watchers(watchEntry).size() == 0) {
                    _watchEntryList.remove(watchEntry);
                    DirectoryWatcher.destroyDirectoryWatcher(WatchEntry.ra$dirWatcher(watchEntry));
                }
            }
        }
    }

    private static URL getFileURLFor(URL uRL) {
        if (JarUtil.isJarURL(uRL)) {
            return JarUtil.getJarFileURL(uRL);
        }
        return uRL;
    }

    private static URL getRootURLFor(URL uRL) {
        URL uRL2 = FileWatcher.getFileURLFor(uRL);
        return URLFileSystem.getParent(uRL2);
    }

    private static WatchEntry findWatchEntry(DirectoryWatcher directoryWatcher) {
        int n = _watchEntryList.size();
        int n2 = 0;
        while (n2 < n) {
            WatchEntry watchEntry = (WatchEntry)_watchEntryList.get(n2);
            if (watchEntry != null && WatchEntry.ra$dirWatcher(watchEntry) == directoryWatcher) {
                return watchEntry;
            }
            ++n2;
        }
        return null;
    }

    private static WatchEntry findWatchEntry(URL uRL) {
        int n = _watchEntryList.size();
        int n2 = 0;
        while (n2 < n) {
            WatchEntry watchEntry = (WatchEntry)_watchEntryList.get(n2);
            if (watchEntry != null && WatchEntry.ra$rootURL(watchEntry).equals(uRL)) {
                return watchEntry;
            }
            ++n2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fireWatchEvent(WatchEntry watchEntry, DirectoryWatcher.DirectoryEvent directoryEvent) {
        ArrayList<FileListener> arrayList = new ArrayList<FileListener>();
        ArrayList<FileEvent> arrayList2 = new ArrayList<FileEvent>();
        Object object = WATCH_LOCK;
        synchronized (object) {
            String string = directoryEvent.getFileName();
            String string2 = directoryEvent.getOldFileName();
            int n = WatchEntry.ra$watchers(watchEntry).size();
            int n2 = 0;
            while (n2 < n) {
                FileWatcher fileWatcher = (FileWatcher)WatchEntry.ra$watchers(watchEntry).get(n2);
                String string3 = fileWatcher.getFileName();
                int n3 = -1;
                int n4 = directoryEvent.getEventType();
                switch (n4) {
                    case 1: 
                    case 2: 
                    case 3: {
                        if (!string.equals(string3)) break;
                        n3 = n4;
                        break;
                    }
                    case 4: {
                        if (string.equals(string3)) {
                            n3 = 1;
                            break;
                        }
                        if (!string2.equals(string3)) break;
                        n3 = 2;
                    }
                }
                if (n3 != -1) {
                    FileWatcher fileWatcher2 = fileWatcher;
                    fileWatcher2.getClass();
                    FileEvent fileEvent = fileWatcher2.new FileEvent(n3, null);
                    FileListener fileListener = fileWatcher._listener;
                    arrayList2.add(fileEvent);
                    arrayList.add(fileListener);
                }
                ++n2;
            }
        }
        int n = arrayList.size();
        int n5 = 0;
        while (n5 < n) {
            FileListener fileListener = (FileListener)arrayList.get(n5);
            FileEvent fileEvent = (FileEvent)arrayList2.get(n5);
            if (fileListener != null && fileEvent != null) {
                try {
                    fileListener.fileUpdate(fileEvent);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
            ++n5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fireCancelledEvent(WatchEntry watchEntry, DirectoryWatcher.DirectoryEvent directoryEvent) {
        ArrayList<FileListener> arrayList = new ArrayList<FileListener>();
        ArrayList<FileEvent> arrayList2 = new ArrayList<FileEvent>();
        Object object = WATCH_LOCK;
        synchronized (object) {
            int n = WatchEntry.ra$watchers(watchEntry).size();
            int n2 = 0;
            while (n2 < n) {
                FileWatcher fileWatcher = (FileWatcher)WatchEntry.ra$watchers(watchEntry).get(n2);
                fileWatcher._active = false;
                FileWatcher fileWatcher2 = fileWatcher;
                fileWatcher2.getClass();
                FileEvent fileEvent = fileWatcher2.new FileEvent(15, null);
                FileListener fileListener = fileWatcher._listener;
                arrayList2.add(fileEvent);
                arrayList.add(fileListener);
                ++n2;
            }
            _watchEntryList.remove(watchEntry);
        }
        int n = arrayList.size();
        int n3 = 0;
        while (n3 < n) {
            FileListener fileListener = (FileListener)arrayList.get(n3);
            FileEvent fileEvent = (FileEvent)arrayList2.get(n3);
            if (fileListener != null && fileEvent != null) {
                try {
                    fileListener.watchCancelled(fileEvent);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
            ++n3;
        }
    }

    static void maS$fireCancelledEvent(WatchEntry watchEntry, DirectoryWatcher.DirectoryEvent directoryEvent) {
        FileWatcher.fireCancelledEvent(watchEntry, directoryEvent);
    }

    static void maS$fireWatchEvent(WatchEntry watchEntry, DirectoryWatcher.DirectoryEvent directoryEvent) {
        FileWatcher.fireWatchEvent(watchEntry, directoryEvent);
    }

    public class FileEvent {
        public static final int FILE_ADDED = 1;
        public static final int FILE_REMOVED = 2;
        public static final int FILE_MODIFIED = 3;
        public static final int WATCH_CANCELLED = 15;
        private int _type;

        private FileEvent(int n) {
            this._type = n;
        }

        public int getEventType() {
            return this._type;
        }

        public FileWatcher getFileWatcher() {
            return FileWatcher.this;
        }

        public URL getFileURL() {
            return this.getFileWatcher().getFileURL();
        }

        FileEvent(int n, 1 var3_3) {
            this(n);
        }

        public final class 1 {
        }
    }

    public static interface FileListener {
        public void fileUpdate(FileEvent var1);

        public void watchCancelled(FileEvent var1);
    }

    private static class WatchEntry
    implements DirectoryWatcher.DirectoryListener {
        private List watchers;
        private URL rootURL;
        private DirectoryWatcher dirWatcher;

        private WatchEntry(List list, URL uRL) {
            this.watchers = list;
            this.rootURL = uRL;
        }

        public void directoryUpdate(DirectoryWatcher.DirectoryEvent directoryEvent) {
            FileWatcher.maS$fireWatchEvent(this, directoryEvent);
        }

        public void watchCancelled(DirectoryWatcher.DirectoryEvent directoryEvent) {
            FileWatcher.maS$fireCancelledEvent(this, directoryEvent);
        }

        static List ra$watchers(WatchEntry watchEntry) {
            return watchEntry.watchers;
        }

        static URL ra$rootURL(WatchEntry watchEntry) {
            return watchEntry.rootURL;
        }

        static DirectoryWatcher ra$dirWatcher(WatchEntry watchEntry) {
            return watchEntry.dirWatcher;
        }

        WatchEntry(List list, URL uRL, 1 var3_3) {
            this(list, uRL);
        }

        static void wa$dirWatcher(WatchEntry watchEntry, DirectoryWatcher directoryWatcher) {
            watchEntry.dirWatcher = directoryWatcher;
        }

        public final class 1 {
        }
    }
}

