/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.natives;

import java.io.File;
import oracle.ide.Addin;
import oracle.ide.Ide;
import oracle.ide.natives.OpenDocumentException;
import oracle.ide.natives.registry.Registry;
import oracle.ide.natives.registry.RegistryNotAvailableException;
import oracle.ide.net.FileNativeHelper;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.AddinPolicyUtils;

public class NativeHandler
implements Addin {
    private static final String LIBNAME = "jdevnative";
    private static boolean isLoaded;
    private static long hiPerfFreq;
    private static String _libDirectory;
    private static WatchListener _watchListener;
    static final int FILE_ADDED = 1;
    static final int FILE_REMOVED = 2;
    static final int FILE_MODIFIED = 3;
    static final int FILE_RENAMED_OLD = 4;
    static final int FILE_RENAMED_NEW = 5;

    static {
        hiPerfFreq = 0L;
        _libDirectory = null;
        _watchListener = null;
    }

    public static native URLFileSystem.FileInfo[] ls(File var0);

    private static native long GetHiPerfTick();

    private static native long GetHiPerfFreq();

    private native void installHandler();

    private native void uninstallHandler();

    private static native void openDocumentImpl(String var0);

    public static native boolean makeFileWriteable(String var0);

    public static long getHiPerfTick() {
        if (isLoaded) {
            return NativeHandler.GetHiPerfTick();
        }
        return System.currentTimeMillis();
    }

    public static long getHiPerfFreq() {
        if (isLoaded) {
            if (hiPerfFreq > 0L) {
                return hiPerfFreq;
            }
            return NativeHandler.GetHiPerfFreq();
        }
        return 1000L;
    }

    public static boolean isLoaded() {
        return isLoaded;
    }

    public static Registry getRegistry() throws RegistryNotAvailableException {
        if (!isLoaded) {
            throw new RegistryNotAvailableException();
        }
        return new Registry();
    }

    public static void openDocument(String string) throws OpenDocumentException {
        if (!isLoaded) {
            throw new UnsupportedOperationException();
        }
        NativeHandler.openDocumentImpl(string);
    }

    static void setLibDirectory(String string) {
        _libDirectory = string;
    }

    public void initialize() {
        String string = _libDirectory != null ? _libDirectory : Ide.getLibDirectory();
        String string2 = System.mapLibraryName(string + LIBNAME);
        try {
            System.load(string2);
            isLoaded = true;
            FileNativeHelper.setFileNativeHelper(new 2());
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
    }

    static native void enterWatcherThread();

    static synchronized void startWatcherThread(WatchListener watchListener) {
        if (_watchListener != null) {
            throw new IllegalStateException("watch listener already set");
        }
        _watchListener = watchListener;
        1 var1_1 = new 1();
        boolean bl = AddinPolicyUtils.setWarnWhenCreatingThreads(false);
        Thread thread = new Thread((Runnable)var1_1, "Native Directory Watcher");
        AddinPolicyUtils.setWarnWhenCreatingThreads(bl);
        thread.setPriority(1);
        thread.start();
    }

    static native void stopWatcherThread();

    static native boolean isWatcherThreadRunning();

    static native int startDirectoryWatch(String var0, boolean var1);

    static native void stopDirectoryWatch(String var0, int var1);

    static void notifyWatchEvent(int n, int n2, String string) {
        if (_watchListener != null) {
            _watchListener.notifyWatchEvent(n, n2, string);
        }
    }

    static void notifyWatchEnded(int n) {
        if (_watchListener != null) {
            _watchListener.notifyWatchEnded(n);
        }
    }

    public final class 2
    extends FileNativeHelper {
        public boolean isLoaded() {
            return NativeHandler.isLoaded();
        }

        public URLFileSystem.FileInfo[] ls(File file) {
            return NativeHandler.ls(file);
        }
    }

    public static final class 1
    implements Runnable {
        public void run() {
            NativeHandler.enterWatcherThread();
        }
    }

    public static interface WatchListener {
        public void notifyWatchEvent(int var1, int var2, String var3);

        public void notifyWatchEnded(int var1);
    }
}

