/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.navigation;

import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.TooManyListenersException;
import javax.swing.Icon;
import oracle.ide.Context;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorAddin;
import oracle.ide.editor.EditorInfo;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.navigation.EditorNavigationPoint;
import oracle.ide.navigation.NavigationPointEvent;
import oracle.ide.navigation.NavigationPointListener;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.ContextHolder;
import oracle.ide.util.ContextWatcher;
import oracle.ide.view.View;

public class DefaultNavigationPoint
implements ContextHolder,
EditorNavigationPoint {
    protected URL nodeURL;
    protected URL prjURL;
    protected URL wspURL;
    protected Class viewClass;
    protected String viewID;
    protected boolean done;
    private NavigationPointListener listener;

    public final int navigate() throws Exception {
        if (!this.done) {
            return this.navigateImpl();
        }
        return this.renavigate();
    }

    public void refresh() {
    }

    public Context getContext() {
        EditorInfo editorInfo = DefaultNavigationPoint.findEditorInfo(this.viewID, this.nodeURL);
        Context context = Context.newIdeContext();
        try {
            context.setNode(NodeFactory.findOrCreate(this.nodeURL));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            context.setProject((Project)NodeFactory.findOrCreate(this.prjURL));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            context.setWorkspace((Workspace)NodeFactory.findOrCreate(this.wspURL));
        }
        catch (Exception exception) {
            // empty catch block
        }
        context.setView(editorInfo != null ? editorInfo._getEditor() : null);
        return context;
    }

    public void setContext(Context context) {
        if (this.nodeURL != null || this.prjURL != null || this.wspURL != null) {
            ContextWatcher.stopWatching(this);
        }
        if (context != null) {
            Node node = context.getNode();
            Project project = context.getProject();
            Workspace workspace = context.getWorkspace();
            View view = context.getView();
            this.nodeURL = node != null ? node.getURL() : null;
            this.prjURL = project != null ? project.getURL() : null;
            this.wspURL = workspace != null ? workspace.getURL() : null;
            this.viewClass = view != null ? view.getClass() : null;
            String string = this.viewID = view != null ? view.getId() : null;
        }
        if (this.nodeURL != null || this.prjURL != null || this.wspURL != null) {
            ContextWatcher.startWatching(this);
        }
    }

    public Object copyTo(Object object) {
        DefaultNavigationPoint defaultNavigationPoint = object != null ? (DefaultNavigationPoint)object : new DefaultNavigationPoint();
        this.copyToImpl(defaultNavigationPoint);
        return defaultNavigationPoint;
    }

    protected final void copyToImpl(DefaultNavigationPoint defaultNavigationPoint) {
        defaultNavigationPoint.nodeURL = this.nodeURL;
        defaultNavigationPoint.prjURL = this.prjURL;
        defaultNavigationPoint.wspURL = this.wspURL;
        defaultNavigationPoint.viewClass = this.viewClass;
        defaultNavigationPoint.viewID = this.viewID;
        defaultNavigationPoint.done = this.done;
    }

    public String toString() {
        Node node = null;
        if (this.nodeURL != null) {
            try {
                node = NodeFactory.findOrCreate(this.nodeURL);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return node != null ? node.getShortLabel() : IdeArb.getString(437);
    }

    public String getShortLabel() {
        return this.toString();
    }

    public String getLongLabel() {
        StringBuffer stringBuffer = new StringBuffer(this.getShortLabel());
        if (this.viewClass != null && Editor.class.isAssignableFrom(this.viewClass)) {
            EditorAddin editorAddin;
            EditorManager editorManager = EditorManager.getEditorManager();
            EditorAddin editorAddin2 = editorAddin = editorManager != null ? editorManager.getEditorAddin(this.viewClass) : null;
            if (editorAddin != null) {
                stringBuffer.append(" [");
                stringBuffer.append(editorAddin.getMenuSpecification().label);
                stringBuffer.append("]");
            }
        }
        return stringBuffer.toString();
    }

    public Icon getIcon() {
        Node node = null;
        if (this.nodeURL != null) {
            try {
                node = NodeFactory.findOrCreate(this.nodeURL);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return node != null ? node.getIcon() : null;
    }

    public String getToolTipText() {
        return this.getLongLabel();
    }

    public void addNavigationPointListener(NavigationPointListener navigationPointListener) throws TooManyListenersException {
        if (this.listener != null && navigationPointListener != null && navigationPointListener != this.listener) {
            throw new TooManyListenersException();
        }
        this.listener = navigationPointListener;
    }

    public void removeNavigationPointListener(NavigationPointListener navigationPointListener) {
        if (navigationPointListener == this.listener) {
            this.listener = null;
        }
    }

    protected void fireExpired(NavigationPointEvent navigationPointEvent) {
        if (this.listener != null) {
            this.listener.expired(navigationPointEvent);
        }
    }

    protected void fireDescriptionChanged(NavigationPointEvent navigationPointEvent) {
        if (this.listener != null) {
            this.listener.descriptionChanged(navigationPointEvent);
        }
    }

    protected int navigateImpl() throws Exception {
        this.done = true;
        return 0;
    }

    protected int renavigate() throws Exception {
        Editor editor;
        EditorInfo editorInfo = DefaultNavigationPoint.findEditorInfo(this.viewID, this.nodeURL);
        Editor editor2 = editor = editorInfo != null ? editorInfo._getEditor() : null;
        if (editor == null) {
            if (this.viewClass != null) {
                EditorManager editorManager = EditorManager.getEditorManager();
                Editor editor3 = editor = editorManager != null ? editorManager.openEditorInFrame(this.viewClass, this.getContext()) : null;
            }
            if (editor != null) {
                this.viewClass = editor.getClass();
                this.viewID = editor.getId();
                this.fireDescriptionChanged(new NavigationPointEvent(this));
                return 0;
            }
        } else {
            EditorManager editorManager = EditorManager.getEditorManager();
            if (editorManager != null) {
                editorManager.activateEditor(editorInfo);
                return 0;
            }
        }
        return 1;
    }

    protected static final EditorInfo findEditorInfo(String string, URL uRL) {
        Iterator iterator;
        if (string == null) {
            return null;
        }
        EditorManager editorManager = EditorManager.getEditorManager();
        List list = editorManager != null ? editorManager.getEditorsInfo() : null;
        Iterator iterator2 = iterator = list != null ? list.iterator() : null;
        if (iterator != null) {
            while (iterator.hasNext()) {
                EditorInfo editorInfo = (EditorInfo)iterator.next();
                Editor editor = editorInfo._getEditor();
                if (editor == null || !editor.getId().equals(string)) continue;
                Context context = editor.getContext();
                Node node = context.getNode();
                if (!URLFileSystem.equals(node.getURL(), uRL)) {
                    return null;
                }
                return editorInfo;
            }
        }
        return null;
    }

    public void nodeRenamed(Context context) {
        URL uRL;
        Node node = context != null ? context.getNode() : null;
        this.nodeURL = uRL = node != null ? node.getURL() : null;
        this.fireDescriptionChanged(new NavigationPointEvent(this));
    }

    public void projectRenamed(Context context) {
        URL uRL;
        Project project = context != null ? context.getProject() : null;
        this.prjURL = uRL = project != null ? project.getURL() : null;
    }

    public void workspaceRenamed(Context context) {
        URL uRL;
        Workspace workspace = context != null ? context.getWorkspace() : null;
        this.wspURL = uRL = workspace != null ? workspace.getURL() : null;
    }

    public void contextRemoved() {
        this.fireExpired(new NavigationPointEvent(this));
    }
}

