/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.navigator;

import java.awt.Component;
import java.awt.Frame;
import java.net.URL;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.spinBox.NumericSpinBox;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.cmd.AddContentCommand;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.IdeActions;
import oracle.ide.controller.MenuManager;
import oracle.ide.controls.Toolbar;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.ContentSet;
import oracle.ide.model.ContentSetHelper;
import oracle.ide.model.ContentSetProvider;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.RelativeDirectoryContextFolder;
import oracle.ide.model.Workspace;
import oracle.ide.model.panels.ProjectContentNavigable;
import oracle.ide.model.panels.ProjectPropertiesDialog;
import oracle.ide.navigator.NavigatorInit;
import oracle.ide.navigator.NavigatorInitFactory;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.navigator.ProjectNavigatorManager;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.IdeIcons;
import oracle.ide.resource.ModelArb;
import oracle.ide.resource.NavigatorArb;
import oracle.ide.resource.PanelsArb;
import oracle.ide.util.PropertyAccess;
import oracle.javatools.dialogs.MessageDialog;

public final class ContentSetSupport
extends NavigatorInit
implements Controller {
    public static final int ADD_URL_TO_PROJECT_CMD_ID = Ide.findOrCreateCmdID("ContentSetSupport.ADD_FILE_TO_PROJECT_CMD_ID");
    public static final int ADD_TO_PROJECT_CMD_ID = Ide.findOrCreateCmdID("ContentSetSupport.ADD_TO_PROJECT_CMD_ID");
    private static final String TOGGLE_DIRS_CMD = "ContentSetSupport.toggleDirs";
    private static final int TOGGLE_DIRS_CMD_ID = Ide.findOrCreateCmdID("ContentSetSupport.toggleDirs");
    private static IdeAction _toggleDirsAction;
    private static final boolean DEFAULT_SHOW_DIRS = false;
    private boolean _showDirs;
    private final NumericSpinBox _spinFlatLevel;
    private static final int DEFAULT_FLAT_LEVEL = 3;
    private int _flatLevel;
    private static final String TOGGLE_SORT_BY_TYPE_CMD = "ContentSetSupport.sortByType";
    private static final int TOGGLE_SORT_BY_TYPE_CMD_ID;
    private static IdeAction _toggleSortByTypeAction;
    private static final boolean DEFAULT_SORT_BY_TYPE = false;
    private boolean _sortByType;
    private static IdeAction _addFileToProjectAction;

    static {
        TOGGLE_SORT_BY_TYPE_CMD_ID = Ide.findOrCreateCmdID(TOGGLE_SORT_BY_TYPE_CMD);
    }

    void $init$() {
        this._showDirs = false;
        this._spinFlatLevel = new NumericSpinBox(0, 99);
        this._flatLevel = 3;
        this._sortByType = false;
    }

    public static void init(ProjectNavigatorManager projectNavigatorManager) {
        ContentSetSupport.maybeInitToggleDirsAction();
        ContentSetSupport.maybeInitToggleSortByTypeAction();
        projectNavigatorManager.addNavigatorInit(new NavigatorInitFactory(ContentSetSupport.class));
    }

    ContentSetSupport(NavigatorWindow navigatorWindow, Context context) {
        super(navigatorWindow, context);
        this.$init$();
        this._spinFlatLevel.setBorder(UIManager.getDefaults().getBorder("TextField.border"));
        this._spinFlatLevel.setIntValue(3);
        ContentSetSupport.setToolTipText((JComponent)this._spinFlatLevel, NavigatorArb.getString(0));
        this._spinFlatLevel.setToolTipText(NavigatorArb.getString(0));
        this._spinFlatLevel.addChangeListener((ChangeListener)new 4());
    }

    public void loadPreferences(PropertyAccess propertyAccess) {
        int n = ContentSetSupport.str2Int(propertyAccess, "flat-level", 3);
        this._spinFlatLevel.setIntValue(n);
        this._showDirs = ContentSetSupport.str2Boolean(propertyAccess, "show-root-dirs", false);
        this._sortByType = ContentSetSupport.str2Boolean(propertyAccess, "sort-by-type", false);
    }

    public void savePreferences(PropertyAccess propertyAccess) {
        ContentSetSupport.int2Str(propertyAccess, "flat-level", this._flatLevel);
        ContentSetSupport.boolean2Str(propertyAccess, "show-root-dirs", this._showDirs);
        ContentSetSupport.boolean2Str(propertyAccess, "sort-by-type", this._sortByType);
    }

    public void copyPreferencesTo(Context context) {
        context.setInt("flat-level", this._flatLevel);
        context.setBoolean("show-root-dirs", this._showDirs);
        context.setBoolean("sort-by-type", this._sortByType);
    }

    public void initToolbar(Toolbar toolbar) {
        this.createAddFileToProjectAction();
        this.attachActionControllers();
        IdeAction ideAction = _toggleDirsAction.newLocalAction(this.getNavigatorWindow());
        ideAction.addController(this);
        toolbar.addToggleButton(ideAction);
        toolbar.add((Component)this._spinFlatLevel);
        IdeAction ideAction2 = _toggleSortByTypeAction.newLocalAction(this.getNavigatorWindow());
        ideAction2.addController(this);
        toolbar.addToggleButton(ideAction2);
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == TOGGLE_DIRS_CMD_ID) {
            this._showDirs ^= true;
            ideAction.setState(this._showDirs);
            ProjectNavigatorManager.refreshAllProjectsInNavigator(context);
            return true;
        }
        if (n == TOGGLE_SORT_BY_TYPE_CMD_ID) {
            this._sortByType ^= true;
            ideAction.setState(this._sortByType);
            ProjectNavigatorManager.refreshAllProjectsInNavigator(context);
            return true;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == TOGGLE_DIRS_CMD_ID) {
            ideAction.setEnabled(true);
            ideAction.setState(this._showDirs);
            return true;
        }
        if (n == TOGGLE_SORT_BY_TYPE_CMD_ID) {
            ideAction.setEnabled(true);
            ideAction.setState(this._sortByType);
            return true;
        }
        return false;
    }

    private static void maybeInitToggleDirsAction() {
        if (_toggleDirsAction == null) {
            IdeAction ideAction = IdeAction.get(TOGGLE_DIRS_CMD_ID, TOGGLE_DIRS_CMD, NavigatorArb.getString(1), null, null, IdeIcons.getInstance(), 4, null, true);
            ideAction.putValue("Check", Boolean.TRUE);
            _toggleDirsAction = ideAction;
        }
    }

    private static void maybeInitToggleSortByTypeAction() {
        if (_toggleSortByTypeAction == null) {
            IdeAction ideAction = IdeAction.get(TOGGLE_SORT_BY_TYPE_CMD_ID, TOGGLE_SORT_BY_TYPE_CMD, ModelArb.getString(53), null, null, ModelArb.getInstance(), 55, null, true);
            ideAction.putValue("Check", Boolean.TRUE);
            _toggleSortByTypeAction = ideAction;
        }
    }

    private void attachActionControllers() {
        this.attachAddToProjectController();
        this.attachDeleteController();
    }

    private void attachDeleteController() {
        IdeAction ideAction = IdeActions.getFileRemoveFromIDEAction();
        3 var2_2 = new 3();
        ideAction.addController(var2_2);
    }

    private void attachAddToProjectController() {
        IdeAction ideAction = IdeAction.find(ADD_TO_PROJECT_CMD_ID);
        2 var2_2 = new 2();
        ideAction.addController(var2_2);
    }

    private IdeAction createAddFileToProjectAction() {
        if (_addFileToProjectAction == null) {
            String string = ModelArb.getString(60);
            String string2 = MenuManager.getJMenu("Tools").getText();
            char c = ModelArb.getMnemonic(61);
            _addFileToProjectAction = IdeAction.get(ADD_URL_TO_PROJECT_CMD_ID, null, string, string2, new Integer(c), (ResourceBundle)NavigatorArb.getInstance(), null, null, false);
            1 var4_4 = new 1();
            _addFileToProjectAction.addController(var4_4);
        }
        return _addFileToProjectAction;
    }

    static NumericSpinBox ra$_spinFlatLevel(ContentSetSupport contentSetSupport) {
        return contentSetSupport._spinFlatLevel;
    }

    static void wa$_flatLevel(ContentSetSupport contentSetSupport, int n) {
        contentSetSupport._flatLevel = n;
    }

    public final class 4
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            int n = ContentSetSupport.ra$_spinFlatLevel(ContentSetSupport.this).getIntValue();
            ContentSetSupport.wa$_flatLevel(ContentSetSupport.this, n);
            NavigatorWindow navigatorWindow = ContentSetSupport.this.getNavigatorWindow();
            ProjectNavigatorManager.refreshAllProjectsInNavigator(navigatorWindow.getContext());
        }
    }

    public final class 3
    implements Controller {
        public boolean handleEvent(IdeAction ideAction, Context context) {
            Project project;
            Project project2 = project = context != null ? context.getProject() : null;
            if (project != null) {
                Element[] elementArray = context.getSelection();
                if (!this.canHandleSelection(elementArray)) {
                    return false;
                }
                if (!this.showConfirmMsg()) {
                    return true;
                }
                ArrayList<URL> arrayList = new ArrayList<URL>();
                ArrayList<String> arrayList2 = new ArrayList<String>();
                int n = 0;
                while (n < elementArray.length) {
                    Object object = elementArray[n].getData();
                    if (object instanceof Locatable) {
                        arrayList.add(((Locatable)object).getURL());
                    } else if (object instanceof RelativeDirectoryContextFolder) {
                        arrayList2.add(((RelativeDirectoryContextFolder)object).getRelativePath());
                    }
                    ++n;
                }
                project.applyBatchChanges(this.updateContentSets(project, arrayList, arrayList2));
                return true;
            }
            return false;
        }

        public boolean update(IdeAction ideAction, Context context) {
            Project project;
            Project project2 = project = context != null ? context.getProject() : null;
            if (project != null) {
                if (!this.canHandleSelection(context.getSelection())) {
                    return false;
                }
                boolean bl = false;
                Element[] elementArray = context.getSelection();
                if (elementArray.length > 0) {
                    Object object = elementArray[0].getData();
                    URL uRL = null;
                    String string = null;
                    if (object instanceof Locatable) {
                        uRL = ((Locatable)object).getURL();
                    } else if (object instanceof RelativeDirectoryContextFolder) {
                        string = ((RelativeDirectoryContextFolder)object).getRelativePath();
                    }
                    if (uRL != null || string != null) {
                        ContentSetProvider[] contentSetProviderArray = ProjectContent.getContentSetProviders();
                        int n = 0;
                        while (n < contentSetProviderArray.length) {
                            String string2 = contentSetProviderArray[n].getKey();
                            ContentSet contentSet = ContentSet.getInstance(project, string2);
                            if (uRL != null && contentSet.canHaveMember(uRL) || string != null && string.length() > 0 && contentSet.toQualifiedURL(string + "/") != null) {
                                bl = true;
                                break;
                            }
                            ++n;
                        }
                        ideAction.setEnabled(bl);
                        String string3 = ModelArb.getString(59);
                        ideAction.putValue("Name", string3);
                        return true;
                    }
                }
            }
            return false;
        }

        private Runnable updateContentSets(Project project, ArrayList arrayList, ArrayList arrayList2) {
            1 var4_4 = new 1(this, arrayList, arrayList2, project);
            return var4_4;
        }

        private boolean showConfirmMsg() {
            String string = PanelsArb.getString(51);
            String string2 = ModelArb.format(58, string);
            String string3 = ModelArb.getString(59);
            return MessageDialog.confirm((Component)((Object)Ide.getMainWindow()), (Object)string2, (String)string3, (String)"f1_idedexcludeprojectcontent_html");
        }

        private boolean canHandleSelection(Element[] elementArray) {
            return elementArray.length <= 0 || !(elementArray[0] instanceof Project) && !(elementArray[0] instanceof Workspace);
        }

        public final class 1
        implements Runnable {
            private final /* synthetic */ ArrayList v$urls;
            private final /* synthetic */ ArrayList v$paths;
            private final /* synthetic */ Project v$project;
            final /* synthetic */ 3 this$0;

            public void run() {
                if (this.v$urls.size() > 0 || this.v$paths.size() > 0) {
                    ProjectContent projectContent = ProjectContent.getInstance(this.v$project);
                    ContentSetProvider[] contentSetProviderArray = ProjectContent.getContentSetProviders();
                    int n = 0;
                    while (n < contentSetProviderArray.length) {
                        String string = contentSetProviderArray[n].getKey();
                        ContentSetHelper contentSetHelper = contentSetProviderArray[n].getContentSetHelper();
                        for (URL uRL : this.v$urls) {
                            contentSetHelper.removeContent(uRL, projectContent);
                        }
                        ContentSet contentSet = projectContent.getContentSet(string);
                        for (String string2 : this.v$paths) {
                            if (string2.length() <= 0) continue;
                            URL uRL = contentSet.toQualifiedURL(string2 + "/");
                            contentSetHelper.removeContent(uRL, projectContent);
                        }
                        ++n;
                    }
                }
            }

            public 1(3 var1_1, ArrayList arrayList, ArrayList arrayList2, Project project) {
                this.v$project = project;
                this.v$paths = arrayList2;
                this.v$urls = arrayList;
                this.this$0 = var1_1;
            }
        }
    }

    public final class 2
    implements Controller {
        public boolean handleEvent(IdeAction ideAction, Context context) {
            Project project;
            Project project2 = project = context != null ? context.getProject() : null;
            if (project != null) {
                String[] stringArray = new String[]{ProjectContentNavigable.PROPERTIES_NODE_LABEL};
                ProjectPropertiesDialog.showDialog((Frame)((Object)Ide.getMainWindow()), project, stringArray);
                return true;
            }
            return false;
        }

        public boolean update(IdeAction ideAction, Context context) {
            return false;
        }
    }

    public final class 1
    implements Controller {
        public boolean handleEvent(IdeAction ideAction, Context context) {
            AddContentCommand addContentCommand = new AddContentCommand();
            addContentCommand.setContext(context);
            try {
                if (addContentCommand.doit() == 0) {
                    Node node = context.getNode();
                    NavigatorWindow navigatorWindow = ContentSetSupport.this.getNavigatorWindow();
                    if (navigatorWindow.isVisible()) {
                        TreeExplorer treeExplorer = navigatorWindow.getTreeExplorer();
                        TNode tNode = treeExplorer.findTNode(node, null);
                        treeExplorer.setSelected(tNode);
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return true;
        }

        public boolean update(IdeAction ideAction, Context context) {
            Node node;
            Project project = context.getProject();
            if (project != null && (context.getSelection().length == 1 || context.getNode() != null) && (node = context.getNode()) != null) {
                boolean bl = this.canBeAddedToProject(project, node);
                ideAction.setEnabled(bl);
                return true;
            }
            ideAction.setEnabled(false);
            return true;
        }

        private boolean canBeAddedToProject(Project project, Node node) {
            URL uRL;
            return !project.containsChild(node) && (URLFileSystem.isRegularFile(uRL = node.getURL()) || URLFileSystem.isDirectory(uRL));
        }
    }
}

