/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.navigator;

import java.util.HashMap;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.explorer.ChildFilter;
import oracle.ide.explorer.ChildFilterFactory;
import oracle.ide.explorer.IconOverlayCache;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.ViewId;
import oracle.ide.navigator.Extension;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.net.URLFilter;
import oracle.ide.view.MultiManager;
import oracle.javatools.jndi.Names;

public abstract class NavigatorManager
extends MultiManager {
    private static final String APP_NAV_NAME = "ide/application-navigator";
    private static final String WORKSPACE_NAV_NAME = "ide/workspace-navigator";
    private static final String CONN_NAV_NAME = "ide/connection-navigator";
    private NavigatorWindow _navigatorWindow;
    private final HashMap _childFilters;
    private final HashMap _urlFilters;

    void $init$() {
        this._childFilters = new HashMap();
        this._urlFilters = new HashMap();
    }

    public static NavigatorManager getApplicationNavigatorManager() {
        return (NavigatorManager)Names.lookup((javax.naming.Context)Names.newInitialContext(), (String)APP_NAV_NAME);
    }

    public static void setApplicationNavigatorManager(NavigatorManager navigatorManager) {
        Names.bind((javax.naming.Context)Names.newInitialContext(), (String)APP_NAV_NAME, (Object)navigatorManager);
    }

    public static NavigatorManager getWorkspaceNavigatorManager() {
        return (NavigatorManager)Names.lookup((javax.naming.Context)Names.newInitialContext(), (String)WORKSPACE_NAV_NAME);
    }

    public static void setWorkspaceNavigatorManager(NavigatorManager navigatorManager) {
        Names.bind((javax.naming.Context)Names.newInitialContext(), (String)WORKSPACE_NAV_NAME, (Object)navigatorManager);
    }

    public static NavigatorManager getConnectionNavigatorManager() {
        return (NavigatorManager)Names.lookup((javax.naming.Context)Names.newInitialContext(), (String)CONN_NAV_NAME);
    }

    public static void setConnectionNavigatorManager(NavigatorManager navigatorManager) {
        Names.bind((javax.naming.Context)Names.newInitialContext(), (String)CONN_NAV_NAME, (Object)navigatorManager);
    }

    public abstract ContextMenu getContextMenu();

    public final boolean isSystemNavigator(ViewId viewId) {
        return viewId != null ? this.getDefaultName().equals(viewId.getName()) : false;
    }

    public final synchronized NavigatorWindow getNavigatorWindow() {
        if (this._navigatorWindow == null) {
            this._navigatorWindow = this.createNavigatorWindow();
        }
        return this._navigatorWindow;
    }

    protected abstract NavigatorWindow createNavigatorWindow();

    public abstract NavigatorWindow openNavigator(Context var1);

    public final NavigatorWindow showNavigator(Context context) {
        return (NavigatorWindow)this.showView(context);
    }

    public abstract void addContextMenuListener(ContextMenuListener var1, Class var2);

    public abstract void removeContextMenuListener(ContextMenuListener var1);

    public final void registerFilter(Class clazz, Class clazz2, URLFilter uRLFilter) {
        if (clazz != null) {
            if (clazz2 != null) {
                this._childFilters.put(clazz, NavigatorManager.newFactoryFromClass(clazz2));
            }
            if (uRLFilter != null) {
                this._urlFilters.put(clazz, uRLFilter);
            }
        }
    }

    public final void registerFilter(Class clazz, ChildFilterFactory childFilterFactory) {
        if (clazz != null && childFilterFactory != null) {
            this._childFilters.put(clazz, childFilterFactory);
        }
    }

    public final ChildFilterFactory getChildFilterFactoryForType(Class clazz) {
        return (ChildFilterFactory)this._childFilters.get(clazz);
    }

    public final URLFilter getURLFilter(Class clazz) {
        return (URLFilter)this._urlFilters.get(clazz);
    }

    public abstract void registerExtension(Extension var1, Class var2);

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_idesystemnavigator_html");
    }

    public final IconOverlayCache getOverlayCache() {
        return IconOverlayCache.getInstance();
    }

    private static ChildFilterFactory newFactoryFromClass(Class clazz) {
        return new 1(clazz);
    }

    public NavigatorManager() {
        this.$init$();
    }

    public static final class 1
    extends ChildFilterFactory {
        private final /* synthetic */ Class v$childFilterClass;

        public ChildFilter newChildFilter() {
            try {
                ChildFilter childFilter = (ChildFilter)this.v$childFilterClass.newInstance();
                return childFilter;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                ChildFilter childFilter = null;
                return childFilter;
            }
        }

        public 1(Class clazz) {
            this.v$childFilterClass = clazz;
        }
    }
}

