/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.navigator;

import java.util.ArrayList;
import java.util.Enumeration;
import oracle.ide.Context;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TNodeConstants;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.layout.ViewId;
import oracle.ide.model.Element;
import oracle.ide.model.Project;
import oracle.ide.navigator.NavigatorInitFactory;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.navigator.ProjectNavigatorWindow;
import oracle.ide.view.View;
import oracle.ideri.navigator.DefaultNavigatorManager;
import oracle.ideri.navigator.DefaultNavigatorWindow;

public abstract class ProjectNavigatorManager
extends DefaultNavigatorManager {
    private final ArrayList _initFactories;

    void $init$() {
        this._initFactories = new ArrayList();
    }

    public static void refreshAllProjectsInNavigator(Context context) {
        NavigatorWindow navigatorWindow;
        TreeExplorer treeExplorer;
        View view = context.getView();
        if (view instanceof NavigatorWindow && (treeExplorer = (navigatorWindow = (NavigatorWindow)view).getTreeExplorer()) != null) {
            ProjectNavigatorManager.refreshProjectNodes(treeExplorer.getRoot());
        }
    }

    private static void refreshProjectNodes(TNode tNode) {
        if (tNode != null) {
            Element element = tNode.getData();
            if (element instanceof Project) {
                tNode.getOwner().refresh(tNode, Project.class);
            } else if (tNode.isSet(TNodeConstants.IS_OPENED)) {
                Enumeration enumeration = tNode.getChildTNodes();
                while (enumeration.hasMoreElements()) {
                    ProjectNavigatorManager.refreshProjectNodes((TNode)enumeration.nextElement());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNavigatorInit(NavigatorInitFactory navigatorInitFactory) {
        ArrayList arrayList = this._initFactories;
        synchronized (arrayList) {
            if (navigatorInitFactory != null) {
                this._initFactories.add(navigatorInitFactory);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final DefaultNavigatorWindow createNavigatorWindow(Context context, ViewId viewId) {
        ArrayList arrayList;
        ArrayList arrayList2 = this._initFactories;
        synchronized (arrayList2) {
            arrayList = new ArrayList(this._initFactories);
        }
        return new ProjectNavigatorWindow(context, viewId.getId(), arrayList);
    }

    protected void initNavigatorWindowComparator(DefaultNavigatorWindow defaultNavigatorWindow) {
    }

    public ProjectNavigatorManager() {
        this.$init$();
    }
}

