/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.navigator;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.navigator.NavigatorInit;
import oracle.ide.navigator.NavigatorInitFactory;
import oracle.ide.util.PropertyAccess;
import oracle.ideri.navigator.DefaultNavigatorWindow;

public final class ProjectNavigatorWindow
extends DefaultNavigatorWindow {
    private final List _inits;
    private Controller _controller;

    ProjectNavigatorWindow(Context context, String string, List list) {
        super(context, string);
        this._inits = ProjectNavigatorWindow.newNavigatorInits(list, this, context);
    }

    private static ArrayList newNavigatorInits(List list, ProjectNavigatorWindow projectNavigatorWindow, Context context) {
        ArrayList<NavigatorInit> arrayList;
        if (list != null) {
            arrayList = new ArrayList(list.size());
            for (NavigatorInitFactory navigatorInitFactory : list) {
                try {
                    NavigatorInit navigatorInit = navigatorInitFactory.newNavigatorInit(projectNavigatorWindow, context);
                    arrayList.add(navigatorInit);
                }
                catch (ThreadDeath threadDeath) {
                    throw threadDeath;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
            arrayList.trimToSize();
        } else {
            arrayList = new ArrayList<NavigatorInit>(0);
        }
        return arrayList;
    }

    public final Context getContext(EventObject eventObject) {
        Context context = super.getContext(eventObject);
        this.copyPreferencesTo(context);
        return context;
    }

    public final Controller getController() {
        if (this._controller == null) {
            ArrayList<Controller> arrayList = new ArrayList<Controller>();
            for (NavigatorInit navigatorInit : this._inits) {
                try {
                    Controller controller = navigatorInit.getController();
                    if (controller == null) continue;
                    arrayList.add(controller);
                }
                catch (ThreadDeath threadDeath) {
                    throw threadDeath;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
            try {
                Controller controller = super.getController();
                if (controller != null) {
                    arrayList.add(controller);
                }
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            this._controller = new ChainedController(arrayList);
        }
        return this._controller;
    }

    public final void copyPreferencesTo(Context context) {
        for (NavigatorInit navigatorInit : this._inits) {
            try {
                navigatorInit.copyPreferencesTo(context);
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public final void setToolbarVisible(boolean bl) {
        Toolbar toolbar;
        boolean bl2 = bl && this.getToolbar() == null;
        super.setToolbarVisible(bl);
        if (bl2 && (toolbar = this.getToolbar()) != null) {
            for (NavigatorInit navigatorInit : this._inits) {
                try {
                    navigatorInit.initToolbar(toolbar);
                }
                catch (ThreadDeath threadDeath) {
                    throw threadDeath;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
    }

    public final void loadLayout(PropertyAccess propertyAccess) {
        super.loadLayout(propertyAccess);
        for (NavigatorInit navigatorInit : this._inits) {
            try {
                navigatorInit.loadPreferences(propertyAccess);
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public final void saveLayout(PropertyAccess propertyAccess) {
        super.saveLayout(propertyAccess);
        for (NavigatorInit navigatorInit : this._inits) {
            try {
                navigatorInit.savePreferences(propertyAccess);
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    private static class ChainedController
    implements Controller {
        private final ArrayList _controllers;

        ChainedController(ArrayList arrayList) {
            this._controllers = arrayList;
        }

        public boolean handleEvent(IdeAction ideAction, Context context) {
            for (Controller controller : this._controllers) {
                try {
                    if (!controller.handleEvent(ideAction, context)) continue;
                    boolean bl = true;
                    return bl;
                }
                catch (ThreadDeath threadDeath) {
                    throw threadDeath;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
            return false;
        }

        public boolean update(IdeAction ideAction, Context context) {
            for (Controller controller : this._controllers) {
                try {
                    if (!controller.update(ideAction, context)) continue;
                    boolean bl = true;
                    return bl;
                }
                catch (ThreadDeath threadDeath) {
                    throw threadDeath;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
            return false;
        }
    }
}

