/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.net;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.util.ModelUtil;

public class DefaultURLFilter
implements URLFilter {
    private ArrayList _accepted;
    private String _description;
    private transient String _fullDescription;

    public DefaultURLFilter(String string) {
        this.setDescription(string);
    }

    public DefaultURLFilter(String string, String string2) {
        this.setDescription(string);
        this.addExtension(string2);
    }

    public DefaultURLFilter(String string, String[] stringArray) {
        this.setDescription(string);
        if (stringArray != null) {
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                this.addExtension(stringArray[n2]);
                ++n2;
            }
        }
    }

    public void addExtension(String string) {
        if (string != null && string.length() > 0) {
            if (this._accepted == null) {
                this._accepted = new ArrayList();
            }
            if (!this._accepted.contains(string)) {
                this._accepted.add(string);
                this._fullDescription = null;
            }
        }
    }

    public void setDescription(String string) {
        this._description = string;
    }

    public boolean accept(URL uRL) {
        if (this._accepted == null) {
            return true;
        }
        Iterator iterator = this._accepted.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            if (!URLFileSystem.hasSuffix(uRL, string)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsImpl((DefaultURLFilter)object);
    }

    protected final boolean equalsImpl(DefaultURLFilter defaultURLFilter) {
        return ModelUtil.areEqual((Object)this._accepted, (Object)defaultURLFilter._accepted) && ModelUtil.areEqual((Object)this._description, (Object)defaultURLFilter._description);
    }

    public String toString() {
        if (this._fullDescription == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this._description != null ? this._description : "");
            if (this._accepted != null) {
                stringBuffer.append(" (");
                Iterator iterator = this._accepted.iterator();
                while (iterator.hasNext()) {
                    String string = iterator.next().toString();
                    stringBuffer.append("*").append(string).append(", ");
                }
                stringBuffer.setLength(stringBuffer.length() - 2);
                stringBuffer.append(")");
            } else {
                stringBuffer.append(" (*.*)");
            }
            this._fullDescription = stringBuffer.toString();
        }
        return this._fullDescription;
    }
}

