/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.net;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLPath;
import oracle.ide.util.ModelUtil;
import oracle.javatools.util.Copyable;

public class FilePath
implements Copyable {
    private final ArrayList _entriesList;
    private transient File[] _entries;
    private transient boolean _mustRecalcEntries;

    void $init$() {
        this._entriesList = new ArrayList();
        this._mustRecalcEntries = true;
    }

    public FilePath() {
        this.$init$();
    }

    public FilePath(File file) {
        this.$init$();
        this.addEntry(file);
    }

    public FilePath(File[] fileArray) {
        this.$init$();
        this.addEntries(fileArray);
    }

    public FilePath(FilePath filePath) {
        this.$init$();
        if (filePath != null) {
            filePath.copyToImpl(this);
        }
    }

    public Object copyTo(Object object) {
        FilePath filePath = object != null ? (FilePath)object : new FilePath();
        this.copyToImpl(filePath);
        return filePath;
    }

    protected final void copyToImpl(FilePath filePath) {
        filePath._entriesList.clear();
        filePath._entriesList.addAll(this._entriesList);
    }

    public File[] getEntries() {
        if (this._mustRecalcEntries) {
            List list = this.getEntriesListDirectly();
            this._entries = new File[list.size()];
            int n = 0;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                this._entries[n++] = (File)iterator.next();
            }
        }
        return (File[])this._entries.clone();
    }

    public void setEntries(File[] fileArray) {
        List list = this.getEntriesListDirectly();
        list.clear();
        if (fileArray != null) {
            this.addEntries(fileArray);
            this._entries = (File[])fileArray.clone();
            this._mustRecalcEntries = false;
        } else {
            this._mustRecalcEntries = true;
        }
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsImpl((FilePath)object);
    }

    protected final boolean equalsImpl(FilePath filePath) {
        return ModelUtil.areEqual((Object)this._entriesList, (Object)filePath._entriesList);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        List list = this.getEntriesListDirectly();
        for (File file : list) {
            String string = file.getAbsolutePath();
            stringBuffer.append(string).append(File.pathSeparatorChar);
        }
        int n = stringBuffer.length();
        if (n > 0) {
            stringBuffer.setLength(n - 1);
        }
        return stringBuffer.toString();
    }

    public void addEntry(File file) {
        if (file == null) {
            return;
        }
        List list = this.getEntriesListDirectly();
        if (!list.contains(file)) {
            list.add(file);
            this._mustRecalcEntries = true;
        }
    }

    public void addEntries(File[] fileArray) {
        if (fileArray == null) {
            return;
        }
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            this.addEntry(fileArray[n2]);
            ++n2;
        }
    }

    public void addEntries(FilePath filePath) {
        List list = this.getEntriesListDirectly();
        List list2 = filePath.getEntriesListDirectly();
        list.addAll(list2);
    }

    public URLPath toURLPath() {
        List list = this.getEntriesListDirectly();
        URLPath uRLPath = new URLPath();
        for (File file : list) {
            URL uRL = URLFactory.newFileURL(file);
            uRLPath.add(uRL);
        }
        return uRLPath;
    }

    public static FilePath newFilePathFromString(String string) {
        FilePath filePath = new FilePath();
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                File file = new File(string2);
                filePath.addEntry(file);
            }
        }
        return filePath;
    }

    protected final List getEntriesListDirectly() {
        return this._entriesList;
    }
}

