/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.net;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.filechooser.FileSystemView;
import oracle.ide.net.FileNativeHelper;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;
import oracle.ide.net.URLFilter;
import oracle.ide.nulls.NullPrintStream;
import oracle.ide.util.Encodings;
import oracle.ide.util.JDK;
import oracle.ide.util.ModelUtil;
import oracle.javatools.net.EncoderUtils;

final class FileURLFileSystemHelper
extends URLFileSystemHelper {
    static final String ICON_KEY_HARD_DRIVE = "FileView.hardDriveIcon";
    private static FileSystemView _fileSystemView;
    private static PrintStream _nullErrorStream;
    private static final String NS_CACHE_NAME = "IDE:UrlDirCache";
    private static final boolean SYSTEM_DISPLAY_NAME_IS_BROKEN;
    private static final String RESERVED_FILENAMES_PROPERTY = "reserved_filenames";
    private static final String[] RESERVED_FILENAMES;

    static {
        String string = System.getProperty("os.name");
        String string2 = System.getProperty("java.version");
        SYSTEM_DISPLAY_NAME_IS_BROKEN = string.startsWith("Windows") && string2.startsWith("1.4.2") && string2.compareTo("1.4.2_06") >= 0;
        String string3 = System.getProperty(RESERVED_FILENAMES_PROPERTY);
        if (string3 != null && string3.length() > 0) {
            ArrayList<String> arrayList = new ArrayList<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken());
            }
            RESERVED_FILENAMES = arrayList.toArray(new String[arrayList.size()]);
        } else {
            RESERVED_FILENAMES = new String[0];
        }
    }

    public URL canonicalize(URL uRL) {
        File file;
        if (URLFileSystem.isLocalFileSystemCaseSensitive()) {
            ArrayList arrayList = new ArrayList();
            StringBuffer stringBuffer = new StringBuffer();
            String string = FileURLFileSystemHelper.url2Path(uRL);
            if (string.startsWith("/")) {
                stringBuffer.append('/');
            }
            String string2 = URLFactory.resolveRelative(arrayList, string, stringBuffer);
            file = new File(string2);
        } else {
            File file2 = FileURLFileSystemHelper.url2File(uRL);
            try {
                file = file2.getCanonicalFile();
            }
            catch (Exception exception) {
                file = file2.getAbsoluteFile();
            }
        }
        return this.isDirectoryPath(uRL) ? URLFactory.newDirURL(file) : URLFactory.newFileURL(file);
    }

    public boolean canRead(URL uRL) {
        File file = FileURLFileSystemHelper.url2File(uRL);
        return file.canRead();
    }

    public boolean canWrite(URL uRL) {
        File file = FileURLFileSystemHelper.url2File(uRL);
        return file.canWrite();
    }

    public boolean canCreate(URL uRL) {
        File file = FileURLFileSystemHelper.url2File(uRL);
        if (file.exists()) {
            return !this.isReservedFilename(uRL) && file.canWrite();
        }
        File file2 = file.getParentFile();
        if (file2 == null) {
            return false;
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        boolean bl = file.isDirectory();
        boolean bl2 = true;
        boolean bl3 = false;
        if (file2.exists()) {
            bl3 = true;
            try {
                if (bl) {
                    bl2 = file.mkdir();
                } else if (file2.canWrite()) {
                    bl2 = file.createNewFile();
                    if (JDK.HAS_BUG_4812991) {
                        bl2 = file.exists();
                    }
                    arrayList.add(file);
                } else {
                    bl2 = false;
                }
            }
            catch (IOException iOException) {
                bl2 = false;
            }
        }
        if (!bl2) {
            return bl2;
        }
        File file3 = file2;
        while (file3 != null && !file3.exists()) {
            arrayList.add(file3);
            file3 = file3.getParentFile();
        }
        if (arrayList.size() > 0) {
            try {
                if (!bl3 && (bl2 = file2.mkdirs())) {
                    if (bl) {
                        bl2 = file.mkdir();
                    } else {
                        bl2 = file.createNewFile();
                        if (JDK.HAS_BUG_4812991) {
                            bl2 = file.exists();
                        }
                    }
                    arrayList.add(0, file);
                }
            }
            catch (Exception exception) {
                bl2 = false;
            }
            for (File file4 : arrayList) {
                if (!file4.exists()) continue;
                try {
                    file4.delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return bl2;
    }

    public void delete(URL uRL) throws IOException {
        File file = FileURLFileSystemHelper.url2File(uRL);
        boolean bl = file.delete();
        if (!bl) {
            throw new IOException("Unable to delete " + file.getAbsolutePath());
        }
    }

    public boolean equals(URL uRL, URL uRL2) {
        return this.areEqualPathElems(uRL.getPath(), uRL2.getPath()) && this.haveSameAuthority(uRL, uRL2) && ModelUtil.areEqual((Object)uRL.getUserInfo(), (Object)uRL2.getUserInfo()) && ModelUtil.areEqual((Object)uRL.getQuery(), (Object)uRL2.getQuery()) && ModelUtil.areEqual((Object)uRL.getRef(), (Object)uRL2.getRef());
    }

    public boolean exists(URL uRL) {
        File file = FileURLFileSystemHelper.url2File(uRL);
        return file.exists() && !this.isReservedFilename(uRL);
    }

    public Icon getDefaultIcon(URL uRL) {
        if (URLFileSystem.isRoot(uRL)) {
            return UIManager.getIcon(ICON_KEY_HARD_DRIVE);
        }
        return super.getDefaultIcon(uRL);
    }

    public long getLength(URL uRL) {
        File file = FileURLFileSystemHelper.url2File(uRL);
        return file.length();
    }

    public URL getParent(URL uRL) {
        File file = FileURLFileSystemHelper.url2File(uRL);
        File file2 = file.getParentFile();
        if (file2 != null && !file.equals(file2)) {
            return URLFactory.newDirURL(file2);
        }
        return null;
    }

    public String getPlatformPathName(URL uRL) {
        if (uRL == null) {
            return "";
        }
        File file = FileURLFileSystemHelper.url2File(uRL);
        String string = file.getPath();
        return string;
    }

    public String getSystemDisplayName(URL uRL) {
        if (SYSTEM_DISPLAY_NAME_IS_BROKEN) {
            return super.getSystemDisplayName(uRL);
        }
        File file = FileURLFileSystemHelper.url2FsvFile(uRL);
        String string = FileURLFileSystemHelper.getFileSystemView().getSystemDisplayName(file);
        return ModelUtil.hasLength((String)string) ? string : file.getName();
    }

    public Icon getSystemIcon(URL uRL) {
        Icon icon;
        File file = FileURLFileSystemHelper.url2FsvFile(uRL);
        PrintStream printStream = System.err;
        try {
            try {
                System.setErr(FileURLFileSystemHelper.getNullErrorStream());
                icon = FileURLFileSystemHelper.getFileSystemView().getSystemIcon(file);
            }
            catch (Exception exception) {
                icon = null;
            }
        }
        finally {
            System.setErr(printStream);
        }
        return icon != null ? icon : super.getSystemIcon(uRL);
    }

    public boolean hasSuffix(URL uRL, String string) {
        if (URLFileSystem.isLocalFileSystemCaseSensitive()) {
            return super.hasSuffix(uRL, string);
        }
        String string2 = uRL.getPath().toLowerCase();
        return string2.endsWith(string.toLowerCase());
    }

    public boolean isBaseURLFor(URL uRL, URL uRL2) {
        if (!this.isDirectoryPath(uRL)) {
            return false;
        }
        String string = uRL.getPath();
        String string2 = uRL2.getPath();
        return string2.startsWith(string);
    }

    public boolean isDirectory(URL uRL) {
        File file = FileURLFileSystemHelper.url2File(uRL);
        return file.isDirectory();
    }

    public boolean isHidden(URL uRL) {
        File file = FileURLFileSystemHelper.url2File(uRL);
        return file.isHidden();
    }

    public boolean isRegularFile(URL uRL) {
        File file = FileURLFileSystemHelper.url2File(uRL);
        return file.isFile();
    }

    public long lastModified(URL uRL) {
        File file = FileURLFileSystemHelper.url2File(uRL);
        long l = file.lastModified();
        return l != 0L ? l : (long)-1;
    }

    public boolean isReadOnly(URL uRL) {
        File file = FileURLFileSystemHelper.url2File(uRL);
        while (file != null) {
            if (file.exists()) {
                return file.canWrite() ^ true;
            }
            file = file.getParentFile();
        }
        return false;
    }

    public URL[] list(URL uRL) {
        File file = FileURLFileSystemHelper.url2File(uRL);
        FileNativeHelper fileNativeHelper = FileNativeHelper.getInstance();
        if (fileNativeHelper.isLoaded()) {
            URLFileSystem.FileInfo[] fileInfoArray = fileNativeHelper.ls(file);
            if (fileInfoArray == null) {
                return null;
            }
            URL[] uRLArray = new URL[fileInfoArray.length];
            int n = fileInfoArray.length - 1;
            while (n >= 0) {
                uRLArray[n] = fileInfoArray[n].getURL();
                --n;
            }
            return uRLArray;
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return null;
        }
        URL[] uRLArray = new URL[fileArray.length];
        int n = fileArray.length - 1;
        while (n >= 0) {
            uRLArray[n] = URLFactory.newFileURL(fileArray[n]);
            --n;
        }
        return uRLArray;
    }

    public URL[] listRoots() {
        File[] fileArray = File.listRoots();
        int n = fileArray.length;
        URL[] uRLArray = new URL[n];
        int n2 = 0;
        while (n2 < n) {
            uRLArray[n2] = URLFactory.newDirURL(fileArray[n2]);
            ++n2;
        }
        return uRLArray;
    }

    public URLFileSystem.FileInfo[] ls(URL uRL) {
        File file = FileURLFileSystemHelper.url2File(uRL);
        FileNativeHelper fileNativeHelper = FileNativeHelper.getInstance();
        if (fileNativeHelper.isLoaded()) {
            return fileNativeHelper.ls(file);
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return null;
        }
        int n = fileArray.length;
        URLFileSystem.FileInfo[] fileInfoArray = new URLFileSystem.FileInfo[n];
        int n2 = 0;
        while (n2 < n) {
            fileInfoArray[n2] = FileURLFileSystemHelper.createFileInfo(fileArray[n2]);
            ++n2;
        }
        return fileInfoArray;
    }

    public URLFileSystem.FileInfo[] ls(URL uRL, URLFilter uRLFilter) {
        URLFileSystem.FileInfo[] fileInfoArray = this.ls(uRL);
        if (fileInfoArray == null || uRLFilter == null) {
            return fileInfoArray;
        }
        ArrayList<URLFileSystem.FileInfo> arrayList = new ArrayList<URLFileSystem.FileInfo>();
        int n = fileInfoArray.length - 1;
        while (n >= 0) {
            URLFileSystem.FileInfo fileInfo = fileInfoArray[n];
            URL uRL2 = fileInfo.getURL();
            if (uRLFilter.accept(uRL2)) {
                arrayList.add(fileInfo);
            }
            --n;
        }
        return arrayList.toArray(new URLFileSystem.FileInfo[arrayList.size()]);
    }

    protected static URLFileSystem.FileInfo createFileInfo(File file) {
        if (file != null) {
            int n;
            long l = file.lastModified();
            l = l != 0L ? l : (long)-1;
            long l2 = file.length();
            int n2 = n = file.isDirectory() ? 1 : 2;
            if (file.isHidden()) {
                n |= 4;
            }
            URL uRL = URLFactory.newFileURL(file);
            return new URLFileSystem.FileInfo(uRL, n, l, l2);
        }
        return null;
    }

    public boolean mkdir(URL uRL) {
        File file = FileURLFileSystemHelper.url2File(uRL);
        if (!file.exists()) {
            return file.mkdir();
        }
        return false;
    }

    public boolean mkdirs(URL uRL) {
        File file;
        if (!this.isDirectoryPath(uRL)) {
            new Exception("Assertion failure -- the URL passed to mkdirs was not a directory URL: " + uRL).printStackTrace();
        }
        if (!(file = FileURLFileSystemHelper.url2File(uRL)).exists()) {
            return file.mkdirs();
        }
        return true;
    }

    public URL createTempFile(String string, String string2, URL uRL) throws IOException {
        return uRL != null ? URLFactory.newFileURL(File.createTempFile(string, string2, new File(uRL.getPath()))) : URLFactory.newFileURL(File.createTempFile(string, string2));
    }

    public InputStream openInputStream(URL uRL) throws IOException {
        String string = uRL.getPath();
        return new FileInputStream(string);
    }

    public OutputStream openOutputStream(URL uRL) throws IOException {
        String string = uRL.getPath();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            return fileOutputStream;
        }
        catch (FileNotFoundException fileNotFoundException) {
            File file = FileURLFileSystemHelper.url2File(uRL);
            File file2 = file.getParentFile();
            file2.mkdirs();
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            return fileOutputStream;
        }
    }

    public void rename(URL uRL, URL uRL2) throws IOException {
        File file = FileURLFileSystemHelper.url2File(uRL);
        File file2 = FileURLFileSystemHelper.url2File(uRL2);
        File file3 = file2.getParentFile();
        file3.mkdirs();
        if (!file.renameTo(file2)) {
            throw new IOException("File.renameTo failed for " + file.getAbsolutePath());
        }
    }

    public boolean setLastModified(URL uRL, long l) {
        File file = FileURLFileSystemHelper.url2File(uRL);
        return file.setLastModified(l);
    }

    public boolean setReadOnly(URL uRL, boolean bl) {
        File file = FileURLFileSystemHelper.url2File(uRL);
        if (!bl) {
            return file.canWrite();
        }
        return file.setReadOnly();
    }

    public String toRelativeSpec(URL uRL, URL uRL2, boolean bl) {
        String string = super.toRelativeSpec(uRL, uRL2, bl);
        if (string == null) {
            return null;
        }
        boolean bl2 = string.startsWith("//");
        return bl2 ? uRL.toString() : string;
    }

    public URL getBaseParent(URL uRL, String string) {
        string = string.replace(File.separatorChar, '/');
        return super.getBaseParent(uRL, string);
    }

    protected boolean haveSameAuthority(URL uRL, URL uRL2) {
        if (uRL == uRL2) {
            return true;
        }
        if (uRL == null || uRL2 == null) {
            return false;
        }
        String string = uRL.getAuthority();
        String string2 = uRL2.getAuthority();
        return !(string != null && string.length() > 0 || string2 != null && string2.length() > 0);
    }

    protected boolean areEqualPathElems(String string, String string2) {
        File file = new File(string);
        File file2 = new File(string2);
        return file.equals(file2);
    }

    private static final String url2Path(URL uRL) {
        String string = uRL.getPath();
        try {
            String string2 = EncoderUtils.decodeString((String)string, (String)Encodings.getDefaultEncoding());
            return string2;
        }
        catch (Exception exception) {
            String string3 = string;
            return string3;
        }
    }

    private static final File url2File(URL uRL) {
        return new File(FileURLFileSystemHelper.url2Path(uRL));
    }

    private static final File url2FsvFile(URL uRL) {
        String string = uRL.getPath();
        try {
            string = EncoderUtils.decodeString((String)string, (String)Encodings.getDefaultEncoding());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return FileURLFileSystemHelper.getFileSystemView().createFileObject(string);
    }

    private static final FileSystemView getFileSystemView() {
        if (_fileSystemView == null) {
            _fileSystemView = FileSystemView.getFileSystemView();
        }
        return _fileSystemView;
    }

    private static final PrintStream getNullErrorStream() {
        if (_nullErrorStream == null) {
            _nullErrorStream = new NullPrintStream(System.err);
        }
        return _nullErrorStream;
    }

    private final boolean isReservedFilename(URL uRL) {
        if (RESERVED_FILENAMES.length > 0) {
            String string = this.getFileName(uRL);
            int n = string.indexOf(46);
            if (n != -1) {
                string = string.substring(0, n);
            }
            if (!URLFileSystem.isLocalFileSystemCaseSensitive()) {
                string = string.toLowerCase();
            }
            int n2 = 0;
            while (n2 < RESERVED_FILENAMES.length) {
                if (RESERVED_FILENAMES[n2].equals(string)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    FileURLFileSystemHelper() {
    }

    public static class SimpleFileInfo
    extends URLFileSystem.FileInfo {
        boolean _init = false;

        protected SimpleFileInfo(URL uRL, int n) throws MalformedURLException {
            super(uRL, n, (long)-1, (long)-1);
        }

        static SimpleFileInfo newFileInfo(String string, String string2, boolean bl) throws MalformedURLException {
            if (bl) {
                return new SimpleFileInfo(URLFactory.newDirURL(string + string2), 1);
            }
            return new SimpleFileInfo(URLFactory.newFileURL(string + string2), 2);
        }

        public boolean isHidden() {
            if (!this._init) {
                this.attributes |= URLFileSystem.isHidden(this.url) ? 4 : 0;
            }
            return (this.attributes & 4) != 0;
        }

        public long lastModified() {
            if (this.lastModified == (long)-1) {
                this.lastModified = URLFileSystem.lastModified(this.url);
            }
            return this.lastModified;
        }

        public long length() {
            if (this.length == (long)-1) {
                this.length = URLFileSystem.getLength(this.url);
            }
            return this.length;
        }
    }
}

