/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.net;

import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.NoRouteToHostException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;

public class HttpURLFileSystemHelper
extends URLFileSystemHelper {
    private HashMap _unreachableMap;
    private String _proxyHost;
    private String _proxyPort;
    private static final int DEFAULT_PORT = 80;

    void $init$() {
        this._unreachableMap = new HashMap();
    }

    public String getSystemDisplayName(URL uRL) {
        if (URLFileSystem.isRoot(uRL)) {
            return URLFileSystem.getPlatformPathName(uRL);
        }
        return URLFileSystem.getFileName(uRL);
    }

    public long getLength(URL uRL) {
        this._checkProxy();
        if (this._unreachableMap.containsKey(uRL.getHost())) {
            return -1;
        }
        try {
            URLConnection uRLConnection = uRL.openConnection();
            try {
                long l = uRLConnection.getContentLength();
                try {
                    uRLConnection.getInputStream().close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return l;
            }
            catch (Throwable throwable) {
                try {
                    uRLConnection.getInputStream().close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        catch (NoRouteToHostException noRouteToHostException) {
            this._unreachableMap.put(uRL.getHost(), null);
            long l = -1;
            return l;
        }
        catch (Exception exception) {
            long l = -1;
            return l;
        }
    }

    public long lastModified(URL uRL) {
        this._checkProxy();
        if (this._unreachableMap.containsKey(uRL.getHost())) {
            return -1;
        }
        try {
            URLConnection uRLConnection = uRL.openConnection();
            try {
                long l = uRLConnection.getLastModified();
                try {
                    uRLConnection.getInputStream().close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return l;
            }
            catch (Throwable throwable) {
                try {
                    uRLConnection.getInputStream().close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        catch (NoRouteToHostException noRouteToHostException) {
            this._unreachableMap.put(uRL.getHost(), null);
            long l = -1;
            return l;
        }
        catch (Exception exception) {
            long l = -1;
            return l;
        }
    }

    public boolean exists(URL uRL) {
        boolean bl;
        block14: {
            bl = false;
            this._checkProxy();
            String string = uRL.getHost();
            if (!this._unreachableMap.containsKey(string)) {
                InputStream inputStream = null;
                try {
                    try {
                        String string2;
                        URLConnection uRLConnection = uRL.openConnection();
                        if (!(uRLConnection instanceof HttpURLConnection)) break block14;
                        HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                        inputStream = httpURLConnection.getInputStream();
                        int n = httpURLConnection.getResponseCode();
                        bl = n >= 100 & n < 400;
                        if (n != 200) break block14;
                        String string3 = URLFileSystem.getFileName(uRL);
                        if (string3.equals(string2 = URLFileSystem.getFileName(httpURLConnection.getURL()))) {
                            bl = true;
                            break block14;
                        }
                        bl = false;
                    }
                    catch (NoRouteToHostException noRouteToHostException) {
                        this._unreachableMap.put(string, null);
                    }
                    catch (ConnectException connectException) {
                    }
                    catch (IOException iOException) {}
                }
                finally {
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return bl;
    }

    public boolean canCreate(URL uRL) {
        boolean bl = false;
        this._checkProxy();
        String string = uRL.getHost();
        if (!this._unreachableMap.containsKey(string)) {
            while (uRL != null) {
                if (this.exists(uRL)) {
                    bl = this.canWrite(uRL);
                    break;
                }
                uRL = this.getParent(uRL);
            }
        }
        return bl;
    }

    public URL getParent(URL uRL) {
        URL uRL2 = super.getParent(uRL);
        if (uRL2 != null && uRL2.equals(uRL)) {
            uRL2 = null;
        }
        return uRL2;
    }

    public InputStream openInputStream(URL uRL) throws IOException {
        this._checkProxy();
        String string = uRL.getHost();
        try {
            if (!this._unreachableMap.containsKey(string)) {
                URLConnection uRLConnection = uRL.openConnection();
                InputStream inputStream = uRLConnection.getInputStream();
                return inputStream;
            }
        }
        catch (NoRouteToHostException noRouteToHostException) {
            this._unreachableMap.put(string, null);
            throw noRouteToHostException;
        }
        throw new IOException();
    }

    private void _checkProxy() {
        String string = System.getProperty("http.proxyHost");
        String string2 = System.getProperty("http.proxyPort");
        if (this._areDifferent(this._proxyHost, string) || this._areDifferent(this._proxyPort, string2)) {
            this._unreachableMap.clear();
            this._proxyHost = string;
            this._proxyPort = string2;
        }
    }

    private boolean _areDifferent(String string, String string2) {
        return string == null ? string2 != null : string.equals(string2) ^ true;
    }

    protected boolean haveSamePort(URL uRL, URL uRL2) {
        int n = uRL.getPort() != -1 ? uRL.getPort() : 80;
        int n2 = uRL2.getPort() != -1 ? uRL2.getPort() : 80;
        return n == n2;
    }

    public HttpURLFileSystemHelper() {
        this.$init$();
    }
}

