/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import oracle.ide.net.ProtocolConstants;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;
import oracle.ide.net.URLFilter;

public class IdeURLFileSystemHelper
extends URLFileSystemHelper {
    public URL canonicalize(URL uRL) {
        return URLFileSystem.canonicalize(this.getRealURL(uRL));
    }

    public boolean canRead(URL uRL) {
        return URLFileSystem.canRead(this.getRealURL(uRL));
    }

    public boolean canWrite(URL uRL) {
        return URLFileSystem.canWrite(this.getRealURL(uRL));
    }

    public URL convertSuffix(URL uRL, String string, String string2) {
        return URLFileSystem.convertSuffix(this.getRealURL(uRL), string, string2);
    }

    public void delete(URL uRL) throws IOException {
        URLFileSystem.deleteEx(this.getRealURL(uRL));
    }

    public URL ensureSuffix(URL uRL, String string) {
        return URLFileSystem.ensureSuffix(this.getRealURL(uRL), string);
    }

    public boolean equals(URL uRL, URL uRL2) {
        return URLFileSystem.equals(this.getRealURL(uRL), this.getRealURL(uRL2));
    }

    public boolean exists(URL uRL) {
        return URLFileSystem.exists(this.getRealURL(uRL));
    }

    public String getFileName(URL uRL) {
        return URLFileSystem.getFileName(this.getRealURL(uRL));
    }

    public long getLength(URL uRL) {
        return URLFileSystem.getLength(this.getRealURL(uRL));
    }

    public String getName(URL uRL) {
        return URLFileSystem.getName(this.getRealURL(uRL));
    }

    public URL getParent(URL uRL) {
        return URLFileSystem.getParent(this.getRealURL(uRL));
    }

    public String getPath(URL uRL) {
        return URLFileSystem.getPath(this.getRealURL(uRL));
    }

    public String getPathNoExt(URL uRL) {
        return URLFileSystem.getPathNoExt(this.getRealURL(uRL));
    }

    public String getPlatformPathName(URL uRL) {
        return URLFileSystem.getPlatformPathName(this.getRealURL(uRL));
    }

    public String getSuffix(URL uRL) {
        return URLFileSystem.getSuffix(this.getRealURL(uRL));
    }

    public boolean hasSuffix(URL uRL, String string) {
        return URLFileSystem.hasSuffix(this.getRealURL(uRL), string);
    }

    public boolean isBaseURLFor(URL uRL, URL uRL2) {
        return URLFileSystem.isBaseURLFor(this.getRealURL(uRL), this.getRealURL(uRL2));
    }

    public boolean isDirectory(URL uRL) {
        return URLFileSystem.isDirectory(this.getRealURL(uRL));
    }

    public boolean isDirectoryPath(URL uRL) {
        return URLFileSystem.isDirectoryPath(this.getRealURL(uRL));
    }

    public boolean isHidden(URL uRL) {
        return URLFileSystem.isHidden(this.getRealURL(uRL));
    }

    public boolean isReadOnly(URL uRL) {
        return URLFileSystem.isReadOnly(this.getRealURL(uRL));
    }

    public boolean isRegularFile(URL uRL) {
        return URLFileSystem.isRegularFile(this.getRealURL(uRL));
    }

    public long lastModified(URL uRL) {
        return URLFileSystem.lastModified(this.getRealURL(uRL));
    }

    public URL[] list(URL uRL) {
        return URLFileSystem.list(this.getRealURL(uRL));
    }

    public URL[] list(URL uRL, URLFilter uRLFilter) {
        return URLFileSystem.list(this.getRealURL(uRL), uRLFilter);
    }

    public boolean mkdir(URL uRL) {
        return URLFileSystem.mkdir(this.getRealURL(uRL));
    }

    public boolean mkdirs(URL uRL) {
        return URLFileSystem.mkdirs(this.getRealURL(uRL));
    }

    public InputStream openInputStream(URL uRL) throws IOException {
        return URLFileSystem.openInputStream(this.getRealURL(uRL));
    }

    public OutputStream openOutputStream(URL uRL) throws IOException {
        return URLFileSystem.openOutputStream(this.getRealURL(uRL));
    }

    public void rename(URL uRL, URL uRL2) throws IOException {
        URLFileSystem.renameEx(this.getRealURL(uRL), this.getRealURL(uRL2));
    }

    public boolean setLastModified(URL uRL, long l) {
        return URLFileSystem.setLastModified(this.getRealURL(uRL), l);
    }

    public boolean setReadOnly(URL uRL, boolean bl) {
        return URLFileSystem.setReadOnly(this.getRealURL(uRL), bl);
    }

    public String toDisplayString(URL uRL) {
        return URLFileSystem.toDisplayString(this.getRealURL(uRL));
    }

    public String toRelativeSpec(URL uRL, URL uRL2) {
        return super.toRelativeSpec(uRL, uRL2);
    }

    public String toRelativeSpec(URL uRL, URL uRL2, boolean bl) {
        return super.toRelativeSpec(uRL, uRL2, bl);
    }

    public URL getBaseParent(URL uRL, String string) {
        return URLFileSystem.getBaseParent(this.getRealURL(uRL), string);
    }

    protected URL getRealURL(URL uRL) {
        String string = uRL.getProtocol();
        if (!ProtocolConstants.isIdeProtocol(string)) {
            return uRL;
        }
        int n = string.lastIndexOf(".");
        String string2 = null;
        String string3 = string;
        List<Object> list = Arrays.asList(ProtocolConstants.PROTOCOLS.getItems());
        while (n > 0) {
            String string4 = string3.substring(0, n);
            int n2 = list.indexOf(string4);
            if (n2 >= 0) {
                string2 = (String)list.get(n2);
            }
            if (string2 != null) break;
            string3 = string4;
            n = string3.lastIndexOf(".");
        }
        if (string2 != null) {
            String string5 = string.substring(string2.length() + 1, string.length());
            return URLFactory.replaceProtocolPart(uRL, string5);
        }
        return null;
    }
}

