/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.net;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.zip.Inflater;
import javax.swing.Timer;
import oracle.ide.net.AlikeStrings;
import oracle.ide.net.InflaterInputStream;
import oracle.ide.net.JarIndexEntry;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFileSystem;
import oracle.ide.performance.PerformanceLogger;
import oracle.ide.util.Encodings;
import oracle.ide.util.ModelUtil;

public final class JarIndex {
    private static final int STORED = 0;
    private static final int DEFLATED = 8;
    private final URL _jarFileURL;
    private final long _timestamp;
    private int[] _offsets;
    private int[] _cSizes;
    private int[] _ucSizes;
    private int[] _dostimes;
    private int[] _table;
    private int[] _tableData;
    private int _tableLen;
    private int numEntries;
    private long centralDirOffset;
    private int centralDirSize;
    private boolean pathlessFiles;
    private AlikeStrings _entryNamesPool;
    private final Object _buildLock;

    void $init$() {
        this._buildLock = new Object();
    }

    JarIndex(URL uRL, long l) {
        this.$init$();
        this._jarFileURL = uRL;
        this._timestamp = l;
    }

    public int dirEntryIndex(String string) {
        return this.dirEntryIndexImpl(string.endsWith("/") ? string : string + "/");
    }

    public int entryIndex(String string) {
        if (string.endsWith("/")) {
            return this.dirEntryIndexImpl(string);
        }
        this.tryBuildFullIndex();
        return this._entryNamesPool.binarySearch(string);
    }

    public int getNumEntries() {
        return this._offsets != null ? this._offsets.length : 0;
    }

    public JarIndexEntry getEntryAt(int n) {
        this.tryBuildFullIndex();
        return new JarIndexEntry(this._entryNamesPool.getStringFromIndex(n), this._cSizes[n], this._ucSizes[n], this._dostimes[n]);
    }

    public String getEntryNameAt(int n) {
        this.tryBuildFullIndex();
        return this._entryNamesPool.getStringFromIndex(n);
    }

    public String[] getEntries() {
        this.tryBuildFullIndex();
        int n = this.getNumEntries();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = this._entryNamesPool.getStringFromIndex(n2);
            ++n2;
        }
        return stringArray;
    }

    public int getSize(String string) {
        int n;
        this.tryBuildFullIndex();
        if (string != null && (n = this._entryNamesPool.binarySearch(string)) >= 0) {
            return this._ucSizes[n];
        }
        return -1;
    }

    public String[] list(String string) {
        String[] stringArray;
        this.tryBuildFullIndex();
        if (string.length() > 0 && ((stringArray = this.listImpl(string.endsWith("/") ? string : string + "/")) != null && stringArray.length > 0 || !this.pathlessFiles || !string.equals("./"))) {
            return stringArray;
        }
        return this.listImpl("");
    }

    public InputStream openInputStream(String string) throws IOException {
        if (string != null) {
            byte[] byArray = new byte[30];
            RandomAccessFile randomAccessFile = null;
            try {
                randomAccessFile = OpenFileCaching.getCachedFile(this._jarFileURL);
                int[] nArray = this.getLOC(randomAccessFile, byArray, string);
                if (nArray != null) {
                    int n = nArray[1];
                    byte[] byArray2 = new byte[n];
                    randomAccessFile.readFully(byArray2);
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
                    int n2 = JarIndex.getCompressionMethod(byArray);
                    switch (n2) {
                        case 0: {
                            ByteArrayInputStream byteArrayInputStream2 = byteArrayInputStream;
                            if (randomAccessFile != null) {
                                OpenFileCaching.releaseCachedFile(this._jarFileURL);
                            }
                            return byteArrayInputStream2;
                        }
                        case 8: {
                            InflaterInputStream inflaterInputStream = new InflaterInputStream(byteArrayInputStream, new Inflater(true));
                            if (randomAccessFile != null) {
                                OpenFileCaching.releaseCachedFile(this._jarFileURL);
                            }
                            return inflaterInputStream;
                        }
                    }
                    throw new IOException("Unsupported compression method (" + n2 + ")");
                }
            }
            finally {
                if (randomAccessFile != null) {
                    OpenFileCaching.releaseCachedFile(this._jarFileURL);
                }
            }
        }
        throw new FileNotFoundException(this.getJarEntryString(string));
    }

    public boolean exists(String string) {
        if (this._entryNamesPool != null) {
            return this.entryIndex(string) >= 0;
        }
        boolean bl = false;
        RandomAccessFile randomAccessFile = null;
        try {
            try {
                randomAccessFile = OpenFileCaching.getCachedFile(this._jarFileURL);
                bl = this.getLOC(randomAccessFile, new byte[30], string) != null;
            }
            catch (IOException iOException) {}
        }
        finally {
            if (randomAccessFile != null) {
                OpenFileCaching.releaseCachedFile(this._jarFileURL);
            }
        }
        if (!bl && string.endsWith("/")) {
            bl = this.dirEntryIndexImpl(string) >= 0;
        }
        return bl;
    }

    public byte[] getBytes(String string) throws IOException {
        this.tryBuildFullIndex();
        if (string != null) {
            byte[] byArray = new byte[30];
            RandomAccessFile randomAccessFile = null;
            try {
                randomAccessFile = OpenFileCaching.getCachedFile(this._jarFileURL);
                int[] nArray = this.getLOC(randomAccessFile, byArray, string);
                if (nArray != null) {
                    int n = nArray[1];
                    byte[] byArray2 = new byte[n];
                    randomAccessFile.readFully(byArray2);
                    int n2 = JarIndex.getCompressionMethod(byArray);
                    switch (n2) {
                        case 0: {
                            byte[] byArray3 = byArray2;
                            if (randomAccessFile != null) {
                                OpenFileCaching.releaseCachedFile(this._jarFileURL);
                            }
                            return byArray3;
                        }
                        case 8: {
                            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
                            int n3 = nArray[2];
                            byte[] byArray4 = new byte[n3];
                            InflaterInputStream inflaterInputStream = new InflaterInputStream(byteArrayInputStream, new Inflater(true), n);
                            int n4 = inflaterInputStream.read(byArray4, 0, n3);
                            if (n4 == n3) {
                                byte[] byArray5 = byArray4;
                                if (randomAccessFile != null) {
                                    OpenFileCaching.releaseCachedFile(this._jarFileURL);
                                }
                                return byArray5;
                            }
                            throw new IOException("Unexpected EOF -- corrupted jar file");
                        }
                    }
                    throw new IOException("Unsupported compression method (" + n2 + ")");
                }
            }
            finally {
                if (randomAccessFile != null) {
                    OpenFileCaching.releaseCachedFile(this._jarFileURL);
                }
            }
        }
        return new byte[0];
    }

    String canonicalize(String string) {
        if (string.endsWith("/")) {
            return string;
        }
        return string;
    }

    void buildIndex() throws IOException {
        this.buildIndex(true);
    }

    void buildIndex(boolean bl) throws IOException {
        if (bl) {
            this.buildFullIndex();
        } else {
            this.buildHashIndex();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildFullIndex() throws IOException {
        if (this._entryNamesPool == null) {
            Object object = this._buildLock;
            synchronized (object) {
                if (this._entryNamesPool == null) {
                    try {
                        this.buildFullIndexImpl();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        this._entryNamesPool = new AlikeStrings(new String[0]);
                    }
                }
            }
        }
    }

    private void buildFullIndexImpl() throws IOException {
        PerformanceLogger.get().startTiming("indexjar_" + this._jarFileURL.toString());
        try {
            if (this._entryNamesPool != null) {
                PerformanceLogger.get().stopTiming("indexjar_" + this._jarFileURL.toString(), "Indexed JAR file " + URLFileSystem.getFileName(this._jarFileURL));
                return;
            }
            long l = -1;
            long l2 = -1;
            long l3 = System.currentTimeMillis();
            File file = JarUtil.getLocalTempJarFile(this._jarFileURL);
            if (file == null || !file.exists()) {
                this.initArrays(0);
                this._entryNamesPool = new AlikeStrings(new String[0]);
                PerformanceLogger.get().stopTiming("indexjar_" + this._jarFileURL.toString(), "Indexed JAR file " + URLFileSystem.getFileName(this._jarFileURL));
                return;
            }
            RandomAccessFile randomAccessFile = null;
            try {
                randomAccessFile = new RandomAccessFile(file, "r");
                if (this.centralDirSize == 0 && !this.findCDIR(randomAccessFile)) {
                    this.initArrays(0);
                    this._entryNamesPool = new AlikeStrings(new String[0]);
                    try {
                        if (randomAccessFile != null) {
                            randomAccessFile.close();
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    PerformanceLogger.get().stopTiming("indexjar_" + this._jarFileURL.toString(), "Indexed JAR file " + URLFileSystem.getFileName(this._jarFileURL));
                    return;
                }
                l = System.currentTimeMillis();
                byte[] byArray = new byte[this.centralDirSize];
                randomAccessFile.seek(this.centralDirOffset);
                randomAccessFile.readFully(byArray);
                l2 = System.currentTimeMillis();
                l -= l2;
                this.initArrays(this.numEntries);
                String[] stringArray = new String[this.numEntries];
                int n = 0;
                boolean bl = Encodings.isDefaultCp1252();
                int n2 = 0;
                while (n2 < this.centralDirSize && n < this.numEntries) {
                    String string;
                    int n3 = JarIndex.get4LE(byArray, n2 + 12);
                    int n4 = JarIndex.get4LE(byArray, n2 + 20);
                    int n5 = JarIndex.get4LE(byArray, n2 + 24);
                    int n6 = JarIndex.get2LE(byArray, n2 + 28);
                    int n7 = JarIndex.get2LE(byArray, n2 + 30);
                    int n8 = JarIndex.get2LE(byArray, n2 + 32);
                    int n9 = JarIndex.get4LE(byArray, n2 + 42);
                    int n10 = n2 + 46;
                    if (bl) {
                        char[] cArray = new char[n6];
                        int n11 = n6 - 1;
                        while (n11 >= 0) {
                            cArray[n11] = (char)(byArray[n10 + n11] & 0xFF);
                            --n11;
                        }
                        string = new String(cArray);
                    } else {
                        string = new String(byArray, n10, n6);
                    }
                    if (!this.pathlessFiles && string.indexOf(47) < 0) {
                        this.pathlessFiles = true;
                    }
                    stringArray[n] = string;
                    this._offsets[n] = n9;
                    this._cSizes[n] = n4;
                    this._ucSizes[n] = n5;
                    this._dostimes[n] = n3;
                    n2 += 46 + n6 + n7 + n8;
                    ++n;
                }
                if (n2 < this.centralDirSize) {
                    // empty if block
                }
                this.sortArrays(stringArray, 0, n - 1);
                long l4 = System.currentTimeMillis();
                l2 -= l4;
                l3 -= l4;
                this._entryNamesPool = new AlikeStrings(stringArray);
                stringArray = null;
                this._table = null;
                this._tableData = null;
                this._tableLen = 0;
            }
            finally {
                try {
                    if (randomAccessFile != null) {
                        randomAccessFile.close();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        finally {
            PerformanceLogger.get().stopTiming("indexjar_" + this._jarFileURL.toString(), "Indexed JAR file " + URLFileSystem.getFileName(this._jarFileURL));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void buildHashIndex() throws IOException {
        File file = JarUtil.getLocalTempJarFile(this._jarFileURL);
        if (file == null) return;
        if (!file.exists()) {
            return;
        }
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(file, "r");
            if (this.centralDirSize == 0 && !this.findCDIR(randomAccessFile)) {
                try {
                    if (randomAccessFile == null) return;
                    randomAccessFile.close();
                    return;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                return;
            }
            byte[] byArray = new byte[this.centralDirSize];
            randomAccessFile.seek(this.centralDirOffset);
            randomAccessFile.readFully(byArray);
            this._tableLen = this.numEntries / 2;
            this._table = new int[this._tableLen];
            this._tableData = new int[this.numEntries * 3 + 1];
            int n = 0;
            int n2 = 0;
            while (n2 < this.centralDirSize) {
                if (n >= this.numEntries) {
                    return;
                }
                int n3 = JarIndex.get4LE(byArray, n2 + 20);
                int n4 = JarIndex.get2LE(byArray, n2 + 28);
                int n5 = JarIndex.get2LE(byArray, n2 + 30);
                int n6 = JarIndex.get2LE(byArray, n2 + 32);
                int n7 = JarIndex.get4LE(byArray, n2 + 42);
                int n8 = n2 + 46;
                int n9 = JarIndex.hash(byArray, n2 + 46, n4) % this._tableLen;
                int n10 = n * 3 + 1;
                this._tableData[n10] = n7;
                this._tableData[n10 + 1] = n3;
                this._tableData[n10 + 2] = this._table[n9];
                this._table[n9] = n10;
                n2 = n8 + n4 + n5 + n6;
                ++n;
            }
            return;
        }
        finally {
            try {
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void tryBuildFullIndex() {
        try {
            this.buildFullIndex();
        }
        catch (IOException iOException) {
            this.initArrays(0);
            this._entryNamesPool = new AlikeStrings(new String[0]);
        }
    }

    private void initArrays(int n) {
        this._offsets = new int[n];
        this._cSizes = new int[n];
        this._ucSizes = new int[n];
        this._dostimes = new int[n];
    }

    private void sortArrays(String[] stringArray, int n, int n2) {
        int n3 = n;
        int n4 = n2;
        String string = stringArray[(n3 + n4) / 2];
        while (true) {
            if (stringArray[n3].compareTo(string) < 0) {
                ++n3;
                continue;
            }
            while (string.compareTo(stringArray[n4]) < 0) {
                --n4;
            }
            if (n3 <= n4) {
                String string2 = stringArray[n3];
                stringArray[n3] = stringArray[n4];
                stringArray[n4] = string2;
                int n5 = this._offsets[n3];
                this._offsets[n3] = this._offsets[n4];
                this._offsets[n4] = n5;
                n5 = this._cSizes[n3];
                this._cSizes[n3] = this._cSizes[n4];
                this._cSizes[n4] = n5;
                n5 = this._ucSizes[n3];
                this._ucSizes[n3] = this._ucSizes[n4];
                this._ucSizes[n4] = n5;
                n5 = this._dostimes[n3];
                this._dostimes[n3] = this._dostimes[n4];
                this._dostimes[n4] = n5;
                ++n3;
                --n4;
            }
            if (n3 > n4) break;
        }
        if (n < n4) {
            this.sortArrays(stringArray, n, n4);
        }
        if (n3 < n2) {
            this.sortArrays(stringArray, n3, n2);
        }
    }

    private int[] getOffsetAndSizes(String string) throws IOException {
        int n;
        if (string != null && (n = this._entryNamesPool.binarySearch(string)) >= 0) {
            return new int[]{this._offsets[n], this._cSizes[n], this._ucSizes[n]};
        }
        return new int[]{-1, -1, -1};
    }

    private int[] getLOC(RandomAccessFile randomAccessFile, byte[] byArray, String string) throws IOException {
        if (this._entryNamesPool == null) {
            return this.getLOCFromHash(randomAccessFile, byArray, string);
        }
        int[] nArray = this.getOffsetAndSizes(string);
        int n = nArray[0];
        if (n >= 0) {
            randomAccessFile.seek(n);
            randomAccessFile.read(byArray, 0, 30);
            if (byArray[0] == 80 && byArray[1] == 75 && byArray[2] == 3 && byArray[3] == 4) {
                int n2 = (byArray[26] & 0xFF) + ((byArray[27] & 0xFF) << 8);
                byte[] byArray2 = new byte[n2];
                randomAccessFile.readFully(byArray2);
                String string2 = new String(byArray2);
                if (ModelUtil.areDifferent((Object)string2, (Object)string)) {
                    throw new IOException("Mismatched entry names '" + string2 + "' and '" + string + "' for jar file" + this._jarFileURL.toString());
                }
                int n3 = (byArray[28] & 0xFF) + ((byArray[29] & 0xFF) << 8);
                randomAccessFile.skipBytes(n3);
                return nArray;
            }
            throw new IOException("Corrupt entry offset for URL " + this._jarFileURL.toString());
        }
        throw new FileNotFoundException(this.getJarEntryString(string));
    }

    private int[] getLOCFromHash(RandomAccessFile randomAccessFile, byte[] byArray, String string) throws IOException {
        if (this._table == null) {
            return null;
        }
        byte[] byArray2 = string.getBytes();
        int n = JarIndex.hash(byArray2, 0, byArray2.length);
        int n2 = this._table[n % this._tableLen];
        while (n2 != 0) {
            int n3;
            int n4 = this._tableData[n2];
            randomAccessFile.seek(n4);
            randomAccessFile.read(byArray, 0, 30);
            if ((long)JarIndex.get4LE(byArray, 0) == 67324752L && (n3 = JarIndex.get2LE(byArray, 26)) > 0 && n3 == byArray2.length) {
                byte[] byArray3 = new byte[n3];
                randomAccessFile.seek(n4 + 30);
                randomAccessFile.readFully(byArray3);
                int n5 = 0;
                while (n5 < n3) {
                    if (byArray2[n5] != byArray3[n5]) {
                        // empty if block
                    }
                    ++n5;
                }
                int n6 = (byArray[28] & 0xFF) + ((byArray[29] & 0xFF) << 8);
                randomAccessFile.skipBytes(n6);
                return new int[]{this._tableData[n2], this._tableData[n2 + 1], 0};
            }
            n2 = this._tableData[n2 + 2];
        }
        return null;
    }

    private String getJarEntryString(String string) {
        return this._jarFileURL.toString() + "!/" + string;
    }

    private static int getCompressionMethod(byte[] byArray) {
        return (byArray[8] & 0xFF) + ((byArray[9] & 0xFF) << 8);
    }

    public long getTimestamp(int n) {
        if (n < 0 || this._dostimes == null || n >= this._dostimes.length) {
            return this.getTimestamp();
        }
        int n2 = this._dostimes[n];
        GregorianCalendar gregorianCalendar = new GregorianCalendar((n2 >> 25 & 0x7F) + 80 + 1900, (n2 >> 21 & 0xF) - 1, n2 >> 16 & 0x1F, n2 >> 11 & 0x1F, n2 >> 5 & 0x3F, n2 << 1 & 0x3E);
        return gregorianCalendar.getTimeInMillis();
    }

    public long getTimestamp() {
        return this._timestamp;
    }

    private static final int get2LE(byte[] byArray, int n) {
        return (byArray[n] & 0xFF) + ((byArray[n + 1] & 0xFF) << 8);
    }

    private static final int get4LE(byte[] byArray, int n) {
        return (byArray[n] & 0xFF) + ((byArray[n + 1] & 0xFF) << 8) + ((byArray[n + 2] & 0xFF) << 16) + (byArray[n + 3] << 24);
    }

    private int dirEntryIndexImpl(String string) {
        String string2;
        this.tryBuildFullIndex();
        int n = this._entryNamesPool.binarySearch(string);
        if (n >= 0) {
            return n;
        }
        if (this.pathlessFiles && string.equals("./")) {
            return 0;
        }
        int n2 = -n - 1;
        if (n2 < this._offsets.length && (string2 = this._entryNamesPool.getStringFromIndex(n2)).startsWith(string)) {
            return n2;
        }
        return -1;
    }

    private String[] listImpl(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = this._offsets.length;
        int n2 = string.length();
        int n3 = this._entryNamesPool.binarySearch(string);
        if (n3 >= 0) {
            ++n3;
        } else if (n2 > 0) {
            if ((n3 = -n3 - 1) >= this._offsets.length) {
                return new String[0];
            }
        } else {
            n3 = 0;
        }
        while (n3 < n) {
            String string2 = this._entryNamesPool.getStringFromIndex(n3);
            if (!string2.startsWith(string)) break;
            if (string2.length() != n2) {
                String string3;
                int n4 = string2.indexOf(47, n2);
                String string4 = string3 = n4 >= n2 ? string2.substring(n2, n4 + 1) : string2.substring(n2);
                if (!arrayList.contains(string3)) {
                    arrayList.add(string3);
                }
            }
            ++n3;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static final int hash(byte[] byArray, int n, int n2) {
        int n3 = 0;
        int n4 = n;
        while (n4 < n + n2) {
            n3 = 31 * n3 + byArray[n4];
            ++n4;
        }
        return n3 < 0 ? n3 + Integer.MAX_VALUE : n3;
    }

    private boolean findCDIR(RandomAccessFile randomAccessFile) throws IOException {
        long l = randomAccessFile.length();
        long l2 = l - (long)22;
        byte[] byArray = new byte[22];
        int n = 65535;
        boolean bl = false;
        while (l2 >= 0L && n > 0) {
            randomAccessFile.seek(l2);
            randomAccessFile.readFully(byArray);
            if (byArray[0] == 80 && byArray[1] == 75 && byArray[2] == 5 && byArray[3] == 6) {
                this.numEntries = JarIndex.get2LE(byArray, 10);
                this.centralDirSize = JarIndex.get4LE(byArray, 12);
                this.centralDirOffset = JarIndex.get4LE(byArray, 16);
                int n2 = 65535 - n;
                if (n2 > 0) {
                    int n3 = JarIndex.get2LE(byArray, 20);
                    if (n3 != n2) break;
                    bl = true;
                    break;
                }
                bl = true;
                break;
            }
            --l2;
            --n;
        }
        if (!bl || this.centralDirSize <= 0 || (long)this.centralDirSize >= l) {
            // empty if block
        }
        return bl;
    }

    public static class OpenFileCaching
    implements ActionListener {
        private static HashMap _openJars;
        private static Timer _cacheTimer;
        private static final int CACHE_DELAY = 60000;
        private static OpenFileCaching _instance;

        public static void checkInit() {
            if (_instance != null) {
                return;
            }
            _openJars = new HashMap();
            _instance = new OpenFileCaching();
            _cacheTimer = new Timer(60000, _instance);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            OpenFileCaching.flushCache();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void flushCache() {
            HashMap hashMap = _openJars;
            synchronized (hashMap) {
                URL[] uRLArray = _openJars.keySet().toArray(new URL[_openJars.size()]);
                int n = 0;
                while (n < uRLArray.length) {
                    URL uRL = uRLArray[n];
                    Entry entry = (Entry)_openJars.get(uRL);
                    if (entry.isUnused()) {
                        RandomAccessFile randomAccessFile = entry.file;
                        try {
                            randomAccessFile.close();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        _openJars.remove(uRL);
                    }
                    ++n;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static RandomAccessFile getCachedFile(URL uRL) throws FileNotFoundException {
            Entry entry;
            OpenFileCaching.checkInit();
            HashMap hashMap = _openJars;
            synchronized (hashMap) {
                _cacheTimer.restart();
                entry = (Entry)_openJars.get(uRL);
                if (entry == null) {
                    File file = JarUtil.getLocalTempJarFile(uRL);
                    RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
                    entry = new Entry(randomAccessFile);
                    _openJars.put(uRL, entry);
                }
                ++entry.useCount;
            }
            return entry.file;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void releaseCachedFile(URL uRL) {
            HashMap hashMap = _openJars;
            synchronized (hashMap) {
                _cacheTimer.restart();
                Entry entry = (Entry)_openJars.get(uRL);
                if (entry != null) {
                    --entry.useCount;
                }
            }
        }

        OpenFileCaching() {
        }

        public static class Entry {
            public RandomAccessFile file;
            public int useCount;

            public Entry(RandomAccessFile randomAccessFile) {
                this.file = randomAccessFile;
            }

            public boolean isUnused() {
                return this.useCount == 0;
            }
        }
    }
}

