/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.net;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.UIManager;
import oracle.ide.net.JarIndex;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;

final class JarURLFileSystemHelper
extends URLFileSystemHelper {
    public URL canonicalize(URL uRL) {
        String string;
        int n;
        if (JarUtil.isJarURL(uRL) && (n = (string = uRL.getPath()).indexOf("!/")) >= 0) {
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 2);
            URL uRL2 = JarUtil.newJarFileURLImpl(string2);
            if (uRL2 != null) {
                String string4;
                JarIndex jarIndex;
                URL uRL3 = URLFileSystem.canonicalize(uRL2);
                String string5 = string3.length() > 0 ? ((jarIndex = JarURLFileSystemHelper.tryGetJarIndex(uRL)) != null ? jarIndex.canonicalize(string3) : string3) : string3;
                String string6 = uRL2.getPath();
                if (!string6.equals(string4 = uRL3.getPath()) || !string5.equals(string3)) {
                    String string7 = string6.equals(string4) ? string2 : string2.substring(0, string2.indexOf(string6)) + string4;
                    String string8 = string7 + "!/" + string5;
                    return URLFactory.replacePathPart(uRL, string8);
                }
            }
        }
        return uRL;
    }

    public boolean canRead(URL uRL) {
        return this.exists(uRL);
    }

    public boolean canWrite(URL uRL) {
        return false;
    }

    public boolean canCreate(URL uRL) {
        return this.exists(uRL);
    }

    public boolean exists(URL uRL) {
        JarIndex jarIndex;
        String string = JarUtil.getJarEntry(uRL);
        if (string != null && (jarIndex = JarURLFileSystemHelper.tryGetJarIndex(uRL, false)) != null) {
            return string.length() > 0 ? jarIndex.exists(string) : true;
        }
        return false;
    }

    public Icon getDefaultIcon(URL uRL) {
        String string = JarUtil.getJarEntry(uRL);
        if (string != null && string.length() == 0) {
            return UIManager.getIcon("FileView.archiveIcon");
        }
        return super.getDefaultIcon(uRL);
    }

    public String getFileName(URL uRL) {
        String string = uRL.getPath();
        int n = string.lastIndexOf("!/");
        if (n == string.length() - 2) {
            int n2 = string.lastIndexOf(47, n);
            return string.substring(n2 + 1, n);
        }
        return super.getFileName(uRL);
    }

    public long getLength(URL uRL) {
        JarIndex jarIndex = JarURLFileSystemHelper.tryGetJarIndex(uRL);
        if (jarIndex != null) {
            String string = JarUtil.getJarEntry(uRL);
            return jarIndex.getSize(string);
        }
        return -1;
    }

    public URL getParent(URL uRL) {
        String string = uRL.getPath();
        int n = string.indexOf("!/");
        if (n >= 0) {
            int n2 = n + 2;
            if (string.length() > n2) {
                int n3;
                if (string.endsWith("/")) {
                    string = string.substring(0, string.length() - 1);
                }
                String string2 = string.substring(0, (n3 = string.lastIndexOf("/")) >= n2 ? n3 + 1 : n2);
                return URLFactory.replacePathPart(uRL, string2);
            }
            string = string.substring(0, string.length() - 2);
            return JarUtil.newJarFileURLImpl(string);
        }
        return null;
    }

    public String getPlatformPathName(URL uRL) {
        URL uRL2 = JarUtil.getJarFileURL(uRL);
        String string = uRL != uRL2 ? URLFileSystem.getPlatformPathName(uRL2) : uRL.toString();
        String string2 = JarUtil.getJarEntry(uRL);
        if (string2 == null || string2.length() == 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append('!').append(File.separatorChar);
        stringBuffer.append(string2.replace('/', File.separatorChar));
        return stringBuffer.toString();
    }

    public boolean isDirectory(URL uRL) {
        String string = JarUtil.getJarEntry(uRL);
        if (string.length() == 0) {
            URL uRL2 = JarUtil.getJarFileURL(uRL);
            return URLFileSystem.exists(uRL2);
        }
        JarIndex jarIndex = JarURLFileSystemHelper.tryGetJarIndex(uRL);
        return jarIndex != null ? jarIndex.dirEntryIndex(string) >= 0 : false;
    }

    public long lastModified(URL uRL) {
        URL uRL2 = JarUtil.getJarFileURL(uRL);
        return URLFileSystem.lastModified(uRL2);
    }

    public URL[] list(URL uRL) {
        String string;
        String[] stringArray;
        JarIndex jarIndex = JarURLFileSystemHelper.tryGetJarIndex(uRL);
        if (jarIndex != null && (stringArray = jarIndex.list(string = JarUtil.getJarEntry(uRL))) != null) {
            ArrayList<URL> arrayList = new ArrayList<URL>();
            int n = stringArray.length - 1;
            while (n >= 0) {
                URL uRL2 = URLFactory.newJarURL(uRL, stringArray[n]);
                arrayList.add(uRL2);
                --n;
            }
            return arrayList.toArray(new URL[arrayList.size()]);
        }
        return null;
    }

    public InputStream openInputStream(URL uRL) throws IOException {
        JarIndex jarIndex = JarUtil.getJarIndex(uRL, false);
        if (jarIndex != null) {
            String string = JarUtil.getJarEntry(uRL);
            return jarIndex.openInputStream(string);
        }
        throw new FileNotFoundException(uRL != null ? uRL.toString() : "<null>");
    }

    public void rename(URL uRL, URL uRL2) throws IOException {
        String string = JarUtil.getJarEntry(uRL);
        if (string != null && string.length() != 0) {
            throw new IOException("Rename not supported inside JAR/ZIP files for oldURL: " + uRL.toString());
        }
        String string2 = JarUtil.getJarEntry(uRL2);
        if (string2 != null && string2.length() != 0) {
            throw new IOException("Rename not supported inside JAR/ZIP files for newURL: " + uRL.toString());
        }
        URL uRL3 = JarUtil.getJarFileURL(uRL);
        URL uRL4 = JarUtil.getJarFileURL(uRL2);
        URLFileSystem.renameEx(uRL3, uRL4);
    }

    public String toRelativeSpec(URL uRL, URL uRL2) {
        String string = JarUtil.getJarEntry(uRL);
        String string2 = JarUtil.getJarEntry(uRL2);
        URL uRL3 = JarUtil.getJarFileURL(uRL);
        URL uRL4 = JarUtil.getJarFileURL(uRL2);
        if (string != null && string.length() != 0 && string2 != null && string2.length() != 0 && string.startsWith(string2) && URLFileSystem.equals(uRL3, uRL4)) {
            return super.toRelativeSpec(uRL, uRL2);
        }
        return uRL.toString();
    }

    private static JarIndex tryGetJarIndex(URL uRL) {
        return JarURLFileSystemHelper.tryGetJarIndex(uRL, true);
    }

    private static JarIndex tryGetJarIndex(URL uRL, boolean bl) {
        try {
            JarIndex jarIndex = JarUtil.getJarIndex(uRL, bl);
            return jarIndex;
        }
        catch (IOException iOException) {
            JarIndex jarIndex = null;
            return jarIndex;
        }
    }

    JarURLFileSystemHelper() {
    }
}

