/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.net;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.jar.Manifest;
import oracle.ide.net.JarIndex;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLTempFile;
import oracle.ide.util.TimedCache;

public final class JarUtil {
    static final String JAR_URL_SEPARATOR = "!/";
    private static final String MANIFEST_FILE = "META-INF/MANIFEST.MF";
    private static final TimedCache _cachedJarIndexes = new TimedCache(300);
    private static final Object JAR_INDEX_LOCK = new Object();
    private static final TimedCache _urlTempFileCache = new TimedCache(300);

    private JarUtil() {
    }

    public static String getJarEntry(URL uRL) {
        String string;
        int n;
        if (JarUtil.isJarURL(uRL) && (n = (string = uRL.getPath()).indexOf(JAR_URL_SEPARATOR)) >= 0) {
            return string.substring(n + 2);
        }
        return null;
    }

    public static URL getJarFileURL(URL uRL) {
        String string;
        int n;
        if (JarUtil.isJarURL(uRL) && (n = (string = uRL.getPath()).indexOf(JAR_URL_SEPARATOR)) >= 0) {
            String string2 = string.substring(0, n);
            return JarUtil.newJarFileURLImpl(string2);
        }
        return uRL;
    }

    public static Manifest getManifest(URL uRL) throws IOException {
        return JarUtil.getManifestImpl(JarUtil.getManifestFileURL(uRL));
    }

    public static Manifest getManifest(File file) throws IOException {
        return JarUtil.getManifestImpl(JarUtil.getManifestFileURL(file));
    }

    public static String getMainClass(File file) throws IOException {
        return JarUtil.getMainClassImpl(JarUtil.getManifestFileURL(file));
    }

    public static String getMainClass(URL uRL) throws IOException {
        return JarUtil.getMainClassImpl(JarUtil.getManifestFileURL(uRL));
    }

    public static String getClassPath(File file) throws IOException {
        return JarUtil.getClassPathImpl(JarUtil.getManifestFileURL(file));
    }

    public static String getClassPath(URL uRL) throws IOException {
        return JarUtil.getClassPathImpl(JarUtil.getManifestFileURL(uRL));
    }

    public static boolean isJarURL(URL uRL) {
        return uRL != null ? uRL.getProtocol().equals("jar") : false;
    }

    public static JarIndex getJarIndex(URL uRL) throws IOException {
        return JarUtil.getJarIndex(uRL, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JarIndex getJarIndex(URL uRL, boolean bl) throws IOException {
        if (uRL == null) {
            return null;
        }
        URL uRL2 = JarUtil.getJarFileURL(uRL);
        long l = URLFileSystem.lastModified(uRL2);
        while (true) {
            Object object = null;
            boolean bl2 = false;
            Object object2 = JAR_INDEX_LOCK;
            synchronized (object2) {
                Object object3 = _cachedJarIndexes.get(uRL2);
                if (object3 != null && object3 instanceof JarIndex) {
                    JarIndex jarIndex = (JarIndex)object3;
                    if (jarIndex.getTimestamp() >= l) {
                        JarIndex jarIndex2 = jarIndex;
                        return jarIndex2;
                    }
                    _cachedJarIndexes.put(uRL2, null);
                    object3 = null;
                }
                if (object3 == null) {
                    bl2 = true;
                    object = new Object();
                    _cachedJarIndexes.put(uRL2, object);
                } else {
                    object = object3;
                }
            }
            Object object4 = object;
            synchronized (object4) {
                if (!bl2) {
                    try {
                        object.wait(50);
                    }
                    catch (InterruptedException interruptedException) {}
                } else {
                    JarIndex jarIndex = null;
                    try {
                        try {
                            jarIndex = new JarIndex(uRL2, l);
                            jarIndex.buildIndex(bl);
                        }
                        catch (IOException iOException) {
                            jarIndex = null;
                            throw iOException;
                        }
                        catch (RuntimeException runtimeException) {
                            jarIndex = null;
                            throw runtimeException;
                        }
                    }
                    catch (Throwable throwable) {
                        Object object5 = JAR_INDEX_LOCK;
                        synchronized (object5) {
                            _cachedJarIndexes.put(uRL2, jarIndex);
                        }
                        object.notifyAll();
                        throw throwable;
                    }
                    Object object6 = JAR_INDEX_LOCK;
                    synchronized (object6) {
                        _cachedJarIndexes.put(uRL2, jarIndex);
                    }
                    object.notifyAll();
                    JarIndex jarIndex3 = jarIndex;
                    return jarIndex3;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseJarIndex(URL uRL) {
        URL uRL2 = JarUtil.getJarFileURL(uRL);
        if (uRL2 != null) {
            Object object = JAR_INDEX_LOCK;
            synchronized (object) {
                _cachedJarIndexes.put(uRL2, null);
            }
        }
    }

    public static boolean isArchive(String string) {
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return false;
        }
        String string2 = string.substring(n).toLowerCase();
        return string2.equals(".jar") || string2.equals(".zip");
    }

    private static URL getManifestFileURL(File file) {
        return URLFactory.newJarURL(file, MANIFEST_FILE);
    }

    private static URL getManifestFileURL(URL uRL) {
        return URLFactory.newJarURL(uRL, MANIFEST_FILE);
    }

    private static String getMainClassImpl(URL uRL) throws IOException {
        return JarUtil.getManifestMainAttribute(uRL, "Main-Class");
    }

    private static String getClassPathImpl(URL uRL) throws IOException {
        return JarUtil.getManifestMainAttribute(uRL, "Class-Path");
    }

    private static Manifest getManifestImpl(URL uRL) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = URLFileSystem.openInputStream(uRL);
            Manifest manifest = new Manifest(inputStream);
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            return manifest;
        }
        catch (Throwable throwable) {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            throw throwable;
        }
    }

    private static String getManifestMainAttribute(URL uRL, String string) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = URLFileSystem.openInputStream(uRL);
            Manifest manifest = new Manifest(inputStream);
            String string2 = manifest.getMainAttributes().getValue(string);
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            return string2;
        }
        catch (Throwable throwable) {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static File getLocalTempJarFile(URL uRL) {
        URLTempFile uRLTempFile;
        TimedCache timedCache = _urlTempFileCache;
        synchronized (timedCache) {
            Object object = _urlTempFileCache.get(uRL);
            if (object != null) {
                uRLTempFile = (URLTempFile)object;
            } else {
                uRLTempFile = new URLTempFile(uRL);
                _urlTempFileCache.put(uRL, uRLTempFile);
            }
        }
        return uRLTempFile.getFile();
    }

    static URL newJarFileURLImpl(String string) {
        try {
            URL uRL = new URL(string);
            return uRL;
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            URL uRL = null;
            return uRL;
        }
    }
}

