/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.net;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.resource.IdeIcons;
import oracle.ide.resource.NetArb;
import oracle.ide.util.IdeUtil;

public class PackageClassChooser
extends DefaultTraversablePanel {
    public static final int PACKAGES_ONLY = 0;
    public static final int CLASSES_ONLY = 1;
    public static final int PACKAGES_AND_CLASSES = 2;
    public static final int APPROVE_OPTION = 0;
    public static final int CANCEL_OPTION = 1;
    public static final int ERROR_OPTION = 2;
    private boolean _multiSelect;
    private final int _scope;
    private final URLPath _path;
    private final Icon packageIcon;
    private final Icon classIcon;
    private final URLNode _root;
    private final DefaultTreeModel _dtm;
    private final JScrollPane _spPkgs;
    private final JTree _pkgTree;
    private transient JEWTDialog _dialog;

    void $init$() {
        this.packageIcon = IdeIcons.getIcon(23);
        this.classIcon = IdeIcons.getIcon(22);
        this._root = new URLNode("", true);
        this._dtm = new DefaultTreeModel(this._root);
        this._spPkgs = new JScrollPane();
        this._pkgTree = new JTree(this._dtm);
    }

    public PackageClassChooser(int n, URLPath uRLPath) {
        this.$init$();
        this._scope = n;
        this._path = uRLPath;
        this._root.buildChildren();
        this._dtm.nodeStructureChanged(this._root);
        this._pkgTree.setRootVisible(false);
        this._pkgTree.setShowsRootHandles(true);
        this._pkgTree.setCellRenderer(new TCR(null));
        UI uI = new UI(null);
        this._pkgTree.addTreeSelectionListener(uI);
        this._pkgTree.addTreeWillExpandListener(uI);
        this._spPkgs.getViewport().add((Component)this._pkgTree, null);
        this._pkgTree.setSelectionRow(0);
        this.setLayout(new BorderLayout());
        this.add((Component)this._spPkgs, "Center");
    }

    public String getSelection() {
        URLNode uRLNode;
        TreePath treePath = this._pkgTree.getSelectionPath();
        if (treePath != null && (uRLNode = (URLNode)treePath.getLastPathComponent()) != null) {
            return uRLNode.getRelPath();
        }
        return null;
    }

    public void setSelection(String string) {
        if (string != null) {
            this.setSelection(new String[]{string});
        }
    }

    private void setSelection(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        ArrayList<TreePath> arrayList = new ArrayList<TreePath>();
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            URLNode uRLNode = this._root;
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                URLNode uRLNode2 = uRLNode.findChild(string2);
                if (uRLNode2 == null) break;
                uRLNode = uRLNode2;
            }
            TreePath treePath = new TreePath(uRLNode.getPath());
            arrayList.add(treePath);
            ++n;
        }
        TreePath[] treePathArray = new TreePath[arrayList.size()];
        arrayList.toArray(treePathArray);
        this._pkgTree.setSelectionPaths(treePathArray);
        IdeUtil.centerTreeSelection(this._pkgTree);
    }

    public void setMultiSelect(boolean bl) {
        if (bl != this._multiSelect) {
            this._multiSelect = bl;
        }
    }

    public int showDialog(Component component) {
        return this.showDialog(component, this._multiSelect, null);
    }

    public JTree getTree() {
        return this._pkgTree;
    }

    public String[] getSelections() {
        TreePath[] treePathArray = this._pkgTree.getSelectionPaths();
        int n = treePathArray.length;
        ArrayList<String> arrayList = new ArrayList<String>(n);
        int n2 = 0;
        while (n2 < n) {
            URLNode uRLNode = (URLNode)treePathArray[n2].getLastPathComponent();
            if (uRLNode != null) {
                arrayList.add(uRLNode.getRelPath());
            }
            ++n2;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private String getTitle(boolean bl) {
        if (this._scope == 0) {
            return bl ? NetArb.getString(32) : NetArb.getString(33);
        }
        return bl ? NetArb.getString(34) : NetArb.getString(35);
    }

    private int showDialog(Component component, boolean bl, String[] stringArray) {
        String string = this.getTitle(bl);
        try {
            TreeSelectionModel treeSelectionModel = this._pkgTree.getSelectionModel();
            treeSelectionModel.setSelectionMode(bl ? 4 : 1);
            this.setSelection(stringArray);
            Frame frame = IdeUtil.findFrame(component);
            this._dialog = new JEWTDialog(frame, string, 7);
            this._dialog.setContent((Component)this);
            this._dialog.setResizable(true);
            this._dialog.setInitialFocus((Component)this._pkgTree);
            this.updateOKButton();
            boolean bl2 = WizardLauncher.runDialog((JDialog)this._dialog);
            this._dialog = null;
            int n = bl2 ? 0 : 1;
            return n;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            int n = 2;
            return n;
        }
    }

    private void updateOKButton() {
        if (this._dialog != null) {
            URLNode uRLNode;
            TreePath treePath = this._pkgTree.getSelectionPath();
            if (treePath != null && (uRLNode = (URLNode)treePath.getLastPathComponent()) != null) {
                this._dialog.setOKButtonEnabled(this._scope == 2 || this._scope == 0 && uRLNode.isPackage() || this._scope == 1 && !uRLNode.isPackage());
                return;
            }
            this._dialog.setOKButtonEnabled(false);
        }
    }

    static URLPath ra$_path(PackageClassChooser packageClassChooser) {
        return packageClassChooser._path;
    }

    static int ra$_scope(PackageClassChooser packageClassChooser) {
        return packageClassChooser._scope;
    }

    static DefaultTreeModel ra$_dtm(PackageClassChooser packageClassChooser) {
        return packageClassChooser._dtm;
    }

    static Icon ra$packageIcon(PackageClassChooser packageClassChooser) {
        return packageClassChooser.packageIcon;
    }

    static Icon ra$classIcon(PackageClassChooser packageClassChooser) {
        return packageClassChooser.classIcon;
    }

    static void mav$updateOKButton(PackageClassChooser packageClassChooser) {
        packageClassChooser.updateOKButton();
    }

    private class URLNode
    extends DefaultMutableTreeNode {
        private final String _relPath;
        private final boolean _isPackage;
        private String _name;
        private boolean _isExpanded;

        URLNode(String string, boolean bl) {
            this._relPath = string;
            this._isPackage = bl;
        }

        public String toString() {
            if (this._name == null) {
                int n = this._relPath.lastIndexOf("/");
                this._name = n >= 0 ? this._relPath.substring(n + 1) : this._relPath;
            }
            return this._name;
        }

        public boolean isLeaf() {
            return this._isPackage ^ true;
        }

        boolean isPackage() {
            return this._isPackage;
        }

        Icon getIcon() {
            return this._isPackage ? PackageClassChooser.ra$packageIcon(PackageClassChooser.this) : PackageClassChooser.ra$classIcon(PackageClassChooser.this);
        }

        boolean isExpanded() {
            return this._isExpanded;
        }

        String getRelPath() {
            return this._relPath.replace('/', '.');
        }

        URLNode findChild(String string) {
            if (string == null) {
                return null;
            }
            if (!this._isExpanded) {
                this.buildChildren();
            }
            Enumeration<TreeNode> enumeration = this.children();
            while (enumeration.hasMoreElements()) {
                URLNode uRLNode = (URLNode)enumeration.nextElement();
                if (!string.equals(uRLNode.toString())) continue;
                return uRLNode;
            }
            return null;
        }

        void buildChildren() {
            List list = PackageClassChooser.ra$_path(PackageClassChooser.this).getDirectories(this._relPath);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string = iterator.next().toString();
                URLNode uRLNode = new URLNode(string, true);
                this.add(uRLNode);
            }
            if (PackageClassChooser.ra$_scope(PackageClassChooser.this) == 1 || PackageClassChooser.ra$_scope(PackageClassChooser.this) == 2) {
                List list2 = PackageClassChooser.ra$_path(PackageClassChooser.this).getFiles(this._relPath);
                for (URL uRL : list2) {
                    if (!URLFileSystem.hasSuffix(uRL, ".class")) continue;
                    String string = PackageClassChooser.ra$_path(PackageClassChooser.this).toRelativePath(uRL);
                    string = string.substring(0, string.length() - 6);
                    URLNode uRLNode = new URLNode(string, false);
                    this.add(uRLNode);
                }
            }
            PackageClassChooser.ra$_dtm(PackageClassChooser.this).nodeStructureChanged(this);
            this._isExpanded = true;
        }
    }

    private static class TCR
    extends DefaultTreeCellRenderer {
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            JLabel jLabel = (JLabel)super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            URLNode uRLNode = (URLNode)object;
            jLabel.setIcon(uRLNode.getIcon());
            return jLabel;
        }

        private TCR() {
        }

        TCR(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private class UI
    implements TreeWillExpandListener,
    TreeSelectionListener {
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            PackageClassChooser.mav$updateOKButton(PackageClassChooser.this);
        }

        public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) {
            TreePath treePath = treeExpansionEvent.getPath();
            URLNode uRLNode = (URLNode)treePath.getLastPathComponent();
            if (uRLNode != null && !uRLNode.isExpanded()) {
                uRLNode.buildChildren();
            }
        }

        public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) {
        }

        private UI() {
        }

        UI(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

