/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.net;

import java.awt.AWTEvent;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.net.URL;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListSelectionModel;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.RootPaneContainer;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.controls.DoubleClickTrigger;
import oracle.ide.controls.GridBagConstants;
import oracle.ide.controls.KeyNavigableTree;
import oracle.ide.controls.KeyNavigationManager;
import oracle.ide.controls.ThinBevel;
import oracle.ide.controls.WaitCursor;
import oracle.ide.dialogs.DialogRunnerCallback;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.FileNativeHelper;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLChooserEvent;
import oracle.ide.net.URLChooserListener;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.net.WildcardURLFilter;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TDialog;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.Traversable;
import oracle.ide.resource.IdeIcons;
import oracle.ide.resource.NetArb;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.ide.util.SwingWorker;
import oracle.javatools.controls.WashedIcon;
import oracle.javatools.controls.nicetable.NiceTable;
import oracle.javatools.controls.nicetable.NiceTableCellRenderer;
import oracle.javatools.controls.nicetable.NiceTableModel;
import oracle.javatools.util.SwingUtils;

public class URLChooser
extends DefaultTraversablePanel
implements GridBagConstants {
    public static final URLFilter ALL_FILES_FILTER = new DefaultURLFilter(NetArb.getString(0));
    public static final int CANCEL_OPTION = 1;
    public static final int APPROVE_OPTION = 0;
    public static final int ERROR_OPTION = -1;
    public static final int MULTIPLE_INTERVAL_SELECTION = 2;
    public static final int SINGLE_INTERVAL_SELECTION = 1;
    public static final int SINGLE_SELECTION = 0;
    public static final int FILES_ONLY = 0;
    public static final int DIRECTORIES_ONLY = 1;
    public static final int DIRECTORIES_OR_FILES = 2;
    private static final int OPEN_DIALOG = 0;
    private static final int SAVE_DIALOG = 1;
    protected static final String HELP_TOPIC_SELECT_FILES = "f1_idedurlchooserfile_html";
    protected static final String HELP_TOPIC_SELECT_DIRECTORIES = "f1_idedurlchooserdir_html";
    protected static final String HELP_TOPIC_SELECT_FILES_OR_DIRECTORIES = "f1_idedurlchooserfiledir_html";
    private static final Pattern FILE_SEPARATORS_PATTERN;
    private static final boolean _isCaseSensitive;
    private static final Comparator _comparator;
    private static final Dimension DEFAULT_DIALOG_SIZE;
    private static Dimension _preferredSize;
    private static final Dimension SHORTCUT_BUTTON_SIZE;
    private static final AlphaComposite SHORTCUT_BACKGROUND_COMPOSITE;
    private static final String[] FILE_TABLE_COLUMN_NAMES;
    private static final Color SHORTCUT_BAR_BACKGROUND_COLOR;
    private static final Color INACTIVE_BACKGROUND_SELECTION_COLOR;
    private static final Color INACTIVE_TEXT_SELECTION_COLOR;
    private static final NumberFormat NUMBER_FORMATTER;
    private static final DateFormat DATE_FORMATTER;
    private static final KeyStroke REFRESH_KEYSTROKE;
    private static final KeyStroke TABLE_DESCEND_KEYSTROKE;
    private static final KeyStroke TABLE_ASCEND_KEYSTROKE;
    private static final KeyStroke[] TABLE_SELECT_CURRENT_KEYSTROKES;
    private static final KeyStroke TABLE_TOGGLE_SELECT_KEYSTROKE;
    private final L _listener;
    private final ShortcutBar _shortcutBar;
    private final JLabel _lblLocation;
    private final JComboBox _cbLocation;
    private final CommandBar _commandBar;
    private final URLNode _root;
    private final DefaultTreeModel _dtm;
    private final JScrollPane _spDirs;
    private final JTree _dirTree;
    private final FileView _fileView;
    private final JLabel _lblFileName;
    private final TF _tfFileName;
    private final DefaultComboBoxModel _modelFileType;
    private final JLabel _lblFileType;
    private final JComboBox _cbFileType;
    private boolean _showJarsAsDirs;
    private final transient Comparator _urlNodeComparator;
    private final transient ArrayList _historyList;
    private transient int _selectionMode;
    private transient int _selectionScope;
    private transient Dlg _urlChooserDialog;
    private transient URLNode _selectedNode;
    private transient URL _selectedURL;
    private transient URLFilter _curFilter;
    private transient JWindow _completionWindow;
    private transient JScrollPane _completionScrollPane;
    private transient CL _completionList;
    private transient Set _extraURLs;
    private List _chooserListener;
    private DialogRunnerCallback _dialogCallback;

    static {
        _isCaseSensitive = URLFileSystem.isLocalFileSystemCaseSensitive();
        _comparator = _isCaseSensitive ? null : String.CASE_INSENSITIVE_ORDER;
        DEFAULT_DIALOG_SIZE = new Dimension(600, 450);
        _preferredSize = new Dimension(550, 300);
        SHORTCUT_BUTTON_SIZE = new Dimension(73, 60);
        SHORTCUT_BACKGROUND_COMPOSITE = AlphaComposite.getInstance(3, 0.5f);
        FILE_TABLE_COLUMN_NAMES = new String[]{NetArb.getString(26), NetArb.getString(27), NetArb.getString(28)};
        SHORTCUT_BAR_BACKGROUND_COLOR = new Color(255, 251, 247);
        INACTIVE_BACKGROUND_SELECTION_COLOR = UIManager.getColor("oracle.ide.explorer.TreeExplorer.inactiveSelectionBackground");
        INACTIVE_TEXT_SELECTION_COLOR = UIManager.getColor("oracle.ide.explorer.TreeExplorer.inactiveSelectionForeground");
        NUMBER_FORMATTER = NumberFormat.getNumberInstance();
        DATE_FORMATTER = DateFormat.getDateTimeInstance(3, 3);
        REFRESH_KEYSTROKE = KeyStroke.getKeyStroke(116, 0);
        TABLE_DESCEND_KEYSTROKE = KeyStroke.getKeyStroke(10, 0);
        TABLE_ASCEND_KEYSTROKE = KeyStroke.getKeyStroke(8, 0);
        TABLE_SELECT_CURRENT_KEYSTROKES = new KeyStroke[]{KeyStroke.getKeyStroke(32, 0), KeyStroke.getKeyStroke(37, 0), KeyStroke.getKeyStroke(226, 0), KeyStroke.getKeyStroke(39, 0), KeyStroke.getKeyStroke(227, 0)};
        TABLE_TOGGLE_SELECT_KEYSTROKE = KeyStroke.getKeyStroke(32, 2);
        String string = "[" + WildcardURLFilter.makeLiteral(File.separator) + (File.separatorChar == '/' ? "" : "/") + "]";
        FILE_SEPARATORS_PATTERN = Pattern.compile(string);
    }

    void $init$() {
        this._listener = new L(null);
        this._shortcutBar = new ShortcutBar();
        this._lblLocation = new JLabel();
        this._cbLocation = new JComboBox();
        this._commandBar = new CommandBar();
        this._root = new URLNode();
        this._dtm = new DefaultTreeModel(this._root);
        this._spDirs = new JScrollPane();
        this._dirTree = new KeyNavigableTree(this._dtm);
        this._fileView = new FileView();
        this._lblFileName = new JLabel();
        this._tfFileName = new TF();
        this._modelFileType = new DefaultComboBoxModel();
        this._lblFileType = new JLabel();
        this._cbFileType = new JComboBox(this._modelFileType);
        this._showJarsAsDirs = true;
        this._urlNodeComparator = new URLNodeComparator(true, _isCaseSensitive);
        this._historyList = new ArrayList();
        this._selectionMode = 0;
        this._selectionScope = -1;
    }

    public URLChooser() {
        this((URL)null);
    }

    public URLChooser(URL uRL) {
        this(null, uRL);
    }

    public URLChooser(URL[] uRLArray, URL uRL) {
        this.$init$();
        this.initHelpID();
        ResourceUtils.resLabel(this._lblLocation, this._cbLocation, NetArb.getString(1));
        ResourceUtils.resLabel(this._lblFileName, this._tfFileName, NetArb.getString(2));
        ResourceUtils.resLabel(this._lblFileType, this._cbFileType, NetArb.getString(3));
        this._cbLocation.setMaximumRowCount(25);
        this._cbLocation.setRenderer(new LCR1(null));
        this._cbLocation.addPopupMenuListener(this._listener);
        this._cbLocation.setPrototypeDisplayValue(this._root);
        this._dirTree.setRootVisible(false);
        this._dirTree.setShowsRootHandles(true);
        this._dirTree.setScrollsOnExpand(true);
        this._dirTree.getSelectionModel().setSelectionMode(1);
        this._dirTree.setCellRenderer(new TCR(null));
        this._dirTree.addTreeSelectionListener(this._listener);
        this._dirTree.addTreeWillExpandListener(this._listener);
        this._spDirs.setViewportView(this._dirTree);
        this._commandBar.setDetailsView(this._fileView.isDetailsView());
        this._fileView.addViewListSelectionListener(this._listener);
        this._fileView.addViewMouseListener(this._listener);
        this._tfFileName.getDocument().addDocumentListener(this._listener);
        this._cbFileType.addActionListener(this._listener);
        this.addAncestorListener(this._listener);
        this.addChooseableURLFilter(ALL_FILES_FILTER);
        this.setURLFilter(null);
        this.setSelectionScope(0);
        this.setRoots(uRLArray != null ? uRLArray : URLFileSystem.listRoots());
        this.setSelectedURL(uRL);
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(_preferredSize);
        this.setMinimumSize(new Dimension(20, 20));
        Insets insets = new Insets(0, 5, 0, 0);
        Insets insets2 = new Insets(5, 0, 5, 0);
        Insets insets3 = new Insets(5, 5, 5, 0);
        this.add((Component)this._lblLocation, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, insets, 0, 0));
        this.add((Component)this._cbLocation, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
        this.add((Component)this._commandBar, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)this._shortcutBar, new GridBagConstraints(0, 1, 1, 3, 0.0, 0.0, 18, 1, insets2, 0, 0));
        this.add((Component)this._fileView, new GridBagConstraints(1, 1, 3, 1, 0.0, 1.0, 18, 1, insets3, 0, 0));
        this.add((Component)this._lblFileName, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, insets3, 0, 0));
        this.add((Component)this._tfFileName, new GridBagConstraints(2, 2, 2, 1, 0.0, 0.0, 17, 2, insets3, 0, 0));
        this.add((Component)this._lblFileType, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, insets3, 0, 0));
        this.add((Component)this._cbFileType, new GridBagConstraints(2, 3, 2, 1, 0.0, 0.0, 17, 2, insets3, 0, 0));
    }

    public URLChooser(URL uRL, boolean bl) {
        this(null, uRL);
        this.setShowJarsAsDirs(bl);
    }

    public URLChooser(URL[] uRLArray, URL uRL, boolean bl) {
        this(uRLArray, uRL);
        this.setShowJarsAsDirs(bl);
    }

    public void setExtraURLs(URL[] uRLArray) {
        URL uRL;
        if (uRLArray != null) {
            if (this._extraURLs == null) {
                this._extraURLs = new HashSet();
            } else {
                this._extraURLs.clear();
            }
            int n = 0;
            while (n < uRLArray.length) {
                URL uRL2 = uRLArray[n];
                while (uRL2 != null && !URLFileSystem.exists(uRL2)) {
                    this._extraURLs.add(uRL2);
                    uRL2 = URLFileSystem.getParent(uRL2);
                }
                ++n;
            }
        } else {
            this._extraURLs = null;
        }
        this.refreshNode(this._selectedNode);
        String string = this.getFileNameURL();
        if (ModelUtil.hasLength((String)string) && (uRL = this.getSelectedURL()) != null) {
            if (!URLFileSystem.isDirectoryPath(uRL)) {
                uRL = URLFileSystem.getParent(uRL);
            }
            URL uRL3 = URLFactory.newURL(uRL, string);
            this.clearHistoryList();
            this.setSelectedURL(uRL3);
        }
    }

    public URL[] getExtraURLs() {
        return this._extraURLs != null ? this._extraURLs.toArray(new URL[this._extraURLs.size()]) : null;
    }

    public void setDialogRunnerCallback(DialogRunnerCallback dialogRunnerCallback) {
        this._dialogCallback = dialogRunnerCallback;
    }

    public DialogRunnerCallback getDialogRunnerCallback() {
        return this._dialogCallback;
    }

    public void setShowJarsAsDirs(boolean bl) {
        this._showJarsAsDirs = bl;
        this.refreshAll();
    }

    public boolean getShowJarsAsDirs() {
        return this._showJarsAsDirs;
    }

    public boolean accept(URL uRL) {
        return this._curFilter.accept(uRL);
    }

    public void addChooseableURLFilter(URLFilter uRLFilter) {
        if (uRLFilter != null && this._modelFileType.getIndexOf(uRLFilter) < 0) {
            this._modelFileType.addElement(uRLFilter);
        }
    }

    public void clearChooseableURLFilters() {
        this._modelFileType.removeAllElements();
    }

    public URLFilter[] getChooseableURLFilters() {
        int n = this._modelFileType.getSize();
        URLFilter[] uRLFilterArray = new URLFilter[n];
        int n2 = 0;
        while (n2 < n) {
            uRLFilterArray[n2] = (URLFilter)this._modelFileType.getElementAt(n2);
            ++n2;
        }
        return uRLFilterArray;
    }

    public void addShortcutButton(Icon icon, String string, URL uRL) {
        this._shortcutBar.addShortcutButton(icon, string, uRL);
    }

    public void removeShortcutButtons() {
        this._shortcutBar.removeShortcutButtons();
    }

    public boolean approveSelection() {
        URL uRL;
        String string;
        URL uRL2;
        File file;
        URL uRL3 = this.getApprovalFileListURL();
        if (!(uRL3 == null || this._selectionScope == 0 && URLFileSystem.isDirectoryPath(uRL3))) {
            this._selectedURL = null;
            return true;
        }
        String string2 = this.getFileNameURL();
        URLNode uRLNode = this.getSelectedDirTreeNode();
        if (!(this._selectionScope != 1 && this._selectionScope != 2 || ModelUtil.hasLength((String)string2) || uRLNode == null)) {
            this._selectedURL = uRLNode.getURL();
            return true;
        }
        if (WildcardURLFilter.hasWildcard(string2)) {
            this.setURLFilter(new WildcardURLFilter(string2, _isCaseSensitive));
            this._tfFileName.selectAll();
            return false;
        }
        if (string2.length() == 2 && string2.endsWith(":") && File.separatorChar == '\\') {
            File file2 = new File(string2 + '\\');
            File file3 = file = file2.exists() ? file2 : null;
            if (file == null) {
                JOptionPane.showMessageDialog(this, NetArb.format(12, string2), NetArb.getString(11), 0);
                this._tfFileName.selectAll();
                return false;
            }
        } else {
            file = new File(string2);
        }
        if (file.isAbsolute()) {
            uRL2 = URLFactory.newFileURL(file);
        } else {
            TreeNode[] treeNodeArray;
            String string3 = string2.replace(File.separatorChar, '/');
            URLNode uRLNode2 = string3.startsWith("/") && uRLNode != null ? ((treeNodeArray = uRLNode.getPath()).length > 1 ? (URLNode)treeNodeArray[1] : null) : uRLNode;
            if (uRLNode2 == null) {
                return false;
            }
            URL uRL4 = uRLNode2.getURL();
            uRL2 = URLFactory.newURL(uRL4, string3);
        }
        if (this.getShowJarsAsDirs() && ((string = URLFileSystem.getSuffix(uRL2)).equals(".jar") || string.equals(".zip") || string.equals(".war") || string.equals(".ear")) && URLFileSystem.exists(uRL2) && !URLFileSystem.isDirectory(uRL2)) {
            uRL2 = URLFactory.newJarURL(uRL2, "");
        }
        if (this._selectionScope == 1 && !URLFileSystem.isDirectoryPath(uRL2)) {
            uRL2 = URLFactory.newURL(uRL2, "");
        }
        if (URLFileSystem.isDirectory(uRL = this.canonicalizeApprovalURL(uRL2)) || this.isExtraDirectoryURL(uRL)) {
            this.setSelectedURL(URLFactory.newURL(uRL, ""));
            this.setFileNameURL(null);
            return false;
        }
        if (this.checkApprovalParentExists(uRL)) {
            this._selectedURL = uRL;
            return true;
        }
        this.showNotFoundError(uRL);
        return false;
    }

    public void cancelSelection() {
    }

    public void changeToParentDirectory() {
        this.runLater(1);
    }

    public URL getSelectedURL() {
        if (this._selectedURL != null) {
            return this._selectedURL;
        }
        URL uRL = this.getApprovalFileListURL();
        if (uRL != null) {
            return uRL;
        }
        return this._selectedNode != null ? this._selectedNode.getURL() : null;
    }

    public String getFileNameURL() {
        return this._tfFileName.getText();
    }

    public void setFileNameURL(String string) {
        this._tfFileName.setText(string != null ? string : "");
    }

    public URL[] getSelectedURLs() {
        boolean bl = false;
        if (this._selectionScope == 0 || this._selectionScope == 2) {
            if (this._selectedURL != null) {
                return new URL[]{this._selectedURL};
            }
            Object[] objectArray = this._fileView.getSelectedValues();
            if (objectArray != null) {
                int n = objectArray.length;
                URL[] uRLArray = new URL[n];
                int n2 = 0;
                while (n2 < n) {
                    URLNode uRLNode = (URLNode)objectArray[n2];
                    uRLArray[n2] = uRLNode.getURL();
                    ++n2;
                }
                return uRLArray;
            }
            if (this._selectionScope == 0) {
                return null;
            }
            bl = true;
        }
        if (this._selectionScope == 1 || bl) {
            TreePath[] treePathArray = this._dirTree.getSelectionPaths();
            int n = treePathArray.length;
            URL[] uRLArray = new URL[n];
            int n3 = 0;
            while (n3 < n) {
                URLNode uRLNode = (URLNode)treePathArray[n3].getLastPathComponent();
                uRLArray[n3] = uRLNode.getURL();
                ++n3;
            }
            return uRLArray;
        }
        return null;
    }

    public void setSelectionMode(int n) {
        if (n != 2 && n != 1 && n != 0) {
            throw new IllegalArgumentException();
        }
        this._selectionMode = n;
        if (this._selectionScope == 1) {
            int n2 = URLChooser.toTreeSelectionMode(n);
            this._dirTree.getSelectionModel().setSelectionMode(n2);
        } else {
            this._fileView.setSelectionMode(n);
        }
    }

    public void setRoots(URL[] uRLArray) {
        this._root.removeAllChildren();
        if (uRLArray != null) {
            int n = 0;
            while (n < uRLArray.length) {
                URL uRL = uRLArray[n];
                URLNode uRLNode = new URLNode(uRL);
                this._root.add(uRLNode);
                ++n;
            }
            this._root.setExpanded(true);
        }
        if (this._selectionScope == 1) {
            this._dtm.nodeStructureChanged(this._root);
        }
    }

    public void setSelectedURL(URL uRL) {
        this.setSelectedURLImpl(uRL, true);
    }

    public void setSelectionScope(int n) {
        if (this._selectionScope == n) {
            return;
        }
        switch (n) {
            case 0: 
            case 2: {
                this.remove(this._spDirs);
                this.add((Component)this._fileView, new GridBagConstraints(1, 1, 3, 1, 0.0, 1.0, 18, 1, new Insets(5, 5, 5, 0), 0, 0));
                this._lblFileType.setVisible(true);
                this._cbFileType.setVisible(true);
                ResourceUtils.resLabel(this._lblFileName, this._tfFileName, NetArb.getString(2));
                break;
            }
            case 1: {
                int n2 = URLChooser.toTreeSelectionMode(this._selectionMode);
                this._dirTree.getSelectionModel().setSelectionMode(n2);
                this.remove(this._fileView);
                this.add((Component)this._spDirs, new GridBagConstraints(1, 1, 3, 1, 0.0, 1.0, 18, 1, new Insets(5, 5, 5, 0), 0, 0));
                this._lblFileType.setVisible(false);
                this._cbFileType.setVisible(false);
                ResourceUtils.resLabel(this._lblFileName, this._tfFileName, NetArb.getString(4));
                this.setFileNameURL(null);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this._selectionScope = n;
        this._commandBar.setSelectionScope(n);
        this.refreshAll();
        this.initHelpID();
    }

    public void setURLFilter(URLFilter uRLFilter) {
        URLFilter uRLFilter2;
        if (uRLFilter != null) {
            int n = this._modelFileType.getIndexOf(uRLFilter);
            if (n < 0) {
                this.addChooseableURLFilter(uRLFilter);
            }
            uRLFilter2 = uRLFilter;
        } else {
            uRLFilter2 = ALL_FILES_FILTER;
        }
        this._modelFileType.setSelectedItem(uRLFilter2);
        this._curFilter = uRLFilter2;
    }

    public void flush() {
        this.flushNodes();
    }

    public int showOpenDialog(Component component) {
        return this.showDialog(component, this, 0, null);
    }

    public int showOpenDialog(Component component, String string) {
        return this.showDialog(component, this, 0, string);
    }

    public int showOpenDialog(Component component, Traversable traversable, String string) {
        return this.showDialog(component, traversable, 0, string);
    }

    public int showSaveDialog(Component component) {
        return this.showDialog(component, this, 1, null);
    }

    public int showSaveDialog(Component component, String string) {
        return this.showDialog(component, this, 1, string);
    }

    public int showSaveDialog(Component component, Traversable traversable, String string) {
        return this.showDialog(component, traversable, 1, string);
    }

    protected URL canonicalizeApprovalURL(URL uRL) {
        return URLFileSystem.canonicalize(uRL);
    }

    protected URL getApprovalFileListURL() {
        URLNode uRLNode = this.getSelectedFileListNode();
        return uRLNode != null ? uRLNode.getURL() : null;
    }

    protected boolean checkApprovalParentExists(URL uRL) {
        URL uRL2 = URLFileSystem.getParent(uRL);
        return URLFileSystem.exists(uRL2) || this.isExtraDirectoryURL(uRL2);
    }

    public void addURLChooserListener(URLChooserListener uRLChooserListener) {
        if (this._chooserListener == null) {
            this._chooserListener = new ArrayList();
        }
        this._chooserListener.add(uRLChooserListener);
    }

    public void removeURLChooserListener(URLChooserListener uRLChooserListener) {
        if (this._chooserListener == null || !this._chooserListener.contains(uRLChooserListener)) {
            throw new IllegalArgumentException("Not a listener for this object");
        }
        this._chooserListener.remove(uRLChooserListener);
        if (this._chooserListener.size() == 0) {
            this._chooserListener = null;
        }
    }

    public void addNotify() {
        super.addNotify();
        URLChooser uRLChooser = this._urlChooserDialog != null ? (JComponent)this._urlChooserDialog.getRootPane() : this;
        URLChooser.addKeyboardAction((JComponent)uRLChooser, (Action)new RefreshAction(null), "urlchooser-refresh", REFRESH_KEYSTROKE, 1);
    }

    public void removeNotify() {
        super.removeNotify();
        URLChooser uRLChooser = this._urlChooserDialog != null ? (JComponent)this._urlChooserDialog.getRootPane() : this;
        URLChooser.removeKeyboardAction(uRLChooser, REFRESH_KEYSTROKE, 1);
    }

    private boolean isExtraDirectoryURL(URL uRL) {
        if (uRL == null || this._extraURLs == null) {
            return false;
        }
        uRL = URLFactory.newURL(uRL, "");
        return this._extraURLs.contains(uRL);
    }

    private void checkIsExtra(URLNode uRLNode) {
        if (this._extraURLs != null && uRLNode != null && !uRLNode.isLeaf() && !uRLNode.exists() && this._extraURLs.contains(uRLNode.getURL())) {
            uRLNode.setExtra(true);
            return;
        }
    }

    private void initHelpID() {
        String string = this.getHelpID();
        switch (this._selectionScope) {
            case 1: {
                if (string != null && !string.equals(HELP_TOPIC_SELECT_FILES) && !string.equals(HELP_TOPIC_SELECT_FILES_OR_DIRECTORIES)) break;
                this.setHelpID(HELP_TOPIC_SELECT_DIRECTORIES);
                break;
            }
            case 2: {
                if (string != null && !string.equals(HELP_TOPIC_SELECT_FILES) && !string.equals(HELP_TOPIC_SELECT_DIRECTORIES)) break;
                this.setHelpID(HELP_TOPIC_SELECT_FILES_OR_DIRECTORIES);
                break;
            }
            default: {
                if (string != null && !string.equals(HELP_TOPIC_SELECT_DIRECTORIES)) break;
                this.setHelpID(HELP_TOPIC_SELECT_FILES);
            }
        }
    }

    private void showNotFoundError(URL uRL) {
        if (this.getParent() != null) {
            JOptionPane.showMessageDialog(this, NetArb.format(14, URLFileSystem.getPlatformPathName(uRL)), NetArb.getString(13), 0);
        }
    }

    private void pushHistoryList(URLNode uRLNode) {
        URL uRL = uRLNode != null ? uRLNode.getURL() : null;
        int n = this._historyList.size();
        if (n > 0) {
            URL uRL2 = (URL)this._historyList.get(n - 1);
            if (n == 1 && uRL2 == null) {
                this._historyList.remove(0);
            } else if (URLFileSystem.equals(uRL, uRL2)) {
                return;
            }
        }
        this._historyList.add(uRL);
        this.updateHistoryButtonStatus();
    }

    private void popHistoryList() {
        int n = this._historyList.size();
        if (n > 1) {
            this._historyList.remove(n - 1);
            URL uRL = (URL)this._historyList.get(n - 2);
            this.setSelectedURLImpl(uRL, false);
            this.updateHistoryButtonStatus();
        }
    }

    private void clearHistoryList() {
        this._historyList.clear();
    }

    private void updateHistoryButtonStatus() {
        this._commandBar.enableBackButton(this._historyList.size() > 1);
    }

    private int showDialog(Component component, Traversable traversable, int n, String string) {
        try {
            String string2;
            String string3;
            switch (n) {
                case 0: {
                    if (this._selectionScope == 0 || this._selectionScope == 2) {
                        string3 = NetArb.getString(16);
                        string2 = string != null ? string : NetArb.getString(15);
                        break;
                    }
                    string3 = NetArb.getString(18);
                    string2 = string != null ? string : NetArb.getString(17);
                    break;
                }
                default: {
                    if (this._selectionScope == 0) {
                        string3 = NetArb.getString(20);
                        string2 = string != null ? string : NetArb.getString(19);
                        break;
                    }
                    string3 = NetArb.getString(18);
                    string2 = string != null ? string : NetArb.getString(17);
                }
            }
            1 var7_7 = new 1(this, component, string2, traversable, null, traversable, string3);
            this._urlChooserDialog = (Dlg)var7_7.initDialog();
            this._urlChooserDialog.setPreferredSize(DEFAULT_DIALOG_SIZE);
            this._fileView.addViewMouseListener(this._urlChooserDialog);
            this._dirTree.addMouseListener(this._urlChooserDialog);
            if (this._dialogCallback != null) {
                this._dialogCallback.dialogAboutToRun((JDialog)((Object)this._urlChooserDialog));
            }
            boolean bl = var7_7.showDialog();
            this._urlChooserDialog = null;
            int n2 = bl ? 0 : 1;
            return n2;
        }
        catch (Exception exception) {
            int n3 = -1;
            return n3;
        }
    }

    private void runNow(int n) {
        UI uI = new UI(n);
        uI.run();
    }

    private void runLater(int n) {
        UI uI = new UI(n);
        SwingUtilities.invokeLater(uI);
    }

    private boolean isRootURL(URL uRL) {
        return URLChooser.isChildURL(this._root, uRL);
    }

    private void setSelectedURLImpl(URL uRL, boolean bl) {
        if (uRL == null) {
            if (this._selectionScope != 1) {
                this._selectedNode = this._root;
                this.runLater(10);
            }
            return;
        }
        if (this._selectionScope == 1 && !URLFileSystem.isDirectoryPath(uRL)) {
            uRL = URLFileSystem.getParent(uRL);
        }
        this.setSelectedURLImpl0(uRL);
        if (this._selectedNode != null) {
            String string;
            if (this._selectionScope != 1) {
                this.maybeLoadTreeNode(this._selectedNode, true, true);
            }
            URL uRL2 = this._selectedNode.getURL();
            if (bl && !JarUtil.isJarURL(uRL2) && (string = URLFileSystem.toRelativeSpec(uRL, this._selectedNode.getURL())) != null) {
                this.setFileNameURL(string);
            }
        }
        if (this._selectionScope == 1) {
            this.runLater(10);
        }
    }

    private void setSelectedURLImpl0(URL uRL) {
        if (uRL == null) {
            return;
        }
        URL uRL2 = URLFileSystem.getParent(uRL);
        if (uRL2 == null || this.isRootURL(uRL)) {
            this.setSelectedURLImpl(this._root, uRL);
        } else {
            this.setSelectedURLImpl0(uRL2);
            if (this._selectedNode != null) {
                this.setSelectedURLImpl(this._selectedNode, uRL);
            }
        }
    }

    private void setSelectedURLImpl(URLNode uRLNode, URL uRL) {
        URLNode uRLNode2 = URLChooser.findChildByURL(uRLNode, uRL);
        if (uRLNode2 != null) {
            if (this._selectionScope == 1) {
                this.maybeLoadTreeNode(uRLNode2, true, false);
                this._selectedNode = uRLNode2;
            } else if (uRLNode2.exists()) {
                this._selectedNode = uRLNode2;
            }
            return;
        }
        if (this._selectionScope != 1 && !uRLNode.isExpanded()) {
            uRLNode2 = new URLNode(uRL);
            this.checkIsExtra(uRLNode2);
            uRLNode.add(uRLNode2);
            if (!uRLNode2.isLeaf() && uRLNode2.exists()) {
                this._selectedNode = uRLNode2;
            }
        }
    }

    private boolean setSelectedNode(URLNode uRLNode) {
        URLNode uRLNode2 = this._selectedNode;
        this._selectedNode = uRLNode;
        if (uRLNode != null) {
            if (this._selectionScope == 1) {
                Object[] objectArray = uRLNode.getPath();
                TreePath treePath = new TreePath(objectArray);
                this._dirTree.setSelectionPath(treePath);
                this._dirTree.scrollPathToVisible(treePath);
            } else {
                this.maybeLoadTreeNode(uRLNode, true, true);
                if (!uRLNode.isExpanded()) {
                    this._selectedNode = uRLNode2;
                    return false;
                }
            }
        }
        return true;
    }

    private void maybeLoadTreeNode(URLNode uRLNode, boolean bl, boolean bl2) {
        if (uRLNode == null || uRLNode.isLeaf()) {
            return;
        }
        if (!uRLNode.isExpanded()) {
            uRLNode.buildChildren(bl, bl2);
        } else if (bl2) {
            this.runLater(12);
        }
    }

    private URLNode getSelectedDirComboBoxNode() {
        return (URLNode)this._cbLocation.getSelectedItem();
    }

    private URLNode getSelectedDirTreeNode() {
        if (this._selectionScope == 1) {
            TreePath treePath = this._dirTree.getSelectionPath();
            return treePath != null ? (URLNode)treePath.getLastPathComponent() : null;
        }
        URLNode uRLNode = this.getSelectedFileListNode();
        if (uRLNode != null && !uRLNode.isLeaf()) {
            return uRLNode;
        }
        return this.getSelectedDirComboBoxNode();
    }

    private URLNode getSelectedFileListNode() {
        return this._selectionScope == 1 ? null : this._fileView.getSelectedNode();
    }

    public final URLFilter getSelectedFilter() {
        return (URLFilter)this._cbFileType.getSelectedItem();
    }

    private static int compare(String string, String string2) {
        if (_comparator != null) {
            return _comparator.compare(string, string2);
        }
        return string.compareTo(string2);
    }

    private void fireUrlFilterChanged(URLFilter uRLFilter, URLFilter uRLFilter2) {
        if (this._chooserListener != null) {
            URLChooserEvent uRLChooserEvent = null;
            int n = this._chooserListener.size();
            while (--n >= 0) {
                try {
                    if (uRLChooserEvent == null) {
                        uRLChooserEvent = new URLChooserEvent(this, 1);
                        uRLChooserEvent.setCurrentFilter(uRLFilter);
                        uRLChooserEvent.setPreviousFilter(uRLFilter2);
                    }
                    ((URLChooserListener)this._chooserListener.get(n)).urlFilterChanged(uRLChooserEvent);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private void fireListSelectionChanged(ListSelectionEvent listSelectionEvent) {
        if (this._chooserListener != null) {
            URLChooserEvent uRLChooserEvent = null;
            int n = this._chooserListener.size();
            while (--n >= 0) {
                try {
                    if (uRLChooserEvent == null) {
                        uRLChooserEvent = new URLChooserEvent(this, 2);
                        uRLChooserEvent.setEventObject(listSelectionEvent);
                    }
                    ((URLChooserListener)this._chooserListener.get(n)).listSelectionChanged(uRLChooserEvent);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private boolean isSingleDirectoryChooser() {
        return this._selectionScope == 1 && this._selectionMode == 0;
    }

    private void flushNodes() {
        Enumeration enumeration = this._root.children();
        while (enumeration.hasMoreElements()) {
            URLNode uRLNode = (URLNode)enumeration.nextElement();
            uRLNode.removeAllChildren();
        }
        if (this._selectionScope == 1) {
            this._dtm.nodeStructureChanged(this._root);
        }
    }

    private void refreshAll() {
        this.flushNodes();
        if (this._selectedNode != null) {
            String string = this.getFileNameURL();
            this.setSelectedURL(this._selectedNode.getURL());
            this.setFileNameURL(string);
        }
    }

    private void refreshNode(URLNode uRLNode) {
        if (uRLNode != null && uRLNode != this._root && !uRLNode.isLeaf() && uRLNode.isExpanded()) {
            uRLNode.rebuildChildren(true, true);
        }
    }

    private static boolean isChildURL(URLNode uRLNode, URL uRL) {
        return URLChooser.findChildByURL(uRLNode, uRL) != null;
    }

    private static URLNode findChildByURL(URLNode uRLNode, URL uRL) {
        if (uRLNode != null) {
            Enumeration enumeration = uRLNode.children();
            while (enumeration.hasMoreElements()) {
                URLNode uRLNode2 = (URLNode)enumeration.nextElement();
                if (!URLFileSystem.equals(uRLNode2.getURL(), uRL)) continue;
                return uRLNode2;
            }
        }
        return null;
    }

    private static int toTreeSelectionMode(int n) {
        switch (n) {
            case 2: {
                return 4;
            }
            case 1: {
                return 2;
            }
        }
        return 1;
    }

    private static void addKeyboardAction(JComponent jComponent, Action action, String string, KeyStroke keyStroke) {
        URLChooser.addKeyboardAction(jComponent, action, string, keyStroke, 0);
    }

    private static void addKeyboardAction(JComponent jComponent, Action action, String string, KeyStroke keyStroke, int n) {
        ActionMap actionMap = jComponent.getActionMap();
        InputMap inputMap = jComponent.getInputMap(n);
        actionMap.put(string, action);
        inputMap.put(keyStroke, string);
    }

    private static void addKeyboardAction(JComponent jComponent, Action action, String string, KeyStroke[] keyStrokeArray) {
        URLChooser.addKeyboardAction(jComponent, action, string, keyStrokeArray, 0);
    }

    private static void addKeyboardAction(JComponent jComponent, Action action, String string, KeyStroke[] keyStrokeArray, int n) {
        ActionMap actionMap = jComponent.getActionMap();
        InputMap inputMap = jComponent.getInputMap(n);
        actionMap.put(string, action);
        int n2 = 0;
        while (n2 < keyStrokeArray.length) {
            inputMap.put(keyStrokeArray[n2], string);
            ++n2;
        }
    }

    private static void removeKeyboardAction(JComponent jComponent, KeyStroke keyStroke) {
        URLChooser.removeKeyboardAction(jComponent, keyStroke, 0);
    }

    private static void removeKeyboardAction(JComponent jComponent, KeyStroke keyStroke, int n) {
        InputMap inputMap = jComponent.getInputMap(n);
        inputMap.remove(keyStroke);
    }

    private static void setLabelIcon(JLabel jLabel, Object object, boolean bl) {
        if (object instanceof URLNode) {
            URLNode uRLNode = (URLNode)object;
            jLabel.setIcon(bl && uRLNode.isHidden() ? uRLNode.getWashedIcon() : uRLNode.getIcon());
        } else {
            jLabel.setIcon(null);
        }
    }

    private static void setLabelFont(JLabel jLabel, Object object, Font font) {
        if (object instanceof URLNode) {
            URLNode uRLNode = (URLNode)object;
            jLabel.setFont(uRLNode.isExtra() ? font.deriveFont(2) : font);
        }
    }

    static int ra$_selectionScope(URLChooser uRLChooser) {
        return uRLChooser._selectionScope;
    }

    static DefaultTreeModel ra$_dtm(URLChooser uRLChooser) {
        return uRLChooser._dtm;
    }

    static void mav$runNow(URLChooser uRLChooser, int n) {
        uRLChooser.runNow(n);
    }

    static JTree ra$_dirTree(URLChooser uRLChooser) {
        return uRLChooser._dirTree;
    }

    static FileView ra$_fileView(URLChooser uRLChooser) {
        return uRLChooser._fileView;
    }

    static void mav$showNotFoundError(URLChooser uRLChooser, URL uRL) {
        uRLChooser.showNotFoundError(uRL);
    }

    static Comparator ra$_urlNodeComparator(URLChooser uRLChooser) {
        return uRLChooser._urlNodeComparator;
    }

    static boolean ra$_showJarsAsDirs(URLChooser uRLChooser) {
        return uRLChooser._showJarsAsDirs;
    }

    static Set ra$_extraURLs(URLChooser uRLChooser) {
        return uRLChooser._extraURLs;
    }

    static boolean mav$setSelectedNode(URLChooser uRLChooser, URLNode uRLNode) {
        return uRLChooser.setSelectedNode(uRLNode);
    }

    static TF ra$_tfFileName(URLChooser uRLChooser) {
        return uRLChooser._tfFileName;
    }

    static JWindow ra$_completionWindow(URLChooser uRLChooser) {
        return uRLChooser._completionWindow;
    }

    static Dlg ra$_urlChooserDialog(URLChooser uRLChooser) {
        return uRLChooser._urlChooserDialog;
    }

    static JLabel ra$_lblFileName(URLChooser uRLChooser) {
        return uRLChooser._lblFileName;
    }

    static void mav$maybeLoadTreeNode(URLChooser uRLChooser, URLNode uRLNode, boolean bl, boolean bl2) {
        uRLChooser.maybeLoadTreeNode(uRLNode, bl, bl2);
    }

    static void mav$runLater(URLChooser uRLChooser, int n) {
        uRLChooser.runLater(n);
    }

    static JComboBox ra$_cbLocation(URLChooser uRLChooser) {
        return uRLChooser._cbLocation;
    }

    static URLNode mav$getSelectedDirComboBoxNode(URLChooser uRLChooser) {
        return uRLChooser.getSelectedDirComboBoxNode();
    }

    static JComboBox ra$_cbFileType(URLChooser uRLChooser) {
        return uRLChooser._cbFileType;
    }

    static void mav$fireListSelectionChanged(URLChooser uRLChooser, ListSelectionEvent listSelectionEvent) {
        uRLChooser.fireListSelectionChanged(listSelectionEvent);
    }

    static CL ra$_completionList(URLChooser uRLChooser) {
        return uRLChooser._completionList;
    }

    static int maS$compare(String string, String string2) {
        return URLChooser.compare(string, string2);
    }

    static void wa$_completionWindow(URLChooser uRLChooser, JWindow jWindow) {
        uRLChooser._completionWindow = jWindow;
    }

    static void wa$_completionList(URLChooser uRLChooser, CL cL) {
        uRLChooser._completionList = cL;
    }

    static L ra$_listener(URLChooser uRLChooser) {
        return uRLChooser._listener;
    }

    static URLNode ra$_root(URLChooser uRLChooser) {
        return uRLChooser._root;
    }

    static Pattern ra$FILE_SEPARATORS_PATTERN() {
        return FILE_SEPARATORS_PATTERN;
    }

    static URLNode maS$findChildByURL(URLNode uRLNode, URL uRL) {
        return URLChooser.findChildByURL(uRLNode, uRL);
    }

    static boolean ra$_isCaseSensitive() {
        return _isCaseSensitive;
    }

    static void wa$_completionScrollPane(URLChooser uRLChooser, JScrollPane jScrollPane) {
        uRLChooser._completionScrollPane = jScrollPane;
    }

    static JScrollPane ra$_completionScrollPane(URLChooser uRLChooser) {
        return uRLChooser._completionScrollPane;
    }

    static boolean mav$isSingleDirectoryChooser(URLChooser uRLChooser) {
        return uRLChooser.isSingleDirectoryChooser();
    }

    static URLFilter ra$_curFilter(URLChooser uRLChooser) {
        return uRLChooser._curFilter;
    }

    static CommandBar ra$_commandBar(URLChooser uRLChooser) {
        return uRLChooser._commandBar;
    }

    static boolean mav$isRootURL(URLChooser uRLChooser, URL uRL) {
        return uRLChooser.isRootURL(uRL);
    }

    static void mav$pushHistoryList(URLChooser uRLChooser, URLNode uRLNode) {
        uRLChooser.pushHistoryList(uRLNode);
    }

    static void mav$refreshAll(URLChooser uRLChooser) {
        uRLChooser.refreshAll();
    }

    static void mav$flushNodes(URLChooser uRLChooser) {
        uRLChooser.flushNodes();
    }

    static void mav$setSelectedURLImpl(URLChooser uRLChooser, URL uRL, boolean bl) {
        uRLChooser.setSelectedURLImpl(uRL, bl);
    }

    static URLNode ra$_selectedNode(URLChooser uRLChooser) {
        return uRLChooser._selectedNode;
    }

    static JScrollPane ra$_spDirs(URLChooser uRLChooser) {
        return uRLChooser._spDirs;
    }

    static void wa$_curFilter(URLChooser uRLChooser, URLFilter uRLFilter) {
        uRLChooser._curFilter = uRLFilter;
    }

    static void mav$fireUrlFilterChanged(URLChooser uRLChooser, URLFilter uRLFilter, URLFilter uRLFilter2) {
        uRLChooser.fireUrlFilterChanged(uRLFilter, uRLFilter2);
    }

    static URLNode mav$getSelectedFileListNode(URLChooser uRLChooser) {
        return uRLChooser.getSelectedFileListNode();
    }

    static URLNode mav$getSelectedDirTreeNode(URLChooser uRLChooser) {
        return uRLChooser.getSelectedDirTreeNode();
    }

    static void wa$_selectedNode(URLChooser uRLChooser, URLNode uRLNode) {
        uRLChooser._selectedNode = uRLNode;
    }

    static void mav$popHistoryList(URLChooser uRLChooser) {
        uRLChooser.popHistoryList();
    }

    static void maS$setLabelIcon(JLabel jLabel, Object object, boolean bl) {
        URLChooser.setLabelIcon(jLabel, object, bl);
    }

    static AlphaComposite ra$SHORTCUT_BACKGROUND_COMPOSITE() {
        return SHORTCUT_BACKGROUND_COMPOSITE;
    }

    static Dimension ra$SHORTCUT_BUTTON_SIZE() {
        return SHORTCUT_BUTTON_SIZE;
    }

    static KeyStroke ra$TABLE_DESCEND_KEYSTROKE() {
        return TABLE_DESCEND_KEYSTROKE;
    }

    static void maS$addKeyboardAction(JComponent jComponent, Action action, String string, KeyStroke keyStroke) {
        URLChooser.addKeyboardAction(jComponent, action, string, keyStroke);
    }

    static KeyStroke ra$TABLE_ASCEND_KEYSTROKE() {
        return TABLE_ASCEND_KEYSTROKE;
    }

    static KeyStroke[] ra$TABLE_SELECT_CURRENT_KEYSTROKES() {
        return TABLE_SELECT_CURRENT_KEYSTROKES;
    }

    static void maS$addKeyboardAction(JComponent jComponent, Action action, String string, KeyStroke[] keyStrokeArray) {
        URLChooser.addKeyboardAction(jComponent, action, string, keyStrokeArray);
    }

    static KeyStroke ra$TABLE_TOGGLE_SELECT_KEYSTROKE() {
        return TABLE_TOGGLE_SELECT_KEYSTROKE;
    }

    static NumberFormat ra$NUMBER_FORMATTER() {
        return NUMBER_FORMATTER;
    }

    static DateFormat ra$DATE_FORMATTER() {
        return DATE_FORMATTER;
    }

    static String[] ra$FILE_TABLE_COLUMN_NAMES() {
        return FILE_TABLE_COLUMN_NAMES;
    }

    static Color ra$INACTIVE_BACKGROUND_SELECTION_COLOR() {
        return INACTIVE_BACKGROUND_SELECTION_COLOR;
    }

    static Color ra$INACTIVE_TEXT_SELECTION_COLOR() {
        return INACTIVE_TEXT_SELECTION_COLOR;
    }

    static void maS$setLabelFont(JLabel jLabel, Object object, Font font) {
        URLChooser.setLabelFont(jLabel, object, font);
    }

    public final class 1
    extends TDialogLauncher {
        private final /* synthetic */ Traversable v$content;
        private final /* synthetic */ String v$approveText;
        final /* synthetic */ URLChooser this$0;

        protected TDialog newDialog() {
            Dlg dlg = this.this$0.new Dlg(this, this.v$content, this.v$approveText);
            if (this.v$content.getHelpID() == null) {
                dlg.setButtonMask(3);
            }
            return dlg;
        }

        public 1(URLChooser uRLChooser, Component component, String string, Traversable traversable, Namespace namespace, Traversable traversable2, String string2) {
            this.v$approveText = string2;
            this.v$content = traversable2;
            this.this$0 = uRLChooser;
            super(component, string, traversable, namespace);
        }
    }

    private class URLNode
    implements Comparable,
    TreeNode {
        static final int DIRS_ALWAYS_EXCLUDED = 0;
        static final int DIRS_FILTERED = 1;
        static final int DIRS_ALWAYS_INCLUDED = 2;
        static final int DIRS_ONLY = 3;
        private final URL _url;
        private final boolean _isLeaf;
        private final List _children;
        private TreeNode _parent;
        private Object _userObject;
        private String _name;
        private Icon _icon;
        private Icon _washedIcon;
        private boolean _expanded;
        private boolean _extra;

        void $init$() {
            this._children = new ArrayList();
        }

        URLNode() {
            this((URL)null);
        }

        URLNode(URLFileSystem.FileInfo fileInfo) {
            this(fileInfo.getURL());
            this.setUserObject(fileInfo);
        }

        URLNode(URL uRL) {
            this.$init$();
            this._url = uRL;
            this._isLeaf = uRL != null && !URLFileSystem.isRoot(uRL) && !URLFileSystem.isDirectoryPath(uRL);
        }

        public Enumeration children() {
            return new Vector(this._children).elements();
        }

        public boolean getAllowsChildren() {
            return true;
        }

        public TreeNode getChildAt(int n) {
            return (TreeNode)this._children.get(n);
        }

        public int getChildCount() {
            return this._children.size();
        }

        public int getIndex(TreeNode treeNode) {
            return this._children.indexOf(treeNode);
        }

        public TreeNode getParent() {
            return this._parent;
        }

        public boolean isLeaf() {
            return this._isLeaf;
        }

        public Object getUserObject() {
            return this._userObject;
        }

        public void setUserObject(Object object) {
            this._userObject = object;
        }

        public void add(URLNode uRLNode) {
            int n = this.getChildCount();
            int n2 = 0;
            while (n2 < n) {
                URLNode uRLNode2 = (URLNode)this.getChildAt(n2);
                int n3 = URLChooser.ra$_urlNodeComparator(URLChooser.this).compare(uRLNode, uRLNode2);
                if (n3 < 0) break;
                ++n2;
            }
            this._children.add(n2, uRLNode);
            uRLNode._parent = this;
        }

        public void removeAllChildren() {
            this._expanded = false;
            this._children.clear();
        }

        public TreeNode[] getPath() {
            return this.getPathToRoot(this, 0);
        }

        protected TreeNode[] getPathToRoot(TreeNode treeNode, int n) {
            TreeNode[] treeNodeArray;
            if (treeNode == null) {
                if (n == 0) {
                    return null;
                }
                treeNodeArray = new TreeNode[n];
            } else {
                treeNodeArray = this.getPathToRoot(treeNode.getParent(), ++n);
                treeNodeArray[treeNodeArray.length - n] = treeNode;
            }
            return treeNodeArray;
        }

        public int compareTo(Object object) {
            return URLChooser.ra$_urlNodeComparator(URLChooser.this).compare(this, (URLNode)object);
        }

        public boolean equals(Object object) {
            return object == this || object instanceof URLNode && URLFileSystem.equals(this._url, ((URLNode)object)._url);
        }

        public String toString() {
            if (this._name == null) {
                this._name = this._url != null ? (URLFileSystem.isRoot(this._url) ? URLFileSystem.getSystemDisplayName(this._url) : URLFileSystem.getFileName(this._url)) : "";
            }
            return this._name;
        }

        public Icon getIcon() {
            if (this._icon == null) {
                this._icon = this._url != null ? URLFileSystem.getDefaultIcon(this._url) : IdeIcons.getIcon(0);
            }
            return this._icon;
        }

        public Icon getWashedIcon() {
            Icon icon;
            if (this._washedIcon == null && (icon = this.getIcon()) != null) {
                this._washedIcon = new WashedIcon(icon);
            }
            return this._washedIcon;
        }

        public boolean exists() {
            if (this.getFileInfo() != null || this.isExtra()) {
                return true;
            }
            return this._url != null ? URLFileSystem.exists(this._url) : false;
        }

        public boolean isRoot() {
            return this._url != null && URLFileSystem.isRoot(this._url);
        }

        public boolean isHidden() {
            URLFileSystem.FileInfo fileInfo = this.getFileInfo();
            return fileInfo != null ? fileInfo.isHidden() : URLFileSystem.isHidden(this._url) && !this.isRoot();
        }

        public long lastModified() {
            URLFileSystem.FileInfo fileInfo = this.getFileInfo();
            return fileInfo != null ? fileInfo.lastModified() : URLFileSystem.lastModified(this._url);
        }

        public long length() {
            URLFileSystem.FileInfo fileInfo = this.getFileInfo();
            return fileInfo != null ? fileInfo.length() : URLFileSystem.getLength(this._url);
        }

        URL getURL() {
            return this._url;
        }

        boolean isExpanded() {
            return this._expanded;
        }

        void setExpanded(boolean bl) {
            this._expanded = bl;
        }

        boolean isExtra() {
            return this._extra;
        }

        void setExtra(boolean bl) {
            this._extra = bl;
        }

        void rebuildChildren(boolean bl, boolean bl2) {
            this.removeAllChildren();
            this.buildChildren(bl, bl2);
        }

        void buildChildren(boolean bl, boolean bl2) {
            this.buildChildren(bl, bl2, false);
        }

        void buildChildren(boolean bl, boolean bl2, boolean bl3) {
            WaitCursor waitCursor;
            if (this._url == null) {
                return;
            }
            if (bl3) {
                waitCursor = null;
            } else {
                waitCursor = new WaitCursor(URLChooser.this);
                waitCursor.show(400L);
            }
            this._expanded = true;
            if (bl) {
                URLNode[] uRLNodeArray = this.getChildURLNodes();
                this.processChildURLNodes(uRLNodeArray, waitCursor, bl2, bl3);
            } else {
                URLChooser.ra$_fileView(URLChooser.this).setKeyboardEnabled(false);
                1 var6_6 = new 1(this, waitCursor, bl2, bl3);
                var6_6.start();
            }
        }

        void insertDir(URL uRL) {
            if (!this._expanded) {
                this.buildChildren(true, false);
            }
            URLNode uRLNode = new URLNode(uRL);
            this.add(uRLNode);
            if (URLChooser.ra$_selectionScope(URLChooser.this) == 1) {
                URLChooser.ra$_dtm(URLChooser.this).nodeStructureChanged(this);
            } else {
                URLChooser.mav$runNow(URLChooser.this, 19);
            }
            URLChooser.mav$setSelectedNode(URLChooser.this, uRLNode);
            URLChooser.mav$runNow(URLChooser.this, 10);
        }

        Vector getFiles(URLFilter uRLFilter, int n) {
            if (uRLFilter == null) {
                uRLFilter = ALL_FILES_FILTER;
            }
            Vector<URLNode> vector = new Vector<URLNode>();
            block4: for (URLNode uRLNode : this._children) {
                URL uRL = uRLNode.getURL();
                if (!uRLNode.isLeaf()) {
                    switch (n) {
                        case 2: {
                            vector.add(uRLNode);
                            continue block4;
                        }
                        case 0: {
                            continue block4;
                        }
                    }
                } else if (n == 3) continue;
                if (!uRLFilter.accept(uRL)) continue;
                vector.add(uRLNode);
            }
            return vector;
        }

        private URLNode[] getChildURLNodes() {
            Object[] objectArray = FileNativeHelper.getInstance().isLoaded() ? URLFileSystem.ls(this._url) : URLFileSystem.list(this._url);
            int n = objectArray != null ? objectArray.length : 2;
            TreeSet<URLNode> treeSet = new TreeSet<URLNode>(URLChooser.ra$_urlNodeComparator(URLChooser.this));
            if (objectArray != null) {
                int n2 = 0;
                while (n2 < n) {
                    URL uRL;
                    String string;
                    String string2;
                    URLNode uRLNode = objectArray instanceof URLFileSystem.FileInfo[] ? new URLNode((URLFileSystem.FileInfo)objectArray[n2]) : new URLNode((URL)objectArray[n2]);
                    if (URLChooser.ra$_selectionScope(URLChooser.this) != 1 || !uRLNode.isLeaf()) {
                        treeSet.add(uRLNode);
                    }
                    if (URLChooser.ra$_showJarsAsDirs(URLChooser.this) && uRLNode.isLeaf() && !(string2 = this._url.getProtocol()).equals("jar") && ((string = URLFileSystem.getFileName(uRL = uRLNode.getURL()).toLowerCase()).endsWith(".jar") || string.endsWith(".zip") || string.endsWith(".war") || string.endsWith(".ear"))) {
                        URLNode uRLNode2 = new URLNode(URLFactory.newJarURL(uRL, ""));
                        treeSet.add(uRLNode2);
                    }
                    ++n2;
                }
            }
            if (URLChooser.ra$_extraURLs(URLChooser.this) != null) {
                for (URL uRL : URLChooser.ra$_extraURLs(URLChooser.this)) {
                    if (!URLFileSystem.isBaseURLFor(this._url, uRL) || !URLFileSystem.equals(this._url, URLFileSystem.getParent(uRL))) continue;
                    URLNode uRLNode = new URLNode(uRL);
                    uRLNode.setExtra(true);
                    treeSet.add(uRLNode);
                }
            }
            if (!treeSet.isEmpty() || objectArray != null) {
                return treeSet.toArray(new URLNode[treeSet.size()]);
            }
            return null;
        }

        private void processChildURLNodes(URLNode[] uRLNodeArray, WaitCursor waitCursor, boolean bl, boolean bl2) {
            this._children.clear();
            if (uRLNodeArray != null) {
                int n = 0;
                while (n < uRLNodeArray.length) {
                    URLNode uRLNode = uRLNodeArray[n];
                    uRLNode._parent = this;
                    this._children.add(uRLNode);
                    ++n;
                }
                if (URLChooser.ra$_selectionScope(URLChooser.this) == 1) {
                    URLChooser.ra$_dtm(URLChooser.this).nodeStructureChanged(this);
                }
                if (bl) {
                    URLChooser.mav$runNow(URLChooser.this, 12);
                }
            } else {
                this._expanded = false;
                if (URLChooser.ra$_selectionScope(URLChooser.this) == 1) {
                    Object[] objectArray = this.getPath();
                    TreePath treePath = new TreePath(objectArray);
                    URLChooser.ra$_dirTree(URLChooser.this).collapsePath(treePath);
                    URLChooser.ra$_dtm(URLChooser.this).nodeStructureChanged(this);
                }
            }
            URLChooser.ra$_fileView(URLChooser.this).setKeyboardEnabled(true);
            if (waitCursor != null) {
                waitCursor.hide();
                RootPaneContainer rootPaneContainer = (RootPaneContainer)((Object)SwingUtilities.getAncestorOfClass(RootPaneContainer.class, URLChooser.this));
                waitCursor.detach(rootPaneContainer);
            }
            if (uRLNodeArray == null && !bl2) {
                URLChooser.mav$showNotFoundError(URLChooser.this, this._url);
            }
        }

        private URLFileSystem.FileInfo getFileInfo() {
            Object object = this.getUserObject();
            return object instanceof URLFileSystem.FileInfo ? (URLFileSystem.FileInfo)object : null;
        }

        static void mav$processChildURLNodes(URLNode uRLNode, URLNode[] uRLNodeArray, WaitCursor waitCursor, boolean bl, boolean bl2) {
            uRLNode.processChildURLNodes(uRLNodeArray, waitCursor, bl, bl2);
        }

        static URLNode[] mav$getChildURLNodes(URLNode uRLNode) {
            return uRLNode.getChildURLNodes();
        }

        public final class 1
        extends SwingWorker {
            private final /* synthetic */ WaitCursor v$waitCursor;
            private final /* synthetic */ boolean v$firePostUpdateTreeSelection;
            private final /* synthetic */ boolean v$nowait;
            final /* synthetic */ URLNode this$0;

            public Object construct() {
                return URLNode.mav$getChildURLNodes(this.this$0);
            }

            public void finished() {
                URLNode[] uRLNodeArray = (URLNode[])this.getValue();
                URLNode.mav$processChildURLNodes(this.this$0, uRLNodeArray, this.v$waitCursor, this.v$firePostUpdateTreeSelection, this.v$nowait);
            }

            public 1(URLNode uRLNode, WaitCursor waitCursor, boolean bl, boolean bl2) {
                this.v$nowait = bl2;
                this.v$firePostUpdateTreeSelection = bl;
                this.v$waitCursor = waitCursor;
                this.this$0 = uRLNode;
            }
        }
    }

    private class L
    implements AWTEventListener,
    MouseListener,
    DocumentListener,
    AncestorListener,
    PopupMenuListener,
    ActionListener,
    ListSelectionListener,
    ListDataListener,
    TreeWillExpandListener,
    TreeSelectionListener {
        private final DoubleClickTrigger _trigger;
        private boolean _enabled;
        private URLNode _lastSelectedNode;

        void $init$() {
            this._trigger = new DoubleClickTrigger();
            this._enabled = true;
        }

        boolean isEnabled() {
            return this._enabled;
        }

        void setEnabled(boolean bl) {
            this._enabled = bl;
        }

        public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) {
            TreePath treePath = treeExpansionEvent.getPath();
            URLNode uRLNode = (URLNode)treePath.getLastPathComponent();
            URLChooser.mav$maybeLoadTreeNode(URLChooser.this, uRLNode, true, false);
        }

        public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) {
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            if (this._enabled) {
                URLChooser.mav$runNow(URLChooser.this, 2);
            }
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            if (listDataEvent.getType() == 0 && listDataEvent.getIndex0() == -1 && listDataEvent.getIndex1() == -1) {
                URLNode uRLNode = URLChooser.mav$getSelectedDirComboBoxNode(URLChooser.this);
                String string = uRLNode != null ? URLFileSystem.getPlatformPathName(uRLNode.getURL()) : null;
                URLChooser.ra$_cbLocation(URLChooser.this).setToolTipText(string);
            }
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (this._enabled) {
                URLChooser.mav$runNow(URLChooser.this, 5);
                URLChooser.mav$fireListSelectionChanged(URLChooser.this, listSelectionEvent);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this._enabled) {
                Object object = actionEvent.getSource();
                if (object == null) {
                    return;
                }
                if (object == URLChooser.ra$_cbFileType(URLChooser.this)) {
                    URLChooser.mav$runNow(URLChooser.this, 6);
                }
            }
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            if (this._enabled) {
                this._lastSelectedNode = URLChooser.mav$getSelectedDirComboBoxNode(URLChooser.this);
            }
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            if (this._enabled) {
                URLChooser.mav$runNow(URLChooser.this, 0);
                URLNode uRLNode = URLChooser.mav$getSelectedDirComboBoxNode(URLChooser.this);
                if (uRLNode != this._lastSelectedNode && !uRLNode.isExpanded()) {
                    URLChooser.ra$_cbLocation(URLChooser.this).setSelectedItem(this._lastSelectedNode);
                }
            }
            this._lastSelectedNode = null;
        }

        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            if (this._enabled) {
                URLChooser.ra$_cbLocation(URLChooser.this).setSelectedItem(this._lastSelectedNode);
                this._lastSelectedNode = null;
            }
        }

        public void ancestorAdded(AncestorEvent ancestorEvent) {
            URLChooser.mav$runLater(URLChooser.this, 9);
        }

        public void ancestorMoved(AncestorEvent ancestorEvent) {
        }

        public void ancestorRemoved(AncestorEvent ancestorEvent) {
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            if (this._enabled) {
                URLChooser.mav$runNow(URLChooser.this, 7);
            }
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            if (this._enabled) {
                URLChooser.mav$runNow(URLChooser.this, 8);
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            URLNode uRLNode;
            if (URLChooser.ra$_selectionScope(URLChooser.this) != 1 && this._trigger.isDoubleClick(mouseEvent) && (uRLNode = URLChooser.ra$_fileView(URLChooser.this).getNodeAt(mouseEvent.getPoint())) != null && !uRLNode.isLeaf()) {
                URLChooser.mav$maybeLoadTreeNode(URLChooser.this, uRLNode, false, true);
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void eventDispatched(AWTEvent aWTEvent) {
            Component component;
            Object object = aWTEvent.getSource();
            Component component2 = component = object instanceof Component ? (Component)object : null;
            if (component != null) {
                switch (aWTEvent.getID()) {
                    case 501: {
                        if (object == URLChooser.ra$_tfFileName(URLChooser.this) || object == URLChooser.ra$_completionWindow(URLChooser.this) || SwingUtilities.windowForComponent(component) == URLChooser.ra$_completionWindow(URLChooser.this)) break;
                        URLChooser.mav$runNow(URLChooser.this, 13);
                        break;
                    }
                    case 205: {
                        if (object == URLChooser.ra$_completionWindow(URLChooser.this) || object == URLChooser.ra$_urlChooserDialog(URLChooser.this)) break;
                        URLChooser.mav$runNow(URLChooser.this, 13);
                        break;
                    }
                    case 100: {
                        if (SwingUtilities.windowForComponent(component) == URLChooser.ra$_completionWindow(URLChooser.this)) break;
                        URLChooser.mav$runNow(URLChooser.this, 13);
                        break;
                    }
                    case 1004: {
                        if (object == URLChooser.ra$_tfFileName(URLChooser.this) || object == URLChooser.ra$_lblFileName(URLChooser.this) || object == URLChooser.ra$_completionWindow(URLChooser.this) || SwingUtilities.windowForComponent(component) == URLChooser.ra$_completionWindow(URLChooser.this)) break;
                        URLChooser.mav$runNow(URLChooser.this, 13);
                    }
                }
            }
        }

        private L() {
            this.$init$();
        }

        L(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class UI
    implements Runnable {
        static final int SYNC_TO_LOCATION_COMBOBOX = 0;
        static final int CHDIR_TO_PARENT = 1;
        static final int SYNC_TO_TREE_SELECTION = 2;
        static final int SYNC_TO_LIST_SELECTION = 5;
        static final int SYNC_TO_FILE_TYPE_COMBOBOX = 6;
        static final int FILE_NAME_INSERT_UPDATE = 7;
        static final int FILE_NAME_REMOVE_UPDATE = 8;
        static final int SYNC_TO_SHORTCUT_BUTTON = 9;
        static final int UPDATE_TREE_SELECTION = 10;
        static final int POST_UPDATE_TREE_SELECTION = 12;
        static final int HIDE_COMPLETION_LIST = 13;
        private static final int AUTO_FILL_FILE_NAME = 14;
        static final int TAB_COMPLETION = 15;
        static final int SELECT_NEXT_COMPLETION = 16;
        static final int SELECT_PREV_COMPLETION = 17;
        static final int NEW_DIR = 18;
        static final int UPDATE_FILE_LIST = 19;
        static final int POP_LAST_DIRECTORY = 20;
        static final int REFRESH_FILE_LIST = 21;
        private final int _type;

        UI(int n) {
            this._type = n;
        }

        public void run() {
            boolean bl = URLChooser.ra$_listener(URLChooser.this).isEnabled();
            try {
                URLChooser.ra$_listener(URLChooser.this).setEnabled(false);
                switch (this._type) {
                    case 1: {
                        this.chdirToParent();
                        break;
                    }
                    case 0: {
                        this.syncToDirComboBox();
                        break;
                    }
                    case 2: {
                        this.syncToTreeSelection();
                        break;
                    }
                    case 5: {
                        this.syncToListSelection();
                        break;
                    }
                    case 6: {
                        this.syncToFileTypeComboBox();
                        this.updateSelectedFile();
                        break;
                    }
                    case 7: {
                        this.updateCompletionList(true);
                        URLChooser.ra$_fileView(URLChooser.this).clearSelection();
                        break;
                    }
                    case 8: {
                        this.updateCompletionList(false);
                        URLChooser.ra$_fileView(URLChooser.this).clearSelection();
                        break;
                    }
                    case 9: 
                    case 10: {
                        if (URLChooser.ra$_selectedNode(URLChooser.this) != null) {
                            this.updateTreeSelection();
                            URLChooser.mav$maybeLoadTreeNode(URLChooser.this, URLChooser.ra$_selectedNode(URLChooser.this), false, true);
                        }
                        break;
                    }
                    case 12: {
                        if (URLChooser.ra$_selectedNode(URLChooser.this) != null) {
                            this.updateLocationComboBox(URLChooser.ra$_selectedNode(URLChooser.this));
                            this.updateFileList(URLChooser.ra$_selectedNode(URLChooser.this));
                            this.updateFilename();
                            this.updateSelectedFile();
                        }
                        break;
                    }
                    case 13: {
                        this.hideCompletionList();
                        break;
                    }
                    case 14: {
                        this.autoFillFileName();
                        break;
                    }
                    case 15: {
                        this.tabCompletion();
                        break;
                    }
                    case 16: {
                        this.selectNextCompletion();
                        break;
                    }
                    case 17: {
                        this.selectPrevCompletion();
                        break;
                    }
                    case 18: {
                        this.createNewDir();
                        break;
                    }
                    case 19: {
                        if (URLChooser.ra$_selectedNode(URLChooser.this) != null) {
                            this.updateFileList(URLChooser.ra$_selectedNode(URLChooser.this));
                        }
                        break;
                    }
                    case 20: {
                        URLChooser.mav$popHistoryList(URLChooser.this);
                        break;
                    }
                    case 21: {
                        this.refreshFileList(URLChooser.mav$getSelectedDirComboBoxNode(URLChooser.this));
                    }
                }
            }
            finally {
                URLChooser.ra$_listener(URLChooser.this).setEnabled(bl);
            }
        }

        private void syncToDirComboBox() {
            URLNode uRLNode = URLChooser.mav$getSelectedDirComboBoxNode(URLChooser.this);
            if (URLChooser.mav$setSelectedNode(URLChooser.this, uRLNode) && URLChooser.ra$_selectionScope(URLChooser.this) == 1) {
                this.updateFileList(uRLNode);
                this.updateSelectedFile();
            }
        }

        private void chdirToParent() {
            TreeNode[] treeNodeArray;
            URLNode uRLNode = URLChooser.mav$getSelectedDirComboBoxNode(URLChooser.this);
            if (uRLNode != null && (treeNodeArray = uRLNode.getPath()).length > 2) {
                this.setLocation((URLNode)treeNodeArray[treeNodeArray.length - 2]);
                this.syncToDirComboBox();
            }
        }

        private void syncToTreeSelection() {
            URLChooser.wa$_selectedNode(URLChooser.this, URLChooser.mav$getSelectedDirTreeNode(URLChooser.this));
            URLChooser.mav$maybeLoadTreeNode(URLChooser.this, URLChooser.ra$_selectedNode(URLChooser.this), false, true);
            URLChooser.ra$_commandBar(URLChooser.this).enableNewDirButton(URLChooser.ra$_selectedNode(URLChooser.this) != null);
        }

        private void syncToListSelection() {
            URLNode uRLNode = URLChooser.mav$getSelectedFileListNode(URLChooser.this);
            URLChooser.wa$_selectedNode(URLChooser.this, uRLNode != null ? uRLNode : URLChooser.mav$getSelectedDirTreeNode(URLChooser.this));
            if (URLChooser.ra$_selectionScope(URLChooser.this) == 1) {
                URLChooser.this.setFileNameURL(null);
            } else if (uRLNode != null && uRLNode.isLeaf() || URLChooser.mav$isSingleDirectoryChooser(URLChooser.this)) {
                String string = uRLNode != null ? uRLNode.toString() : "";
                URLChooser.this.setFileNameURL(string);
            }
        }

        private void syncToFileTypeComboBox() {
            URLFilter uRLFilter = URLChooser.ra$_curFilter(URLChooser.this);
            URLChooser.wa$_curFilter(URLChooser.this, URLChooser.this.getSelectedFilter());
            URLNode uRLNode = URLChooser.mav$getSelectedDirComboBoxNode(URLChooser.this);
            this.updateFileList(uRLNode);
            URLChooser.mav$fireUrlFilterChanged(URLChooser.this, URLChooser.ra$_curFilter(URLChooser.this), uRLFilter);
        }

        private void updateTreeSelection() {
            if (URLChooser.ra$_selectionScope(URLChooser.this) == 1) {
                Object[] objectArray = URLChooser.ra$_selectedNode(URLChooser.this).getPath();
                TreePath treePath = new TreePath(objectArray);
                URLChooser.ra$_dirTree(URLChooser.this).expandPath(treePath);
                this.scrollTreeToSelection();
            }
        }

        private void scrollTreeToSelection() {
            if (URLChooser.ra$_selectionScope(URLChooser.this) == 1) {
                int n;
                Object[] objectArray = URLChooser.ra$_selectedNode(URLChooser.this).getPath();
                TreePath treePath = new TreePath(objectArray);
                URLChooser.ra$_dirTree(URLChooser.this).setSelectionPath(treePath);
                Rectangle rectangle = URLChooser.ra$_dirTree(URLChooser.this).getPathBounds(treePath);
                JViewport jViewport = URLChooser.ra$_spDirs(URLChooser.this).getViewport();
                Rectangle rectangle2 = jViewport.getViewRect();
                rectangle2.y = rectangle.y - (rectangle2.height - rectangle.height >> 1);
                if (rectangle2.y < 0) {
                    rectangle2.y = 0;
                }
                if (rectangle2.y + rectangle2.height > (n = URLChooser.ra$_dirTree(URLChooser.this).getHeight())) {
                    rectangle2.y = n - rectangle2.height;
                }
                URLChooser.ra$_dirTree(URLChooser.this).scrollRectToVisible(rectangle2);
            }
        }

        private void updateLocationComboBox(URLNode uRLNode) {
            Object[] objectArray;
            if (uRLNode == null) {
                this.setLocation(null);
                return;
            }
            TreeNode[] treeNodeArray = uRLNode.getPath();
            if (URLChooser.ra$_selectionScope(URLChooser.this) == 1) {
                int n = treeNodeArray.length - 1;
                objectArray = new Object[n];
                int n2 = 0;
                while (n2 < n) {
                    objectArray[n2++] = treeNodeArray[n2];
                }
            } else {
                int n = URLChooser.ra$_root(URLChooser.this).getChildCount();
                ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>(n + treeNodeArray.length - 1);
                int n3 = 0;
                while (n3 < n) {
                    URLNode uRLNode2 = (URLNode)URLChooser.ra$_root(URLChooser.this).getChildAt(n3);
                    arrayList.add(uRLNode2);
                    if (treeNodeArray.length > 1) {
                        int n4 = 1;
                        while (n4 < treeNodeArray.length) {
                            URLNode uRLNode3 = (URLNode)treeNodeArray[n4];
                            if (URLFileSystem.equals(uRLNode3.getURL(), uRLNode2.getURL())) {
                                while (++n4 < treeNodeArray.length) {
                                    arrayList.add(treeNodeArray[n4]);
                                }
                                break;
                            }
                            ++n4;
                        }
                    }
                    ++n3;
                }
                objectArray = arrayList.toArray(new TreeNode[arrayList.size()]);
            }
            ComboBoxModel comboBoxModel = URLChooser.ra$_cbLocation(URLChooser.this).getModel();
            if (comboBoxModel != null) {
                comboBoxModel.removeListDataListener(URLChooser.ra$_listener(URLChooser.this));
            }
            comboBoxModel = new DefaultComboBoxModel<Object>(objectArray);
            comboBoxModel.addListDataListener(URLChooser.ra$_listener(URLChooser.this));
            this.setLocationsModel(comboBoxModel);
            this.setLocation(uRLNode);
        }

        private void refreshFileList(URLNode uRLNode) {
            if (URLChooser.ra$_selectionScope(URLChooser.this) == 1) {
                URLChooser.mav$refreshAll(URLChooser.this);
                this.scrollTreeToSelection();
            } else {
                URLChooser.mav$flushNodes(URLChooser.this);
                URLChooser.ra$_fileView(URLChooser.this).clearList(true);
                if (uRLNode != null) {
                    URLChooser.mav$setSelectedURLImpl(URLChooser.this, uRLNode.getURL(), false);
                }
                this.updateSelectedFile();
            }
        }

        private void updateFileList(URLNode uRLNode) {
            URLChooser.ra$_fileView(URLChooser.this).updateList(uRLNode, URLChooser.ra$_curFilter(URLChooser.this));
            URLChooser.ra$_commandBar(URLChooser.this).enableUpDirButton(uRLNode != null && !URLChooser.mav$isRootURL(URLChooser.this, uRLNode.getURL()));
            URLChooser.mav$pushHistoryList(URLChooser.this, uRLNode);
        }

        private void updateFilename() {
            if (URLChooser.mav$isSingleDirectoryChooser(URLChooser.this)) {
                URLChooser.this.setFileNameURL(null);
            }
        }

        private void updateSelectedFile() {
            URLChooser.ra$_fileView(URLChooser.this).updateSelectedFile(URLChooser.this.getFileNameURL());
        }

        private void updateCompletionList(boolean bl) {
            if (URLChooser.ra$_completionWindow(URLChooser.this) == null) {
                Window window = (Window)SwingUtilities.getAncestorOfClass(Window.class, URLChooser.this);
                if (window == null) {
                    return;
                }
                URLChooser.wa$_completionWindow(URLChooser.this, new JWindow(window));
                URLChooser.ra$_completionWindow(URLChooser.this).setFocusableWindowState(false);
                Point point = URLChooser.ra$_tfFileName(URLChooser.this).getLocationOnScreen();
                Dimension dimension = URLChooser.ra$_tfFileName(URLChooser.this).getSize();
                URLChooser.ra$_completionWindow(URLChooser.this).setLocation(point.x, point.y + dimension.height + 1);
                URLChooser.wa$_completionList(URLChooser.this, new CL());
                if (this.setCompletionListData(bl)) {
                    URLChooser.wa$_completionScrollPane(URLChooser.this, new JScrollPane());
                    URLChooser.ra$_completionScrollPane(URLChooser.this).setViewportView(URLChooser.ra$_completionList(URLChooser.this));
                    Dimension dimension2 = URLChooser.ra$_completionScrollPane(URLChooser.this).getPreferredSize();
                    dimension2.width = dimension.width;
                    ++dimension2.height;
                    URLChooser.ra$_completionScrollPane(URLChooser.this).setPreferredSize(dimension2);
                    URLChooser.ra$_completionWindow(URLChooser.this).getContentPane().add(URLChooser.ra$_completionScrollPane(URLChooser.this));
                    URLChooser.ra$_completionWindow(URLChooser.this).pack();
                    Toolkit.getDefaultToolkit().addAWTEventListener(URLChooser.ra$_listener(URLChooser.this), 85);
                    URLChooser.ra$_completionWindow(URLChooser.this).setVisible(true);
                }
            } else {
                this.setCompletionListData(bl);
            }
        }

        private boolean setCompletionListData(boolean bl) {
            URLNode uRLNode;
            String string = URLChooser.this.getFileNameURL();
            if (!ModelUtil.hasLength((String)string)) {
                this.hideCompletionList();
                return false;
            }
            boolean bl2 = new File(string).isAbsolute() || string.startsWith(File.separator) || string.startsWith("/");
            URLNode uRLNode2 = uRLNode = bl2 ? URLChooser.ra$_root(URLChooser.this) : URLChooser.mav$getSelectedDirComboBoxNode(URLChooser.this);
            if (uRLNode == null) {
                this.hideCompletionList();
                return false;
            }
            String[] stringArray = URLChooser.ra$FILE_SEPARATORS_PATTERN().split(string, -1);
            StringBuffer stringBuffer = new StringBuffer();
            if (stringArray.length > 1) {
                int n = 0;
                while (n < stringArray.length - 1) {
                    String string2 = stringArray[n];
                    if (!ModelUtil.hasLength((String)string2) && n > 0) {
                        this.hideCompletionList();
                        return false;
                    }
                    URL uRL = uRLNode.getURL();
                    URL uRL2 = uRL == null ? (!ModelUtil.hasLength((String)string2) ? this.getRootURL(URLChooser.mav$getSelectedDirComboBoxNode(URLChooser.this).getURL()) : URLFactory.newDirURL(string2 + '/')) : URLFactory.newDirURL(uRL, string2);
                    URLNode uRLNode3 = URLChooser.maS$findChildByURL(uRLNode, uRL2);
                    if (uRLNode3 != null) {
                        uRLNode = uRLNode3;
                    } else {
                        URLNode uRLNode4 = (URLNode)uRLNode.getParent();
                        if (uRLNode4 != null && URLFileSystem.equals(uRLNode4.getURL(), uRL2)) {
                            uRLNode = uRLNode4;
                        } else {
                            this.hideCompletionList();
                            return false;
                        }
                    }
                    if (!uRLNode.isExpanded()) {
                        uRLNode.buildChildren(true, false, true);
                    }
                    stringBuffer.append(string2).append(File.separator);
                    ++n;
                }
                string = stringArray[stringArray.length - 1];
            }
            String string3 = WildcardURLFilter.makeLiteral(string);
            WildcardURLFilter wildcardURLFilter = new WildcardURLFilter(string3 + "*", URLChooser.ra$_isCaseSensitive());
            int n = URLChooser.ra$_selectionScope(URLChooser.this) == 1 ? 3 : 1;
            Vector vector = new Vector();
            if (stringArray.length <= 1) {
                vector.addAll(URLChooser.ra$_root(URLChooser.this).getFiles(wildcardURLFilter, n));
            }
            vector.addAll(uRLNode.getFiles(wildcardURLFilter, n));
            int n2 = vector.size();
            if (n2 <= 0) {
                this.hideCompletionList();
                return false;
            }
            if (bl && n2 == 1) {
                URLChooser.mav$runLater(URLChooser.this, 14);
            }
            URLChooser.ra$_completionList(URLChooser.this).setPathPrefix(stringBuffer.toString());
            URLChooser.ra$_completionList(URLChooser.this).setListData(vector);
            return true;
        }

        private void autoFillFileName() {
            String string;
            int n;
            String string2;
            int n2;
            int n3;
            String string3;
            URL uRL;
            if (URLChooser.ra$_completionList(URLChooser.this) == null) {
                return;
            }
            URLNode uRLNode = (URLNode)URLChooser.ra$_completionList(URLChooser.this).getModel().getElementAt(0);
            URL uRL2 = uRLNode.getURL();
            String string4 = URLChooser.ra$_completionList(URLChooser.this).getPathPrefix().replace(File.separatorChar, '/');
            if (new File(string4).isAbsolute()) {
                uRL = URLFactory.newURL(string4);
            } else if (string4.startsWith(File.separator) || string4.startsWith("/")) {
                uRL = URLFactory.newURL(this.getRootURL(URLChooser.mav$getSelectedDirComboBoxNode(URLChooser.this).getURL()), string4);
            } else {
                URLNode uRLNode2 = URLChooser.mav$getSelectedDirComboBoxNode(URLChooser.this);
                uRL = URLFactory.newURL(uRLNode2.getURL(), string4);
            }
            if (JarUtil.isJarURL(uRL2) && !JarUtil.isJarURL(uRL)) {
                uRL2 = JarUtil.getJarFileURL(uRL2);
            }
            if (!ModelUtil.hasLength((String)(string3 = URLFileSystem.toRelativeSpec(uRL2, uRL, true)))) {
                return;
            }
            StringBuffer stringBuffer = new StringBuffer(string4 + string3);
            if (stringBuffer.charAt(n3 = stringBuffer.length() - 1) == '/') {
                stringBuffer.setLength(n3);
            }
            if ((n2 = (string2 = stringBuffer.toString()).length()) >= (n = (string = URLChooser.this.getFileNameURL()).length())) {
                String string5;
                String string6 = string2.substring(0, n);
                String string7 = string.replace('/', File.separatorChar);
                if (URLChooser.maS$compare(string7, string5 = string6.replace('/', File.separatorChar)) == 0) {
                    URLChooser.this.setFileNameURL(string + string2.substring(n));
                    URLChooser.ra$_tfFileName(URLChooser.this).setCaretPosition(string2.length());
                    URLChooser.ra$_tfFileName(URLChooser.this).moveCaretPosition(n);
                }
            }
        }

        private URL getRootURL(URL uRL) {
            if (uRL == null) {
                return null;
            }
            URL uRL2;
            while ((uRL2 = URLFileSystem.getParent(uRL)) != null) {
                uRL = uRL2;
            }
            return uRL;
        }

        private void hideCompletionList() {
            if (URLChooser.ra$_completionWindow(URLChooser.this) != null) {
                URLChooser.ra$_completionWindow(URLChooser.this).dispose();
                URLChooser.wa$_completionWindow(URLChooser.this, null);
                URLChooser.wa$_completionList(URLChooser.this, null);
                Toolkit.getDefaultToolkit().removeAWTEventListener(URLChooser.ra$_listener(URLChooser.this));
            }
        }

        private void tabCompletion() {
            String string;
            String string2 = string = URLChooser.this.getFileNameURL();
            int n = string2.length();
            ListModel listModel = URLChooser.ra$_completionList(URLChooser.this).getModel();
            int n2 = listModel.getSize();
            String string3 = "";
            String string4 = string2;
            block0: while (true) {
                int n3 = n2;
                while (--n3 >= 0) {
                    URLNode uRLNode = (URLNode)listModel.getElementAt(n3);
                    URL uRL = uRLNode.getURL();
                    string3 = URLFileSystem.getFileName(uRL);
                    if (n > string3.length() || URLChooser.maS$compare(string2, string4 = string3.substring(0, n)) != 0) break block0;
                }
                string = string4;
                if (++n > string3.length()) break;
                string2 = string3.substring(0, n);
            }
            URLChooser.this.setFileNameURL(string);
        }

        private void selectNextCompletion() {
            int n = URLChooser.ra$_completionList(URLChooser.this).getModel().getSize() - 1;
            int n2 = URLChooser.ra$_completionList(URLChooser.this).getSelectedIndex();
            if (n2 < n) {
                this.setCompletionIndex(n2 + 1);
            }
        }

        private void selectPrevCompletion() {
            int n = URLChooser.ra$_completionList(URLChooser.this).getSelectedIndex();
            if (n > 0) {
                this.setCompletionIndex(n - 1);
            } else if (n < 0) {
                int n2 = URLChooser.ra$_completionList(URLChooser.this).getModel().getSize() - 1;
                this.setCompletionIndex(n2);
            }
        }

        private void setCompletionIndex(int n) {
            URLChooser.ra$_completionList(URLChooser.this).setSelectedIndex(n);
            URLChooser.ra$_completionList(URLChooser.this).ensureIndexIsVisible(n);
        }

        private void createNewDir() {
            URLNode uRLNode = URLChooser.mav$getSelectedDirComboBoxNode(URLChooser.this);
            if (uRLNode != null) {
                URL uRL;
                URL uRL2 = uRLNode.getURL();
                String string = "";
                while (true) {
                    if ((string = this.showNewDirectoryDialog(URLChooser.this, string)) == null) {
                        return;
                    }
                    if (string.indexOf(47) >= 0 || string.indexOf(File.separatorChar) >= 0) {
                        JOptionPane.showMessageDialog(URLChooser.this, NetArb.getString(24), NetArb.getString(23), 0);
                        continue;
                    }
                    uRL = URLFactory.newDirURL(uRL2, string);
                    if (URLFileSystem.mkdirs(uRL)) break;
                    JOptionPane.showMessageDialog(URLChooser.this, NetArb.getString(25), NetArb.getString(23), 0);
                }
                uRLNode.insertDir(uRL);
                return;
            }
        }

        private String showNewDirectoryDialog(Component component, String string) {
            JPanel jPanel = new JPanel(new GridBagLayout());
            JLabel jLabel = new JLabel();
            JTextField jTextField = new JTextField(30);
            ResourceUtils.resLabel(jLabel, jTextField, NetArb.getString(22));
            int n = 0;
            jPanel.add((Component)jLabel, new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
            jPanel.add((Component)jTextField, new GridBagConstraints(0, n++, 0, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
            jPanel.add((Component)new JLabel(), new GridBagConstraints(0, n++, 0, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            JEWTDialog jEWTDialog = new JEWTDialog(SwingUtils.findFrame((Component)URLChooser.this), NetArb.getString(21), 3);
            jEWTDialog.setInitialFocus((Component)jTextField);
            jEWTDialog.setContent((Component)jPanel);
            jEWTDialog.setOKButtonEnabled(false);
            jTextField.getDocument().addDocumentListener(new 1(this, jEWTDialog, jTextField));
            jTextField.setText(string);
            if (WizardLauncher.runDialog((JDialog)jEWTDialog)) {
                return jTextField.getText();
            }
            return null;
        }

        private void setLocation(URLNode uRLNode) {
            ListCellRenderer listCellRenderer = URLChooser.ra$_cbLocation(URLChooser.this).getRenderer();
            URLChooser.ra$_cbLocation(URLChooser.this).setRenderer(null);
            URLChooser.ra$_cbLocation(URLChooser.this).setSelectedItem(uRLNode);
            URLChooser.ra$_cbLocation(URLChooser.this).setRenderer(listCellRenderer);
        }

        private void setLocationsModel(ComboBoxModel comboBoxModel) {
            ListCellRenderer listCellRenderer = URLChooser.ra$_cbLocation(URLChooser.this).getRenderer();
            URLChooser.ra$_cbLocation(URLChooser.this).setRenderer(null);
            URLChooser.ra$_cbLocation(URLChooser.this).setModel(comboBoxModel);
            URLChooser.ra$_cbLocation(URLChooser.this).setRenderer(listCellRenderer);
        }

        public final class 1
        implements DocumentListener {
            private final /* synthetic */ JEWTDialog v$dlg;
            private final /* synthetic */ JTextField v$dirNameField;
            final /* synthetic */ UI this$0;

            public void changedUpdate(DocumentEvent documentEvent) {
                this.processChange();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                this.processChange();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.processChange();
            }

            private void processChange() {
                this.v$dlg.setOKButtonEnabled(this.canOk());
            }

            private boolean canOk() {
                return this.v$dirNameField.getText().trim().length() > 0;
            }

            public 1(UI uI, JEWTDialog jEWTDialog, JTextField jTextField) {
                this.v$dirNameField = jTextField;
                this.v$dlg = jEWTDialog;
                this.this$0 = uI;
            }
        }
    }

    private class RefreshAction
    extends AbstractAction {
        public static final String KEY = "urlchooser-refresh";

        public boolean isEnabled() {
            if (URLChooser.ra$_selectionScope(URLChooser.this) == 1) {
                return URLChooser.ra$_dirTree(URLChooser.this).isEnabled();
            }
            return URLChooser.ra$_fileView(URLChooser.this).isEnabled();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            URLChooser.mav$runNow(URLChooser.this, 21);
        }

        private RefreshAction() {
        }

        RefreshAction(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private static class URLNodeComparator
    implements Comparator {
        private final boolean _dirsBeforeFiles;
        private final boolean _caseSensitive;

        public URLNodeComparator(boolean bl, boolean bl2) {
            this._dirsBeforeFiles = bl;
            this._caseSensitive = bl2;
        }

        public int compare(Object object, Object object2) {
            boolean bl;
            boolean bl2;
            if (object == object2) {
                return 0;
            }
            if (object == null) {
                return -1;
            }
            if (object2 == null) {
                return 1;
            }
            URL uRL = ((URLNode)object).getURL();
            URL uRL2 = ((URLNode)object2).getURL();
            if (this._dirsBeforeFiles && (bl2 = URLFileSystem.isDirectoryPath(uRL)) != (bl = URLFileSystem.isDirectoryPath(uRL2))) {
                return bl2 ? -1 : 1;
            }
            String string = URLFileSystem.getFileName(uRL);
            String string2 = URLFileSystem.getFileName(uRL2);
            if (this._caseSensitive) {
                return string.compareTo(string2);
            }
            return string.compareToIgnoreCase(string2);
        }
    }

    private class Dlg
    extends TDialog
    implements MouseListener {
        private final DoubleClickTrigger _trigger;

        Dlg(TDialogLauncher tDialogLauncher, Traversable traversable, String string) {
            super(tDialogLauncher);
            this.$init$();
            this.init(traversable, string);
        }

        private void init(Traversable traversable, String string) {
            this.setResizable(true);
            this.setOKButtonText(string);
            this.setContent(traversable.getComponent());
            this.setInitialFocus(URLChooser.ra$_tfFileName(URLChooser.this));
        }

        protected void dismissDialog(boolean bl) {
            if (bl) {
                URLChooser.this.cancelSelection();
                super.dismissDialog(bl);
                return;
            }
            boolean bl2 = this.isOKButtonEnabled();
            this.setOKButtonEnabled(false);
            boolean bl3 = URLChooser.this.approveSelection();
            this.setOKButtonEnabled(bl2);
            if (bl3) {
                super.dismissDialog(bl);
            }
        }

        void $init$() {
            this._trigger = new DoubleClickTrigger();
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (this._trigger.isDoubleClick(mouseEvent)) {
                Point point = mouseEvent.getPoint();
                if (URLChooser.ra$_selectionScope(URLChooser.this) == 1) {
                    int n = URLChooser.ra$_dirTree(URLChooser.this).getRowForLocation(point.x, point.y);
                    if (URLChooser.ra$_dirTree(URLChooser.this).isRowSelected(n)) {
                        this.dismissDialog(false);
                    }
                } else {
                    URLNode uRLNode = URLChooser.ra$_fileView(URLChooser.this).getNodeAt(point);
                    if (uRLNode != null && uRLNode.isLeaf()) {
                        this.dismissDialog(false);
                    }
                }
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }

    private class TF
    extends JTextField {
        private final boolean _doTabCompletion;

        void $init$() {
            this._doTabCompletion = Boolean.getBoolean("jdev.tab.completion");
        }

        public TF() {
            this.$init$();
            if (this._doTabCompletion) {
                this.setFocusTraversalKeys(0, Collections.EMPTY_SET);
            }
        }

        protected void processKeyEvent(KeyEvent keyEvent) {
            if (keyEvent.getID() == 401) {
                int n = keyEvent.getKeyCode();
                if (n == 9 && this._doTabCompletion) {
                    boolean bl;
                    if (URLChooser.ra$_completionWindow(URLChooser.this) != null) {
                        URLChooser.mav$runNow(URLChooser.this, 15);
                        bl = false;
                    } else {
                        bl = true;
                    }
                    if (bl) {
                        KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent(this);
                    }
                    keyEvent.consume();
                } else if (URLChooser.ra$_completionWindow(URLChooser.this) != null) {
                    switch (n) {
                        case 27: {
                            URLChooser.mav$runNow(URLChooser.this, 13);
                            keyEvent.consume();
                            return;
                        }
                        case 38: {
                            URLChooser.mav$runNow(URLChooser.this, 17);
                            keyEvent.consume();
                            return;
                        }
                        case 40: {
                            URLChooser.mav$runNow(URLChooser.this, 16);
                            keyEvent.consume();
                            return;
                        }
                        case 33: {
                            break;
                        }
                    }
                }
            }
            super.processKeyEvent(keyEvent);
        }

        protected void clear() {
            this.setText("");
        }
    }

    private class CL
    extends JList
    implements MouseListener,
    ListSelectionListener,
    KeyListener {
        private String _pathPrefix;
        private final DoubleClickTrigger _trigger;

        void $init$() {
            this._pathPrefix = "";
            this._trigger = new DoubleClickTrigger();
        }

        CL() {
            this.$init$();
            this.setSelectionMode(0);
            this.setCellRenderer(new LCR2());
            this.setVisibleRowCount(7);
            this.addKeyListener(this);
            this.addListSelectionListener(this);
            this.addMouseListener(this);
        }

        public boolean isFocusTraversable() {
            return false;
        }

        String getPathPrefix() {
            return this._pathPrefix;
        }

        void setPathPrefix(String string) {
            this._pathPrefix = string != null ? string : "";
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            boolean bl = URLChooser.ra$_listener(URLChooser.this).isEnabled();
            try {
                URLChooser.ra$_listener(URLChooser.this).setEnabled(false);
                URLNode uRLNode = (URLNode)this.getSelectedValue();
                if (uRLNode != null) {
                    URL uRL = uRLNode.getURL();
                    if (URLFileSystem.isRoot(uRL)) {
                        URLChooser.this.setFileNameURL(URLFileSystem.getPlatformPathName(uRL));
                    } else {
                        URLChooser.this.setFileNameURL(this._pathPrefix + URLFileSystem.getFileName(uRL));
                    }
                }
            }
            finally {
                URLChooser.ra$_listener(URLChooser.this).setEnabled(bl);
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
            switch (keyEvent.getKeyCode()) {
                case 10: {
                    URLChooser.mav$runNow(URLChooser.this, 13);
                    if (URLChooser.ra$_urlChooserDialog(URLChooser.this) == null) break;
                    URLChooser.ra$_urlChooserDialog(URLChooser.this).dismissDialog(false);
                    break;
                }
                case 27: {
                    URLChooser.mav$runNow(URLChooser.this, 13);
                    keyEvent.consume();
                }
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            URLChooser.mav$runNow(URLChooser.this, 13);
            if (this._trigger.isDoubleClick(mouseEvent)) {
                URLChooser.ra$_urlChooserDialog(URLChooser.this).dismissDialog(false);
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        static String ra$_pathPrefix(CL cL) {
            return cL._pathPrefix;
        }

        private final class LCR2
        extends DefaultListCellRenderer {
            LCR2() {
                this.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
            }

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                URLChooser.maS$setLabelIcon(jLabel, object, false);
                this.setText(CL.ra$_pathPrefix(CL.this) + object.toString());
                this.setEnabled(jList.isEnabled());
                return jLabel;
            }
        }
    }

    private class ShortcutBar
    extends JPanel
    implements ComponentListener {
        private final JScrollPane _shortcutScrollPane;
        private final ShortcutPanel _shortcutPanel;

        public ShortcutBar() {
            BoxLayout boxLayout = new BoxLayout(this, 1);
            this.setLayout(boxLayout);
            this.setBorder(ThinBevel.RAISED_BORDER);
            this.setVisible(false);
            this._shortcutPanel = new ShortcutPanel();
            this._shortcutScrollPane = new JScrollPane(20, 31);
            this._shortcutScrollPane.setOpaque(false);
            this._shortcutScrollPane.setBorder(BorderFactory.createEmptyBorder());
            this._shortcutScrollPane.setViewportView(this._shortcutPanel);
            this._shortcutScrollPane.getViewport().setOpaque(false);
            this._shortcutScrollPane.getVerticalScrollBar().addComponentListener(this);
            this.add(this._shortcutScrollPane);
        }

        public void addShortcutButton(Icon icon, String string, URL uRL) {
            if (uRL == null) {
                return;
            }
            ShortcutButton shortcutButton = new ShortcutButton(icon, string, uRL);
            this._shortcutPanel.add(shortcutButton);
        }

        public void removeShortcutButtons() {
            this._shortcutPanel.removeAll();
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            Composite composite = graphics2D.getComposite();
            Rectangle rectangle = graphics2D.getClipBounds();
            graphics2D.setComposite(URLChooser.ra$SHORTCUT_BACKGROUND_COMPOSITE());
            graphics2D.setColor(Color.white);
            graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics2D.setComposite(composite);
        }

        public Dimension getPreferredSize() {
            JScrollBar jScrollBar;
            Dimension dimension = this._shortcutPanel.getMinimumSize();
            int n = dimension != null ? dimension.width : this._shortcutPanel.getWidth();
            Insets insets = this._shortcutPanel.getInsets();
            if (insets != null) {
                n += insets.left + insets.right;
            }
            if ((insets = this.getInsets()) != null) {
                n += insets.left + insets.right;
            }
            if ((insets = this._shortcutScrollPane.getViewport().getInsets()) != null) {
                n += insets.left + insets.right;
            }
            if ((jScrollBar = this._shortcutScrollPane.getVerticalScrollBar()) != null && jScrollBar.isVisible()) {
                n += jScrollBar.getWidth();
            }
            int n2 = URLChooser.ra$_cbFileType(URLChooser.this).getY() + URLChooser.ra$_cbFileType(URLChooser.this).getHeight() - URLChooser.ra$_fileView(URLChooser.this).getY();
            return new Dimension(n, n2);
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        public void componentHidden(ComponentEvent componentEvent) {
            if (componentEvent.getSource() == this._shortcutScrollPane.getVerticalScrollBar()) {
                URLChooser.this.revalidate();
            }
        }

        public void componentShown(ComponentEvent componentEvent) {
            this.componentHidden(componentEvent);
        }

        public void componentMoved(ComponentEvent componentEvent) {
        }

        public void componentResized(ComponentEvent componentEvent) {
        }

        private class ShortcutPanel
        extends JToolBar
        implements Scrollable {
            public ShortcutPanel() {
                super(1);
                this.setFloatable(false);
                this.setRollover(true);
                this.setOpaque(false);
                this.setBorder(BorderFactory.createEmptyBorder());
            }

            public Dimension getPreferredScrollableViewportSize() {
                return new Dimension(URLChooser.ra$SHORTCUT_BUTTON_SIZE().width, URLChooser.ra$_cbFileType(URLChooser.this).getY() + URLChooser.ra$_cbFileType(URLChooser.this).getHeight() - URLChooser.ra$_fileView(URLChooser.this).getY());
            }

            public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
                return n == 1 ? rectangle.height / URLChooser.ra$SHORTCUT_BUTTON_SIZE().height * URLChooser.ra$SHORTCUT_BUTTON_SIZE().height : rectangle.width / URLChooser.ra$SHORTCUT_BUTTON_SIZE().width * URLChooser.ra$SHORTCUT_BUTTON_SIZE().width;
            }

            public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
                return n == 1 ? URLChooser.ra$SHORTCUT_BUTTON_SIZE().height : URLChooser.ra$SHORTCUT_BUTTON_SIZE().width;
            }

            public boolean getScrollableTracksViewportHeight() {
                return false;
            }

            public boolean getScrollableTracksViewportWidth() {
                return false;
            }

            protected void addImpl(Component component, Object object, int n) {
                super.addImpl(component, object, n);
                ShortcutBar.this.setVisible(true);
            }

            public void removeAll() {
                super.removeAll();
                ShortcutBar.this.setVisible(false);
            }
        }

        private class ShortcutButton
        extends JButton
        implements ActionListener {
            private final URL _targetURL;

            public ShortcutButton(Icon icon, String string, URL uRL) {
                super(icon);
                this.setMargin(new Insets(1, 1, 1, 1));
                this.setMinimumSize(URLChooser.ra$SHORTCUT_BUTTON_SIZE());
                this.setPreferredSize(URLChooser.ra$SHORTCUT_BUTTON_SIZE());
                this.setMaximumSize(URLChooser.ra$SHORTCUT_BUTTON_SIZE());
                this.setOpaque(false);
                URL uRL2 = this._targetURL = URLFileSystem.isDirectoryPath(uRL) ? URLFactory.newURL(uRL, "") : URLFileSystem.getParent(uRL);
                if (icon == null) {
                    this.setIcon(IdeIcons.getIcon(4));
                }
                this.setText(string);
                this.setToolTipText(NetArb.format(10, string, URLFileSystem.getPlatformPathName(this._targetURL)));
                this.setHorizontalTextPosition(0);
                this.setVerticalTextPosition(3);
                this.addActionListener(this);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                URLChooser.mav$setSelectedURLImpl(URLChooser.this, this._targetURL, false);
                URLChooser.ra$_tfFileName(URLChooser.this).requestFocus();
            }
        }
    }

    private class CommandBar
    extends JToolBar
    implements ActionListener {
        private static final String ICON_KEY_UP_FOLDER = "FileChooser.upFolderIcon";
        private static final String ICON_KEY_NEW_FOLDER = "FileChooser.newFolderIcon";
        private static final String ICON_KEY_DETAILS_VIEW = "FileChooser.detailsViewIcon";
        private static final String ICON_KEY_LIST_VIEW = "FileChooser.listViewIcon";
        private JButton _btnBack;
        private JButton _btnChdirToParent;
        private JButton _btnNewDir;
        private JToggleButton _btnListView;
        private JToggleButton _btnDetailsView;

        public CommandBar() {
            this.setBorder(BorderFactory.createEmptyBorder());
            this.setFloatable(false);
            this.setRollover(true);
            this.createButtons();
        }

        public void enableBackButton(boolean bl) {
            if (this._btnBack != null) {
                this._btnBack.setEnabled(bl);
            }
        }

        public void enableUpDirButton(boolean bl) {
            if (this._btnChdirToParent != null) {
                this._btnChdirToParent.setEnabled(bl);
            }
        }

        public void enableNewDirButton(boolean bl) {
            if (this._btnNewDir != null) {
                this._btnNewDir.setEnabled(bl);
            }
        }

        public void setDetailsView(boolean bl) {
            if (this._btnListView != null && this._btnDetailsView != null) {
                URLChooser.ra$_fileView(URLChooser.this).setDetailsView(bl);
            }
        }

        public void setSelectionScope(int n) {
            this.removeAll();
            if (n == 1) {
                if (this._btnNewDir != null) {
                    this.add(this._btnNewDir);
                }
            } else {
                if (this._btnBack != null) {
                    this.add(this._btnBack);
                }
                if (this._btnChdirToParent != null) {
                    this.add(this._btnChdirToParent);
                }
                if (this._btnNewDir != null) {
                    this.add(this._btnNewDir);
                }
                if (this._btnListView != null && this._btnDetailsView != null) {
                    if (this.getComponentCount() > 0) {
                        this.add(Box.createHorizontalStrut(5));
                    }
                    this.add(this._btnListView);
                    this.add(this._btnDetailsView);
                }
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (URLChooser.ra$_listener(URLChooser.this).isEnabled()) {
                Object object = actionEvent.getSource();
                if (object == null) {
                    return;
                }
                if (object == this._btnBack) {
                    URLChooser.mav$runNow(URLChooser.this, 20);
                } else if (object == this._btnChdirToParent) {
                    URLChooser.mav$runNow(URLChooser.this, 1);
                } else if (object == this._btnNewDir) {
                    URLChooser.mav$runNow(URLChooser.this, 18);
                } else if (object == this._btnListView) {
                    this.setDetailsView(false);
                } else if (object == this._btnDetailsView) {
                    this.setDetailsView(true);
                }
            }
        }

        private JButton createButton(Icon icon, String string) {
            JButton jButton = new JButton(icon);
            this.initButton(jButton, string);
            return jButton;
        }

        private JToggleButton createToggleButton(Icon icon, String string) {
            JToggleButton jToggleButton = new JToggleButton(icon);
            this.initButton(jToggleButton, string);
            return jToggleButton;
        }

        private void initButton(AbstractButton abstractButton, String string) {
            abstractButton.setMargin(new Insets(1, 1, 1, 1));
            abstractButton.addActionListener(this);
            if (string != null) {
                abstractButton.setToolTipText(string);
            }
        }

        private void createButtons() {
            Icon icon = IdeIcons.getIcon(14);
            if (icon != null) {
                this._btnBack = this.createButton(icon, NetArb.getString(5));
                this._btnBack.setEnabled(false);
            } else {
                this._btnBack = null;
            }
            Icon icon2 = NetArb.getIcon(36);
            this._btnChdirToParent = icon2 != null ? this.createButton(icon2, NetArb.getString(6)) : null;
            Icon icon3 = NetArb.getIcon(37);
            this._btnNewDir = icon3 != null ? this.createButton(icon3, NetArb.getString(7)) : null;
            Icon icon4 = NetArb.getIcon(38);
            Icon icon5 = NetArb.getIcon(39);
            if (icon4 != null && icon5 != null) {
                this._btnListView = this.createToggleButton(icon4, NetArb.getString(8));
                this._btnDetailsView = this.createToggleButton(icon5, NetArb.getString(9));
                ButtonGroup buttonGroup = new ButtonGroup();
                buttonGroup.add(this._btnListView);
                buttonGroup.add(this._btnDetailsView);
                this._btnListView.setSelected(true);
            } else {
                this._btnDetailsView = null;
                this._btnListView = null;
            }
        }
    }

    private class FileView
    extends JPanel
    implements KeyListener {
        private final FileTable _fileTable;
        private final JScrollPane _fileScrollPane;

        void $init$() {
            this._fileTable = new FileTable();
            this._fileScrollPane = this._fileTable.getScrollPaneForTable();
        }

        public FileView() {
            this.$init$();
            this.setSelectionMode(2);
            this.setLayout(new BoxLayout(this, 1));
            this.add(this._fileScrollPane);
        }

        public void clearSelection() {
            this._fileTable.clearSelection();
        }

        public URLNode getNodeAt(Point point) {
            return this._fileTable.getNodeAt(point);
        }

        public URLNode getSelectedNode() {
            return this._fileTable.getSelectedNode();
        }

        public URL getSelectedURL() {
            URLNode uRLNode = this.getSelectedNode();
            return uRLNode != null ? uRLNode.getURL() : null;
        }

        public Object[] getSelectedValues() {
            return this._fileTable.getSelectedValues();
        }

        public void resetSelection() {
            this._fileTable.resetSelection();
        }

        public void setDetailsView(boolean bl) {
            this._fileTable.setDetailsView(bl);
            this.updateColumnHeader();
        }

        public boolean isDetailsView() {
            return this._fileTable.isDetailsView();
        }

        public void setKeyboardEnabled(boolean bl) {
            if (bl) {
                this._fileTable.removeKeyListener(this);
            } else {
                this._fileTable.addKeyListener(this);
            }
        }

        public void setSelectionMode(int n) {
            this._fileTable.setSelectionMode(n);
        }

        public void setSelectionModel(ListSelectionModel listSelectionModel) {
            if (listSelectionModel != null) {
                DefaultListSelectionModel defaultListSelectionModel = new DefaultListSelectionModel();
                defaultListSelectionModel.setSelectionMode(listSelectionModel.getSelectionMode());
                defaultListSelectionModel.setAnchorSelectionIndex(listSelectionModel.getAnchorSelectionIndex());
                defaultListSelectionModel.setLeadSelectionIndex(listSelectionModel.getLeadSelectionIndex());
                this._fileTable.setSelectionModel(defaultListSelectionModel);
            }
        }

        public void updateList(URLNode uRLNode, URLFilter uRLFilter) {
            this._fileTable.updateList(uRLNode, uRLFilter);
        }

        public void clearList(boolean bl) {
            this._fileTable.clearList();
            if (bl) {
                this.paint(this.getGraphics());
            }
        }

        public void updateSelectedFile(String string) {
            this._fileTable.updateSelectedFile(string);
        }

        public void addViewMouseListener(MouseListener mouseListener) {
            this._fileTable.addMouseListener(mouseListener);
        }

        public void removeViewMouseListener(MouseListener mouseListener) {
            this._fileTable.removeMouseListener(mouseListener);
        }

        public void addViewListSelectionListener(ListSelectionListener listSelectionListener) {
            this._fileTable.getSelectionModel().addListSelectionListener(listSelectionListener);
        }

        public void removeViewListSelectionListener(ListSelectionListener listSelectionListener) {
            this._fileTable.getSelectionModel().removeListSelectionListener(listSelectionListener);
        }

        public void keyPressed(KeyEvent keyEvent) {
            Toolkit.getDefaultToolkit().beep();
            keyEvent.consume();
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        protected void updateColumnHeader() {
            this._fileTable.getTableHeader().setVisible(this.isDetailsView());
            this._fileScrollPane.setColumnHeaderView(this.isDetailsView() ? this._fileTable.getTableHeader() : null);
        }

        static JScrollPane ra$_fileScrollPane(FileView fileView) {
            return fileView._fileScrollPane;
        }

        private class FileTable
        extends NiceTable
        implements FocusListener {
            private final FileTableModel _model;
            private final KeyNavigationManager _knm;
            private TableColumn[] columns;
            private boolean columnsSized;

            void $init$() {
                this._model = new FileTableModel();
                this._knm = new KeyNavigationManager();
            }

            public FileTable() {
                super(null);
                this.$init$();
                this.setFocusTraversalKeys(0, null);
                this.setFocusTraversalKeys(1, null);
                this._knm.setKeyComponentAdapter(new KeyNavigationManager.TableKeyAdapter((JTable)((Object)this)));
                this.addFocusListener(this);
                this.setModel(this._model);
                this.setSorted(true);
                this.setDefaultRenderer(URLNode.class, (TableCellRenderer)((Object)new URLNodeCellRenderer(null)));
                this.setDefaultRenderer(FileSize.class, (TableCellRenderer)((Object)new NoSelectionCellRenderer(null)));
                this.setDefaultRenderer(FileDate.class, (TableCellRenderer)((Object)new NoSelectionCellRenderer(null)));
                URLChooser.maS$addKeyboardAction((JComponent)((Object)this), (Action)new TableDescendDirectoryAction(null), "table-descend-into-child", URLChooser.ra$TABLE_DESCEND_KEYSTROKE());
                URLChooser.maS$addKeyboardAction((JComponent)((Object)this), (Action)new TableAscendDirectoryAction(null), "table-ascend-to-parent", URLChooser.ra$TABLE_ASCEND_KEYSTROKE());
                URLChooser.maS$addKeyboardAction((JComponent)((Object)this), (Action)new TableSelectCurrentAction(null), "table-select-current", URLChooser.ra$TABLE_SELECT_CURRENT_KEYSTROKES());
                URLChooser.maS$addKeyboardAction((JComponent)((Object)this), (Action)new TableToggleSelectAction(null), "table-toggle-selection", URLChooser.ra$TABLE_TOGGLE_SELECT_KEYSTROKE());
            }

            public void setDetailsView(boolean bl) {
                this._model.setDetailsView(bl);
                this.setAutoResizeMode(bl ? 0 : 2);
                if (!bl) {
                    this.removeDetailColumns();
                } else {
                    this.addDetailColumns();
                }
            }

            public boolean isDetailsView() {
                return this._model.isDetailsView();
            }

            public void updateSelectedFile(String string) {
                int n = this._model.findNode(string);
                if (n >= 0) {
                    this.selectRow(n);
                } else {
                    this.resetSelection();
                }
            }

            public void resetSelection() {
                if (this.getModel().getRowCount() > 0) {
                    this.selectRow(0);
                    this.removeRowSelectionInterval(0, 0);
                }
            }

            public void clearList() {
                this._model.setData(new URLNode[0]);
            }

            public void updateList(URLNode uRLNode, URLFilter uRLFilter) {
                if (uRLNode == null) {
                    this.clearList();
                } else {
                    int n = URLChooser.ra$_selectionScope(URLChooser.this) == 1 ? 0 : (URLChooser.ra$_selectionScope(URLChooser.this) == 1 ? 3 : 2);
                    Vector vector = uRLNode.getFiles(uRLFilter, n);
                    URLNode[] uRLNodeArray = vector.toArray(new URLNode[vector.size()]);
                    this._model.setData(uRLNodeArray);
                }
            }

            public Object[] getSelectedValues() {
                int[] nArray = this.getSelectedRows();
                Object[] objectArray = new Object[nArray.length];
                int n = 0;
                while (n < nArray.length) {
                    objectArray[n] = this.getModel().getValueAt(nArray[n], 0);
                    ++n;
                }
                return objectArray;
            }

            public URLNode getSelectedNode() {
                int n = this.getSelectedRow();
                return n >= 0 ? (URLNode)this.getModel().getValueAt(n, 0) : null;
            }

            public URLNode getNodeAt(Point point) {
                int n = this.columnAtPoint(point);
                if (n != this.convertColumnIndexToView(0)) {
                    return null;
                }
                int n2 = this.rowAtPoint(point);
                return n >= 0 && n2 >= 0 ? (URLNode)this.getModel().getValueAt(n2, 0) : null;
            }

            public void focusGained(FocusEvent focusEvent) {
                if (this.isDetailsView()) {
                    ListSelectionModel listSelectionModel = this.getColumnModel().getSelectionModel();
                    int n = listSelectionModel.getAnchorSelectionIndex();
                    int n2 = listSelectionModel.getLeadSelectionIndex();
                    int n3 = this.convertColumnIndexToView(0);
                    if (n2 != -1 && n2 != n3 || n != -1 && n != n3) {
                        this.changeSelection(this.getSelectionModel().getAnchorSelectionIndex(), n3, false, false);
                    }
                }
                this.repaintSelectedRows();
            }

            public void focusLost(FocusEvent focusEvent) {
                this.repaintSelectedRows();
            }

            public void changeSelection(int n, int n2, boolean bl, boolean bl2) {
                if (n2 == -1 || n2 == this.convertColumnIndexToView(0)) {
                    super.changeSelection(n, n2, bl, bl2);
                }
            }

            public void doLayout() {
                if (!this.columnsSized && this.isDetailsView()) {
                    this.initColumnSizes();
                    this.columnsSized = true;
                }
                super.doLayout();
            }

            public boolean isManagingFocus() {
                return false;
            }

            protected void processKeyEvent(KeyEvent keyEvent) {
                if (this._knm != null) {
                    this._knm.preProcessKeyEvent(keyEvent);
                }
                super.processKeyEvent(keyEvent);
                if (this._knm != null) {
                    this._knm.postProcessKeyEvent(keyEvent);
                }
            }

            protected void configureEnclosingScrollPane() {
                super.configureEnclosingScrollPane();
                FileView.this.updateColumnHeader();
            }

            private void repaintSelectedRows() {
                this.repaint();
            }

            private void selectRow(int n) {
                this.changeSelection(n, -1, false, false);
            }

            private void removeDetailColumns() {
                if (this.columns == null) {
                    TableColumnModel tableColumnModel = this.getColumnModel();
                    int n = tableColumnModel.getColumnCount();
                    this.columns = new TableColumn[n];
                    int n2 = this.convertColumnIndexToView(0);
                    int n3 = n;
                    while (--n3 >= 0) {
                        if (n3 != n2) {
                            TableColumn tableColumn;
                            this.columns[n3] = tableColumn = tableColumnModel.getColumn(n3);
                            tableColumnModel.removeColumn(tableColumn);
                            continue;
                        }
                        this.columns[n3] = null;
                    }
                }
            }

            private void addDetailColumns() {
                if (this.columns != null) {
                    TableColumnModel tableColumnModel = this.getColumnModel();
                    TableColumn tableColumn = tableColumnModel.getColumn(0);
                    int n = 0;
                    while (n < this.columns.length) {
                        TableColumn tableColumn2 = this.columns[n];
                        if (tableColumn2 != null) {
                            tableColumnModel.addColumn(tableColumn2);
                        } else {
                            tableColumnModel.removeColumn(tableColumn);
                            tableColumnModel.addColumn(tableColumn);
                        }
                        ++n;
                    }
                    this.columns = null;
                }
            }

            private void initColumnSizes() {
                TableColumnModel tableColumnModel = this.getColumnModel();
                int n = this.getRowCount();
                int n2 = tableColumnModel.getColumnCount();
                int n3 = 0;
                int n4 = 0;
                while (n4 < n2) {
                    TableColumn tableColumn = tableColumnModel.getColumn(n4);
                    Component component = this.getTableHeader().getDefaultRenderer().getTableCellRendererComponent((JTable)((Object)this), tableColumn.getHeaderValue(), false, false, -1, n4);
                    int n5 = component.getPreferredSize().width;
                    Class clazz = this.getColumnClass(n4);
                    int n6 = 0;
                    while (n6 < n) {
                        component = this.getDefaultRenderer(clazz).getTableCellRendererComponent((JTable)((Object)this), this.getValueAt(n6, n4), false, false, n6, n4);
                        n5 = Math.max(n5, component.getPreferredSize().width);
                        ++n6;
                    }
                    tableColumn.setPreferredWidth(n5);
                    n3 += n5;
                    ++n4;
                }
                int n7 = FileView.ra$_fileScrollPane(FileView.this).getViewport().getWidth();
                this.setSize(n7, this.getHeight());
                if (n7 > n3) {
                    int n8 = n7 - n3;
                    TableColumn tableColumn = tableColumnModel.getColumn(0);
                    int n9 = tableColumn.getPreferredWidth();
                    int n10 = n8 * 6 / 10;
                    n8 -= n10;
                    tableColumn.setPreferredWidth(n9 + n10);
                    tableColumn = tableColumnModel.getColumn(1);
                    n9 = tableColumn.getPreferredWidth();
                    n10 = n8 / 2;
                    n8 -= n10;
                    tableColumn.setPreferredWidth(n9 + n10);
                    tableColumn = tableColumnModel.getColumn(2);
                    n9 = tableColumn.getPreferredWidth();
                    n10 = n8;
                    n8 -= n10;
                    tableColumn.setPreferredWidth(n9 + n10);
                }
                this.resizeAndRepaint();
            }

            private final class FileSize
            implements Comparable {
                private final URLNode node;

                public FileSize(URLNode uRLNode) {
                    this.node = uRLNode;
                }

                public String toString() {
                    if (!this.isLeaf()) {
                        return "";
                    }
                    return NetArb.format(29, URLChooser.ra$NUMBER_FORMATTER().format(this.getKbSize()));
                }

                public int compareTo(Object object) {
                    long l;
                    FileSize fileSize = (FileSize)object;
                    if (this.isLeaf() != fileSize.isLeaf()) {
                        return this.isLeaf() ? 1 : -1;
                    }
                    long l2 = this.getSize();
                    if (l2 != (l = fileSize.getSize())) {
                        return l2 > l ? 1 : -1;
                    }
                    return this.node.compareTo(fileSize.node);
                }

                boolean isLeaf() {
                    return this.node.isLeaf();
                }

                long getSize() {
                    return this.isLeaf() ? this.node.length() : 0L;
                }

                long getKbSize() {
                    long l = this.getSize();
                    if (l <= 0L) {
                        return 0L;
                    }
                    long l2 = (l + 512L) / 1024L;
                    return l2 > 0L ? l2 : 1L;
                }
            }

            private final class FileDate
            implements Comparable {
                private final URLNode node;

                public FileDate(URLNode uRLNode) {
                    this.node = uRLNode;
                }

                public String toString() {
                    return URLChooser.ra$DATE_FORMATTER().format(this.getDate());
                }

                public int compareTo(Object object) {
                    long l;
                    FileDate fileDate = (FileDate)object;
                    if (this.isLeaf() != fileDate.isLeaf()) {
                        return this.isLeaf() ? 1 : -1;
                    }
                    long l2 = this.lastModified();
                    if (l2 != (l = fileDate.lastModified())) {
                        return l2 > l ? 1 : -1;
                    }
                    return this.node.compareTo(fileDate.node);
                }

                boolean isLeaf() {
                    return this.node.isLeaf();
                }

                long lastModified() {
                    return this.node.lastModified();
                }

                Date getDate() {
                    return new Date(this.lastModified());
                }
            }

            private final class FileTableModel
            extends AbstractTableModel
            implements NiceTableModel {
                private static final int URLNODE_COLUMN = 0;
                private static final int SIZE_COLUMN = 1;
                private static final int DATE_MODIFIED_COLUMN = 2;
                private URLNode[] _data;
                private boolean _detailsView;

                public void setDetailsView(boolean bl) {
                    this._detailsView = bl;
                }

                public boolean isDetailsView() {
                    return this._detailsView;
                }

                public void setData(URLNode[] uRLNodeArray) {
                    this._data = uRLNodeArray;
                    this.fireTableDataChanged();
                }

                public int findNode(String string) {
                    if (string != null && string.length() != 0 && this._data != null) {
                        int n = 0;
                        while (n < this._data.length) {
                            URLNode uRLNode = this._data[n];
                            if (URLChooser.maS$compare(uRLNode.toString(), string) == 0) {
                                return n;
                            }
                            ++n;
                        }
                    }
                    return -1;
                }

                public int getColumnAlignment(int n) {
                    switch (n) {
                        case 1: {
                            return 4;
                        }
                    }
                    return 2;
                }

                public Comparator getColumnSortComparator(int n) {
                    return null;
                }

                public int getColumnCount() {
                    return URLChooser.ra$FILE_TABLE_COLUMN_NAMES().length;
                }

                public String getColumnName(int n) {
                    return URLChooser.ra$FILE_TABLE_COLUMN_NAMES()[n];
                }

                public int getRowCount() {
                    return this._data != null ? this._data.length : 0;
                }

                public Object getValueAt(int n, int n2) {
                    if (this._data == null || n < 0 || n >= this._data.length) {
                        return null;
                    }
                    URLNode uRLNode = this._data[n];
                    switch (n2) {
                        case 0: {
                            return uRLNode;
                        }
                        case 1: {
                            return new FileSize(uRLNode);
                        }
                        case 2: {
                            return new FileDate(uRLNode);
                        }
                    }
                    return null;
                }

                public Class getColumnClass(int n) {
                    switch (n) {
                        case 0: {
                            return URLNode.class;
                        }
                        case 1: {
                            return FileSize.class;
                        }
                        case 2: {
                            return FileDate.class;
                        }
                    }
                    return null;
                }
            }

            private final class URLNodeCellRenderer
            extends NiceTableCellRenderer {
                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                    if (bl && this.isActiveColumn(jTable, n2)) {
                        if (jTable.hasFocus()) {
                            this.setBackground(jTable.getSelectionBackground());
                            this.setForeground(jTable.getSelectionForeground());
                        } else {
                            this.setBackground(URLChooser.ra$INACTIVE_BACKGROUND_SELECTION_COLOR());
                            this.setForeground(URLChooser.ra$INACTIVE_TEXT_SELECTION_COLOR());
                        }
                    }
                    URLChooser.maS$setLabelIcon((JLabel)((Object)this), object, true);
                    URLChooser.maS$setLabelFont((JLabel)((Object)this), object, jTable.getFont());
                    this.setEnabled(jTable.isEnabled());
                    this.setValue(object);
                    return this;
                }

                private boolean isActiveColumn(JTable jTable, int n) {
                    return n == jTable.getColumnModel().getSelectionModel().getAnchorSelectionIndex();
                }

                private URLNodeCellRenderer() {
                }

                URLNodeCellRenderer(1 var2_2) {
                    this();
                }

                public final class 1 {
                }
            }

            private final class NoSelectionCellRenderer
            extends NiceTableCellRenderer {
                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    return super.getTableCellRendererComponent(jTable, object, false, bl2, n, n2);
                }

                private NoSelectionCellRenderer() {
                }

                NoSelectionCellRenderer(1 var2_2) {
                    this();
                }

                public final class 1 {
                }
            }

            private class TableDescendDirectoryAction
            extends AbstractAction {
                public static final String KEY = "table-descend-into-child";

                public boolean isEnabled() {
                    if (!FileTable.this.isEnabled()) {
                        return false;
                    }
                    URL uRL = FileView.this.getSelectedURL();
                    return uRL != null && URLFileSystem.isDirectoryPath(uRL);
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    URLChooser.this.setSelectedURL(FileView.this.getSelectedURL());
                }

                private TableDescendDirectoryAction() {
                }

                TableDescendDirectoryAction(1 var2_2) {
                    this();
                }

                public final class 1 {
                }
            }

            private class TableAscendDirectoryAction
            extends AbstractAction {
                public static final String KEY = "table-ascend-to-parent";

                public boolean isEnabled() {
                    return FileTable.this.isEnabled();
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    URLChooser.mav$runNow(URLChooser.this, 1);
                }

                private TableAscendDirectoryAction() {
                }

                TableAscendDirectoryAction(1 var2_2) {
                    this();
                }

                public final class 1 {
                }
            }

            private final class TableSelectCurrentAction
            extends TableSelectAction {
                public static final String KEY = "table-select-current";

                protected int getDelta() {
                    return 0;
                }

                private TableSelectCurrentAction() {
                    super(null);
                }

                TableSelectCurrentAction(1 var2_2) {
                    this();
                }

                public final class 1 {
                }
            }

            private final class TableToggleSelectAction
            extends TableSelectAction {
                public static final String KEY = "table-toggle-selection";

                protected int getDelta() {
                    return 0;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    JTable jTable = (JTable)actionEvent.getSource();
                    if (jTable.getSelectionModel().isSelectionEmpty()) {
                        super.actionPerformed(actionEvent);
                    } else {
                        FileTable.this.clearSelection();
                    }
                }

                private TableToggleSelectAction() {
                    super(null);
                }

                TableToggleSelectAction(1 var2_2) {
                    this();
                }

                public final class 1 {
                }
            }

            private abstract class TableSelectAction
            extends AbstractAction {
                protected abstract int getDelta();

                public boolean isEnabled() {
                    return FileTable.this.isEnabled();
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    JTable jTable = (JTable)actionEvent.getSource();
                    int n = this.getIndexForSelection(jTable);
                    if (n >= 0 && n < jTable.getModel().getRowCount()) {
                        jTable.changeSelection(n, -1, false, false);
                    }
                }

                protected int getIndexForSelection(JTable jTable) {
                    int n = jTable.getModel().getRowCount();
                    int n2 = this.getDelta();
                    int n3 = jTable.getSelectionModel().getAnchorSelectionIndex();
                    if (n3 == -1) {
                        if (n > 0) {
                            n3 = n2 >= 0 ? 0 : n - 1;
                        }
                    } else if ((n3 += n2) < 0) {
                        n3 = 0;
                    } else if (n3 >= n) {
                        n3 = n - 1;
                    }
                    return n3;
                }

                private TableSelectAction() {
                }

                TableSelectAction(1 var2_2) {
                    this();
                }

                public final class 1 {
                }
            }
        }
    }

    private static class TCR
    extends DefaultTreeCellRenderer {
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            JLabel jLabel = (JLabel)super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            URLChooser.maS$setLabelIcon(jLabel, object, false);
            this.setEnabled(jTree.isEnabled());
            return jLabel;
        }

        private TCR() {
        }

        TCR(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static class LCR1
    extends DefaultListCellRenderer {
        private static final Border _defaultBorder = BorderFactory.createEmptyBorder(0, 2, 0, 0);

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            int n2;
            JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object instanceof URLNode) {
                URL uRL;
                URLNode uRLNode = (URLNode)object;
                TreeNode[] treeNodeArray = uRLNode.getPath();
                n2 = Math.max(treeNodeArray.length - 2, 0);
                if (n < 0 && (uRL = uRLNode.getURL()) != null) {
                    jLabel.setText(URLFileSystem.getPlatformPathName(uRL));
                }
            } else {
                n2 = 0;
            }
            jLabel.setBorder(n > 0 ? BorderFactory.createEmptyBorder(0, n2 * 10 + 2, 0, 0) : _defaultBorder);
            URLChooser.maS$setLabelIcon(jLabel, object, false);
            this.setEnabled(jList.isEnabled());
            return jLabel;
        }

        private LCR1() {
        }

        LCR1(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

