/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.net;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import oracle.ide.net.JarUtil;
import oracle.ide.net.NameGenerator;
import oracle.ide.net.ProtocolConstants;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.net.EncoderUtils;

public final class URLFactory {
    private static final Method urlSet;

    public static URL copyURL(URL uRL) {
        return URLFactory.newURL(uRL.getProtocol(), uRL.getUserInfo(), uRL.getHost(), uRL.getPort(), uRL.getPath(), uRL.getQuery(), uRL.getRef());
    }

    public static URL newURL(URL uRL, String string) {
        String string2 = URLFactory.resolveRelative(uRL.getPath(), string);
        if (JarUtil.isJarURL(uRL) && string2.indexOf("!/") < 0) {
            return JarUtil.newJarFileURLImpl(string2);
        }
        return URLFactory.replacePathPart(uRL, string2);
    }

    public static URL newDirURL(URL uRL, String string) {
        return string.endsWith("/") ? URLFactory.newURL(uRL, string) : URLFactory.newURL(uRL, string + "/");
    }

    public static URL newURL(String string, String string2) {
        return URLFactory.newURL(string, null, null, -1, string2, null, null);
    }

    public static URL newDirURL(String string, String string2) {
        return string2.endsWith("/") ? URLFactory.newURL(string, string2) : URLFactory.newURL(string, string2 + "/");
    }

    public static URL newUniqueURL(URL uRL, NameGenerator nameGenerator) {
        URL uRL2;
        do {
            String string;
            if ((uRL2 = URLFactory.newURL(uRL, string = nameGenerator.nextName())) != null) continue;
            return null;
        } while (URLFileSystem.isBound(uRL2));
        return uRL2;
    }

    public static URL replaceProtocolPart(URL uRL, String string) {
        String string2 = uRL.getUserInfo();
        String string3 = uRL.getHost();
        int n = uRL.getPort();
        String string4 = uRL.getPath();
        String string5 = uRL.getQuery();
        String string6 = uRL.getRef();
        return URLFactory.newURL(string, string2, string3, n, string4, string5, string6);
    }

    public static URL replacePortPart(URL uRL, int n) {
        String string = uRL.getProtocol();
        String string2 = uRL.getUserInfo();
        String string3 = uRL.getHost();
        String string4 = uRL.getPath();
        String string5 = uRL.getQuery();
        String string6 = uRL.getRef();
        return URLFactory.newURL(string, string2, string3, n, string4, string5, string6);
    }

    public static URL replaceHostPart(URL uRL, String string) {
        String string2 = uRL.getProtocol();
        String string3 = uRL.getUserInfo();
        int n = uRL.getPort();
        String string4 = uRL.getPath();
        String string5 = uRL.getQuery();
        String string6 = uRL.getRef();
        return URLFactory.newURL(string2, string3, string, n, string4, string5, string6);
    }

    public static URL replacePathPart(URL uRL, String string) {
        String string2 = uRL.getProtocol();
        String string3 = uRL.getUserInfo();
        String string4 = uRL.getHost();
        int n = uRL.getPort();
        String string5 = uRL.getQuery();
        String string6 = uRL.getRef();
        return URLFactory.newURL(string2, string3, string4, n, string, string5, string6);
    }

    public static URL replaceRefPart(URL uRL, String string) {
        String string2 = uRL.getProtocol();
        String string3 = uRL.getUserInfo();
        String string4 = uRL.getHost();
        int n = uRL.getPort();
        String string5 = uRL.getPath();
        String string6 = uRL.getQuery();
        return URLFactory.newURL(string2, string3, string4, n, string5, string6, string);
    }

    public static URL replaceQueryPart(URL uRL, String string) {
        String string2 = uRL.getProtocol();
        String string3 = uRL.getUserInfo();
        String string4 = uRL.getHost();
        int n = uRL.getPort();
        String string5 = uRL.getPath();
        String string6 = uRL.getRef();
        return URLFactory.newURL(string2, string3, string4, n, string5, string, string6);
    }

    public static URL encodeURL(URL uRL) {
        return URLFactory.encodeURL(uRL, null);
    }

    public static URL encodeURL(URL uRL, String string) {
        URL uRL2 = URLFactory.newURL(uRL.getProtocol(), URLFactory.encodeStr(uRL.getUserInfo(), string), uRL.getHost(), uRL.getPort(), URLFactory.encodeStr(uRL.getPath(), string), URLFactory.encodeQuery(uRL.getQuery(), string), URLFactory.encodeStr(uRL.getRef(), string));
        return uRL2;
    }

    private static String encodeStr(String string, String string2) {
        if (string == null || string.length() == 0) {
            return string;
        }
        try {
            String string3 = EncoderUtils.encodeString((String)string, (String)string2);
            return string3;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String string4 = string;
            return string4;
        }
    }

    private static String encodeStr(String string) {
        return URLFactory.encodeStr(string, null);
    }

    private static String encodeQuery(String string) {
        return URLFactory.encodeQuery(string, null);
    }

    private static String encodeQuery(String string, String string2) {
        if (string == null || string.length() == 0) {
            return string;
        }
        StringWriter stringWriter = new StringWriter(string.length());
        try {
            EncoderUtils.writeQueryParameters((Writer)stringWriter, (String)string, (String)string2, (int)0);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String string3 = string;
            return string3;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringWriter.toString();
    }

    public static URL newURL(String string) {
        return URLFactory.newURL(string, false, false);
    }

    static URL newURL(String string, boolean bl, boolean bl2) {
        int n;
        if (string == null) {
            return null;
        }
        if (bl && !string.endsWith("/")) {
            string = string + "/";
        }
        if ((n = string.length()) > 0 && (string.charAt(0) == File.separatorChar || n > 1 && string.charAt(1) == ':' || string.indexOf(58) < 0 && bl2)) {
            return URLFactory.newFileURL(string);
        }
        if (string.toLowerCase().startsWith("file:")) {
            return URLFactory.newFileURL(string.substring(5));
        }
        try {
            URL uRL = new URL(string);
            return uRL;
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static URL newFileURL(String string) {
        if (string == null) {
            return null;
        }
        String string2 = URLFactory.sanitizePath(string);
        return URLFactory.newURL("file", string2);
    }

    public static URL newFileURL(File file) {
        if (file == null) {
            return null;
        }
        String string = file.getAbsolutePath();
        if (file.isDirectory()) {
            return URLFactory.newDirURL(string);
        }
        return URLFactory.newFileURL(string);
    }

    public static URL newDirURL(String string) {
        if (string == null) {
            return null;
        }
        String string2 = URLFactory.sanitizePath(string);
        if (!string2.endsWith("/")) {
            string2 = string2 + "/";
        }
        return URLFactory.newURL("file", string2);
    }

    public static URL newDirURL(File file) {
        return file != null ? URLFactory.newDirURL(file.getAbsolutePath()) : null;
    }

    public static URL newIdeURL(String string, URL uRL) {
        if (string == null || uRL == null) {
            return null;
        }
        if (!ProtocolConstants.isIdeProtocol(string)) {
            return null;
        }
        String string2 = string + "." + uRL.getProtocol();
        return URLFactory.replaceProtocolPart(uRL, string2);
    }

    public static URL newJarURL(File file, String string) {
        URL uRL = URLFactory.newFileURL(file);
        return URLFactory.newJarURL(uRL, string);
    }

    public static URL newJarURL(URL uRL, String string) {
        if (JarUtil.isJarURL(uRL)) {
            String string2 = uRL.getPath();
            int n = string2.indexOf("!/");
            if (n < 0) {
                throw new IllegalArgumentException("Bad jar url: " + uRL);
            }
            StringBuffer stringBuffer = new StringBuffer(string2);
            if (!string2.endsWith("/")) {
                stringBuffer.append('/');
            }
            if (string != null) {
                stringBuffer.append(string);
            }
            return URLFactory.replacePathPart(uRL, stringBuffer.toString());
        }
        StringBuffer stringBuffer = new StringBuffer(uRL.toString());
        stringBuffer.append("!/");
        if (string != null) {
            stringBuffer.append(string);
        }
        return URLFactory.newURL("jar", stringBuffer.toString());
    }

    public static URL newURL(String string, String string2, String string3, int n, String string4, String string5, String string6) {
        try {
            URL uRL = new URL(string, "", -1, "");
            string3 = string3 == null ? "" : string3;
            string4 = string4 == null ? "" : string4;
            String string7 = n < 0 ? string3 : string3 + ":" + n;
            Object[] objectArray = new Object[]{string, string3, new Integer(n), string7, string2, string4, string5, string6};
            urlSet.invoke((Object)uRL, objectArray);
            URL uRL2 = uRL;
            return uRL2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            URL uRL = null;
            return uRL;
        }
    }

    private static URL newDirURL(String string, String string2, String string3, int n, String string4, String string5, String string6) {
        return URLFactory.newURL(string, string2, string3, n, string4.endsWith("/") ? string4 : string4 + "/", string5, string6);
    }

    private static String sanitizePath(String string) {
        if (File.separatorChar != '/') {
            string = string.replace(File.separatorChar, '/');
        }
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        return string;
    }

    static String resolveRelative(ArrayList arrayList, String string, StringBuffer stringBuffer) {
        int n;
        boolean bl = false;
        int n2 = 0;
        while (true) {
            String string2;
            int n3;
            boolean bl2 = (n3 = string.indexOf(47, n2)) == -1;
            String string3 = string2 = bl2 ? string.substring(n2) : string.substring(n2, n3);
            if (string2.length() > 0) {
                if (string2.equals("..")) {
                    int n4 = arrayList.size();
                    if (n4 > 0) {
                        arrayList.remove(n4 - 1);
                    }
                    bl = true;
                } else if (string2.equals(".")) {
                    bl = true;
                } else {
                    arrayList.add(string2);
                    bl = false;
                }
            }
            if (bl2) break;
            n2 = n3 + 1;
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next().toString()).append('/');
        }
        if (!bl && !string.endsWith("/") && string.length() != 0 && (n = stringBuffer.length()) > 0) {
            stringBuffer.setLength(n - 1);
        }
        return stringBuffer.toString();
    }

    private static String resolveRelative(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (true) {
            String string3;
            int n2;
            boolean bl = (n2 = string.indexOf(47, n)) == -1;
            String string4 = string3 = bl ? string.substring(n) : string.substring(n, n2);
            if (string3.length() > 0 || n2 == n + 1) {
                arrayList.add(string3);
            }
            if (bl) break;
            n = n2 + 1;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (string.startsWith("//")) {
            stringBuffer.append("//");
        } else if (string.startsWith("/")) {
            stringBuffer.append('/');
        }
        return URLFactory.resolveRelative(arrayList, string2, stringBuffer);
    }

    private URLFactory() {
    }

    static {
        Class<String> clazz = String.class;
        try {
            urlSet = URL.class.getDeclaredMethod("set", clazz, clazz, Integer.TYPE, clazz, clazz, clazz, clazz, clazz);
            urlSet.setAccessible(true);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalStateException();
        }
    }
}

