/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.net;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import oracle.ide.net.FileURLFileSystemHelper;
import oracle.ide.net.HttpURLFileSystemHelper;
import oracle.ide.net.IdeDisplayURLFileSystemHelper;
import oracle.ide.net.IdeURLFileSystemHelper;
import oracle.ide.net.JarURLFileSystemHelper;
import oracle.ide.net.ProtocolConstants;
import oracle.ide.net.URLExistsTest;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystemEvent;
import oracle.ide.net.URLFileSystemHelper;
import oracle.ide.net.URLFileSystemListener;
import oracle.ide.net.URLFilter;
import oracle.ide.net.VirtualFileSystemHelper;

public final class URLFileSystem {
    private static final HashMap _helpers = new HashMap();
    private static final URLFileSystemHelper _defaultHelper = new URLFileSystemHelper();
    private static final ArrayList _existsTests = new ArrayList(3);
    private static final boolean _isCaseSensitive;
    private static Map _rootURLToListenerMap;
    private static final Object VFS_COOKIE;
    private static boolean TRACE_DANGLING_STREAMS;

    static {
        URLFileSystem.registerHelper("file", new VirtualFileSystemHelper(new FileURLFileSystemHelper()));
        URLFileSystem.registerHelper("jar", new JarURLFileSystemHelper());
        URLFileSystem.registerHelper("http", new HttpURLFileSystemHelper());
        URLFileSystem.registerHelper("https", new HttpURLFileSystemHelper());
        URLFileSystem.registerHelper("ide.text", new IdeURLFileSystemHelper());
        URLFileSystem.registerHelper("ide.display", new IdeDisplayURLFileSystemHelper());
        File file = new File("A");
        File file2 = new File("a");
        _isCaseSensitive = file.equals(file2) ^ true;
        _rootURLToListenerMap = new HashMap(500);
        VFS_COOKIE = new String[]{"URLFileSystem.VFSCookie"};
        TRACE_DANGLING_STREAMS = false;
        1 var2_2 = new 1();
    }

    private URLFileSystem() {
    }

    public static void registerHelper(String string, URLFileSystemHelper uRLFileSystemHelper) {
        if (string != null && string.length() > 0 && uRLFileSystemHelper != null) {
            _helpers.put(string, uRLFileSystemHelper);
            if (ProtocolConstants.isIdeProtocol(string)) {
                ProtocolConstants.addIdeProtocol(string);
            }
        }
    }

    public static URLFileSystemHelper findHelper(String string) {
        Object v = _helpers.get(string);
        if (v == null && ProtocolConstants.isIdeProtocol(string)) {
            int n = string.lastIndexOf(".");
            while (n > 0) {
                String string2 = string.substring(0, n);
                v = _helpers.get(string2);
                if (v != null) break;
                string = string2;
                n = string.lastIndexOf(".");
            }
        }
        return v != null ? (URLFileSystemHelper)v : _defaultHelper;
    }

    public static URLFileSystemHelper findHelper(URL uRL) {
        if (uRL == null) {
            return _defaultHelper;
        }
        String string = uRL.getProtocol();
        return URLFileSystem.findHelper(string);
    }

    public static void addExistsTest(URLExistsTest uRLExistsTest) {
        if (uRLExistsTest != null) {
            _existsTests.add(uRLExistsTest);
        }
    }

    public static URL canonicalize(URL uRL) {
        return URLFileSystem.findHelper(uRL).canonicalize(uRL);
    }

    public static boolean canRead(URL uRL) {
        return URLFileSystem.findHelper(uRL).canRead(uRL);
    }

    public static boolean canWrite(URL uRL) {
        return URLFileSystem.findHelper(uRL).canWrite(uRL);
    }

    public static boolean canCreate(URL uRL) {
        return URLFileSystem.findHelper(uRL).canCreate(uRL);
    }

    public static boolean canDelete(URL uRL) {
        return URLFileSystem.findHelper(uRL).canDelete(uRL);
    }

    public static boolean isValid(URL uRL) {
        return URLFileSystem.findHelper(uRL).isValid(uRL);
    }

    public static URL convertSuffix(URL uRL, String string, String string2) {
        return URLFileSystem.findHelper(uRL).convertSuffix(uRL, string, string2);
    }

    public static void copy(URL uRL, URL uRL2) throws IOException {
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            inputStream = URLFileSystem.openInputStream(uRL);
            outputStream = URLFileSystem.openOutputStream(uRL2);
            if (!URLFileSystem.mkdirs(URLFileSystem.getParent(uRL2))) {
                throw new IOException();
            }
            URLFileSystem.copy(inputStream, outputStream);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static void copy(InputStream inputStream, URL uRL) throws IOException {
        OutputStream outputStream = null;
        try {
            outputStream = URLFileSystem.openOutputStream(uRL);
            URLFileSystem.mkdirs(URLFileSystem.getParent(uRL));
            URLFileSystem.copy(inputStream, outputStream);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static void copy(URL uRL, File file) throws IOException {
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            inputStream = URLFileSystem.openInputStream(uRL);
            File file2 = file.getParentFile();
            if (file2 != null) {
                file2.mkdirs();
            }
            outputStream = new FileOutputStream(file);
            URLFileSystem.copy(inputStream, outputStream);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[4096];
        while ((n = inputStream.read(byArray)) >= 0) {
            outputStream.write(byArray, 0, n);
        }
    }

    public static boolean delete(URL uRL) {
        try {
            URLFileSystem.deleteEx(uRL);
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            boolean bl = false;
            return bl;
        }
    }

    public static void deleteEx(URL uRL) throws IOException {
        URLFileSystemHelper uRLFileSystemHelper = URLFileSystem.findHelper(uRL);
        URL uRL2 = URLFileSystem.getTrackedRootURL(uRL);
        boolean bl = uRL2 != null;
        boolean bl2 = bl && uRLFileSystemHelper.isRegularFile(uRL);
        boolean bl3 = bl && !bl2 && uRLFileSystemHelper.isDirectory(uRL);
        uRLFileSystemHelper.delete(uRL);
        if (bl2 || bl3) {
            int n = bl2 ? 3 : 11;
            URLFileSystem.fireURLFileSystemEvent(uRL, n);
        }
    }

    public static URL ensureSuffix(URL uRL, String string) {
        return URLFileSystem.findHelper(uRL).ensureSuffix(uRL, string);
    }

    public static boolean equals(URL uRL, URL uRL2) {
        if (uRL == uRL2) {
            return true;
        }
        if (!URLFileSystem.protocolsAreEqual(uRL, uRL2)) {
            return false;
        }
        return URLFileSystem.findHelper(uRL).equals(uRL, uRL2);
    }

    public static boolean exists(URL uRL) {
        return URLFileSystem.findHelper(uRL).exists(uRL);
    }

    public static Icon getDefaultIcon(URL uRL) {
        return URLFileSystem.findHelper(uRL).getDefaultIcon(uRL);
    }

    public static String getFileName(URL uRL) {
        return URLFileSystem.findHelper(uRL).getFileName(uRL);
    }

    public static long getLength(URL uRL) {
        return URLFileSystem.findHelper(uRL).getLength(uRL);
    }

    public static String getName(URL uRL) {
        return URLFileSystem.findHelper(uRL).getName(uRL);
    }

    public static URL getParent(URL uRL) {
        return URLFileSystem.findHelper(uRL).getParent(uRL);
    }

    public static String getPath(URL uRL) {
        return URLFileSystem.findHelper(uRL).getPath(uRL);
    }

    public static String getPathNoExt(URL uRL) {
        return URLFileSystem.findHelper(uRL).getPathNoExt(uRL);
    }

    public static String getPlatformPathName(URL uRL) {
        return URLFileSystem.findHelper(uRL).getPlatformPathName(uRL);
    }

    public static String getSuffix(URL uRL) {
        return URLFileSystem.findHelper(uRL).getSuffix(uRL);
    }

    public static String getSystemDisplayName(URL uRL) {
        return URLFileSystem.findHelper(uRL).getSystemDisplayName(uRL);
    }

    public static Icon getSystemIcon(URL uRL) {
        return URLFileSystem.findHelper(uRL).getSystemIcon(uRL);
    }

    public static boolean hasSuffix(URL uRL, String string) {
        return URLFileSystem.findHelper(uRL).hasSuffix(uRL, string);
    }

    public static boolean hasSuffix(URL uRL, String[] stringArray) {
        URLFileSystemHelper uRLFileSystemHelper = URLFileSystem.findHelper(uRL);
        int n = 0;
        while (n < stringArray.length) {
            if (uRLFileSystemHelper.hasSuffix(uRL, stringArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static boolean isBaseURLFor(URL uRL, URL uRL2) {
        if (uRL == null || uRL2 == null) {
            return false;
        }
        if (uRL == uRL2) {
            return true;
        }
        if (!URLFileSystem.protocolsAreEqual(uRL, uRL2)) {
            return false;
        }
        return URLFileSystem.findHelper(uRL).isBaseURLFor(uRL, uRL2);
    }

    public static boolean isBound(URL uRL) {
        for (URLExistsTest uRLExistsTest : _existsTests) {
            if (!uRLExistsTest.urlExists(uRL)) continue;
            return true;
        }
        return URLFileSystem.exists(uRL);
    }

    public static boolean isLocalFileSystemCaseSensitive() {
        return _isCaseSensitive;
    }

    public static boolean isDirectory(URL uRL) {
        return URLFileSystem.findHelper(uRL).isDirectory(uRL);
    }

    public static boolean isDirectoryPath(URL uRL) {
        return URLFileSystem.findHelper(uRL).isDirectoryPath(uRL);
    }

    public static boolean isHidden(URL uRL) {
        return URLFileSystem.findHelper(uRL).isHidden(uRL);
    }

    public static boolean isReadOnly(URL uRL) {
        return URLFileSystem.findHelper(uRL).isReadOnly(uRL);
    }

    public static boolean isRegularFile(URL uRL) {
        return URLFileSystem.findHelper(uRL).isRegularFile(uRL);
    }

    public static boolean isRoot(URL uRL) {
        if (uRL == null) {
            return false;
        }
        URL[] uRLArray = URLFileSystem.listRoots();
        int n = uRLArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (URLFileSystem.equals(uRL, uRLArray[n2])) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static URL[] listRoots() {
        ArrayList<URL> arrayList = new ArrayList<URL>(40);
        ArrayList arrayList2 = new ArrayList(_helpers.keySet());
        Collections.sort(arrayList2);
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            URLFileSystemHelper uRLFileSystemHelper = (URLFileSystemHelper)_helpers.get(string);
            URL[] uRLArray = uRLFileSystemHelper.listRoots();
            if (uRLArray == null) continue;
            arrayList.addAll(Arrays.asList(uRLArray));
        }
        return arrayList.toArray(new URL[arrayList.size()]);
    }

    public static long lastModified(URL uRL) {
        return URLFileSystem.findHelper(uRL).lastModified(uRL);
    }

    public static URL[] list(URL uRL) {
        uRL = URLFileSystem.assertIsDirURL(uRL);
        return URLFileSystem.findHelper(uRL).list(uRL);
    }

    public static URL[] list(URL uRL, URLFilter uRLFilter) {
        uRL = URLFileSystem.assertIsDirURL(uRL);
        return URLFileSystem.findHelper(uRL).list(uRL, uRLFilter);
    }

    public static FileInfo[] ls(URL uRL) {
        uRL = URLFileSystem.assertIsDirURL(uRL);
        return URLFileSystem.findHelper(uRL).ls(uRL);
    }

    public static FileInfo[] ls(URL uRL, URLFilter uRLFilter) {
        uRL = URLFileSystem.assertIsDirURL(uRL);
        return URLFileSystem.findHelper(uRL).ls(uRL, uRLFilter);
    }

    public static FileInfo[] lsCached(URL uRL) {
        uRL = URLFileSystem.assertIsDirURL(uRL);
        return URLFileSystem.findHelper(uRL).lsCached(uRL);
    }

    public static FileInfo[] lsCached(URL uRL, URLFilter uRLFilter) {
        uRL = URLFileSystem.assertIsDirURL(uRL);
        return URLFileSystem.findHelper(uRL).lsCached(uRL, uRLFilter);
    }

    public static boolean mkdir(URL uRL) {
        URLFileSystemHelper uRLFileSystemHelper = URLFileSystem.findHelper(uRL = URLFileSystem.assertIsDirURL(uRL));
        boolean bl = uRLFileSystemHelper.mkdir(uRL);
        if (bl) {
            URLFileSystem.fireURLFileSystemEvent(uRL, 10);
        }
        return bl;
    }

    public static boolean mkdirs(URL uRL) {
        uRL = URLFileSystem.assertIsDirURL(uRL);
        URLFileSystemHelper uRLFileSystemHelper = URLFileSystem.findHelper(uRL);
        URL uRL2 = URLFileSystem.getTrackedRootURL(uRL);
        List list = URLFileSystem.getNonExistentParents(uRL2, uRL);
        boolean bl = uRLFileSystemHelper.mkdirs(uRL);
        URLFileSystem.notifyExistentParents(uRL2, list);
        if (bl) {
            URLFileSystem.fireURLFileSystemEvent(uRL, 10);
        }
        return bl;
    }

    public static URL createTempFile(String string, String string2, URL uRL) throws IOException {
        return uRL != null ? URLFileSystem.findHelper(uRL).createTempFile(string, string2, uRL) : URLFileSystem.findHelper("file").createTempFile(string, string2, null);
    }

    public static InputStream openInputStream(URL uRL) throws IOException {
        return URLFileSystem.findHelper(uRL).openInputStream(uRL);
    }

    public static OutputStream openOutputStream(URL uRL) throws IOException {
        URLFileSystemHelper uRLFileSystemHelper = URLFileSystem.findHelper(uRL);
        URL uRL2 = URLFileSystem.getTrackedRootURL(uRL);
        List list = URLFileSystem.getNonExistentParents(uRL2, uRL);
        boolean bl = uRL2 != null;
        boolean bl2 = bl && uRLFileSystemHelper.isRegularFile(uRL);
        try {
            OutputStream outputStream = uRLFileSystemHelper.openOutputStream(uRL);
            if (bl) {
                if (outputStream != null) {
                    2 var7_7 = new 2(bl2, uRL2, list, uRL);
                    outputStream = new TrackedOutputStream(var7_7, outputStream);
                } else {
                    URLFileSystem.notifyExistentParents(uRL2, list);
                }
            }
            OutputStream outputStream2 = outputStream;
            return outputStream2;
        }
        catch (IOException iOException) {
            URLFileSystem.notifyExistentParents(uRL2, list);
            throw iOException;
        }
    }

    public static boolean renameTo(URL uRL, URL uRL2) {
        try {
            URLFileSystem.renameEx(uRL, uRL2);
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            boolean bl = false;
            return bl;
        }
    }

    public static void renameEx(URL uRL, URL uRL2) throws IOException {
        if (uRL == null || uRL2 == null) {
            throw new IOException("URLFileSystem.renameEx: Null URL parameter");
        }
        if (uRL == uRL2 || uRL.equals(uRL2)) {
            throw new IOException("URLFileSystem.renameEx: URL parameters are equal");
        }
        if (!URLFileSystem.protocolsAreEqual(uRL, uRL2)) {
            URLFileSystem.copy(uRL, uRL2);
            URLFileSystem.deleteEx(uRL);
        }
        URLFileSystemHelper uRLFileSystemHelper = URLFileSystem.findHelper(uRL);
        URL uRL3 = URLFileSystem.getTrackedRootURL(uRL);
        URL uRL4 = URLFileSystem.getTrackedRootURL(uRL2);
        boolean bl = uRL3 != null;
        boolean bl2 = uRL4 != null;
        boolean bl3 = bl && uRLFileSystemHelper.isRegularFile(uRL);
        boolean bl4 = bl && !bl3 && uRLFileSystemHelper.isDirectory(uRL);
        List list = URLFileSystem.getNonExistentParents(uRL4, uRL2);
        boolean bl5 = false;
        try {
            uRLFileSystemHelper.rename(uRL, uRL2);
            bl5 = true;
        }
        catch (Throwable throwable) {
            try {
                if (bl || bl2) {
                    URLFileSystem.notifyExistentParents(uRL4, list);
                    if (bl5 && (bl3 || bl4)) {
                        int n = bl3 ? 4 : 12;
                        URLFileSystem.fireRenameURLFileSystemEvent(uRL2, uRL, n);
                    }
                }
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable2) {
                throwable2.printStackTrace();
            }
            throw throwable;
        }
        try {
            if (bl || bl2) {
                URLFileSystem.notifyExistentParents(uRL4, list);
                if (bl5 && (bl3 || bl4)) {
                    int n = bl3 ? 4 : 12;
                    URLFileSystem.fireRenameURLFileSystemEvent(uRL2, uRL, n);
                }
            }
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static boolean setLastModified(URL uRL, long l) {
        URLFileSystemHelper uRLFileSystemHelper = URLFileSystem.findHelper(uRL);
        URL uRL2 = URLFileSystem.getTrackedRootURL(uRL);
        boolean bl = uRL2 != null && uRLFileSystemHelper.isRegularFile(uRL);
        long l2 = bl ? URLFileSystem.lastModified(uRL) : 0L;
        boolean bl2 = uRLFileSystemHelper.setLastModified(uRL, l);
        if (bl2 && bl && l2 != l) {
            URLFileSystem.fireURLFileSystemEvent(uRL, 2);
        }
        return bl2;
    }

    public static boolean setReadOnly(URL uRL, boolean bl) {
        return URLFileSystem.findHelper(uRL).setReadOnly(uRL, bl);
    }

    public static String toDisplayString(URL uRL) {
        return URLFileSystem.findHelper(uRL).toDisplayString(uRL);
    }

    public static String toEncodedString(URL uRL) {
        return URLFileSystem.findHelper(uRL).toEncodedString(uRL, null);
    }

    public static String toEncodedString(URL uRL, String string) {
        return URLFileSystem.findHelper(uRL).toEncodedString(uRL, string);
    }

    public static String toRelativeSpec(URL uRL, URL uRL2) {
        return URLFileSystem.findHelper(uRL).toRelativeSpec(uRL, uRL2);
    }

    public static String toRelativeSpec(URL uRL, URL uRL2, boolean bl) {
        return URLFileSystem.findHelper(uRL).toRelativeSpec(uRL, uRL2, bl);
    }

    public static URL getBaseParent(URL uRL, String string) {
        return URLFileSystem.findHelper(uRL).getBaseParent(uRL, string);
    }

    public static Reader createReader(URL uRL, String string) throws IOException {
        return URLFileSystem.findHelper(uRL).createReader(uRL, string);
    }

    private static boolean protocolsAreEqual(URL uRL, URL uRL2) {
        if (uRL == null || uRL2 == null) {
            return false;
        }
        String string = uRL.getProtocol();
        String string2 = uRL2.getProtocol();
        return string.equals(string2);
    }

    protected static void fireURLFileSystemEvent(URL uRL, int n) {
        if (uRL == null) {
            return;
        }
        List list = URLFileSystem.getTrackedRootURLs(uRL);
        URLFileSystem.fireURLFileSystemEvent(list, uRL, null, n);
    }

    protected static void fireRenameURLFileSystemEvent(URL uRL, URL uRL2, int n) {
        if (uRL == null || uRL2 == null) {
            return;
        }
        List list = URLFileSystem.getTrackedRootURLs(uRL2);
        List list2 = URLFileSystem.getTrackedRootURLs(uRL);
        HashSet hashSet = new HashSet(list.size() + list2.size());
        hashSet.addAll(list);
        hashSet.addAll(list2);
        ArrayList arrayList = new ArrayList(hashSet);
        URLFileSystem.fireURLFileSystemEvent(arrayList, uRL, uRL2, n);
    }

    private static void fireURLFileSystemEvent(List list, URL uRL, URL uRL2, int n) {
        if (uRL == null || list == null || list.size() == 0) {
            return;
        }
        if (!URLFileSystemEvent.isValidEventType(n)) {
            return;
        }
        Map map = URLFileSystem.getListenersAndTrackedRootURLs(list);
        for (URLFileSystemListener uRLFileSystemListener : map.keySet()) {
            List list2 = (List)map.get(uRLFileSystemListener);
            URL[] uRLArray = list2.toArray(new URL[list2.size()]);
            URLFileSystemEvent uRLFileSystemEvent = new URLFileSystemEvent(uRLArray, uRL, uRL2, n);
            try {
                uRLFileSystemListener.notifyEvent(uRLFileSystemEvent);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static URL getTrackedRootURL(URL uRL) {
        if (uRL == null) {
            return null;
        }
        Map map = _rootURLToListenerMap;
        synchronized (map) {
            for (URL uRL2 : _rootURLToListenerMap.keySet()) {
                if (uRL2 == null || !URLFileSystem.isBaseURLFor(uRL2, uRL)) continue;
                URL uRL3 = uRL2;
                return uRL3;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Map getListenersAndTrackedRootURLs(List list) {
        int n;
        int n2 = n = list == null ? 0 : list.size();
        if (n == 0) {
            return null;
        }
        HashMap hashMap = new HashMap();
        Map map = _rootURLToListenerMap;
        synchronized (map) {
            int n3 = 0;
            while (n3 < n) {
                URL uRL = (URL)list.get(n3);
                List list2 = (List)_rootURLToListenerMap.get(uRL);
                if (list2 != null) {
                    for (Object e : list2) {
                        ArrayList<URL> arrayList = (ArrayList<URL>)hashMap.get(e);
                        if (arrayList == null) {
                            arrayList = new ArrayList<URL>();
                            hashMap.put(e, arrayList);
                        }
                        arrayList.add(uRL);
                    }
                }
                ++n3;
            }
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static List getTrackedRootURLs(URL uRL) {
        if (uRL == null) {
            return null;
        }
        ArrayList<URL> arrayList = new ArrayList<URL>();
        Map map = _rootURLToListenerMap;
        synchronized (map) {
            for (URL uRL2 : _rootURLToListenerMap.keySet()) {
                if (uRL2 == null || !URLFileSystem.isBaseURLFor(uRL2, uRL)) continue;
                arrayList.add(uRL2);
            }
        }
        return arrayList;
    }

    protected static List getNonExistentParents(URL uRL, URL uRL2) {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        if (uRL != null) {
            URL uRL3;
            URL uRL4 = uRL2;
            while (!URLFileSystem.equals(uRL4, uRL) && (uRL3 = URLFileSystem.getParent(uRL4)) != null && !URLFileSystem.isDirectory(uRL3)) {
                arrayList.add(uRL3);
                uRL4 = uRL3;
            }
        }
        return arrayList;
    }

    protected static void notifyExistentParents(URL uRL, List list) {
        if (uRL != null && list != null) {
            int n = list.size();
            int n2 = n - 1;
            while (n2 >= 0) {
                URL uRL2 = (URL)list.get(n2);
                URLFileSystem.fireURLFileSystemEvent(uRL2, 10);
                --n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addURLFileSystemListener(URL uRL, URLFileSystemListener uRLFileSystemListener) {
        if (uRL == null || uRLFileSystemListener == null) {
            return;
        }
        Object object = VFS_COOKIE;
        synchronized (object) {
            Map map = _rootURLToListenerMap;
            synchronized (map) {
                ArrayList<URLFileSystemListener> arrayList = (ArrayList<URLFileSystemListener>)_rootURLToListenerMap.get(uRL);
                if (arrayList == null) {
                    arrayList = new ArrayList<URLFileSystemListener>(20);
                    _rootURLToListenerMap.put(uRL, arrayList);
                }
                if (!arrayList.contains(uRLFileSystemListener)) {
                    arrayList.add(uRLFileSystemListener);
                }
            }
            VirtualFileSystemHelper.cacheDirectoryTree(uRL, uRLFileSystemListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeURLFileSystemListener(URL uRL, URLFileSystemListener uRLFileSystemListener) {
        if (uRL == null || uRLFileSystemListener == null) {
            return;
        }
        Object object = VFS_COOKIE;
        synchronized (object) {
            Map map = _rootURLToListenerMap;
            synchronized (map) {
                List list = (List)_rootURLToListenerMap.get(uRL);
                if (list != null && list.contains(uRLFileSystemListener)) {
                    list.remove(uRLFileSystemListener);
                    if (list.size() == 0) {
                        _rootURLToListenerMap.remove(uRL);
                    }
                }
            }
            VirtualFileSystemHelper.uncacheDirectoryTree(uRL, uRLFileSystemListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection getURLsForListener(URLFileSystemListener uRLFileSystemListener) {
        if (uRLFileSystemListener == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<URL> arrayList = new ArrayList<URL>();
        Map map = _rootURLToListenerMap;
        synchronized (map) {
            for (URL uRL : _rootURLToListenerMap.keySet()) {
                List list;
                if (uRL == null || (list = (List)_rootURLToListenerMap.get(uRL)) == null || !list.contains(uRLFileSystemListener)) continue;
                arrayList.add(uRL);
            }
        }
        return arrayList;
    }

    private static URL assertIsDirURL(URL uRL) {
        String string;
        if (uRL != null && (string = uRL.getPath()) != null && string.length() > 0 && string.charAt(string.length() - 1) != '/') {
            new IllegalArgumentException("A non-directory URL was passed to an URLFileSystem method that requires a directory URL.  You must use URLFactory.newDirURL(..) instead of newURL(..) to create directory URLs: " + string).printStackTrace();
            return URLFactory.replacePathPart(uRL, string + "/");
        }
        return uRL;
    }

    static void wa$TRACE_DANGLING_STREAMS(boolean bl) {
        TRACE_DANGLING_STREAMS = bl;
    }

    static boolean ra$TRACE_DANGLING_STREAMS() {
        return TRACE_DANGLING_STREAMS;
    }

    public static final class 2
    implements Runnable {
        private final /* synthetic */ boolean v$existed;
        private final /* synthetic */ URL v$rootURL;
        private final /* synthetic */ List v$intermediateList;
        private final /* synthetic */ URL v$url;

        public void run() {
            int n = this.v$existed ? 2 : 1;
            URLFileSystem.notifyExistentParents(this.v$rootURL, this.v$intermediateList);
            URLFileSystem.fireURLFileSystemEvent(this.v$url, n);
        }

        public 2(boolean bl, URL uRL, List list, URL uRL2) {
            this.v$url = uRL2;
            this.v$intermediateList = list;
            this.v$rootURL = uRL;
            this.v$existed = bl;
        }
    }

    public static class FileInfo {
        protected static final int ATTR_DIRECTORY = 1;
        protected static final int ATTR_REGULAR = 2;
        protected static final int ATTR_HIDDEN = 4;
        protected URL url;
        protected int attributes;
        protected long lastModified;
        protected long length;

        protected FileInfo(URL uRL) {
            this(uRL, (URLFileSystem.isDirectory(uRL) ? 1 : 0) | (URLFileSystem.isRegularFile(uRL) ? 2 : 0) | (URLFileSystem.isHidden(uRL) ? 4 : 0), URLFileSystem.lastModified(uRL), URLFileSystem.getLength(uRL));
        }

        protected FileInfo(File file, String string, int n, long l, long l2) {
            this(new File(file, string), n, l, l2);
        }

        protected FileInfo(String string, String string2, int n, long l, long l2) {
            this(new File(string, string2), n, l, l2);
        }

        protected FileInfo(File file, int n, long l, long l2) {
            this(file.getAbsolutePath(), n, l, l2);
        }

        protected FileInfo(String string, int n, long l, long l2) {
            this((n & 1) != 0 ? URLFactory.newDirURL(string) : URLFactory.newFileURL(string), n, l, l2);
        }

        protected FileInfo(URL uRL, int n, long l, long l2) {
            this.url = uRL;
            this.attributes = n;
            this.lastModified = l;
            this.length = l2;
        }

        public URL getURL() {
            return this.url;
        }

        public boolean isDirectory() {
            return (this.attributes & 1) != 0;
        }

        public boolean isFile() {
            return (this.attributes & 2) != 0;
        }

        public boolean isHidden() {
            return (this.attributes & 4) != 0;
        }

        public long lastModified() {
            return this.lastModified;
        }

        public long length() {
            return this.length;
        }
    }

    public static final class 1
    implements Runnable {
        public void run() {
            URLFileSystem.wa$TRACE_DANGLING_STREAMS(true);
        }
    }

    protected static class TrackedOutputStream
    extends OutputStream {
        private OutputStream _tracked;
        private Runnable _runnable;
        private boolean _closed;
        private Exception _trace;

        void $init$() {
            this._closed = false;
            this._trace = null;
        }

        protected TrackedOutputStream(Runnable runnable, OutputStream outputStream) {
            this.$init$();
            this._runnable = runnable;
            this._tracked = outputStream;
            if (URLFileSystem.ra$TRACE_DANGLING_STREAMS()) {
                this._trace = new RuntimeException("OutputStream allocation point");
            }
        }

        public void write(int n) throws IOException {
            this._tracked.write(n);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this._tracked.write(byArray, n, n2);
        }

        public void flush() throws IOException {
            this._tracked.flush();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            TrackedOutputStream trackedOutputStream = this;
            synchronized (trackedOutputStream) {
                if (!this._closed) {
                    this._closed = true;
                    try {
                        if (this._tracked != null) {
                            this._tracked.close();
                            this._tracked = null;
                        }
                        this._trace = null;
                    }
                    finally {
                        if (this._runnable != null) {
                            this._runnable.run();
                            this._runnable = null;
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            TrackedOutputStream trackedOutputStream = this;
            synchronized (trackedOutputStream) {
                if (this._closed || this._trace != null) {
                    // empty if block
                }
            }
            Thread thread = Thread.currentThread();
            ClassLoader classLoader = thread.getContextClassLoader();
            try {
                thread.setContextClassLoader(ClassLoader.getSystemClassLoader());
                this.close();
            }
            finally {
                thread.setContextClassLoader(classLoader);
            }
        }
    }
}

