/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.net;

import java.net.URL;
import java.util.EventObject;

public class URLFileSystemEvent
extends EventObject {
    public static final int FILE_ADDED = 1;
    public static final int FILE_CHANGED = 2;
    public static final int FILE_REMOVED = 3;
    public static final int FILE_RENAMED = 4;
    public static final int DIRECTORY_ADDED = 10;
    public static final int DIRECTORY_REMOVED = 11;
    public static final int DIRECTORY_RENAMED = 12;
    private URL[] _rootURLs;
    private URL _changeURL;
    private URL _oldURL;
    private int _eventType;

    public static boolean isValidEventType(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    public URL[] getRootURLs() {
        return this._rootURLs;
    }

    public URL getURL() {
        return this._changeURL;
    }

    public URL getNewURL() {
        return this.getURL();
    }

    public URL getOldURL() {
        return this._oldURL;
    }

    public int getEventType() {
        return this._eventType;
    }

    public URLFileSystemEvent(URL[] uRLArray, URL uRL, int n) {
        this(uRLArray, uRL, null, n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public URLFileSystemEvent(URL[] uRLArray, URL uRL, URL uRL2, int n) {
        super(uRLArray);
        this._rootURLs = uRLArray;
        this._changeURL = uRL;
        this._oldURL = uRL2;
        this._eventType = n;
        if (uRL2 == null) {
            if (!URLFileSystemEvent.isRenameEvent(n)) return;
        }
        if (URLFileSystemEvent.isRenameEvent(n)) return;
    }

    private static boolean isRenameEvent(int n) {
        return n == 12 || n == 4;
    }

    protected String getEventTypeString() {
        return URLFileSystemEvent.getEventTypeString(this.getEventType());
    }

    protected static String getEventTypeString(int n) {
        switch (n) {
            case 1: {
                return "FILE_ADDED";
            }
            case 2: {
                return "FILE_CHANGED";
            }
            case 3: {
                return "FILE_REMOVED";
            }
            case 4: {
                return "FILE_RENAMED";
            }
            case 10: {
                return "DIRECTORY_ADDED";
            }
            case 11: {
                return "DIRECTORY_REMOVED";
            }
            case 12: {
                return "DIRECTORY_RENAMED";
            }
        }
        return "UNKNOWN";
    }

    public String toString() {
        URL[] uRLArray = this.getRootURLs();
        StringBuffer stringBuffer = new StringBuffer();
        int n = uRLArray.length;
        String string = "";
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(string);
            string = ", ";
            stringBuffer.append(uRLArray[n2]);
            ++n2;
        }
        if (URLFileSystemEvent.isRenameEvent(this._eventType)) {
            return "roots: " + stringBuffer.toString() + ", old url: " + this.getOldURL() + ", new url: " + this.getNewURL() + ", event: " + this.getEventTypeString();
        }
        return "roots: " + stringBuffer.toString() + ", url: " + this.getURL() + ", event: " + this.getEventTypeString();
    }
}

