/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.Icon;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.resource.IdeIcons;

public class URLFileSystemHelper {
    static final String ICON_KEY_DIRECTORY = "FileView.directoryIcon";
    static final String ICON_KEY_FILE = "FileView.fileIcon";

    protected URLFileSystemHelper() {
    }

    public URL canonicalize(URL uRL) {
        return uRL;
    }

    public boolean canRead(URL uRL) {
        try {
            URLConnection uRLConnection = uRL.openConnection();
            boolean bl = uRLConnection.getDoInput();
            return bl;
        }
        catch (Exception exception) {
            boolean bl = false;
            return bl;
        }
    }

    public boolean canWrite(URL uRL) {
        try {
            URLConnection uRLConnection = uRL.openConnection();
            boolean bl = uRLConnection.getDoOutput();
            return bl;
        }
        catch (Exception exception) {
            boolean bl = false;
            return bl;
        }
    }

    public boolean canCreate(URL uRL) {
        return true;
    }

    public boolean canDelete(URL uRL) {
        return this.exists(uRL) && !this.isReadOnly(uRL);
    }

    public boolean isValid(URL uRL) {
        if (this.exists(uRL)) {
            return true;
        }
        return this.canCreate(uRL);
    }

    public URL convertSuffix(URL uRL, String string, String string2) {
        String string3;
        String string4 = uRL.getPath();
        if (string4.endsWith(string)) {
            int n = string4.length() - string.length();
            string3 = string4.substring(0, n) + string2;
        } else {
            string3 = string4 + string2;
        }
        return URLFactory.replacePathPart(uRL, string3);
    }

    public void delete(URL uRL) throws IOException {
    }

    public URL ensureSuffix(URL uRL, String string) {
        if (this.hasSuffix(uRL, string)) {
            return uRL;
        }
        String string2 = uRL.getPath();
        return URLFactory.replacePathPart(uRL, string2 + string);
    }

    public boolean equals(URL uRL, URL uRL2) {
        return this.haveSameHost(uRL, uRL2) && this.haveSamePort(uRL, uRL2) && this.haveSamePath(uRL, uRL2) && this.haveSameQuery(uRL, uRL2) && this.haveSameRef(uRL, uRL2) && this.haveSameUserInfo(uRL, uRL2);
    }

    public boolean exists(URL uRL) {
        return false;
    }

    public Icon getDefaultIcon(URL uRL) {
        if (URLFileSystem.isDirectoryPath(uRL)) {
            return IdeIcons.getIcon(4);
        }
        return IdeIcons.getIcon(2);
    }

    public String getFileName(URL uRL) {
        if (uRL == null) {
            return "";
        }
        String string = uRL.getPath();
        if (string == null || string.length() == 0) {
            return "";
        }
        if (string.equals("/")) {
            return "/";
        }
        int n = string.lastIndexOf(47);
        if (n == string.length() - 1) {
            int n2 = string.lastIndexOf(47, n - 1);
            return string.substring(n2 + 1, n);
        }
        return string.substring(n + 1);
    }

    public long getLength(URL uRL) {
        try {
            URLConnection uRLConnection = uRL.openConnection();
            long l = uRLConnection.getContentLength();
            return l;
        }
        catch (Exception exception) {
            long l = -1;
            return l;
        }
    }

    public String getName(URL uRL) {
        String string = this.getFileName(uRL);
        int n = string.indexOf(46);
        return n > 0 ? string.substring(0, n) : string;
    }

    public URL getParent(URL uRL) {
        URL uRL2 = URLFactory.newURL(uRL, "..");
        return uRL2 != null && !URLFileSystem.equals(uRL, uRL2) ? uRL2 : null;
    }

    public String getPath(URL uRL) {
        return uRL.getPath();
    }

    public String getPathNoExt(URL uRL) {
        String string = this.getPath(uRL);
        int n = string.lastIndexOf("/");
        int n2 = string.lastIndexOf(".");
        if (n2 <= n) {
            return string;
        }
        return string.substring(0, n2);
    }

    public String getPlatformPathName(URL uRL) {
        return uRL != null ? uRL.toString() : "";
    }

    public String getSuffix(URL uRL) {
        String string = uRL.getPath();
        int n = string.lastIndexOf(46);
        int n2 = string.lastIndexOf(47);
        return n >= 0 && n > n2 ? string.substring(n) : "";
    }

    public String getSystemDisplayName(URL uRL) {
        return URLFileSystem.getFileName(uRL);
    }

    public Icon getSystemIcon(URL uRL) {
        return URLFileSystem.getDefaultIcon(uRL);
    }

    public boolean hasSuffix(URL uRL, String string) {
        String string2 = uRL.getPath();
        return string2.endsWith(string);
    }

    public boolean isBaseURLFor(URL uRL, URL uRL2) {
        if (!this.isDirectoryPath(uRL)) {
            return false;
        }
        String string = uRL.toString();
        String string2 = uRL2.toString();
        return string2.startsWith(string);
    }

    public boolean isDirectory(URL uRL) {
        return false;
    }

    public boolean isDirectoryPath(URL uRL) {
        return uRL != null && uRL.getPath().endsWith("/") && uRL.getQuery() == null && uRL.getRef() == null;
    }

    public boolean isHidden(URL uRL) {
        return false;
    }

    public boolean isReadOnly(URL uRL) {
        return true;
    }

    public boolean isRegularFile(URL uRL) {
        return this.exists(uRL) && !this.isDirectory(uRL);
    }

    public long lastModified(URL uRL) {
        try {
            URLConnection uRLConnection = uRL.openConnection();
            long l = uRLConnection.getLastModified();
            return l;
        }
        catch (Exception exception) {
            long l = -1;
            return l;
        }
    }

    public URL[] list(URL uRL) {
        return new URL[0];
    }

    public URL[] list(URL uRL, URLFilter uRLFilter) {
        URL[] uRLArray = this.list(uRL);
        if (uRLArray == null) {
            return null;
        }
        if (uRLFilter == null) {
            return uRLArray;
        }
        ArrayList<URL> arrayList = new ArrayList<URL>();
        int n = uRLArray.length - 1;
        while (n >= 0) {
            URL uRL2 = uRLArray[n];
            if (uRLFilter.accept(uRL2)) {
                arrayList.add(uRL2);
            }
            --n;
        }
        return arrayList.toArray(new URL[arrayList.size()]);
    }

    public URL[] listRoots() {
        return null;
    }

    public URLFileSystem.FileInfo[] ls(URL uRL) {
        return this.ls(uRL, null);
    }

    public URLFileSystem.FileInfo[] lsCached(URL uRL) {
        return this.lsCached(uRL, null);
    }

    public URLFileSystem.FileInfo[] ls(URL uRL, URLFilter uRLFilter) {
        URL[] uRLArray = URLFileSystem.list(uRL, uRLFilter);
        if (uRLArray == null) {
            return null;
        }
        URLFileSystem.FileInfo[] fileInfoArray = new URLFileSystem.FileInfo[uRLArray.length];
        int n = 0;
        while (n < uRLArray.length) {
            fileInfoArray[n] = new URLFileSystem.FileInfo(uRLArray[n]);
            ++n;
        }
        return fileInfoArray;
    }

    public URLFileSystem.FileInfo[] lsCached(URL uRL, URLFilter uRLFilter) {
        return this.ls(uRL, uRLFilter);
    }

    public boolean mkdir(URL uRL) {
        return false;
    }

    public boolean mkdirs(URL uRL) {
        return false;
    }

    public URL createTempFile(String string, String string2, URL uRL) throws IOException {
        return null;
    }

    public InputStream openInputStream(URL uRL) throws IOException {
        return uRL.openStream();
    }

    public OutputStream openOutputStream(URL uRL) throws IOException {
        return uRL.openConnection().getOutputStream();
    }

    public void rename(URL uRL, URL uRL2) throws IOException {
    }

    public boolean setLastModified(URL uRL, long l) {
        return false;
    }

    public boolean setReadOnly(URL uRL, boolean bl) {
        return false;
    }

    public String toDisplayString(URL uRL) {
        return uRL == null ? "" : uRL.toString();
    }

    public String toEncodedString(URL uRL) {
        return this.toEncodedString(uRL, null);
    }

    public String toEncodedString(URL uRL, String string) {
        URL uRL2 = URLFactory.encodeURL(uRL, string);
        return uRL2 != null ? uRL2.toString() : "";
    }

    public String toRelativeSpec(URL uRL, URL uRL2) {
        return this.toRelativeSpec(uRL, uRL2, false);
    }

    public String toRelativeSpec(URL uRL, URL uRL2, boolean bl) {
        if (!this.haveSameProtocol(uRL, uRL2) || !this.haveSameAuthority(uRL, uRL2)) {
            return bl ? null : uRL.toString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = this.appendRelativePath(uRL, uRL2, stringBuffer, bl);
        if (bl && !bl2) {
            return null;
        }
        return stringBuffer.toString();
    }

    public URL getBaseParent(URL uRL, String string) {
        String string2 = uRL.getPath();
        int n = string2.lastIndexOf(47);
        if (n < string2.length() - 1) {
            uRL = this.getParent(uRL);
            string2 = uRL.getPath();
        }
        String string3 = string2.substring(0, n);
        int n2 = string.lastIndexOf(47);
        if (n2 < 0) {
            return uRL;
        }
        String string4 = string.substring(0, string.lastIndexOf(47));
        StringTokenizer stringTokenizer = new StringTokenizer(string4, "/");
        String string5 = stringTokenizer.nextToken();
        StringTokenizer stringTokenizer2 = new StringTokenizer(string3, "/");
        int n3 = stringTokenizer2.countTokens();
        int n4 = 0;
        boolean bl = false;
        while (stringTokenizer2.hasMoreTokens()) {
            String string6 = stringTokenizer2.nextToken();
            if (this.areEqualPathElems(string5, string6)) {
                int n5;
                int n6 = stringTokenizer2.countTokens();
                if (n6 != (n5 = stringTokenizer.countTokens())) continue;
                if (n5 != 0) {
                    string5 = stringTokenizer.nextToken();
                    ++n4;
                    continue;
                }
                bl = true;
                break;
            }
            if (n4 == 0) continue;
            n4 = 0;
            break;
        }
        if (bl) {
            int n7 = n4;
            while (n7 >= 0) {
                uRL = this.getParent(uRL);
                --n7;
            }
        }
        return uRL;
    }

    public Reader createReader(URL uRL, String string) throws IOException {
        InputStream inputStream = null;
        InputStreamReader inputStreamReader = null;
        try {
            inputStream = URLFileSystem.openInputStream(uRL);
            inputStreamReader = new InputStreamReader(inputStream, string);
        }
        finally {
            if (inputStreamReader == null && inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return inputStreamReader;
    }

    protected boolean haveSameUserInfo(URL uRL, URL uRL2) {
        return this.areEqual(uRL.getUserInfo(), uRL2.getUserInfo());
    }

    protected boolean haveSameHost(URL uRL, URL uRL2) {
        return this.areEqual(uRL.getHost(), uRL2.getHost());
    }

    protected boolean haveSamePath(URL uRL, URL uRL2) {
        return this.areEqual(uRL.getPath(), uRL2.getPath());
    }

    protected boolean haveSameQuery(URL uRL, URL uRL2) {
        return this.areEqual(uRL.getQuery(), uRL2.getQuery());
    }

    protected boolean haveSameRef(URL uRL, URL uRL2) {
        return this.areEqual(uRL.getRef(), uRL2.getRef());
    }

    protected boolean haveSamePort(URL uRL, URL uRL2) {
        return uRL.getPort() == uRL2.getPort();
    }

    protected final boolean areEqual(String string, String string2) {
        return string == string2 || string != null && string.equals(string2);
    }

    protected boolean haveSameProtocol(URL uRL, URL uRL2) {
        if (uRL == null || uRL2 == null) {
            return false;
        }
        String string = uRL.getProtocol();
        String string2 = uRL2.getProtocol();
        return string.equals(string2);
    }

    protected boolean haveSameAuthority(URL uRL, URL uRL2) {
        if (uRL == uRL2) {
            return true;
        }
        if (uRL == null || uRL2 == null) {
            return false;
        }
        String string = uRL.getAuthority();
        String string2 = uRL2.getAuthority();
        if (string == null) {
            return string2 == null;
        }
        if (string2 != null) {
            return string.equals(string2);
        }
        return false;
    }

    protected boolean appendRelativePath(URL uRL, URL uRL2, StringBuffer stringBuffer, boolean bl) {
        boolean bl2;
        String string = uRL.getPath();
        int n = string.lastIndexOf(47);
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "/");
        String string4 = uRL2.getPath();
        String string5 = string4.substring(0, string4.lastIndexOf(47));
        StringTokenizer stringTokenizer2 = new StringTokenizer(string5, "/");
        int n2 = stringTokenizer2.countTokens();
        int n3 = 0;
        String string6 = null;
        while (stringTokenizer.hasMoreTokens() && stringTokenizer2.hasMoreTokens()) {
            String string7;
            string6 = stringTokenizer.nextToken();
            if (!this.areEqualPathElems(string6, string7 = stringTokenizer2.nextToken())) break;
            ++n3;
            string6 = null;
        }
        boolean bl3 = bl2 = n2 == n3;
        if (bl && !bl2) {
            return false;
        }
        if (n3 == 0) {
            stringBuffer.append(string);
        } else {
            int n4;
            int n5 = n4 = n2 - n3;
            while (n5 > 0) {
                stringBuffer.append("../");
                --n5;
            }
            if (string6 != null && string6.length() > 0) {
                if (n4 == 0 && string6.indexOf(58) >= 0) {
                    stringBuffer.append("./");
                }
                stringBuffer.append(string6).append('/');
            }
            while (stringTokenizer.hasMoreTokens()) {
                stringBuffer.append(stringTokenizer.nextToken()).append('/');
            }
            stringBuffer.append(string3);
        }
        return bl2;
    }

    protected boolean areEqualPathElems(String string, String string2) {
        return string.equals(string2);
    }
}

