/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.net;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import oracle.ide.model.DefaultSubDirtyable;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLComparator;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;
import oracle.ide.net.URLFilter;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;
import oracle.javatools.util.Copyable;

public class URLPath
extends DefaultSubDirtyable
implements Copyable {
    private final List _entriesList;

    public URLPath() {
        this._entriesList = new ArrayList();
    }

    public URLPath(int n) {
        this._entriesList = new ArrayList(n);
    }

    public URLPath(URL uRL) {
        this();
        this.add(uRL);
    }

    public URLPath(URL[] uRLArray) {
        this();
        this.add(uRLArray);
    }

    public URLPath(ListStructure listStructure) {
        if (listStructure != null) {
            for (Object e : listStructure) {
                if (e == null) {
                    throw new IllegalArgumentException("The specified ListStructure contains null.");
                }
                if (e instanceof URL) continue;
                throw new IllegalArgumentException("The specified ListStructure contains a non-URL object (" + e.getClass().toString() + ")");
            }
            this._entriesList = listStructure;
        } else {
            this._entriesList = new ArrayList();
        }
    }

    public URLPath(URLPath uRLPath) {
        this();
        if (uRLPath != null) {
            uRLPath.copyToImpl(this);
        }
    }

    public Object copyTo(Object object) {
        URLPath uRLPath = object != null ? (URLPath)object : new URLPath();
        this.copyToImpl(uRLPath);
        return uRLPath;
    }

    protected final void copyToImpl(URLPath uRLPath) {
        uRLPath._entriesList.clear();
        uRLPath._entriesList.addAll(this._entriesList);
    }

    public void add(URL uRL) {
        if (uRL != null && !this.contains(uRL)) {
            this._entriesList.add(uRL);
            this.markDirty(true);
        }
    }

    public void add(URL[] uRLArray) {
        if (uRLArray != null) {
            int n = uRLArray.length;
            int n2 = 0;
            while (n2 < n) {
                this.add(uRLArray[n2]);
                ++n2;
            }
        }
    }

    public void add(List list) {
        if (list != null) {
            for (Object e : list) {
                if (!(e instanceof URL)) continue;
                this.add((URL)e);
            }
        }
    }

    public void add(URLPath uRLPath) {
        if (uRLPath != null) {
            this.add(uRLPath.getEntries());
        }
    }

    public List asList() {
        return Collections.unmodifiableList(this._entriesList);
    }

    public URL[] getEntries() {
        return this._entriesList.toArray(new URL[this._entriesList.size()]);
    }

    public boolean contains(URL uRL) {
        return this.findEntry(uRL) >= 0;
    }

    public List getAllDirectories() {
        URL[] uRLArray = this.getEntries();
        HashSet hashSet = new HashSet();
        int n = 0;
        while (n < uRLArray.length) {
            this._getAllDirectories(uRLArray[n], uRLArray[n], hashSet, URLFileSystem.findHelper(uRLArray[n]));
            ++n;
        }
        ArrayList arrayList = new ArrayList(hashSet);
        Collections.sort(arrayList);
        return arrayList;
    }

    public List getDirectories(String string) {
        return this.getDirectories(string, null);
    }

    public List getDirectories(String string, URLFilter uRLFilter) {
        ArrayList arrayList = new ArrayList();
        if (string != null) {
            HashSet<String> hashSet = new HashSet<String>();
            String string2 = string.length() == 0 || string.endsWith("/") ? string : string + "/";
            URL[] uRLArray = this.getEntries();
            int n = 0;
            while (n < uRLArray.length) {
                URL uRL = URLFactory.newDirURL(uRLArray[n], string);
                URLFileSystemHelper uRLFileSystemHelper = URLFileSystem.findHelper(uRL);
                URLFileSystem.FileInfo[] fileInfoArray = uRLFileSystemHelper.ls(uRL, uRLFilter);
                if (fileInfoArray != null) {
                    int n2 = 0;
                    while (n2 < fileInfoArray.length) {
                        URLFileSystem.FileInfo fileInfo = fileInfoArray[n2];
                        if (fileInfo.isDirectory()) {
                            URL uRL2 = fileInfo.getURL();
                            hashSet.add(string2 + uRLFileSystemHelper.getFileName(uRL2));
                        }
                        ++n2;
                    }
                }
                ++n;
            }
            arrayList.addAll(hashSet);
            Collections.sort(arrayList);
        }
        return arrayList;
    }

    public List getFiles(String string) {
        return this.getFiles(string, null);
    }

    public List getFiles(String string, URLFilter uRLFilter) {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        if (string != null) {
            URL[] uRLArray = this.getEntries();
            int n = 0;
            while (n < uRLArray.length) {
                URL uRL = URLFactory.newDirURL(uRLArray[n], string);
                URLFileSystem.FileInfo[] fileInfoArray = URLFileSystem.ls(uRL, uRLFilter);
                if (fileInfoArray != null) {
                    int n2 = 0;
                    while (n2 < fileInfoArray.length) {
                        URLFileSystem.FileInfo fileInfo = fileInfoArray[n2];
                        if (fileInfo.isFile()) {
                            URL uRL2 = fileInfo.getURL();
                            arrayList.add(uRL2);
                        }
                        ++n2;
                    }
                }
                ++n;
            }
            Collections.sort(arrayList, new URLComparator());
        }
        return arrayList;
    }

    public List getFilesAndDirectories(String string, boolean bl) {
        return this.getFilesAndDirectories(string, bl, null);
    }

    public List getFilesAndDirectories(String string, boolean bl, URLFilter uRLFilter) {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        if (string != null) {
            URL[] uRLArray = this.getEntries();
            int n = 0;
            while (n < uRLArray.length) {
                URL uRL = URLFactory.newDirURL(uRLArray[n], string);
                URLFileSystemHelper uRLFileSystemHelper = URLFileSystem.findHelper(uRL);
                URLFileSystem.FileInfo[] fileInfoArray = uRLFileSystemHelper.ls(uRL, uRLFilter);
                if (fileInfoArray != null) {
                    int n2 = 0;
                    while (n2 < fileInfoArray.length) {
                        URL uRL2 = fileInfoArray[n2].getURL();
                        arrayList.add(uRL2);
                        ++n2;
                    }
                }
                ++n;
            }
            Collections.sort(arrayList, new URLComparator(bl));
        }
        return arrayList;
    }

    public URL getFirstEntry() {
        if (this._entriesList.size() > 0) {
            return (URL)this._entriesList.get(0);
        }
        return null;
    }

    public static URLPath getURLPath(HashStructure hashStructure, String string) {
        URLPath uRLPath = new URLPath();
        if (hashStructure != null) {
            try {
                ListStructure listStructure = hashStructure.getListStructure(string);
                uRLPath.add((List)listStructure);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return uRLPath;
    }

    public static boolean setURLPath(HashStructure hashStructure, String string, URLPath uRLPath) {
        if (hashStructure != null) {
            try {
                if (uRLPath != null) {
                    ListStructure listStructure = hashStructure.getOrCreateListStructure(string);
                    boolean bl = listStructure.mirror(uRLPath.asList());
                    return bl;
                }
                if (hashStructure.containsKey(string)) {
                    hashStructure.remove(string);
                    boolean bl = true;
                    return bl;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return false;
    }

    public Iterator iterator() {
        return this._entriesList.iterator();
    }

    public static URLPath newURLPathFromString(String string) {
        URLPath uRLPath = new URLPath();
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                URL uRL = URLPath.pathToURL(string2);
                uRLPath.add(uRL);
            }
        }
        return uRLPath;
    }

    public void remove(URL uRL) {
        int n;
        if (uRL != null && (n = this.findEntry(uRL)) >= 0) {
            this._entriesList.remove(n);
            this.markDirty(true);
        }
    }

    public void remove(URL[] uRLArray) {
        if (uRLArray != null) {
            int n = uRLArray.length;
            int n2 = 0;
            while (n2 < n) {
                this.remove(uRLArray[n2]);
                ++n2;
            }
        }
    }

    public void remove(URLPath uRLPath) {
        if (uRLPath != null) {
            this.remove(uRLPath.getEntries());
        }
    }

    public void setEntries(URL[] uRLArray) {
        this._entriesList.clear();
        if (uRLArray != null) {
            this.add(uRLArray);
        }
        this.markDirty(true);
    }

    public int size() {
        return this._entriesList.size();
    }

    private boolean isArchive(URL uRL) {
        return ".zip".equalsIgnoreCase(URLFileSystem.getSuffix(uRL)) || ".jar".equalsIgnoreCase(URLFileSystem.getSuffix(uRL));
    }

    public URL toQualifiedURL(String string) {
        URL[] uRLArray = this.toQualifiedURL(string, true);
        if (uRLArray == null) {
            return null;
        }
        return uRLArray[0];
    }

    public URL[] toQualifiedURL(String string, boolean bl) {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        if (string != null) {
            URL[] uRLArray = this.getEntries();
            int n = 0;
            while (n < uRLArray.length) {
                URL uRL = uRLArray[n];
                URL uRL2 = uRL.getProtocol().equals("jar") ? URLFactory.newJarURL(uRL, string) : (this.isArchive(uRL) ? URLFactory.newJarURL(uRL, string) : URLFactory.newURL(uRL, string));
                if (URLFileSystem.exists(uRL2)) {
                    arrayList.add(uRL2);
                    if (bl) break;
                }
                ++n;
            }
        }
        if (arrayList.size() == 0) {
            return null;
        }
        return arrayList.toArray(new URL[arrayList.size()]);
    }

    public URL toBoundURL(String string) {
        if (string != null) {
            URL[] uRLArray = this.getEntries();
            int n = 0;
            while (n < uRLArray.length) {
                URL uRL = uRLArray[n];
                URL uRL2 = uRL.getProtocol().equals("jar") ? URLFactory.newJarURL(uRL, string) : URLFactory.newURL(uRL, string);
                if (URLFileSystem.isBound(uRL2)) {
                    return uRL2;
                }
                ++n;
            }
        }
        return null;
    }

    public String toRelativePath(URL uRL) {
        if (uRL != null) {
            URL[] uRLArray = this.getEntries();
            int n = 0;
            while (n < uRLArray.length) {
                URL uRL2 = uRLArray[n];
                String string = URLFileSystem.toRelativeSpec(uRL, uRL2, true);
                if (string != null) {
                    return string;
                }
                ++n;
            }
        }
        return null;
    }

    public String toShortestRelativePath(URL uRL) {
        URL uRL2 = this.getLongestMatchingEntry(uRL);
        if (uRL2 != null) {
            return URLFileSystem.toRelativeSpec(uRL, uRL2, true);
        }
        return null;
    }

    public URL getLongestMatchingEntry(URL uRL) {
        if (uRL != null) {
            String string = uRL.toString();
            URL[] uRLArray = this.getEntries();
            String string2 = null;
            URL uRL2 = null;
            int n = 0;
            while (n < uRLArray.length) {
                URL uRL3 = uRLArray[n];
                String string3 = uRL3.toString();
                if (string.startsWith(string3) && (string2 == null || string3.length() > string2.length())) {
                    string2 = string3;
                    uRL2 = uRL3;
                }
                ++n;
            }
            return uRL2;
        }
        return null;
    }

    public String[] toStrings() {
        URL[] uRLArray = this.getEntries();
        String[] stringArray = new String[uRLArray.length];
        int n = 0;
        while (n < uRLArray.length) {
            String string;
            URL uRL = uRLArray[n];
            stringArray[n] = string = URLFileSystem.getPlatformPathName(uRL);
            ++n;
        }
        return stringArray;
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsImpl((URLPath)object);
    }

    protected final boolean equalsImpl(URLPath uRLPath) {
        if (this == uRLPath) {
            return true;
        }
        if (this._entriesList.size() != uRLPath._entriesList.size()) {
            return false;
        }
        Iterator iterator = this._entriesList.iterator();
        Iterator iterator2 = uRLPath._entriesList.iterator();
        while (iterator.hasNext()) {
            URL uRL;
            URL uRL2 = (URL)iterator.next();
            if (URLFileSystem.equals(uRL2, uRL = (URL)iterator2.next())) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        URL[] uRLArray = this.getEntries();
        int n = 0;
        while (n < uRLArray.length) {
            URL uRL = uRLArray[n];
            String string = URLFileSystem.getPlatformPathName(uRL);
            stringBuffer.append(string).append(File.pathSeparatorChar);
            ++n;
        }
        int n2 = stringBuffer.length();
        if (n2 > 0) {
            stringBuffer.setLength(n2 - 1);
        }
        return stringBuffer.toString();
    }

    public boolean validateAllEntriesExist() {
        URL[] uRLArray = this.getEntries();
        if (uRLArray == null) {
            return true;
        }
        int n = 0;
        while (n < uRLArray.length) {
            if (!URLFileSystem.exists(uRLArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private int findEntry(URL uRL) {
        if (uRL != null) {
            URL[] uRLArray = this.getEntries();
            int n = 0;
            while (n < uRLArray.length) {
                if (URLFileSystem.equals(uRL, uRLArray[n])) {
                    return n;
                }
                ++n;
            }
        }
        return -1;
    }

    private static URL pathToURL(String string) {
        if (JarUtil.isArchive(string)) {
            URL uRL = URLFactory.newFileURL(string);
            return URLFactory.newJarURL(uRL, "");
        }
        URL uRL = URLFactory.newDirURL(string);
        return URLFileSystem.canonicalize(uRL);
    }

    private void _getAllDirectories(URL uRL, URL uRL2, Set set, URLFileSystemHelper uRLFileSystemHelper) {
        URLFileSystem.FileInfo[] fileInfoArray = uRLFileSystemHelper.ls(uRL2);
        if (fileInfoArray != null) {
            String string = uRLFileSystemHelper.toRelativeSpec(uRL2, uRL);
            if (string != null && string.length() > 0) {
                set.add(string);
            }
            int n = 0;
            while (n < fileInfoArray.length) {
                URLFileSystem.FileInfo fileInfo = fileInfoArray[n];
                if (fileInfo.isDirectory()) {
                    this._getAllDirectories(uRL, fileInfo.getURL(), set, uRLFileSystemHelper);
                }
                ++n;
            }
        }
    }
}

