/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.net;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Encodings;
import oracle.javatools.net.EncoderUtils;

public final class URLTempFile {
    private final URL _url;
    private Long _timestamp;
    private File _file;
    private boolean _tempWasCreated;

    public URLTempFile(URL uRL) {
        this._url = uRL;
    }

    public File getFile() {
        this.maybeRefresh();
        return this._file;
    }

    public boolean tempWasCreated() {
        return this._tempWasCreated;
    }

    protected void finalize() {
        this.deleteTempFile();
    }

    private void maybeRefresh() {
        if (this._url == null) {
            return;
        }
        long l = URLFileSystem.lastModified(this._url);
        if (this._timestamp != null && this._timestamp == l) {
            return;
        }
        String string = this._url.getProtocol();
        if (string.equalsIgnoreCase("file")) {
            if (this._file == null) {
                String string2 = this._url.getPath();
                try {
                    string2 = EncoderUtils.decodeString((String)string2, (String)Encodings.getDefaultEncoding());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                this._file = new File(string2);
                this._tempWasCreated = false;
            }
            this._timestamp = new Long(l);
            return;
        }
        this.deleteTempFile();
        this._file = null;
        this._tempWasCreated = false;
        try {
            String string3 = URLFileSystem.getName(this._url);
            String string4 = URLFileSystem.getSuffix(this._url);
            File file = File.createTempFile(string3, string4);
            file.deleteOnExit();
            URLFileSystem.copy(this._url, file);
            this._timestamp = new Long(l);
            this._file = file;
            this._tempWasCreated = true;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void deleteTempFile() {
        try {
            if (this._tempWasCreated && this._file != null && this._file.exists()) {
                this._file.delete();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

