/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.net;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLChooserInit;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.util.ModelUtil;
import oracle.javatools.controls.FileField;

public class URLTextField
extends FileField
implements ActionListener {
    public static final int OPEN_DIALOG = 0;
    public static final int SAVE_DIALOG = 1;
    private final Comparator _comparator;
    private boolean _isDir;
    private boolean _showJarsAsDirs;
    private String _lastSetText;
    private URL _url;
    private URL _baseURL;
    private String _title;
    private String _helpCtx;
    private List _filterList;
    private URLChooserInit _chooserInit;
    private URLFilter _filter;
    private boolean _clearAllFilters;
    private URL _defaultChooserURL;
    private int _dialogType;

    void $init$() {
        this._clearAllFilters = false;
        this._dialogType = 0;
    }

    public URLTextField() {
        this(null);
    }

    public URLTextField(URL uRL) {
        this(uRL, true, true);
    }

    public URLTextField(URL uRL, boolean bl) {
        this(uRL, bl, true);
    }

    public URLTextField(URL uRL, boolean bl, boolean bl2) {
        this.$init$();
        this._comparator = URLFileSystem.isLocalFileSystemCaseSensitive() ? null : String.CASE_INSENSITIVE_ORDER;
        this.setURL(uRL);
        this.setDirectoryOnly(bl);
        this._showJarsAsDirs = bl2;
    }

    public static URLTextField newForSavingFile() {
        return new URLTextField(null, false, false);
    }

    public URL getURL() {
        String string = this.getText();
        if (!ModelUtil.hasLength((String)string)) {
            return this._baseURL;
        }
        if (this.compare(string, this._lastSetText) == 0) {
            return this._url;
        }
        URL uRL = URLFactory.newURL(string, this._isDir, false);
        if (uRL != null) {
            return URLFileSystem.canonicalize(uRL);
        }
        if (this._baseURL == null) {
            return null;
        }
        URL uRL2 = this._isDir ? URLFactory.newDirURL(this._baseURL, string) : URLFactory.newURL(this._baseURL, string);
        return URLFileSystem.canonicalize(uRL2);
    }

    public void setURL(URL uRL) {
        this._url = uRL;
        if (this._url == null) {
            this._lastSetText = "";
            this.setText("");
        } else if (this._baseURL == null) {
            this._lastSetText = URLFileSystem.getPlatformPathName(uRL);
            this.setText(this._lastSetText);
        } else {
            String string = URLFileSystem.toRelativeSpec(uRL, this._baseURL, true);
            if (string != null) {
                this._lastSetText = string.endsWith("/") ? string.substring(0, string.length() - 1) : string;
                this.setText(this._lastSetText);
            } else {
                this._lastSetText = URLFileSystem.getPlatformPathName(uRL);
                this.setText(this._lastSetText);
            }
        }
    }

    public boolean isDirectoryOnly() {
        return this._isDir;
    }

    public void setDirectoryOnly(boolean bl) {
        this._isDir = bl;
        this.setOnlyDirectories(bl);
    }

    public void setClearAllFilters(boolean bl) {
        this._clearAllFilters = bl;
    }

    public void setDefaultChooserURL(URL uRL) {
        this._defaultChooserURL = uRL;
    }

    public void addChooseableURLFilter(URLFilter uRLFilter) {
        if (this._filterList == null) {
            this._filterList = new ArrayList();
        }
        this._filterList.add(uRLFilter);
    }

    public void clearChooseableURLFilters() {
        this._clearAllFilters = true;
        if (this._filterList != null) {
            this._filterList.clear();
            this._filterList = null;
        }
    }

    public URLFilter getFilter() {
        return this._filter;
    }

    public void setFilter(URLFilter uRLFilter) {
        this._filter = uRLFilter;
    }

    public void setDialogType(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("type not OPEN_DIALOG or SAVE_DIALOG");
        }
        this._dialogType = n;
    }

    public int getDialogType() {
        return this._dialogType;
    }

    public URLChooserInit getChooserInit() {
        return this._chooserInit;
    }

    public void setChooserInit(URLChooserInit uRLChooserInit) {
        this._chooserInit = uRLChooserInit;
    }

    public void setBaseURL(URL uRL) {
        this._baseURL = uRL;
    }

    public void setDialogTitle(String string) {
        this._title = string;
    }

    public void setDialogHelpContext(String string) {
        this._helpCtx = string;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.browseForURL();
    }

    public boolean browseForURL() {
        boolean bl = false;
        URL uRL = this.getURL() != null ? this.getURL() : this._defaultChooserURL;
        URLChooser uRLChooser = this.createChooser(uRL);
        int n = this._dialogType == 0 ? uRLChooser.showOpenDialog((Component)((Object)this), this._title) : uRLChooser.showSaveDialog((Component)((Object)this), this._title);
        if (n == 0) {
            this.setURL(uRLChooser.getSelectedURL());
            bl = true;
        }
        return bl;
    }

    protected URLChooser createChooser(URL uRL) {
        URLChooser uRLChooser = DialogUtil.newURLChooser(uRL);
        if (this._chooserInit != null) {
            this._chooserInit.initURLChooser(uRLChooser);
        }
        if (this._baseURL != null) {
            uRLChooser.setRoots(new URL[]{this._baseURL});
        }
        if (this._helpCtx != null) {
            uRLChooser.setHelpID(this._helpCtx);
        }
        uRLChooser.setShowJarsAsDirs(this._showJarsAsDirs);
        uRLChooser.setSelectionMode(0);
        uRLChooser.setSelectionScope(this._isDir ? 1 : 0);
        if (this._clearAllFilters) {
            uRLChooser.clearChooseableURLFilters();
        }
        if (this._filterList != null) {
            for (URLFilter uRLFilter : this._filterList) {
                uRLChooser.addChooseableURLFilter(uRLFilter);
            }
        }
        if (this._filter != null) {
            uRLChooser.setURLFilter(this._filter);
        }
        return uRLChooser;
    }

    private int compare(String string, String string2) {
        if (this._comparator != null) {
            return this._comparator.compare(string, string2);
        }
        return string.compareTo(string2);
    }
}

