/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.net;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.ide.natives.DirectoryWatcher;
import oracle.ide.natives.NativeHandler;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;
import oracle.ide.net.URLFileSystemHelperDecorator;
import oracle.ide.net.URLFilter;
import oracle.ide.persistence.NameSpace;
import oracle.javatools.assembly.AssemblyException;
import oracle.javatools.assembly.AssemblyFactory;
import oracle.javatools.assembly.ObjectArrayFactory;
import oracle.javatools.assembly.ObjectFactory;
import oracle.javatools.assembly.StringFactory;

public class VirtualFileSystemHelper
extends URLFileSystemHelperDecorator {
    private static boolean ENABLED = true;
    private static boolean USE_UNVERIFIED = false;
    private static boolean SKIP_PERSISTENCE = false;
    private static final boolean VERBOSE_ENTRY = false;
    private static final boolean VERBOSE_HELPER = false;
    private static final boolean VERBOSE_WATCHER = false;
    private static final boolean VERBOSE_LISTENER = false;
    private static final boolean VERBOSE_PERSIST = false;
    private static final boolean VERBOSE_CACHE = false;
    private static final boolean VERBOSE_FILTER = false;
    private static final String VERBOSE_ENTRY_PREFIX = "VFS/ENTRY: ";
    private static Object ENABLED_LOCK;
    private static boolean _enabled;
    private static boolean _watcherEnabled;
    private static List vfsList;
    private static final String VERBOSE_HELPER_PREFIX = "VFS/HELPER: ";
    private List _pendingUrlList;
    private List _disableUrlList;
    private HashMap _urlToWatchMap;
    private static final String VERBOSE_WATCHER_PREFIX = "VFS/WATCHER: ";
    private DWListener _listener;
    private static final String VERBOSE_LISTENER_PREFIX = "VFS/LISTENER: ";
    private boolean _loaded;
    private static final String NS_KEY_PREFIX = "$VFSData$";
    private static final String DATA_KEY = "VFSData";
    private static final String VERBOSE_PERSIST_PREFIX = "VFS/PERSIST: ";
    private boolean _isFile;
    private static final String VERBOSE_CACHE_PREFIX = "VFS/CACHE: ";
    private static final DirEntry DIR_NON_EXISTENT;
    private static final URLFileSystem.FileInfo FILE_NON_EXISTENT;
    private static final String VERBOSE_FILTER_PREFIX = "VFS/FILTER: ";
    private HashMap _activeRootMap;
    private HashMap _urlToDirEntryMap;
    private static final int PROCESS_REMOVE = 1;
    private static final int PROCESS_INVALIDATE = 2;
    private static final int PROCESS_UNVERIFIED = 3;
    private static final AssemblyFactory FILE_INFO_FACTORY;
    private static final AssemblyFactory FP_FILE_INFO_FACTORY;
    private static final AssemblyFactory DIR_ENTRY_FACTORY;
    private static final AssemblyFactory FP_DIR_ENTRY_FACTORY;
    private static final AssemblyFactory DIR_ENTRY_ARRAY_FACTORY;
    private static final AssemblyFactory FP_DIR_ENTRY_ARRAY_FACTORY;

    protected VirtualFileSystemHelper(URLFileSystemHelper uRLFileSystemHelper) {
        super(uRLFileSystemHelper);
        this.$init$();
        VirtualFileSystemHelper.registerVFS(this);
    }

    static {
        String string = System.getProperty("os.name").toLowerCase();
        boolean bl = string.indexOf("windows") != -1;
        boolean bl2 = bl;
        String string2 = bl ? "true" : "false";
        String string3 = System.getProperty("VFS_ENABLE", string2);
        boolean bl3 = ENABLED = string3 != null && Boolean.valueOf(string3) != false;
        if (ENABLED != bl2) {
            // empty if block
        }
        boolean bl4 = USE_UNVERIFIED = (string3 = System.getProperty("VFS_USE_UNVERIFIED", "false")) != null && Boolean.valueOf(string3.toString()) != false;
        if (USE_UNVERIFIED) {
            // empty if block
        }
        boolean bl5 = SKIP_PERSISTENCE = (string3 = System.getProperty("VFS_SKIP_PERSISTENCE", "false")) != null && Boolean.valueOf(string3.toString()) != false;
        if (SKIP_PERSISTENCE) {
            // empty if block
        }
        ENABLED_LOCK = new Object();
        _enabled = false;
        _watcherEnabled = false;
        vfsList = new ArrayList();
        DIR_NON_EXISTENT = new DirEntry(null);
        DirEntry.wa$_dirURL(DIR_NON_EXISTENT, URLFactory.newFileURL("non_existing_directory"));
        DirEntry.wa$_files(DIR_NON_EXISTENT, new URLFileSystem.FileInfo[0]);
        URL uRL = URLFactory.newFileURL("non_existing_file");
        FILE_NON_EXISTENT = new URLFileSystem.FileInfo(uRL, 0, 0L, 0L);
        FILE_INFO_FACTORY = new FileInfoFactory(false, null);
        FP_FILE_INFO_FACTORY = new FileInfoFactory(true, null);
        DIR_ENTRY_FACTORY = new DirEntryFactory(false, null);
        FP_DIR_ENTRY_FACTORY = new DirEntryFactory(true, null);
        DIR_ENTRY_ARRAY_FACTORY = new ObjectArrayFactory(DIR_ENTRY_FACTORY);
        FP_DIR_ENTRY_ARRAY_FACTORY = new ObjectArrayFactory(FP_DIR_ENTRY_FACTORY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void enableVFS() {
        if (ENABLED) {
            Object object = ENABLED_LOCK;
            synchronized (object) {
                _enabled = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void enableNativeWatching() {
        if (ENABLED) {
            Object object = ENABLED_LOCK;
            synchronized (object) {
                _watcherEnabled = true;
            }
            int n = vfsList.size();
            int n2 = 0;
            while (n2 < n) {
                VirtualFileSystemHelper virtualFileSystemHelper = (VirtualFileSystemHelper)vfsList.get(n2);
                virtualFileSystemHelper.updateDirectoryTracking();
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void shutdownVFS() {
        if (ENABLED) {
            Object object = ENABLED_LOCK;
            synchronized (object) {
                _enabled = false;
            }
            int n = vfsList.size();
            int n2 = 0;
            while (n2 < n) {
                VirtualFileSystemHelper virtualFileSystemHelper = (VirtualFileSystemHelper)vfsList.get(n2);
                virtualFileSystemHelper.saveDirData();
                ++n2;
            }
        }
    }

    public static synchronized void invalidateDirectory(URL uRL) {
        VirtualFileSystemHelper.invalidateDirectoryImpl(uRL, false);
    }

    public static synchronized void invalidateDirectoryTree(URL uRL) {
        VirtualFileSystemHelper.invalidateDirectoryImpl(uRL, true);
    }

    public static synchronized void setVerifyPersistedData(boolean bl) {
        String string = System.getProperty("VFS_USE_UNVERIFIED");
        if (string != null) {
            return;
        }
        USE_UNVERIFIED = bl ^ true;
    }

    static synchronized void cacheDirectoryTree(URL uRL, Object object) {
        VirtualFileSystemHelper virtualFileSystemHelper;
        if (ENABLED && (virtualFileSystemHelper = VirtualFileSystemHelper.findVFSHelper(uRL)) != null) {
            virtualFileSystemHelper.activateDirectory(uRL, object);
            virtualFileSystemHelper.addToDirectoryTracking(uRL);
        }
    }

    static synchronized void uncacheDirectoryTree(URL uRL, Object object) {
        VirtualFileSystemHelper virtualFileSystemHelper;
        if (ENABLED && (virtualFileSystemHelper = VirtualFileSystemHelper.findVFSHelper(uRL)) != null) {
            virtualFileSystemHelper.deactivateDirectory(uRL, object);
            virtualFileSystemHelper.resyncDirectoryTracking();
        }
    }

    private static void invalidateDirectoryImpl(URL uRL, boolean bl) {
        VirtualFileSystemHelper virtualFileSystemHelper;
        if (ENABLED && (virtualFileSystemHelper = VirtualFileSystemHelper.findVFSHelper(uRL)) != null) {
            virtualFileSystemHelper.invalidateDirEntry(uRL, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isEnabled() {
        Object object = ENABLED_LOCK;
        synchronized (object) {
            boolean bl = _enabled;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isWatcherEnabled() {
        Object object = ENABLED_LOCK;
        synchronized (object) {
            boolean bl = _watcherEnabled && NativeHandler.isLoaded();
            return bl;
        }
    }

    private static synchronized void registerVFS(VirtualFileSystemHelper virtualFileSystemHelper) {
        vfsList.add(virtualFileSystemHelper);
    }

    public void delete(URL uRL) throws IOException {
        if (VirtualFileSystemHelper.isEnabled()) {
            this.disableDirectoryTrackingFor(uRL, true);
        }
        try {
            this._helper.delete(uRL);
            if (VirtualFileSystemHelper.isEnabled()) {
                this.removeCachedDirEntry(uRL);
                this.markParentDirty(uRL);
            }
        }
        finally {
            if (VirtualFileSystemHelper.isEnabled()) {
                this.updateDirectoryTracking();
            }
        }
    }

    public boolean exists(URL uRL) {
        URLFileSystem.FileInfo fileInfo;
        if (VirtualFileSystemHelper.isEnabled() && (fileInfo = this.findCachedFileInfo(uRL)) != null) {
            return fileInfo != FILE_NON_EXISTENT;
        }
        return this._helper.exists(uRL);
    }

    public long getLength(URL uRL) {
        URLFileSystem.FileInfo fileInfo;
        if (VirtualFileSystemHelper.isEnabled() && (fileInfo = this.findCachedFileInfo(uRL)) != null) {
            if (fileInfo == FILE_NON_EXISTENT) {
                return -1;
            }
            return fileInfo.length();
        }
        return this._helper.getLength(uRL);
    }

    public boolean isDirectory(URL uRL) {
        URLFileSystem.FileInfo fileInfo;
        if (VirtualFileSystemHelper.isEnabled() && (fileInfo = this.findCachedFileInfo(uRL)) != null) {
            if (fileInfo == FILE_NON_EXISTENT) {
                return false;
            }
            return fileInfo.isDirectory();
        }
        return this._helper.isDirectory(uRL);
    }

    public boolean isHidden(URL uRL) {
        URLFileSystem.FileInfo fileInfo;
        if (VirtualFileSystemHelper.isEnabled() && (fileInfo = this.findCachedFileInfo(uRL)) != null) {
            if (fileInfo == FILE_NON_EXISTENT) {
                return false;
            }
            return fileInfo.isHidden();
        }
        return this._helper.isHidden(uRL);
    }

    public boolean isRegularFile(URL uRL) {
        URLFileSystem.FileInfo fileInfo;
        if (VirtualFileSystemHelper.isEnabled() && (fileInfo = this.findCachedFileInfo(uRL)) != null) {
            if (fileInfo == FILE_NON_EXISTENT) {
                return false;
            }
            return fileInfo.isFile();
        }
        return this._helper.isRegularFile(uRL);
    }

    public long lastModified(URL uRL) {
        URLFileSystem.FileInfo fileInfo;
        if (VirtualFileSystemHelper.isEnabled() && (fileInfo = this.findCachedFileInfo(uRL)) != null) {
            if (fileInfo == FILE_NON_EXISTENT) {
                return -1;
            }
            return fileInfo.lastModified();
        }
        return this._helper.lastModified(uRL);
    }

    public URL[] list(URL uRL) {
        return this.list(uRL, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL[] list(URL uRL, URLFilter uRLFilter) {
        if (VirtualFileSystemHelper.isEnabled()) {
            DirEntry dirEntry = this.findOrFetchDirEntry(uRL);
            if (dirEntry == null || dirEntry == DIR_NON_EXISTENT) {
                return null;
            }
            DirEntry dirEntry2 = dirEntry;
            synchronized (dirEntry2) {
                URL[] uRLArray;
                int n = DirEntry.ra$_files(dirEntry).length;
                if (uRLFilter == null) {
                    URL[] uRLArray2 = new URL[n];
                    int n2 = 0;
                    while (n2 < n) {
                        uRLArray2[n2] = DirEntry.ra$_files(dirEntry)[n2].getURL();
                        ++n2;
                    }
                    URL[] uRLArray3 = uRLArray2;
                    return uRLArray3;
                }
                ArrayList<URL> arrayList = new ArrayList<URL>(n);
                int n3 = 0;
                while (n3 < n) {
                    URL uRL2 = DirEntry.ra$_files(dirEntry)[n3].getURL();
                    if (uRLFilter.accept(uRL2)) {
                        arrayList.add(uRL2);
                    }
                    ++n3;
                }
                int n4 = arrayList.size();
                URL[] uRLArray4 = uRLArray = arrayList.toArray(new URL[n4]);
                return uRLArray4;
            }
        }
        return this._helper.list(uRL, uRLFilter);
    }

    public URLFileSystem.FileInfo[] ls(URL uRL) {
        return this.ls(uRL, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URLFileSystem.FileInfo[] ls(URL uRL, URLFilter uRLFilter) {
        if (VirtualFileSystemHelper.isEnabled()) {
            DirEntry dirEntry = this.findOrFetchDirEntry(uRL);
            if (dirEntry == null || dirEntry == DIR_NON_EXISTENT) {
                return null;
            }
            DirEntry dirEntry2 = dirEntry;
            synchronized (dirEntry2) {
                URLFileSystem.FileInfo[] fileInfoArray;
                int n = DirEntry.ra$_files(dirEntry).length;
                if (uRLFilter == null) {
                    URLFileSystem.FileInfo[] fileInfoArray2 = new URLFileSystem.FileInfo[n];
                    System.arraycopy(DirEntry.ra$_files(dirEntry), 0, fileInfoArray2, 0, n);
                    URLFileSystem.FileInfo[] fileInfoArray3 = fileInfoArray2;
                    return fileInfoArray3;
                }
                ArrayList<URLFileSystem.FileInfo> arrayList = new ArrayList<URLFileSystem.FileInfo>(n);
                int n2 = 0;
                while (n2 < n) {
                    URLFileSystem.FileInfo fileInfo = DirEntry.ra$_files(dirEntry)[n2];
                    if (fileInfo != null && uRLFilter.accept(fileInfo.getURL())) {
                        arrayList.add(fileInfo);
                    }
                    ++n2;
                }
                int n3 = arrayList.size();
                URLFileSystem.FileInfo[] fileInfoArray4 = fileInfoArray = arrayList.toArray(new URLFileSystem.FileInfo[n3]);
                return fileInfoArray4;
            }
        }
        return this._helper.ls(uRL, uRLFilter);
    }

    public URLFileSystem.FileInfo[] lsCached(URL uRL) {
        return this.ls(uRL);
    }

    public URLFileSystem.FileInfo[] lsCached(URL uRL, URLFilter uRLFilter) {
        return this.ls(uRL, uRLFilter);
    }

    public boolean mkdir(URL uRL) {
        boolean bl = this._helper.mkdir(uRL);
        if (VirtualFileSystemHelper.isEnabled() && bl) {
            this.markParentDirty(uRL);
            this.updateDirectoryTracking();
        }
        return bl;
    }

    public boolean mkdirs(URL uRL) {
        boolean bl = this._helper.mkdirs(uRL);
        if (VirtualFileSystemHelper.isEnabled() && bl) {
            this.markClosestParentDirty(uRL);
            this.updateDirectoryTracking();
        }
        return bl;
    }

    public URL createTempFile(String string, String string2, URL uRL) throws IOException {
        return this._helper.createTempFile(string, string2, uRL);
    }

    public OutputStream openOutputStream(URL uRL) throws IOException {
        OutputStream outputStream = this._helper.openOutputStream(uRL);
        if (VirtualFileSystemHelper.isEnabled() && outputStream != null) {
            this.markClosestParentDirty(uRL);
        }
        return outputStream;
    }

    public void rename(URL uRL, URL uRL2) throws IOException {
        if (VirtualFileSystemHelper.isEnabled()) {
            this.disableDirectoryTrackingFor(uRL, true);
        }
        try {
            this._helper.rename(uRL, uRL2);
            if (VirtualFileSystemHelper.isEnabled()) {
                this.removeCachedDirEntry(uRL);
                this.markParentDirty(uRL);
                this.markClosestParentDirty(uRL2);
            }
        }
        finally {
            if (VirtualFileSystemHelper.isEnabled()) {
                this.updateDirectoryTracking();
            }
        }
    }

    public boolean setLastModified(URL uRL, long l) {
        boolean bl = this._helper.setLastModified(uRL, l);
        if (VirtualFileSystemHelper.isEnabled() && bl) {
            this.markParentDirty(uRL);
        }
        return bl;
    }

    public boolean setReadOnly(URL uRL, boolean bl) {
        boolean bl2 = this._helper.setReadOnly(uRL, bl);
        if (VirtualFileSystemHelper.isEnabled() && bl2) {
            this.markParentDirty(uRL);
        }
        return bl2;
    }

    void $init$() {
        this._pendingUrlList = new ArrayList();
        this._disableUrlList = new ArrayList();
        this._urlToWatchMap = new HashMap(50);
        this._listener = new DWListener(null);
        this._loaded = false;
        this._isFile = false;
        this._activeRootMap = new HashMap(50);
        this._urlToDirEntryMap = new HashMap(1000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToDirectoryTracking(URL uRL) {
        List list = this._pendingUrlList;
        synchronized (list) {
            this._pendingUrlList.add(uRL);
        }
        this.updateDirectoryTracking();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resyncDirectoryTracking() {
        URL[] uRLArray = this.getActiveDirectories();
        List list = this._pendingUrlList;
        synchronized (list) {
            List list2 = this._disableUrlList;
            synchronized (list2) {
                HashMap hashMap = this._urlToWatchMap;
                synchronized (hashMap) {
                    ArrayList<URL> arrayList = new ArrayList<URL>(Arrays.asList(uRLArray));
                    ArrayList arrayList2 = new ArrayList();
                    arrayList2.addAll(this._pendingUrlList);
                    arrayList2.addAll(this._disableUrlList);
                    arrayList2.addAll(this._urlToWatchMap.keySet());
                    ArrayList arrayList3 = arrayList2;
                    arrayList3.removeAll(arrayList);
                    for (URL uRL : arrayList3) {
                        this.disableDirectoryTrackingFor(uRL, false);
                    }
                    this._pendingUrlList.removeAll(arrayList3);
                    this._disableUrlList.removeAll(arrayList3);
                }
            }
        }
    }

    private void updateDirectoryTracking() {
        if (!VirtualFileSystemHelper.isWatcherEnabled() || !this.isFileProtocol()) {
            return;
        }
        this.enableDirectoryTrackingFor(this._pendingUrlList);
        this.enableDirectoryTrackingFor(this._disableUrlList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enableDirectoryTrackingFor(List list) {
        List list2 = list;
        synchronized (list2) {
            if (list.isEmpty()) {
                return;
            }
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                DirectoryWatcher directoryWatcher;
                URL uRL = (URL)iterator.next();
                if (this._urlToWatchMap.containsKey(uRL) || (directoryWatcher = DirectoryWatcher.createDirectoryWatcher(uRL, this._listener)) == null) continue;
                HashMap hashMap = this._urlToWatchMap;
                synchronized (hashMap) {
                    this._urlToWatchMap.put(uRL, directoryWatcher);
                }
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disableDirectoryTrackingFor(URL uRL, boolean bl) {
        List list = this._disableUrlList;
        synchronized (list) {
            HashMap hashMap = this._urlToWatchMap;
            synchronized (hashMap) {
                boolean bl2 = false;
                Iterator iterator = this._urlToWatchMap.keySet().iterator();
                while (iterator.hasNext()) {
                    URL uRL2 = (URL)iterator.next();
                    if ((!bl || !URLFileSystem.isBaseURLFor(uRL, uRL2)) && (bl || !uRL.equals(uRL2))) continue;
                    DirectoryWatcher directoryWatcher = (DirectoryWatcher)this._urlToWatchMap.get(uRL2);
                    iterator.remove();
                    if (directoryWatcher == null) continue;
                    DirectoryWatcher.destroyDirectoryWatcher(directoryWatcher);
                    this._disableUrlList.add(uRL2);
                }
            }
        }
    }

    protected String getNameSpaceKey() {
        return NS_KEY_PREFIX + this._helper.getClass().getName();
    }

    private NameSpace getNameSpace() {
        String string = this.getNameSpaceKey();
        NameSpace nameSpace = NameSpace.getNameSpace(string);
        if (nameSpace == null) {
            // empty if block
        }
        return nameSpace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureDataLoaded() {
        if (!this._loaded && VirtualFileSystemHelper.isEnabled()) {
            HashMap hashMap = this._urlToDirEntryMap;
            synchronized (hashMap) {
                if (!this._loaded) {
                    this.loadDirData();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDirData() {
        HashMap hashMap = this._urlToDirEntryMap;
        synchronized (hashMap) {
            if (!this._loaded) {
                NameSpace nameSpace;
                this.checkIfIsFileProtocol();
                this._urlToDirEntryMap.clear();
                if (!SKIP_PERSISTENCE && (nameSpace = this.getNameSpace()) != null) {
                    try {
                        long l = System.currentTimeMillis();
                        byte[] byArray = nameSpace.getRecord(DATA_KEY);
                        long l2 = System.currentTimeMillis() - l;
                        if (byArray != null) {
                            l = System.currentTimeMillis();
                            Object[] objectArray = (Object[])(this.isFileProtocol() ? FP_DIR_ENTRY_ARRAY_FACTORY.assemble(byArray) : DIR_ENTRY_ARRAY_FACTORY.assemble(byArray));
                            int n = objectArray != null ? objectArray.length : 0;
                            int n2 = 0;
                            while (n2 < n) {
                                DirEntry dirEntry = (DirEntry)objectArray[n2];
                                if (dirEntry != null) {
                                    URL uRL = DirEntry.ra$_dirURL(dirEntry);
                                    DirEntry dirEntry2 = dirEntry;
                                    DirEntry.wa$_flags(dirEntry2, (byte)(DirEntry.ra$_flags(dirEntry2) | 4));
                                    this._urlToDirEntryMap.put(uRL, dirEntry);
                                }
                                ++n2;
                            }
                            l2 = System.currentTimeMillis() - l;
                        }
                    }
                    catch (AssemblyException assemblyException) {
                        nameSpace.delRecord(DATA_KEY);
                        nameSpace.flush();
                    }
                }
                this._loaded = true;
                this.updateDirectoryTracking();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveDirData() {
        HashMap hashMap = this._urlToDirEntryMap;
        synchronized (hashMap) {
            if (!SKIP_PERSISTENCE) {
                try {
                    NameSpace nameSpace = this.getNameSpace();
                    if (nameSpace != null) {
                        long l = System.currentTimeMillis();
                        Object[] objectArray = this._urlToDirEntryMap.values().toArray();
                        byte[] byArray = this.isFileProtocol() ? FP_DIR_ENTRY_ARRAY_FACTORY.disassemble((Object)objectArray) : DIR_ENTRY_ARRAY_FACTORY.disassemble((Object)objectArray);
                        long l2 = System.currentTimeMillis() - l;
                        l = System.currentTimeMillis();
                        nameSpace.putRecord(DATA_KEY, byArray);
                        nameSpace.flush();
                        l2 = System.currentTimeMillis() - l;
                    }
                }
                catch (AssemblyException assemblyException) {
                    // empty catch block
                }
            }
        }
    }

    private boolean isFileProtocol() {
        return this._isFile;
    }

    private void checkIfIsFileProtocol() {
        URLFileSystemHelper uRLFileSystemHelper = URLFileSystem.findHelper("file");
        VirtualFileSystemHelper virtualFileSystemHelper = VirtualFileSystemHelper.findVFSHelper(uRLFileSystemHelper);
        if (virtualFileSystemHelper == this) {
            this._isFile = true;
        }
    }

    private static VirtualFileSystemHelper findVFSHelper(URL uRL) {
        return VirtualFileSystemHelper.findVFSHelper(URLFileSystem.findHelper(uRL));
    }

    private static VirtualFileSystemHelper findVFSHelper(URLFileSystemHelper uRLFileSystemHelper) {
        while (true) {
            if (uRLFileSystemHelper instanceof VirtualFileSystemHelper) {
                return (VirtualFileSystemHelper)uRLFileSystemHelper;
            }
            if (!(uRLFileSystemHelper instanceof URLFileSystemHelperDecorator)) break;
            uRLFileSystemHelper = ((URLFileSystemHelperDecorator)uRLFileSystemHelper).getHelper();
        }
        return null;
    }

    private void markDirDirty(URL uRL) {
        DirEntry dirEntry;
        if (uRL != null && (dirEntry = this.lookupCacheImpl(uRL)) != null) {
            this.markDirEntryDirty(dirEntry);
        }
    }

    private void markParentDirty(URL uRL) {
        URL uRL2 = this.getParent(uRL);
        if (uRL2 != null) {
            this.markDirDirty(uRL2);
            URL uRL3 = this.getParent(uRL2);
            if (uRL3 != null) {
                this.markDirDirty(uRL3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markClosestParentDirty(URL uRL) {
        DirEntry dirEntry = null;
        URL uRL2 = uRL;
        HashMap hashMap = this._urlToDirEntryMap;
        synchronized (hashMap) {
            while (uRL2 != null) {
                dirEntry = this.lookupCacheImpl(uRL2);
                if (dirEntry != null) {
                    this.markDirEntryDirty(dirEntry);
                    URL uRL3 = this.getParent(uRL2);
                    if (uRL3 == null) break;
                    this.markDirDirty(uRL3);
                    break;
                }
                uRL2 = this.getParent(uRL2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidateDirEntry(URL uRL, boolean bl) {
        HashMap hashMap = this._urlToDirEntryMap;
        synchronized (hashMap) {
            if (!bl) {
                DirEntry dirEntry = this.lookupCacheImpl(uRL);
                if (dirEntry != null) {
                    this.markDirEntryDirty(dirEntry);
                }
            } else {
                this.processChildrenCacheImpl(uRL, 2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URLFileSystem.FileInfo findCachedFileInfo(URL uRL) {
        DirEntry dirEntry;
        URL uRL2 = this.getParent(uRL);
        if (uRL2 != null && (dirEntry = this.findCachedDirEntry(uRL2)) != null) {
            if (dirEntry == DIR_NON_EXISTENT) {
                return FILE_NON_EXISTENT;
            }
            DirEntry dirEntry2 = dirEntry;
            synchronized (dirEntry2) {
                URLFileSystem.FileInfo[] fileInfoArray = DirEntry.ra$_files(dirEntry);
                int n = fileInfoArray.length;
                int n2 = 0;
                while (n2 < n) {
                    if (uRL.equals(fileInfoArray[n2].getURL())) {
                        URLFileSystem.FileInfo fileInfo = fileInfoArray[n2];
                        return fileInfo;
                    }
                    ++n2;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DirEntry findCachedDirEntry(URL uRL) {
        URL uRL2 = this.getActiveRoot(uRL);
        if (uRL2 == null) {
            return null;
        }
        DirEntry dirEntry = this.lookupCacheImpl(uRL);
        if (dirEntry == null) {
            return null;
        }
        DirEntry dirEntry2 = dirEntry;
        synchronized (dirEntry2) {
            if (!this.isDirEntryValid(dirEntry)) {
                DirEntry dirEntry3 = null;
                return dirEntry3;
            }
        }
        return dirEntry;
    }

    private void removeCachedDirEntry(URL uRL) {
        this.processChildrenCacheImpl(uRL, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DirEntry findOrFetchDirEntry(URL uRL) {
        URL uRL2;
        URL uRL3 = this.getActiveRoot(uRL);
        boolean bl = uRL3 != null;
        DirEntry dirEntry = this.lookupCacheImpl(uRL);
        DirEntry dirEntry2 = null;
        if (bl && dirEntry != null) {
            DirEntry dirEntry3 = dirEntry;
            synchronized (dirEntry3) {
                if (this.isDirEntryValid(dirEntry)) {
                    DirEntry dirEntry4 = dirEntry;
                    return dirEntry4;
                }
            }
        }
        if ((dirEntry2 = this.fetchDirFromHelper(uRL2 = dirEntry != null ? DirEntry.ra$_dirURL(dirEntry) : uRL)) == null) {
            if (dirEntry != null) {
                this.processChildrenCacheImpl(uRL, 1);
            }
        } else {
            if (bl || dirEntry != null) {
                this.storeCacheImpl(dirEntry2);
            }
            if (dirEntry != null) {
                HashSet<URL> hashSet = new HashSet<URL>();
                URLFileSystem.FileInfo[] fileInfoArray = DirEntry.ra$_files(dirEntry);
                int n = fileInfoArray.length;
                int n2 = 0;
                while (n2 < n) {
                    URLFileSystem.FileInfo fileInfo = fileInfoArray[n2];
                    if (fileInfo.isDirectory()) {
                        hashSet.add(fileInfoArray[n2].getURL());
                    }
                    ++n2;
                }
                URLFileSystem.FileInfo[] fileInfoArray2 = DirEntry.ra$_files(dirEntry2);
                int n3 = fileInfoArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    URLFileSystem.FileInfo fileInfo = fileInfoArray2[n4];
                    if (fileInfo.isDirectory()) {
                        hashSet.remove(fileInfoArray2[n4].getURL());
                    }
                    ++n4;
                }
                for (URL uRL4 : hashSet) {
                    this.processChildrenCacheImpl(uRL4, 1);
                }
            }
        }
        return dirEntry2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activateDirectory(URL uRL, Object object) {
        HashMap hashMap = this._activeRootMap;
        synchronized (hashMap) {
            HashSet<Object> hashSet = (HashSet<Object>)this._activeRootMap.get(uRL);
            if (hashSet == null) {
                hashSet = new HashSet<Object>(5);
                this._activeRootMap.put(uRL, hashSet);
                this.processChildrenCacheImpl(uRL, 3);
            }
            hashSet.add(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deactivateDirectory(URL uRL, Object object) {
        HashMap hashMap = this._activeRootMap;
        synchronized (hashMap) {
            Set set = (Set)this._activeRootMap.get(uRL);
            if (set != null) {
                set.remove(object);
                if (set.isEmpty()) {
                    this._activeRootMap.remove(uRL);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URL[] getActiveDirectories() {
        HashMap hashMap = this._activeRootMap;
        synchronized (hashMap) {
            Set set = this._activeRootMap.keySet();
            URL[] uRLArray = set.toArray(new URL[set.size()]);
            return uRLArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URL getActiveRoot(URL uRL) {
        URL uRL2 = null;
        HashMap hashMap = this._activeRootMap;
        synchronized (hashMap) {
            String string = uRL.getPath();
            for (URL uRL3 : this._activeRootMap.keySet()) {
                if (this.isFileProtocol()) {
                    String string2 = uRL3.getPath();
                    if (!string.startsWith(string2)) continue;
                    uRL2 = uRL3;
                    break;
                }
                if (!uRL3.equals(uRL) && !this.isBaseURLFor(uRL3, uRL)) continue;
                uRL2 = uRL3;
                break;
            }
        }
        return uRL2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markDirEntryDirty(DirEntry dirEntry) {
        DirEntry dirEntry2 = dirEntry;
        synchronized (dirEntry2) {
            DirEntry dirEntry3 = dirEntry;
            DirEntry.wa$_flags(dirEntry3, (byte)(DirEntry.ra$_flags(dirEntry3) | 1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markDirEntryUnverified(DirEntry dirEntry) {
        DirEntry dirEntry2 = dirEntry;
        synchronized (dirEntry2) {
            DirEntry dirEntry3 = dirEntry;
            DirEntry.wa$_flags(dirEntry3, (byte)(DirEntry.ra$_flags(dirEntry3) | 4));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DirEntry lookupCacheImpl(URL uRL) {
        this.ensureDataLoaded();
        DirEntry dirEntry = null;
        HashMap hashMap = this._urlToDirEntryMap;
        synchronized (hashMap) {
            dirEntry = (DirEntry)this._urlToDirEntryMap.get(uRL);
        }
        return dirEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeCacheImpl(DirEntry dirEntry) {
        this.ensureDataLoaded();
        HashMap hashMap = this._urlToDirEntryMap;
        synchronized (hashMap) {
            if (dirEntry != null) {
                this._urlToDirEntryMap.put(DirEntry.ra$_dirURL(dirEntry), dirEntry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processChildrenCacheImpl(URL uRL, int n) {
        this.ensureDataLoaded();
        HashMap hashMap = this._urlToDirEntryMap;
        synchronized (hashMap) {
            String string = uRL.getPath();
            Collection collection = this._urlToDirEntryMap.values();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                DirEntry dirEntry = (DirEntry)iterator.next();
                URL uRL2 = DirEntry.ra$_dirURL(dirEntry);
                boolean bl = false;
                if (this.isFileProtocol()) {
                    String string2 = uRL2.getPath();
                    if (string2.startsWith(string)) {
                        bl = true;
                    }
                } else if (uRL2.equals(uRL) || this.isBaseURLFor(uRL, uRL2)) {
                    bl = true;
                }
                if (!bl) continue;
                switch (n) {
                    case 1: {
                        iterator.remove();
                        break;
                    }
                    case 2: {
                        this.markDirEntryDirty(dirEntry);
                        break;
                    }
                    case 3: {
                        this.markDirEntryUnverified(dirEntry);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDirEntryDirty(DirEntry dirEntry) {
        DirEntry dirEntry2 = dirEntry;
        synchronized (dirEntry2) {
            boolean bl = VirtualFileSystemHelper.isFlagSet(DirEntry.ra$_flags(dirEntry), 1);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDirEntryUnverified(DirEntry dirEntry) {
        DirEntry dirEntry2 = dirEntry;
        synchronized (dirEntry2) {
            boolean bl = VirtualFileSystemHelper.isFlagSet(DirEntry.ra$_flags(dirEntry), 4);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDirEntryValid(DirEntry dirEntry) {
        DirEntry dirEntry2 = dirEntry;
        synchronized (dirEntry2) {
            boolean bl = this.isDirEntryDirty(dirEntry);
            boolean bl2 = this.isDirEntryUnverified(dirEntry);
            boolean bl3 = (bl || !USE_UNVERIFIED && bl2) ^ true;
            return bl3;
        }
    }

    private DirEntry fetchDirFromHelper(URL uRL) {
        URLFileSystem.FileInfo[] fileInfoArray;
        if (!VirtualFileSystemHelper.isEnabled()) {
            // empty if block
        }
        if ((fileInfoArray = this._helper.ls(uRL)) != null) {
            DirEntry dirEntry = new DirEntry(null);
            DirEntry.wa$_dirURL(dirEntry, uRL);
            DirEntry.wa$_flags(dirEntry, (byte)0);
            DirEntry.wa$_files(dirEntry, fileInfoArray);
            return dirEntry;
        }
        return null;
    }

    private static boolean isFlagSet(int n, int n2) {
        return (n & n2) != 0;
    }

    static void mav$disableDirectoryTrackingFor(VirtualFileSystemHelper virtualFileSystemHelper, URL uRL, boolean bl) {
        virtualFileSystemHelper.disableDirectoryTrackingFor(uRL, bl);
    }

    static void mav$removeCachedDirEntry(VirtualFileSystemHelper virtualFileSystemHelper, URL uRL) {
        virtualFileSystemHelper.removeCachedDirEntry(uRL);
    }

    static void mav$markParentDirty(VirtualFileSystemHelper virtualFileSystemHelper, URL uRL) {
        virtualFileSystemHelper.markParentDirty(uRL);
    }

    static AssemblyFactory ra$FP_FILE_INFO_FACTORY() {
        return FP_FILE_INFO_FACTORY;
    }

    static AssemblyFactory ra$FILE_INFO_FACTORY() {
        return FILE_INFO_FACTORY;
    }

    private class DWListener
    implements DirectoryWatcher.DirectoryListener {
        public void directoryUpdate(DirectoryWatcher.DirectoryEvent directoryEvent) {
            int n = directoryEvent.getEventType();
            URL uRL = directoryEvent.getRootURL();
            URL uRL2 = null;
            switch (n) {
                case 2: {
                    String string = directoryEvent.getFileName().replace('\\', '/');
                    uRL2 = URLFactory.newURL(uRL, string);
                    VirtualFileSystemHelper.mav$removeCachedDirEntry(VirtualFileSystemHelper.this, uRL2);
                    VirtualFileSystemHelper.mav$markParentDirty(VirtualFileSystemHelper.this, uRL2);
                    break;
                }
                case 4: {
                    String string = directoryEvent.getOldFileName().replace('\\', '/');
                    uRL2 = URLFactory.newURL(uRL, string);
                    VirtualFileSystemHelper.mav$removeCachedDirEntry(VirtualFileSystemHelper.this, uRL2);
                    VirtualFileSystemHelper.mav$markParentDirty(VirtualFileSystemHelper.this, uRL2);
                    break;
                }
                case 1: 
                case 3: {
                    String string = directoryEvent.getFileName().replace('\\', '/');
                    uRL2 = URLFactory.newURL(uRL, string);
                    VirtualFileSystemHelper.mav$markParentDirty(VirtualFileSystemHelper.this, uRL2);
                }
            }
        }

        public void watchCancelled(DirectoryWatcher.DirectoryEvent directoryEvent) {
            URL uRL = directoryEvent.getRootURL();
            VirtualFileSystemHelper.mav$disableDirectoryTrackingFor(VirtualFileSystemHelper.this, uRL, false);
        }

        private DWListener() {
        }

        DWListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private static final class DirEntry {
        private URL _dirURL;
        private static final int FLAGS_NONE = 0;
        private static final int FLAGS_DIRTY = 1;
        private static final int FLAGS_UNVERIFIED = 4;
        private byte _flags;
        private URLFileSystem.FileInfo[] _files;

        private DirEntry() {
        }

        DirEntry(1 var1_1) {
            this();
        }

        static void wa$_dirURL(DirEntry dirEntry, URL uRL) {
            dirEntry._dirURL = uRL;
        }

        static void wa$_flags(DirEntry dirEntry, byte by) {
            dirEntry._flags = by;
        }

        static void wa$_files(DirEntry dirEntry, URLFileSystem.FileInfo[] fileInfoArray) {
            dirEntry._files = fileInfoArray;
        }

        static byte ra$_flags(DirEntry dirEntry) {
            return dirEntry._flags;
        }

        static URL ra$_dirURL(DirEntry dirEntry) {
            return dirEntry._dirURL;
        }

        static URLFileSystem.FileInfo[] ra$_files(DirEntry dirEntry) {
            return dirEntry._files;
        }

        public final class 1 {
        }
    }

    private static final class FileInfoFactory
    extends ObjectFactory {
        private boolean _isFileProtocol;
        public static final byte FILE_INFO_CODE = -15;
        public static final byte FP_FILE_INFO_CODE = -5;

        private FileInfoFactory(boolean bl) {
            this._isFileProtocol = bl;
        }

        public byte getObjectCode() {
            return this._isFileProtocol ? (byte)-5 : -15;
        }

        public Object assembleImpl(DataInput dataInput) throws IOException, AssemblyException {
            String string = (String)StringFactory.STRING_FACTORY.assemble(dataInput);
            URL uRL = this._isFileProtocol ? URLFactory.newFileURL(string) : URLFactory.newURL(string);
            int n = dataInput.readInt();
            long l = dataInput.readLong();
            long l2 = dataInput.readLong();
            return new URLFileSystem.FileInfo(uRL, n, l, l2);
        }

        public void disassembleImpl(Object object, DataOutput dataOutput) throws IOException, ClassCastException, AssemblyException {
            URLFileSystem.FileInfo fileInfo = (URLFileSystem.FileInfo)object;
            URL uRL = fileInfo.getURL();
            String string = this._isFileProtocol ? uRL.getPath() : uRL.toString();
            int n = fileInfo.attributes;
            long l = fileInfo.lastModified;
            long l2 = fileInfo.length;
            StringFactory.STRING_FACTORY.disassemble((Object)string, dataOutput);
            dataOutput.writeInt(n);
            dataOutput.writeLong(l);
            dataOutput.writeLong(l2);
        }

        FileInfoFactory(boolean bl, 1 var2_2) {
            this(bl);
        }

        public final class 1 {
        }
    }

    private static final class DirEntryFactory
    extends ObjectFactory {
        private boolean _isFileProtocol;
        public static final byte DIR_ENTRY_CODE = -34;
        public static final byte FP_DIR_ENTRY_CODE = -37;

        private DirEntryFactory(boolean bl) {
            this._isFileProtocol = bl;
        }

        public byte getObjectCode() {
            return this._isFileProtocol ? (byte)-37 : -34;
        }

        public Object assembleImpl(DataInput dataInput) throws IOException, AssemblyException {
            String string = (String)StringFactory.STRING_FACTORY.assemble(dataInput);
            URL uRL = this._isFileProtocol ? URLFactory.newFileURL(string) : URLFactory.newURL(string);
            byte by = dataInput.readByte();
            int n = dataInput.readInt();
            URLFileSystem.FileInfo[] fileInfoArray = new URLFileSystem.FileInfo[n];
            int n2 = 0;
            while (n2 < n) {
                fileInfoArray[n2] = (URLFileSystem.FileInfo)(this._isFileProtocol ? VirtualFileSystemHelper.ra$FP_FILE_INFO_FACTORY().assemble(dataInput) : VirtualFileSystemHelper.ra$FILE_INFO_FACTORY().assemble(dataInput));
                ++n2;
            }
            DirEntry dirEntry = new DirEntry(null);
            DirEntry.wa$_dirURL(dirEntry, uRL);
            DirEntry.wa$_flags(dirEntry, by);
            DirEntry.wa$_files(dirEntry, fileInfoArray);
            return dirEntry;
        }

        public void disassembleImpl(Object object, DataOutput dataOutput) throws IOException, ClassCastException, AssemblyException {
            DirEntry dirEntry = (DirEntry)object;
            URL uRL = DirEntry.ra$_dirURL(dirEntry);
            String string = this._isFileProtocol ? uRL.getPath() : uRL.toString();
            byte by = DirEntry.ra$_flags(dirEntry);
            URLFileSystem.FileInfo[] fileInfoArray = DirEntry.ra$_files(dirEntry);
            int n = fileInfoArray != null ? fileInfoArray.length : 0;
            StringFactory.STRING_FACTORY.disassemble((Object)string, dataOutput);
            dataOutput.writeByte(by);
            dataOutput.writeInt(n);
            int n2 = 0;
            while (n2 < n) {
                if (this._isFileProtocol) {
                    VirtualFileSystemHelper.ra$FP_FILE_INFO_FACTORY().disassemble((Object)fileInfoArray[n2], dataOutput);
                } else {
                    VirtualFileSystemHelper.ra$FILE_INFO_FACTORY().disassemble((Object)fileInfoArray[n2], dataOutput);
                }
                ++n2;
            }
        }

        DirEntryFactory(boolean bl, 1 var2_2) {
            this(bl);
        }

        public final class 1 {
        }
    }
}

