/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.net;

import java.net.URL;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.resource.NetArb;
import oracle.ide.util.ModelUtil;

public class WildcardURLFilter
implements URLFilter {
    private final Pattern _pattern;
    private final String _description;

    public WildcardURLFilter(String string) {
        this(string, URLFileSystem.isLocalFileSystemCaseSensitive());
    }

    public WildcardURLFilter(String string, boolean bl) {
        this(string, bl, NetArb.getString(31));
    }

    public WildcardURLFilter(String string, boolean bl, String string2) {
        String string3 = WildcardURLFilter.wildcard2Regexp(string);
        Pattern pattern = null;
        try {
            pattern = bl ? Pattern.compile(string3) : Pattern.compile(string3, 2);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            patternSyntaxException.printStackTrace();
        }
        this._pattern = pattern;
        this._description = NetArb.format(30, string2, string);
    }

    public boolean accept(URL uRL) {
        return this.match(URLFileSystem.getFileName(uRL));
    }

    protected boolean match(String string) {
        return this._pattern != null ? this._pattern.matcher(string).matches() : true;
    }

    public static boolean hasWildcard(String string) {
        return string != null && (string.indexOf("*") >= 0 || string.indexOf("?") >= 0);
    }

    public static String wildcard2Regexp(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("^");
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (Character.isLetterOrDigit(c)) {
                stringBuffer.append(c);
            } else if (c == '\\') {
                stringBuffer.append('\\');
                if (++n2 < n) {
                    stringBuffer.append(cArray[n2]);
                }
            } else if (c == '*' || c == '?') {
                stringBuffer.append('.').append(c);
            } else {
                stringBuffer.append('\\').append(c);
            }
            ++n2;
        }
        stringBuffer.append("$");
        return stringBuffer.toString();
    }

    public static String makeLiteral(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (Character.isLetterOrDigit(c)) {
                stringBuffer.append(c);
            } else {
                stringBuffer.append('\\').append(c);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsImpl((WildcardURLFilter)object);
    }

    protected final boolean equalsImpl(WildcardURLFilter wildcardURLFilter) {
        return ModelUtil.areEqual((Object)this._pattern, (Object)wildcardURLFilter._pattern) && ModelUtil.areEqual((Object)this._description, (Object)wildcardURLFilter._description);
    }

    public String toString() {
        return this._description;
    }
}

