/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.palette;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import oracle.ide.palette.PaletteLoader;

public class PaletteUtil {
    private static final String _loaderClass = "oracle.ideimpl.palette.PaletteLoaderImpl";

    private PaletteUtil() {
    }

    public static void usage() {
        System.out.println("Palette Util Jdeveloper 9i");
        System.out.println("Usage:  <palette.xml> <palette entry properties file>");
        System.out.println("");
        System.exit(0);
    }

    public static void loadPaletteItems(URL uRL, URL uRL2) {
        PaletteUtil.getLoader().loadPaletteItems(uRL, uRL2);
    }

    private static PaletteLoader getLoader() {
        try {
            Class<?> clazz = Class.forName(_loaderClass);
            PaletteLoader paletteLoader = (PaletteLoader)clazz.newInstance();
            return paletteLoader;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
            return null;
        }
    }

    private static URL getFileURL(String string) {
        URL uRL = null;
        File file = new File(string);
        if (file.exists()) {
            try {
                uRL = file.toURL();
            }
            catch (MalformedURLException malformedURLException) {
                System.out.println("ERROR: URL [" + uRL.toString() + "] is not valid");
            }
        }
        return uRL;
    }

    private static void abort(String string) {
        System.out.println("ERROR: " + string);
        System.exit(1);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 2) {
            PaletteUtil.usage();
        }
        URL uRL = PaletteUtil.getFileURL(stringArray[0]);
        URL uRL2 = PaletteUtil.getFileURL(stringArray[1]);
        if (uRL == null || uRL2 == null) {
            PaletteUtil.abort("Invalid Command Line Arguments Given");
        }
        PaletteUtil.loadPaletteItems(uRL, uRL2);
        System.exit(0);
    }
}

