/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.panels;

import java.util.Collections;
import java.util.EventListener;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.swing.event.EventListenerList;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.ApplyListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.MetaTraversable;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.NavigableUIContainer;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;

abstract class AbstractUIContainer
extends DefaultTraversablePanel
implements ApplyListener,
NavigableUIContainer {
    private EventListenerList _listeners;
    private Navigable[] _rootNavigables;
    private boolean _refreshNeeded;
    private transient TraversableContext _lastKnownTC;

    public void onEntry(TraversableContext traversableContext) {
        this._lastKnownTC = traversableContext;
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        this._lastKnownTC = traversableContext;
    }

    public String getHelpID() {
        Traversable traversable;
        Navigable navigable = this.getCurrentNavigable();
        String string = MetaTraversable.findHelpID(navigable, traversable = this.getCurrentTraversable());
        if (string == null) {
            string = super.getHelpID();
        }
        return string;
    }

    public void addApplyListener(ApplyListener applyListener) {
        this.addListener(ApplyListener.class, applyListener);
    }

    public void removeApplyListener(ApplyListener applyListener) {
        this.removeListener(ApplyListener.class, applyListener);
    }

    public void apply(ApplyEvent applyEvent) {
        this.fireApply(applyEvent);
    }

    public void cancel(ApplyEvent applyEvent) {
        this.fireCancel(applyEvent);
    }

    public void setRootNavigables(Navigable[] navigableArray) {
        this._rootNavigables = navigableArray;
        this._refreshNeeded = true;
    }

    public boolean displayDetailNodesAsChildren() {
        return true;
    }

    protected void addListener(Class clazz, EventListener eventListener) {
        if (this._listeners == null) {
            this._listeners = new EventListenerList();
        }
        this._listeners.add(clazz, eventListener);
    }

    protected void removeListener(Class clazz, EventListener eventListener) {
        if (this._listeners != null) {
            this._listeners.remove(clazz, eventListener);
        }
    }

    protected Navigable[] getRootNavigables() {
        return this._rootNavigables;
    }

    protected final void maybeRefreshUI(TraversableContext traversableContext) {
        if (this._refreshNeeded) {
            this._refreshNeeded = false;
            this.refreshUI(traversableContext);
        }
    }

    protected abstract void refreshUI(TraversableContext var1);

    protected abstract Navigable getCurrentNavigable();

    protected abstract Traversable getCurrentTraversable();

    protected TraversableContext newTraversableContext() {
        TraversableContext traversableContext;
        Navigable navigable = this.getCurrentNavigable();
        Namespace namespace = navigable.getDataScope();
        if (namespace != null) {
            traversableContext = new TraversableContext((MetaTraversable)navigable, namespace, 0);
            traversableContext.setDesignTimeParent(this._lastKnownTC);
        } else {
            traversableContext = new TraversableContext((MetaTraversable)navigable, this._lastKnownTC, 0);
        }
        traversableContext.putDesignTimeObject("navigable-ui-container", this);
        return traversableContext;
    }

    protected Iterator getListenerIterator(Class clazz) {
        if (this._listeners == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        Object[] objectArray = this._listeners.getListenerList();
        return new 1I(this, objectArray, clazz);
    }

    protected void fireApply(ApplyEvent applyEvent) {
        Iterator iterator = this.getListenerIterator(ApplyListener.class);
        while (iterator.hasNext()) {
            ((ApplyListener)iterator.next()).apply(applyEvent);
        }
    }

    protected void fireCancel(ApplyEvent applyEvent) {
        Iterator iterator = this.getListenerIterator(ApplyListener.class);
        while (iterator.hasNext()) {
            ((ApplyListener)iterator.next()).cancel(applyEvent);
        }
    }

    AbstractUIContainer() {
    }

    class 1I
    implements Iterator {
        int _i;
        private final /* synthetic */ Object[] v$listeners;
        private final /* synthetic */ Class v$listenerClass;
        final /* synthetic */ AbstractUIContainer this$0;

        1I(AbstractUIContainer abstractUIContainer, Object[] objectArray, Class clazz) {
            this.v$listenerClass = clazz;
            this.v$listeners = objectArray;
            this.this$0 = abstractUIContainer;
            this._i = objectArray != null ? objectArray.length : -1;
            this.gotoNext();
        }

        public boolean hasNext() {
            return this._i >= 0;
        }

        public Object next() {
            if (this._i < 0) {
                throw new NoSuchElementException();
            }
            Object object = this.v$listeners[this._i + 1];
            this.gotoNext();
            return object;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void gotoNext() {
            this._i -= 2;
            while (this._i >= 0) {
                if (this.v$listeners[this._i] == this.v$listenerClass) break;
                this._i -= 2;
            }
        }
    }
}

