/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.panels;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.resource.PanelsArb;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.util.SwingUtils;

class ExceptionPanel
extends DefaultTraversablePanel {
    public static final String EXCEPTION_KEY = "ExceptionPanel.exception.key";
    private final JTextArea textArea;
    private Throwable lastException;

    void $init$() {
        this.textArea = new JTextArea();
    }

    ExceptionPanel() {
        this((Exception)null);
        this.textArea.setEditable(false);
    }

    ExceptionPanel(Exception exception) {
        this.$init$();
        JLabel jLabel = new JLabel(PanelsArb.getString(32));
        this.maybeSetExceptionText(exception);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add((Component)this.textArea, null);
        this.setLayout(new GridBagLayout());
        Insets insets = new Insets(5, 5, 5, 5);
        this.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
        this.add((Component)jScrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, insets, 0, 0));
    }

    public void onEntry(TraversableContext traversableContext) {
        this.maybeSetExceptionText((Exception)traversableContext.getDesignTimeObject(EXCEPTION_KEY));
        if (this.lastException != null) {
            Object object = traversableContext.getDesignTimeObject("navigable-ui-container");
            Frame frame = null;
            if (object instanceof Frame) {
                frame = (Frame)object;
            }
            if (frame == null) {
                frame = SwingUtils.getMainWindow();
            }
            ExceptionDialog.showExceptionDialog((Component)frame, (Throwable)this.lastException);
        }
    }

    private void maybeSetExceptionText(Exception exception) {
        Throwable throwable = exception;
        if (throwable != null) {
            while (throwable.getCause() != null) {
                throwable = throwable.getCause();
            }
            this.textArea.setEditable(true);
            this.textArea.setText(ExceptionPanel.getThrowableText(throwable));
            this.textArea.setEditable(false);
            this.lastException = throwable;
        }
    }

    private static String getThrowableText(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }
}

