/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.panels;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.controls.JSelectableLabel;
import oracle.ide.controls.WaitCursor;
import oracle.ide.panels.AbstractUIContainer;
import oracle.ide.panels.ExceptionPanel;
import oracle.ide.panels.MDDEvent;
import oracle.ide.panels.MDDListener;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.NavigableContext;
import oracle.ide.panels.TitledPanel;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.resource.PanelsArb;
import oracle.ide.util.AccessibleUtils;
import oracle.javatools.dialogs.ExceptionDialog;

public class MDDPanel
extends AbstractUIContainer {
    public static final String CURRENT_TREE1 = "MDDPanel.CURRENT_TREE1";
    public static final String CURRENT_TREE1_MODEL = "MDDPanel.CURRENT_TREE1_MODEL";
    public static final String CURRENT_TREE1_NODE = "MDDPanel.CURRENT_TREE1_NODE";
    public static final String CURRENT_TRAVERSABLE = "MDDPanel.CURRENT_TRAVERSABLE";
    public static final String CURRENT_TRAVERSABLE_HINT_TEXT = "MDDPanel.CURRENT_TRAVERSABLE_HINT_TEXT";
    public static final String TREE_PANEL_NORTH = "North";
    public static final String TREE_PANEL_SOUTH = "South";
    public static final String TREE_PANEL_EAST = "East";
    public static final String TREE_PANEL_WEST = "West";
    private static final boolean _debug = Boolean.getBoolean("MDDPanel.debug");
    private final Tcr _tcr;
    private final Tsl _tsl;
    private final DefaultMutableTreeNode root1;
    private final JScrollPane jScrollPane1;
    private final JTree jTree1;
    private final DefaultMutableTreeNode root2;
    private final JScrollPane jScrollPane2;
    private final JTree jTree2;
    private final JPanel _treePanel;
    private final JPanel detailJPanel;
    private final CardLayout mddCardLayout;
    private final TitledPanel titledPanel;
    private final JSplitPane jSplitPane1;
    private final JSplitPane jSplitPane2;
    private final HashMap _navTravMap;
    private final boolean _useDetailTree;
    private Navigable _curNavigable;
    private Traversable _curTraversable;
    private final ArrayList _compKeys;
    private int _nextCardLayoutKey;
    private transient boolean _onEntryCalled;
    private int _titleDepth;
    private transient boolean _childComparatorIsSet;
    private Comparator _childComparator;
    private Comparator _defaultChildComparator;
    private boolean _selectionDelay;
    private MDDPanelHintHandler _hintHandler;
    private ExceptionPanel exceptionPanel;

    void $init$() {
        this._tcr = new Tcr(null);
        this._tsl = new Tsl();
        this.root1 = new DefaultMutableTreeNode();
        this.jScrollPane1 = new JScrollPane();
        this.jTree1 = MDDPanel.newJTree(this.root1, this._tcr, this._tsl, PanelsArb.getString(34));
        this._treePanel = new JPanel();
        this.detailJPanel = new JPanel();
        this.mddCardLayout = new CardLayout();
        this._navTravMap = new HashMap();
        this._compKeys = new ArrayList();
        this._nextCardLayoutKey = 0;
        this._titleDepth = 1;
        this._selectionDelay = true;
        this.exceptionPanel = null;
    }

    protected MDDPanel() {
        this((Navigable[])null, false);
    }

    public MDDPanel(Navigable navigable) {
        this(new Navigable[]{navigable});
    }

    public MDDPanel(Navigable[] navigableArray) {
        this(navigableArray, false);
    }

    public MDDPanel(Navigable[] navigableArray, boolean bl) {
        this.$init$();
        this.setRootNavigables(navigableArray);
        this._useDetailTree = bl;
        this._treePanel.setLayout(new BorderLayout());
        ToolTipManager.sharedInstance().registerComponent(this.jTree1);
        if (bl) {
            this.root2 = new DefaultMutableTreeNode();
            this.jScrollPane2 = new JScrollPane();
            this.jTree2 = MDDPanel.newJTree(this.root2, this._tcr, this._tsl, PanelsArb.getString(35));
            ToolTipManager.sharedInstance().registerComponent(this.jTree2);
            this.jSplitPane1 = new JSplitPane(0, this.jScrollPane1, this.jScrollPane2);
            this.jSplitPane1.setBorder(null);
            this.jSplitPane1.setResizeWeight(0.4);
            this._treePanel.add((Component)this.jSplitPane1, "Center");
            this.titledPanel = null;
            this.jSplitPane2 = new JSplitPane(1, this._treePanel, this.detailJPanel);
        } else {
            this.root2 = null;
            this.jScrollPane2 = null;
            this.jTree2 = null;
            this.jSplitPane1 = null;
            this._treePanel.add((Component)this.jScrollPane1, "Center");
            this.titledPanel = this.createTitledPanel(this.detailJPanel);
            this.jSplitPane2 = new JSplitPane(1, this._treePanel, this.titledPanel);
        }
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(565, 310));
        Dimension dimension = new Dimension(20, 20);
        this.jScrollPane1.setMinimumSize(dimension);
        this.jScrollPane1.setBorder(null);
        Dimension dimension2 = new Dimension(170, 200);
        this.jScrollPane1.setPreferredSize(dimension2);
        this.jScrollPane1.getViewport().add((Component)this.jTree1, null);
        if (this.jScrollPane2 != null) {
            this.jScrollPane2.getViewport().add((Component)this.jTree2, null);
            this.jScrollPane2.setMinimumSize(dimension);
            this.jScrollPane2.setPreferredSize(dimension2);
            this.jScrollPane2.setBorder(null);
        }
        this.detailJPanel.setMinimumSize(new Dimension(100, 100));
        this.detailJPanel.setPreferredSize(new Dimension(365, 210));
        this.detailJPanel.setLayout(this.mddCardLayout);
        this.jSplitPane2.setDividerSize(7);
        this.add((Component)this.jSplitPane2, "Center");
        this.jSplitPane2.setBorder(BorderFactory.createEmptyBorder());
        this.jScrollPane1.setBorder(BorderFactory.createLineBorder(SystemColor.controlShadow));
        this._hintHandler = new MDDPanelHintHandler(null);
    }

    protected TitledPanel createTitledPanel(JPanel jPanel) {
        TitledPanel titledPanel = new TitledPanel(jPanel);
        titledPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        return titledPanel;
    }

    public boolean displayDetailNodesAsChildren() {
        return this._useDetailTree ^ true;
    }

    public void onEntry(TraversableContext traversableContext) {
        this._onEntryCalled = true;
        super.onEntry(traversableContext);
        this.maybeRefreshUI(traversableContext);
        Traversable traversable = this.getCurrentTraversable();
        if (traversable != null) {
            this.enterTraversable(traversable);
        } else {
            Navigable[] navigableArray = this.getRootNavigables();
            if (navigableArray != null && navigableArray.length > 0) {
                this.setTree1SelectionRow(0);
            }
        }
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        super.onExit(traversableContext);
        Traversable traversable = this.getCurrentTraversable();
        if (traversable != null) {
            this.exitTraversable(traversable);
        }
        Tsl.ra$_timer(this._tsl).stop();
    }

    public void expandTree1ToDepth(int n) {
        this.assertOnEntryCalled("expandTree1ToDepth");
        MDDPanel.expandTreeToDepth(this.jTree1, n);
    }

    public void expandTree1Path(String[] stringArray) {
        this.assertOnEntryCalled("expandTree1Path");
        TreePath treePath = this.convertPath(stringArray);
        if (treePath != null) {
            this.jTree1.expandPath(treePath);
        }
    }

    public void setTree1SelectionRow(int n) {
        this.assertOnEntryCalled("setTree1SelectionRow");
        this.jTree1.setSelectionRow(n);
    }

    public void setTree1SelectionPath(String[] stringArray) {
        this.assertOnEntryCalled("setTree1SelectionPath");
        TreePath treePath = this.convertPath(stringArray);
        if (treePath != null) {
            this.jTree1.setSelectionPath(treePath);
        }
    }

    public String[] getTree1SelectionPath() {
        this.assertOnEntryCalled("getTree1SelectionPath");
        TreePath treePath = this.jTree1.getSelectionPath();
        int n = treePath == null ? 1 : treePath.getPathCount();
        String[] stringArray = new String[n - 1];
        int n2 = 1;
        while (n2 < n) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getPathComponent(n2);
            Navigable navigable = (Navigable)defaultMutableTreeNode.getUserObject();
            stringArray[n2 - 1] = MDDPanel.getShortLabelFromNavigable(navigable);
            ++n2;
        }
        return stringArray;
    }

    public void setMainDividerLocation(double d) {
        if (this.jSplitPane2 != null) {
            this.jSplitPane2.setDividerLocation(d);
        }
    }

    public void setMainDividerSize(int n) {
        if (this.jSplitPane2 != null) {
            this.jSplitPane2.setDividerSize(n);
        }
    }

    public void setMainResizeWeight(double d) {
        if (this.jSplitPane2 != null) {
            this.jSplitPane2.setResizeWeight(d);
        }
    }

    public void setDetailDividerLocation(double d) {
        if (this.jSplitPane1 != null) {
            this.jSplitPane1.setDividerLocation(d);
        }
    }

    public void setDetailDividerSize(int n) {
        if (this.jSplitPane1 != null) {
            this.jSplitPane1.setDividerSize(n);
        }
    }

    public void setDetailResizeWeight(double d) {
        if (this.jSplitPane1 != null) {
            this.jSplitPane1.setResizeWeight(d);
        }
    }

    public void setTitleDepth(int n) {
        this._titleDepth = n;
    }

    public int getTitleDepth() {
        return this._titleDepth;
    }

    public void setChildComparator(Comparator comparator) {
        this._childComparator = comparator;
        this._childComparatorIsSet = true;
    }

    public Comparator getChildComparator() {
        return this._childComparator;
    }

    public void setDefaultChildComparator(Comparator comparator) {
        this._defaultChildComparator = comparator;
        if (!this._childComparatorIsSet) {
            this._childComparator = comparator;
        }
    }

    public Comparator getDefaultChildComparator() {
        return this._defaultChildComparator;
    }

    public void addMDDListener(MDDListener mDDListener) {
        this.addListener(MDDListener.class, mDDListener);
    }

    public void removeMDDListener(MDDListener mDDListener) {
        this.removeListener(MDDListener.class, mDDListener);
    }

    public void addTreePanelComponent(Component component, Object object) {
        if (object != TREE_PANEL_NORTH && object != TREE_PANEL_SOUTH && object != TREE_PANEL_EAST && object != TREE_PANEL_WEST) {
            throw new IllegalArgumentException("Invalid tree panel layout constraint.  Use only the defined constants.");
        }
        this._treePanel.add(component, object);
    }

    public boolean enableSelectionDelay(boolean bl) {
        boolean bl2 = this._selectionDelay;
        this._selectionDelay = bl;
        return bl2;
    }

    protected Navigable getCurrentNavigable() {
        return this._curNavigable;
    }

    protected Traversable getCurrentTraversable() {
        return this._curTraversable;
    }

    protected TraversableContext newTraversableContext() {
        TreePath treePath;
        TraversableContext traversableContext = super.newTraversableContext();
        if (this.jTree1 != null) {
            traversableContext.putDesignTimeObject(CURRENT_TREE1, this.jTree1);
            traversableContext.putDesignTimeObject(CURRENT_TREE1_MODEL, this.jTree1.getModel());
        }
        if ((treePath = this.jTree1.getSelectionPath()) != null) {
            traversableContext.putDesignTimeObject(CURRENT_TREE1_NODE, treePath.getLastPathComponent());
        }
        traversableContext.putDesignTimeObject(CURRENT_TRAVERSABLE, this.getCurrentTraversable());
        return traversableContext;
    }

    protected void refreshUI(TraversableContext traversableContext) {
        this.root1.removeAllChildren();
        Navigable[] navigableArray = this.getRootNavigables();
        if (navigableArray == null) {
            return;
        }
        int n = navigableArray.length;
        NavigableContext navigableContext = new NavigableContext(traversableContext, this.displayDetailNodesAsChildren());
        navigableContext.getScope().put("Navigable.DEFAULT_CHILD_COMPARATOR_KEY", (Object)this._defaultChildComparator);
        navigableArray = Navigable.sortNavigables(navigableArray, this._childComparator);
        int n2 = 0;
        while (n2 < n) {
            block7: {
                Navigable navigable = navigableArray[n2];
                if (navigable != null) {
                    try {
                        DefaultMutableTreeNode defaultMutableTreeNode = navigable.createTreeNode(navigableContext);
                        if (defaultMutableTreeNode != null) {
                            this.root1.add(defaultMutableTreeNode);
                        }
                    }
                    catch (Throwable throwable) {
                        if (!(throwable instanceof ThreadDeath)) break block7;
                        throw (ThreadDeath)throwable;
                    }
                }
            }
            ++n2;
        }
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(this.root1);
        defaultTreeModel.addTreeModelListener(this._tsl);
        this.jTree1.setModel(defaultTreeModel);
        if (this.jSplitPane1 != null) {
            this.jSplitPane1.setDividerLocation(0.4);
        }
    }

    protected void fireTraversableEntered(TraversableContext traversableContext) {
        MDDEvent mDDEvent = null;
        Iterator iterator = this.getListenerIterator(MDDListener.class);
        while (iterator.hasNext()) {
            if (mDDEvent == null) {
                mDDEvent = new MDDEvent(traversableContext);
            }
            ((MDDListener)iterator.next()).traversableEntered(mDDEvent);
        }
    }

    protected JSplitPane getMainSplitPane() {
        return this.jSplitPane2;
    }

    protected JSplitPane getDetailSplitPane() {
        return this.jSplitPane1;
    }

    protected JPanel getDetailPanel() {
        return this.detailJPanel;
    }

    private void assertOnEntryCalled(String string) {
    }

    private static String getShortLabelFromNavigable(Navigable navigable) {
        String string = navigable.getShortLabel();
        if (string == null) {
            string = PanelsArb.getString(33);
        }
        return string;
    }

    private void forceChildLoad(DefaultMutableTreeNode defaultMutableTreeNode, boolean bl) {
        if (defaultMutableTreeNode.getUserObject() == null) {
            return;
        }
        Navigable navigable = (Navigable)defaultMutableTreeNode.getUserObject();
        NavigableContext navigableContext = null;
        int n = 0;
        int n2 = defaultMutableTreeNode.getChildCount();
        while (n < n2) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n);
            Object object = defaultMutableTreeNode2.getUserObject();
            if (object instanceof NavigableContext) {
                defaultMutableTreeNode.remove(n);
                navigableContext = (NavigableContext)object;
                break;
            }
            ++n;
        }
        if (navigableContext != null) {
            WaitCursor waitCursor;
            WaitCursor waitCursor2 = waitCursor = bl ? Ide.getWaitCursor() : null;
            if (waitCursor != null) {
                waitCursor.show();
            }
            try {
                navigableContext.setScope(navigable.getDataScope());
                navigable.lazyLoadChildNavigables(defaultMutableTreeNode, navigableContext);
            }
            finally {
                if (waitCursor != null) {
                    waitCursor.hide();
                }
            }
        }
    }

    private TreePath findPath(TreePath treePath, String[] stringArray, int n) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        this.forceChildLoad(defaultMutableTreeNode, false);
        int n2 = defaultMutableTreeNode.getChildCount();
        int n3 = 0;
        while (n3 < n2) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n3);
            Navigable navigable = (Navigable)defaultMutableTreeNode2.getUserObject();
            String string = MDDPanel.getShortLabelFromNavigable(navigable);
            if (string.equals(stringArray[n])) {
                TreePath treePath2 = treePath.pathByAddingChild(defaultMutableTreeNode2);
                if (++n < stringArray.length) {
                    return this.findPath(treePath2, stringArray, n);
                }
                return treePath2;
            }
            ++n3;
        }
        return null;
    }

    private TreePath convertPath(String[] stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            TreePath treePath = new TreePath(this.root1);
            return this.findPath(treePath, stringArray, 0);
        }
        return null;
    }

    private void enterTraversable(Traversable traversable) {
        WaitCursor waitCursor = new WaitCursor(this);
        waitCursor.show();
        TraversableContext traversableContext = this.newTraversableContext();
        try {
            try {
                this.enterTraversableImpl(traversable, traversableContext);
            }
            catch (Exception exception) {
                if (this.exceptionPanel == null) {
                    this.exceptionPanel = new ExceptionPanel();
                }
                traversableContext.putDesignTimeObject("ExceptionPanel.exception.key", exception);
                this.enterTraversableImpl(this.exceptionPanel, traversableContext);
            }
        }
        finally {
            try {
                this.fireTraversableEntered(traversableContext);
            }
            finally {
                waitCursor.hide();
                waitCursor.detach((RootPaneContainer)((Object)SwingUtilities.getAncestorOfClass(RootPaneContainer.class, this)));
            }
        }
    }

    private void enterTraversableImpl(Traversable traversable, TraversableContext traversableContext) {
        traversable.onEntry(traversableContext);
        String string = this.getCardLayoutKey(traversable.getComponent());
        this.mddCardLayout.show(this.detailJPanel, string);
        if (this.titledPanel != null && this._titleDepth > 0) {
            Object[] objectArray;
            int n;
            TreePath treePath = this.jTree1.getSelectionModel().getLeadSelectionPath();
            String string2 = null;
            if (treePath != null && (n = (objectArray = treePath.getPath()).length) > 1) {
                int n2 = Math.min(this._titleDepth, n - 1);
                int n3 = Math.max(n - this._titleDepth, 1);
                string2 = objectArray[n3].toString();
                int n4 = 1;
                while (n4 < n2) {
                    string2 = PanelsArb.format(36, string2, objectArray[n3 + n4].toString());
                    ++n4;
                }
            }
            this.titledPanel.setTitle(string2);
        }
        this.detailJPanel.validate();
        this._hintHandler.onEntry(traversable, traversableContext);
    }

    private void exitTraversable(Traversable traversable) throws TraversalException {
        TraversableContext traversableContext = this.newTraversableContext();
        try {
            traversable.onExit(traversableContext);
            this._hintHandler.onExit(traversable, traversableContext);
        }
        catch (TraversalException traversalException) {
            throw traversalException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            ExceptionDialog.showExceptionDialog((Component)this, (Throwable)exception);
        }
    }

    private String getCardLayoutKey(Component component) {
        String string = this.findCardLayoutKey(component);
        return string != null ? string : this.createCardLayoutKey(component);
    }

    private String findCardLayoutKey(Component component) {
        for (CompKey compKey : this._compKeys) {
            if (compKey.comp != component) continue;
            return compKey.key;
        }
        return null;
    }

    private String createCardLayoutKey(Component component) {
        String string = Integer.toString(this._nextCardLayoutKey++);
        CompKey compKey = new CompKey(component, string);
        this._compKeys.add(compKey);
        this.detailJPanel.add(component, string);
        return string;
    }

    private Traversable getTraversable(Navigable navigable) {
        if (navigable == null) {
            return null;
        }
        Object object = navigable.isUsingTraversableDefaultConstructor() ? navigable.getTraversableClass() : navigable;
        if (this._navTravMap.containsKey(object)) {
            return (Traversable)this._navTravMap.get(object);
        }
        Traversable traversable = navigable.newTraversable(this);
        this._navTravMap.put(object, traversable);
        return traversable;
    }

    private static JTree newJTree(DefaultMutableTreeNode defaultMutableTreeNode, TreeCellRenderer treeCellRenderer, Tsl tsl, String string) {
        JTree jTree = new JTree(defaultMutableTreeNode);
        jTree.setCellRenderer(treeCellRenderer);
        jTree.getSelectionModel().setSelectionMode(1);
        jTree.setRootVisible(false);
        jTree.setShowsRootHandles(true);
        jTree.addTreeSelectionListener(tsl);
        jTree.addFocusListener(tsl);
        jTree.addTreeWillExpandListener(tsl);
        if (jTree.getModel() != null) {
            AccessibleUtils.updateAccessibleName(jTree, string, false);
        }
        return jTree;
    }

    private static void expandTreeToDepth(JTree jTree, int n) {
        TreePath treePath = jTree.getSelectionPath();
        int n2 = 0;
        while (n2 < jTree.getRowCount()) {
            if (n <= 0) {
                jTree.expandRow(n2);
            } else {
                TreePath treePath2 = jTree.getPathForRow(n2);
                if (treePath2 != null && treePath2.getPathCount() <= n) {
                    jTree.expandRow(n2);
                } else {
                    jTree.collapseRow(n2);
                }
            }
            ++n2;
        }
        if (treePath != null) {
            jTree.setSelectionPath(treePath);
        } else {
            jTree.setSelectionRow(0);
        }
    }

    static void wa$_curNavigable(MDDPanel mDDPanel, Navigable navigable) {
        mDDPanel._curNavigable = navigable;
    }

    static Navigable ra$_curNavigable(MDDPanel mDDPanel) {
        return mDDPanel._curNavigable;
    }

    static Traversable ra$_curTraversable(MDDPanel mDDPanel) {
        return mDDPanel._curTraversable;
    }

    static void mav$exitTraversable(MDDPanel mDDPanel, Traversable traversable) {
        mDDPanel.exitTraversable(traversable);
    }

    static JTree ra$jTree1(MDDPanel mDDPanel) {
        return mDDPanel.jTree1;
    }

    static JTree ra$jTree2(MDDPanel mDDPanel) {
        return mDDPanel.jTree2;
    }

    static Traversable mav$getTraversable(MDDPanel mDDPanel, Navigable navigable) {
        return mDDPanel.getTraversable(navigable);
    }

    static void wa$_curTraversable(MDDPanel mDDPanel, Traversable traversable) {
        mDDPanel._curTraversable = traversable;
    }

    static void mav$enterTraversable(MDDPanel mDDPanel, Traversable traversable) {
        mDDPanel.enterTraversable(traversable);
    }

    static void mav$forceChildLoad(MDDPanel mDDPanel, DefaultMutableTreeNode defaultMutableTreeNode, boolean bl) {
        mDDPanel.forceChildLoad(defaultMutableTreeNode, bl);
    }

    static boolean ra$_selectionDelay(MDDPanel mDDPanel) {
        return mDDPanel._selectionDelay;
    }

    static String maS$getShortLabelFromNavigable(Navigable navigable) {
        return MDDPanel.getShortLabelFromNavigable(navigable);
    }

    static boolean ra$_debug() {
        return _debug;
    }

    private class CompKey {
        final Component comp;
        final String key;

        CompKey(Component component, String string) {
            this.comp = component;
            this.key = string;
        }
    }

    private class Tsl
    implements ActionListener,
    FocusListener,
    TreeModelListener,
    TreeWillExpandListener,
    TreeSelectionListener {
        private TreePath _curTreePath;
        private Object _lastTreeWithFocus;
        private final HashMap _detailTreeCache;
        private final Timer _timer;
        private TreeSelectionEvent _selectionEvent;

        void $init$() {
            this._curTreePath = null;
            this._lastTreeWithFocus = null;
        }

        public Tsl() {
            this.$init$();
            this._detailTreeCache = MDDPanel.ra$jTree2(MDDPanel.this) != null ? new HashMap() : null;
            this._timer = new Timer(250, this);
            this._timer.setRepeats(false);
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            if (treeSelectionEvent.isAddedPath()) {
                if (MDDPanel.ra$_selectionDelay(MDDPanel.this)) {
                    this._timer.restart();
                    this._selectionEvent = treeSelectionEvent;
                } else {
                    this.updateSelection(treeSelectionEvent);
                }
            }
        }

        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            if (MDDPanel.ra$_curTraversable(MDDPanel.this) != null) {
                Object[] objectArray = treeModelEvent.getChildren();
                int n = 0;
                while (n < objectArray.length) {
                    Traversable traversable;
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)objectArray[n];
                    Navigable navigable = (Navigable)defaultMutableTreeNode.getUserObject();
                    if (navigable == MDDPanel.ra$_curNavigable(MDDPanel.this) && (traversable = MDDPanel.mav$getTraversable(MDDPanel.this, navigable)) == MDDPanel.ra$_curTraversable(MDDPanel.this)) {
                        MDDPanel.wa$_curTraversable(MDDPanel.this, null);
                        this._curTreePath = null;
                    }
                    ++n;
                }
            }
        }

        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        }

        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        }

        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        }

        public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) {
            boolean bl;
            TreePath treePath = treeExpansionEvent.getPath();
            boolean bl2 = bl = treePath.getPathCount() == 1;
            if (bl) {
                return;
            }
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            MDDPanel.mav$forceChildLoad(MDDPanel.this, defaultMutableTreeNode, true);
        }

        public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.updateSelection(this._selectionEvent);
        }

        private void updateSelection(TreeSelectionEvent treeSelectionEvent) {
            JTree jTree = (JTree)treeSelectionEvent.getSource();
            this.updateSelectedNavigable(jTree, treeSelectionEvent.getNewLeadSelectionPath());
        }

        public void focusGained(FocusEvent focusEvent) {
            Object object = focusEvent.getSource();
            if (object == null || this._lastTreeWithFocus != object) {
                // empty if block
            }
        }

        public void focusLost(FocusEvent focusEvent) {
        }

        private void updateSelectedNavigable(JTree jTree, TreePath treePath) {
            if (MDDPanel.ra$_curTraversable(MDDPanel.this) != null) {
                try {
                    MDDPanel.mav$exitTraversable(MDDPanel.this, MDDPanel.ra$_curTraversable(MDDPanel.this));
                }
                catch (TraversalException traversalException) {
                    traversalException.showMessageDialog(MDDPanel.this);
                    jTree.removeTreeSelectionListener(this);
                    jTree.removeFocusListener(this);
                    try {
                        jTree.expandPath(this._curTreePath);
                        jTree.setSelectionPath(this._curTreePath);
                    }
                    finally {
                        jTree.addTreeSelectionListener(this);
                        jTree.addFocusListener(this);
                    }
                    return;
                }
            }
            Navigable navigable = null;
            Traversable traversable = null;
            if (jTree == MDDPanel.ra$jTree1(MDDPanel.this)) {
                navigable = this.unwrapSelectedNavigable(MDDPanel.ra$jTree1(MDDPanel.this));
                if (MDDPanel.ra$jTree2(MDDPanel.this) == null) {
                    traversable = MDDPanel.mav$getTraversable(MDDPanel.this, navigable);
                } else {
                    DefaultMutableTreeNode defaultMutableTreeNode;
                    if (this._detailTreeCache.containsKey(navigable)) {
                        defaultMutableTreeNode = (DefaultMutableTreeNode)this._detailTreeCache.get(navigable);
                    } else {
                        NavigableContext navigableContext = new NavigableContext(navigable.getDataScope(), MDDPanel.this.displayDetailNodesAsChildren());
                        defaultMutableTreeNode = navigable.createDetailRootNode(navigableContext);
                        this._detailTreeCache.put(navigable, defaultMutableTreeNode);
                    }
                    if (MDDPanel.ra$jTree2(MDDPanel.this).getModel().getRoot() != defaultMutableTreeNode) {
                        MDDPanel.ra$jTree2(MDDPanel.this).setModel(new DefaultTreeModel(defaultMutableTreeNode));
                    }
                    traversable = MDDPanel.mav$getTraversable(MDDPanel.this, navigable);
                }
            } else if (jTree == MDDPanel.ra$jTree2(MDDPanel.this)) {
                navigable = this.unwrapSelectedNavigable(MDDPanel.ra$jTree2(MDDPanel.this));
                traversable = MDDPanel.mav$getTraversable(MDDPanel.this, navigable);
            }
            if (traversable != null) {
                MDDPanel.wa$_curTraversable(MDDPanel.this, traversable);
                this._curTreePath = treePath;
                MDDPanel.mav$enterTraversable(MDDPanel.this, traversable);
            }
        }

        private Navigable unwrapSelectedNavigable(JTree jTree) {
            TreePath treePath = jTree.getSelectionPath();
            if (treePath == null) {
                return null;
            }
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            MDDPanel.wa$_curNavigable(MDDPanel.this, (Navigable)defaultMutableTreeNode.getUserObject());
            return MDDPanel.ra$_curNavigable(MDDPanel.this);
        }

        static Timer ra$_timer(Tsl tsl) {
            return tsl._timer;
        }
    }

    private static class Tcr
    implements TreeCellRenderer {
        private final JSelectableLabel _label;

        void $init$() {
            this._label = new JSelectableLabel();
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            this._label.setEnabled(jTree.isEnabled());
            this._label.setSelected(bl);
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            Navigable navigable = (Navigable)defaultMutableTreeNode.getUserObject();
            Font font = this._label.getFont();
            if (navigable != null) {
                String string = MDDPanel.maS$getShortLabelFromNavigable(navigable);
                this._label.setText(string);
                this._label.setIcon(navigable.getIcon());
                if (MDDPanel.ra$_debug()) {
                    StringBuffer stringBuffer = new StringBuffer();
                    String string2 = navigable.getToolTipText();
                    if (string2 != null) {
                        stringBuffer.append(string2).append(" (");
                    } else {
                        stringBuffer.append("(");
                    }
                    Class clazz = navigable.getTraversableClass();
                    stringBuffer.append(clazz != null ? clazz.getName() : navigable.getClass().getName()).append(")");
                    this._label.setToolTipText(stringBuffer.toString());
                } else {
                    this._label.setToolTipText(navigable.getToolTipText());
                }
                switch (navigable.getDisplayStyle()) {
                    case 0: {
                        font = font.deriveFont(0);
                        break;
                    }
                    case 1: {
                        font = font.deriveFont(1);
                        break;
                    }
                    case 2: {
                        font = font.deriveFont(2);
                    }
                }
            } else {
                this._label.setText(null);
                this._label.setIcon(null);
                this._label.setToolTipText(null);
                font = font.deriveFont(0);
            }
            this._label.setFont(font);
            this._label.setHasFocus(bl4);
            return this._label;
        }

        private Tcr() {
            this.$init$();
        }

        Tcr(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static class MDDPanelHintHandler
    extends WindowAdapter
    implements AWTEventListener {
        private Component _traversableComponent;
        private String _hintText;
        private JEWTDialog _parentDialog;
        private boolean _listenerAdded;

        public void onEntry(Traversable traversable, TraversableContext traversableContext) {
            if (this._parentDialog == null) {
                this._parentDialog = this.getParentDialog(traversable.getComponent());
                if (this._parentDialog != null) {
                    this._parentDialog.addWindowListener((WindowListener)this);
                }
            }
            if (this._parentDialog != null && traversableContext.contains(MDDPanel.CURRENT_TRAVERSABLE_HINT_TEXT)) {
                this._hintText = (String)traversableContext.get(MDDPanel.CURRENT_TRAVERSABLE_HINT_TEXT);
                traversableContext.remove(MDDPanel.CURRENT_TRAVERSABLE_HINT_TEXT);
                this.addListener(traversable);
            }
        }

        public void onExit(Traversable traversable, TraversableContext traversableContext) {
            this.removeListener();
            if (this._parentDialog != null) {
                this._parentDialog.getAccessibleContext().setAccessibleName("");
            }
        }

        public void windowClosed(WindowEvent windowEvent) {
            this._parentDialog.removeWindowListener((WindowListener)this);
            this.removeListener();
        }

        private void addListener(Traversable traversable) {
            this._traversableComponent = traversable.getComponent();
            if (!this._listenerAdded) {
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                toolkit.addAWTEventListener(this, 4);
                this._listenerAdded = true;
            }
        }

        private void removeListener() {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            toolkit.removeAWTEventListener(this);
            this._listenerAdded = false;
        }

        public void eventDispatched(AWTEvent aWTEvent) {
            int n = aWTEvent.getID();
            switch (n) {
                case 1004: {
                    this.whenFocusGained((FocusEvent)aWTEvent);
                }
            }
        }

        private void whenFocusGained(FocusEvent focusEvent) {
            if (focusEvent.isTemporary()) {
                return;
            }
            if (this.isComponentInTraversableComponent(focusEvent.getComponent())) {
                this._parentDialog.getAccessibleContext().setAccessibleName(this._hintText);
                this.removeListener();
            }
        }

        private JEWTDialog getParentDialog(Component component) {
            JEWTDialog jEWTDialog = null;
            Component component2 = component;
            while (component2.getParent() != null) {
                if (!((component2 = component2.getParent()) instanceof JEWTDialog)) continue;
                jEWTDialog = (JEWTDialog)component2;
                break;
            }
            return jEWTDialog;
        }

        private boolean isComponentInTraversableComponent(Component component) {
            boolean bl = false;
            Component component2 = component;
            while (component2.getParent() != null) {
                if ((component2 = component2.getParent()) != this._traversableComponent) continue;
                bl = true;
                break;
            }
            return bl;
        }

        private MDDPanelHintHandler() {
        }

        MDDPanelHintHandler(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

