/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.panels;

import java.lang.reflect.Constructor;
import oracle.ide.panels.Traversable;
import oracle.javatools.util.Copyable;

final class MetaCtor
implements Copyable {
    private String _classStr;
    private Class _class;
    private Class[] _ctorArgTypes;

    MetaCtor(String string, Class[] classArray) {
        this._classStr = string;
        this._ctorArgTypes = classArray;
    }

    MetaCtor(Class clazz, Class[] classArray) {
        this._class = clazz;
        this._ctorArgTypes = classArray;
    }

    private MetaCtor() {
    }

    public Object copyTo(Object object) {
        MetaCtor metaCtor = object != null ? (MetaCtor)object : new MetaCtor();
        this.copyToImpl(metaCtor);
        return metaCtor;
    }

    protected final void copyToImpl(MetaCtor metaCtor) {
        metaCtor._classStr = this._classStr;
        metaCtor._class = this._class;
        metaCtor._ctorArgTypes = this._ctorArgTypes;
    }

    Class getDeclaringClass() {
        try {
            this.maybeInitClass();
            Class clazz = this._class;
            return clazz;
        }
        catch (Exception exception) {
            Class clazz = null;
            return clazz;
        }
    }

    Constructor getConstructor() throws ClassNotFoundException, NoSuchMethodException {
        this.maybeInitClass();
        MetaCtor.validateClass(this._class);
        Constructor constructor = this._class.getDeclaredConstructor(this._ctorArgTypes);
        constructor.setAccessible(true);
        return constructor;
    }

    private void maybeInitClass() throws ClassNotFoundException, NoSuchMethodException {
        if (this._class == null) {
            this._class = Class.forName(this._classStr);
            this._classStr = null;
        }
    }

    private static void validateClass(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Unexpected null Traversable class.");
        }
        if (!Traversable.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("The specified class does not implement the Traversable interface: " + clazz.getName());
        }
    }
}

