/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.panels;

import java.awt.Component;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import javax.swing.JComponent;
import oracle.ide.panels.ApplyListener;
import oracle.ide.panels.ApplyNotifier;
import oracle.ide.panels.ExceptionPanel;
import oracle.ide.panels.MetaCtor;
import oracle.ide.panels.Traversable;
import oracle.javatools.util.Copyable;

public class MetaTraversable
implements Copyable {
    private MetaCtor _metaCtor;
    private Object[] _ctorArgs;
    private Constructor _travCtor;
    private String _helpID;
    private HashMap _nameLinks;

    public MetaTraversable(Class clazz) {
        this(clazz, null, null);
    }

    public MetaTraversable(Class clazz, Class[] classArray, Object[] objectArray) {
        this(null, clazz, classArray, objectArray);
    }

    protected MetaTraversable() {
    }

    protected MetaTraversable(String string) {
        this(string, null, null, null);
    }

    private MetaTraversable(String string, Class clazz, Class[] classArray, Object[] objectArray) {
        if (string != null) {
            this._metaCtor = new MetaCtor(string, classArray);
        } else if (clazz != null) {
            this._metaCtor = new MetaCtor(clazz, classArray);
        } else {
            return;
        }
        this._ctorArgs = objectArray;
    }

    public Object copyTo(Object object) {
        MetaTraversable metaTraversable = object != null ? (MetaTraversable)object : new MetaTraversable();
        this.copyToImpl(metaTraversable);
        return metaTraversable;
    }

    protected final void copyToImpl(MetaTraversable metaTraversable) {
        metaTraversable._metaCtor = this._metaCtor != null ? (MetaCtor)this._metaCtor.copyTo(null) : null;
        metaTraversable._ctorArgs = this._ctorArgs;
        metaTraversable._travCtor = this._travCtor;
        metaTraversable._helpID = this._helpID;
        metaTraversable._nameLinks = this._nameLinks != null ? new HashMap(this._nameLinks) : null;
    }

    public boolean isUsingTraversableDefaultConstructor() {
        if (this._metaCtor == null && this._travCtor == null) {
            return false;
        }
        return this._ctorArgs == null || this._ctorArgs.length == 0;
    }

    public Class getTraversableClass() {
        if (this._metaCtor != null) {
            return this._metaCtor.getDeclaringClass();
        }
        if (this._travCtor != null) {
            return this._travCtor.getDeclaringClass();
        }
        return null;
    }

    public Traversable newTraversable(ApplyNotifier applyNotifier) {
        Traversable traversable = null;
        try {
            traversable = this.newTraversable();
            if (applyNotifier != null && traversable instanceof ApplyListener) {
                applyNotifier.addApplyListener((ApplyListener)((Object)traversable));
            }
        }
        catch (Exception exception) {
            ExceptionPanel exceptionPanel = new ExceptionPanel(exception);
            return exceptionPanel;
        }
        return traversable;
    }

    public void setHelpID(String string) {
        this._helpID = string;
    }

    public void setNameLink(String string, String string2) {
        if (this._nameLinks == null) {
            this._nameLinks = new HashMap();
        }
        this._nameLinks.put(string, string2);
    }

    protected Traversable newTraversable() {
        try {
            this.maybeInitTravCtor();
            Traversable traversable = (Traversable)this._travCtor.newInstance(this._ctorArgs);
            return traversable;
        }
        catch (Exception exception) {
            ExceptionPanel exceptionPanel = new ExceptionPanel(exception);
            return exceptionPanel;
        }
    }

    String getNameLink(String string) {
        if (this._nameLinks == null || !this._nameLinks.containsKey(string)) {
            return string;
        }
        Object v = this._nameLinks.get(string);
        return v != null ? v.toString() : null;
    }

    public static final String findHelpID(MetaTraversable metaTraversable, Traversable traversable) {
        String string;
        String string2 = string = metaTraversable != null ? metaTraversable.getHelpID() : null;
        if (string == null) {
            string = MetaTraversable.findHelpID(traversable);
        }
        return string;
    }

    static final String findHelpID(Traversable traversable) {
        String string = null;
        if (traversable != null) {
            try {
                string = traversable.getHelpID();
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            if (string == null) {
                Component component = traversable.getComponent();
                while (component != null) {
                    Object object;
                    if (component instanceof JComponent && (object = ((JComponent)component).getClientProperty("HelpID")) instanceof String) {
                        string = (String)object;
                        break;
                    }
                    component = component.getParent();
                }
            }
        }
        return string;
    }

    private String getHelpID() {
        return this._helpID;
    }

    private void maybeInitTravCtor() {
        if (this._travCtor == null && this._metaCtor != null) {
            try {
                this._travCtor = this._metaCtor.getConstructor();
            }
            catch (Exception exception) {
                this.handleInitException(exception);
            }
            this._metaCtor = null;
        }
    }

    private void handleInitException(Exception exception) {
        try {
            this._travCtor = ExceptionPanel.class.getConstructor(Exception.class);
            this._ctorArgs = new Object[]{exception};
        }
        catch (Exception exception2) {
            exception.printStackTrace();
            this._travCtor = null;
            this._ctorArgs = null;
        }
    }
}

