/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.panels;

import java.lang.reflect.Constructor;
import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.model.Displayable;
import oracle.ide.panels.MetaTraversable;
import oracle.ide.panels.NavigableContext;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.Namespace;

public class Navigable
extends MetaTraversable
implements Displayable {
    public static final int PLAIN = 0;
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    public static final String DEFAULT_CHILD_COMPARATOR_KEY = "Navigable.DEFAULT_CHILD_COMPARATOR_KEY";
    public static final Comparator NAVIGABLE_COMPARATOR = new NavigableComparator();
    private String _shortLabel;
    private String _rawShortLabel;
    private Navigable[] _childNavigables;
    private int _displayStyle;
    private Comparator _childComparator;
    private transient Namespace _dataScope;

    protected Navigable(String string) {
        this(string, null, null);
    }

    public Navigable(String string, Class clazz) {
        this(string, clazz, null);
    }

    public Navigable(String string, Class clazz, Navigable[] navigableArray) {
        super(clazz);
        this._rawShortLabel = string;
        this._childNavigables = navigableArray;
    }

    public Navigable(String string, Class clazz, Class[] classArray, Object[] objectArray, Navigable[] navigableArray) {
        super(clazz, classArray, objectArray);
        this._rawShortLabel = string;
        this._childNavigables = navigableArray;
    }

    protected Navigable() {
    }

    public Object copyTo(Object object) {
        Navigable navigable;
        if (object == null) {
            try {
                Class<?> clazz = this.getClass();
                Constructor<?> constructor = clazz.getDeclaredConstructor(null);
                constructor.setAccessible(true);
                navigable = (Navigable)constructor.newInstance(null);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                navigable = new Navigable(null);
            }
        } else {
            navigable = (Navigable)object;
        }
        this.copyToImpl(navigable);
        return navigable;
    }

    protected final void copyToImpl(Navigable navigable) {
        super.copyToImpl(navigable);
        navigable._shortLabel = this._shortLabel;
        navigable._rawShortLabel = this._rawShortLabel;
        if (this._childNavigables != null) {
            int n = this._childNavigables.length;
            Navigable[] navigableArray = new Navigable[n];
            int n2 = 0;
            while (n2 < n) {
                Navigable navigable2 = this._childNavigables[n2];
                navigableArray[n2] = navigable2 != null ? (Navigable)navigable2.copyTo(null) : null;
                ++n2;
            }
            navigable._childNavigables = navigableArray;
        } else {
            navigable._childNavigables = null;
        }
        navigable._childComparator = this._childComparator;
    }

    public String getShortLabel() {
        if (this._shortLabel == null) {
            this._shortLabel = StringUtils.stripMnemonic((String)this._rawShortLabel);
        }
        return this._shortLabel;
    }

    public String getRawShortLabel() {
        return this._rawShortLabel;
    }

    public String getLongLabel() {
        return this.getShortLabel();
    }

    public Icon getIcon() {
        return null;
    }

    public String getToolTipText() {
        return null;
    }

    public String toString() {
        return this.getShortLabel();
    }

    public int getDisplayStyle() {
        return this._displayStyle;
    }

    public void setDisplayStyle(int n) {
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException();
        }
        this._displayStyle = n;
    }

    public void setShortLabel(String string) {
        this._shortLabel = string;
    }

    public void setChildComparator(Comparator comparator) {
        this._childComparator = comparator;
    }

    protected Comparator getChildComparator() {
        return this._childComparator;
    }

    public DefaultMutableTreeNode createTreeNode(NavigableContext navigableContext) {
        this.setDataScope(navigableContext.getScope());
        DefaultMutableTreeNode defaultMutableTreeNode = this.createTreeNodeImpl(navigableContext);
        return defaultMutableTreeNode;
    }

    public DefaultMutableTreeNode createDetailRootNode(NavigableContext navigableContext) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
        this.appendDetailNavigables(defaultMutableTreeNode, navigableContext);
        return defaultMutableTreeNode;
    }

    public void addChildNavigable(Navigable navigable) {
        if (this._childNavigables == null || this._childNavigables.length == 0) {
            this._childNavigables = new Navigable[]{navigable};
        } else {
            int n = this._childNavigables.length;
            Navigable[] navigableArray = new Navigable[n + 1];
            System.arraycopy(this._childNavigables, 0, navigableArray, 0, n);
            navigableArray[n] = navigable;
            this.setChildNavigables(navigableArray);
        }
    }

    void lazyLoadChildNavigables(DefaultMutableTreeNode defaultMutableTreeNode, NavigableContext navigableContext) {
        if (navigableContext != null && navigableContext.displayDetailNodesAsChildren()) {
            this.appendDetailNavigables(defaultMutableTreeNode, navigableContext);
        }
        this.appendChildNavigables(defaultMutableTreeNode, navigableContext);
    }

    protected void setDataScope(Namespace namespace) {
        this._dataScope = namespace;
    }

    protected Navigable[] getChildNavigables() {
        return this._childNavigables;
    }

    protected void setChildNavigables(Navigable[] navigableArray) {
        this._childNavigables = navigableArray;
    }

    protected Navigable[] getDetailNavigables() {
        return null;
    }

    protected DefaultMutableTreeNode createTreeNodeImpl(NavigableContext navigableContext) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(this);
        if (this.mayHaveChildren(navigableContext)) {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(navigableContext, false));
        }
        return defaultMutableTreeNode;
    }

    protected void appendChildNavigables(DefaultMutableTreeNode defaultMutableTreeNode, NavigableContext navigableContext) {
        Navigable[] navigableArray = this.getChildNavigables();
        this.appendChildNodes(defaultMutableTreeNode, navigableArray, navigableContext);
    }

    protected void appendChildNodes(DefaultMutableTreeNode defaultMutableTreeNode, Navigable[] navigableArray, NavigableContext navigableContext) {
        if (navigableArray == null) {
            return;
        }
        Comparator comparator = this._childComparator != null || navigableContext == null ? this._childComparator : (Comparator)navigableContext.getScope().find(DEFAULT_CHILD_COMPARATOR_KEY);
        navigableArray = Navigable.sortNavigables(navigableArray, comparator);
        int n = navigableArray.length;
        int n2 = 0;
        while (n2 < n) {
            DefaultMutableTreeNode defaultMutableTreeNode2;
            Navigable navigable = navigableArray[n2];
            if (navigable != null && (defaultMutableTreeNode2 = navigable.createTreeNode(navigableContext)) != null) {
                defaultMutableTreeNode.insert(defaultMutableTreeNode2, defaultMutableTreeNode.getChildCount());
            }
            ++n2;
        }
    }

    protected void appendDetailNavigables(DefaultMutableTreeNode defaultMutableTreeNode, NavigableContext navigableContext) {
        Navigable[] navigableArray = this.getDetailNavigables();
        this.appendChildNodes(defaultMutableTreeNode, navigableArray, navigableContext);
    }

    protected static Navigable[] sortNavigables(Navigable[] navigableArray, Comparator comparator) {
        if (comparator == null || navigableArray == null || navigableArray.length < 2) {
            return navigableArray;
        }
        int n = navigableArray.length;
        Navigable[] navigableArray2 = new Navigable[n];
        System.arraycopy(navigableArray, 0, navigableArray2, 0, n);
        Arrays.sort(navigableArray2, comparator);
        return navigableArray2;
    }

    protected boolean mayHaveChildren(NavigableContext navigableContext) {
        Navigable[] navigableArray;
        Navigable[] navigableArray2 = this.getChildNavigables();
        if (navigableArray2 != null && navigableArray2.length > 0) {
            return true;
        }
        return navigableContext.displayDetailNodesAsChildren() && (navigableArray = this.getDetailNavigables()) != null && navigableArray.length > 0;
    }

    Namespace getDataScope() {
        return this._dataScope;
    }

    public static class NavigableComparator
    implements Comparator {
        protected static final Collator COLLATOR = Collator.getInstance();
        private String _firstItemLabel;

        public NavigableComparator() {
        }

        public NavigableComparator(String string) {
            this();
            this.setFirstItemLabel(string);
        }

        public void setFirstItemLabel(String string) {
            this._firstItemLabel = string;
        }

        public String getFirstItemLabel() {
            return this._firstItemLabel;
        }

        public int compare(Object object, Object object2) {
            String string = ((Navigable)object).getShortLabel();
            String string2 = ((Navigable)object2).getShortLabel();
            if (this._firstItemLabel != null) {
                if (ModelUtil.areEqual((Object)string, (Object)this._firstItemLabel)) {
                    return ModelUtil.areEqual((Object)string2, (Object)this._firstItemLabel) ? 0 : -1;
                }
                if (ModelUtil.areEqual((Object)string2, (Object)this._firstItemLabel)) {
                    return 1;
                }
            }
            if (string == string2) {
                return 0;
            }
            if (string == null) {
                return -1;
            }
            if (string2 == null) {
                return 1;
            }
            return COLLATOR.compare(string, string2);
        }
    }
}

