/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.panels;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.net.URL;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.component.NewFilePanel;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Workspaces;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversalException;
import oracle.ide.resource.ComponentArb;
import oracle.ide.resource.IdeArb;
import oracle.ide.resource.ModelArb;
import oracle.ide.util.ResourceUtils;

public class NewWorkspacePanel
extends DefaultTraversablePanel
implements VetoableChangeListener {
    private static final String HELP_TOPIC = "f1_idednewworkspace_html";
    private NewFilePanel _filePanel;
    private JCheckBox _addProjectCheckBox;
    private JCheckBox _openNavigatorCheckBox;
    private JEWTDialog _dlg;

    void $init$() {
        this._filePanel = new NewFilePanel();
    }

    public NewWorkspacePanel(boolean bl, boolean bl2, boolean bl3) {
        this.$init$();
        this.setLayout(new GridBagLayout());
        this.setFilePrompt(ComponentArb.getString(21));
        this._filePanel.setFileExtension(".jws");
        this._filePanel.setFileType(IdeArb.getString(273));
        this._filePanel.setShowExtension(false);
        if (bl3) {
            URL uRL = NewWorkspacePanel.getDefaultWorkspaceDirURL();
            String string = NewWorkspacePanel.getDefaultWorkspaceFileName(uRL);
            this._filePanel.setDirectoryURL(uRL);
            this._filePanel.setFileName(string);
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.add((Component)this._filePanel, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        if (bl) {
            this._addProjectCheckBox = new JCheckBox();
            ResourceUtils.resButton(this._addProjectCheckBox, IdeArb.getString(262));
            this._addProjectCheckBox.setSelected(true);
            this.add((Component)this._addProjectCheckBox, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
        }
        if (bl2) {
            this._openNavigatorCheckBox = new JCheckBox();
            ResourceUtils.resButton(this._openNavigatorCheckBox, IdeArb.getString(261));
            this._openNavigatorCheckBox.setSelected(false);
            this.add((Component)this._openNavigatorCheckBox, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(15, 0, 0, 0), 0, 0));
        }
    }

    public static URL getDefaultWorkspaceDirURL() {
        URL uRL;
        URL uRL2;
        Workspaces workspaces = Ide.getWorkspaces();
        URL uRL3 = uRL2 = workspaces != null ? workspaces.getWorkDirectory() : null;
        if (uRL2 == null) {
            String string = Ide.getWorkDirectory();
            uRL2 = URLFactory.newDirURL(string);
        }
        String string = ModelArb.getString(6);
        int n = 1;
        while (URLFileSystem.exists(uRL = URLFactory.newURL(uRL2, string + Integer.toString(n++)))) {
        }
        return uRL;
    }

    public static String getDefaultWorkspaceFileName(URL uRL) {
        return URLFileSystem.getName(uRL) + ".jws";
    }

    public void defaultWorkspaceDirToURL(URL uRL) {
        URL uRL2;
        if (uRL == null) {
            String string = Ide.getWorkDirectory();
            uRL = URLFactory.newDirURL(string);
        }
        String string = ModelArb.getString(6);
        int n = 1;
        while (URLFileSystem.exists(uRL2 = URLFactory.newURL(uRL, string + Integer.toString(n++)))) {
        }
        String string2 = NewWorkspacePanel.getDefaultWorkspaceFileName(uRL2);
        this._filePanel.setDirectoryURL(uRL2);
        this._filePanel.setFileName(string2);
    }

    public boolean runDialog() {
        return this.runDialog(IdeArb.getString(256));
    }

    public boolean runDialog(String string) {
        HelpSystem.getHelpSystem().registerTopic(this, HELP_TOPIC);
        this._dlg = OnePageWizardDialogFactory.createJEWTDialog(this, this._filePanel.getDefaultFocusComponent(), string);
        this._dlg.setDefaultButton(1);
        this._dlg.addVetoableChangeListener((VetoableChangeListener)this);
        return WizardLauncher.runDialog((JDialog)this._dlg);
    }

    public boolean validatePanel() {
        URL uRL = null;
        try {
            uRL = this._filePanel.getFileURL();
        }
        catch (TraversalException traversalException) {
            traversalException.showMessageDialog(this);
        }
        return uRL != null;
    }

    public boolean isAddProject() {
        return this._addProjectCheckBox.isSelected();
    }

    public void setAddProject(boolean bl) {
        this._addProjectCheckBox.setSelected(bl);
    }

    public boolean isOpenNavigator() {
        return this._openNavigatorCheckBox.isSelected();
    }

    public void setOpenNavigator(boolean bl) {
        this._openNavigatorCheckBox.setSelected(bl);
    }

    public URL getFileURL() {
        try {
            URL uRL = this._filePanel.getFileURL();
            return uRL;
        }
        catch (TraversalException traversalException) {
            URL uRL = null;
            return uRL;
        }
    }

    public void setDirectoryPrompt(String string) {
        this._filePanel.setDirectoryPrompt(string);
    }

    public void setFilePrompt(String string) {
        this._filePanel.setFilePrompt(string);
    }

    public NewFilePanel getNewFilePanel() {
        return this._filePanel;
    }

    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)propertyChangeEvent) && !this.validatePanel()) {
            throw new PropertyVetoException("no", propertyChangeEvent);
        }
    }
}

