/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.panels;

import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JDialog;
import javax.swing.event.EventListenerList;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.dialogs.DialogRunnerCallback;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.dialogs.SizeKeeperCallback;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.model.Node;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.ApplyListener;
import oracle.ide.panels.ApplyNotifier;
import oracle.ide.panels.DialogCallbacks;
import oracle.ide.panels.TDialog;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.resource.PanelsArb;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.Namespace;

public class TDialogLauncher
implements ApplyNotifier {
    private final Component _parent;
    private final String _title;
    private final Traversable _traversable;
    private final TraversableContext _tc;
    private final Node[] _sources;
    private JEWTDialog _jewtDialog;
    private EventListenerList _applyListeners;
    private Dimension _initialSize;
    private boolean _pack;
    private DialogRunnerCallback _dialogCallback;
    private static Dimension _defaultSize = new Dimension(600, 400);

    public TDialogLauncher(Component component, String string, Traversable traversable, Namespace namespace, DialogRunnerCallback dialogRunnerCallback, Node[] nodeArray) {
        if (traversable == null) {
            throw new IllegalArgumentException();
        }
        this._dialogCallback = dialogRunnerCallback;
        this._parent = component;
        this._title = string;
        this._traversable = traversable;
        this._sources = nodeArray;
        this._tc = namespace instanceof TraversableContext ? (TraversableContext)namespace : new TraversableContext(namespace != null ? namespace : new Namespace(), 1);
        this._tc.setDialogCallbacks(new DialogCall(null));
        if (this._traversable instanceof ApplyListener) {
            this.addApplyListener((ApplyListener)((Object)this._traversable));
        }
        this._traversable.onEntry(this._tc);
    }

    public TDialogLauncher(Component component, String string, Traversable traversable, Namespace namespace, DialogRunnerCallback dialogRunnerCallback) {
        this(component, string, traversable, namespace, dialogRunnerCallback, null);
    }

    public TDialogLauncher(Component component, String string, Traversable traversable, Namespace namespace) {
        this(component, string, traversable, namespace, null);
    }

    public void addApplyListener(ApplyListener applyListener) {
        if (this._applyListeners == null) {
            this._applyListeners = new EventListenerList();
        }
        this._applyListeners.add(ApplyListener.class, applyListener);
    }

    public void removeApplyListener(ApplyListener applyListener) {
        if (this._applyListeners != null) {
            this._applyListeners.remove(ApplyListener.class, applyListener);
        }
    }

    public Component getParent() {
        return this._parent;
    }

    public String getTitle() {
        return this._title;
    }

    public Dimension getInitialSize() {
        return this._initialSize != null ? this._initialSize : this.getDefaultInitialSize();
    }

    public void setInitialSize(Dimension dimension) {
        this._initialSize = dimension;
    }

    public void setInitialSize(int n, int n2) {
        this.setInitialSize(new Dimension(n, n2));
    }

    public void setPackDialog(boolean bl) {
        this._pack = bl;
    }

    public Dimension getDefaultInitialSize() {
        return TDialogLauncher.getPreferredDefaultInitialSize();
    }

    public static Dimension getPreferredDefaultInitialSize() {
        return new Dimension(_defaultSize);
    }

    public static void setPreferredDefaultInitialSize(Dimension dimension) {
        _defaultSize = new Dimension(dimension);
    }

    public JEWTDialog initDialog() {
        if (this._jewtDialog == null) {
            this._jewtDialog = this.newDialog();
            if (this._pack) {
                this._jewtDialog.pack();
            } else {
                this._jewtDialog.setPreferredSize(this.getInitialSize());
            }
        }
        if (ModelUtil.hasNonNullElement((Object[])this._sources)) {
            ArrayList<Node> arrayList = new ArrayList<Node>();
            int n = 0;
            while (n < this._sources.length) {
                if (this._sources[n].isReadOnly()) {
                    arrayList.add(this._sources[n]);
                }
                ++n;
            }
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(URLFileSystem.getPlatformPathName(((Node)iterator.next()).getURL()));
                stringBuffer.append('\n');
            }
            int n2 = arrayList.size();
            if (n2 > 0) {
                String string = n2 == 1 ? PanelsArb.format(49, stringBuffer.toString()) : PanelsArb.format(50, stringBuffer.toString());
                MessageDialog.information((Component)((Object)Ide.getMainWindow()), string, this._title, null);
                this._jewtDialog.setOKButtonEnabled(false);
            }
        }
        return this._jewtDialog;
    }

    public boolean showDialog() {
        boolean bl;
        JEWTDialog jEWTDialog = this.initDialog();
        if (this._dialogCallback != null) {
            this._dialogCallback.dialogAboutToRun((JDialog)jEWTDialog);
            if (this._dialogCallback instanceof SizeKeeperCallback) {
                try {
                    String string = ((SizeKeeperCallback)this._dialogCallback).getKey();
                    String string2 = Ide.getProperty(string + ".width");
                    String string3 = Ide.getProperty(string + ".height");
                    Dimension dimension = new Dimension(Integer.parseInt(string2), Integer.parseInt(string3));
                    jEWTDialog.setMaximumInitialSize(dimension);
                    jEWTDialog.setPreferredSize(dimension);
                    jEWTDialog.setMinimumSize(_defaultSize);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (bl = WizardLauncher.runDialog((JDialog)jEWTDialog)) {
            this.fireApply();
        } else {
            this.fireCancel();
        }
        return bl;
    }

    public void dispose() {
        this._tc.setDialogCallbacks(null);
    }

    private JEWTDialog getDialog() {
        return this._jewtDialog;
    }

    protected TraversableContext getTraversableContext() {
        return this._tc;
    }

    protected TDialog newDialog() {
        return new TDialog(this);
    }

    protected void fireApply() {
        if (this._applyListeners == null) {
            return;
        }
        Object[] objectArray = this._applyListeners.getListenerList();
        ApplyEvent applyEvent = null;
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == ApplyListener.class) {
                if (applyEvent == null) {
                    applyEvent = new ApplyEvent(this.getTraversableContext());
                }
                ((ApplyListener)objectArray[n + 1]).apply(applyEvent);
            }
            n -= 2;
        }
    }

    protected void fireCancel() {
        if (this._applyListeners == null) {
            return;
        }
        Object[] objectArray = this._applyListeners.getListenerList();
        ApplyEvent applyEvent = null;
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == ApplyListener.class) {
                if (applyEvent == null) {
                    applyEvent = new ApplyEvent(this.getTraversableContext());
                }
                ((ApplyListener)objectArray[n + 1]).cancel(applyEvent);
            }
            n -= 2;
        }
    }

    final Traversable getTraversable() {
        return this._traversable;
    }

    private void enableOK(boolean bl) {
        JEWTDialog jEWTDialog = this.getDialog();
        if (jEWTDialog != null) {
            jEWTDialog.setOKButtonEnabled(bl);
        }
    }

    static void mav$enableOK(TDialogLauncher tDialogLauncher, boolean bl) {
        tDialogLauncher.enableOK(bl);
    }

    private final class DialogCall
    extends DialogCallbacks {
        public void enableOKButton(boolean bl) {
            TDialogLauncher.mav$enableOK(TDialogLauncher.this, bl);
        }

        private DialogCall() {
        }

        DialogCall(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

