/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.wizard.ImageWizardPage;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.controls.WaitCursor;
import oracle.ide.panels.AbstractUIContainer;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.dialogs.ExceptionDialog;

public class TabbedPanel
extends AbstractUIContainer {
    public static final String DEFAULT_TAB_INDEX = "TabbedPanel.DEFAULT_TAB_INDEX";
    private final JTabbedPane _tabbedPane;
    private final ChangeListener _listener;
    private Traversable[] _traversables;
    private transient Image _curImage;
    private transient int _curIndex;

    void $init$() {
        this._listener = new 1();
        this._traversables = new Traversable[0];
        this._curImage = null;
        this._curIndex = -1;
    }

    public TabbedPanel(Navigable[] navigableArray) {
        this(navigableArray, 1);
    }

    public TabbedPanel(Navigable[] navigableArray, int n) {
        this.$init$();
        this.setRootNavigables(navigableArray);
        this._tabbedPane = new JTabbedPane(n);
        this.setLayout(new BorderLayout());
        this.add((Component)this._tabbedPane, "Center");
    }

    public static Navigable createNavigable(String string, Navigable[] navigableArray) {
        return new Navigable(string, TabbedPanel.class, new Class[]{Navigable[].class}, new Object[]{navigableArray}, null);
    }

    public void onEntry(TraversableContext traversableContext) {
        super.onEntry(traversableContext);
        this.maybeRefreshUI(traversableContext);
        Navigable[] navigableArray = this.getRootNavigables();
        if (navigableArray != null) {
            int n;
            int n2 = navigableArray.length;
            Integer n3 = (Integer)traversableContext.getDesignTimeObject(DEFAULT_TAB_INDEX);
            int n4 = 0;
            if (n3 != null && (n = n3.intValue()) >= 0 && n < n2) {
                n4 = n;
            }
            if (n2 > 0 && (this._curIndex < 0 || this._curIndex >= n2)) {
                this._tabbedPane.setSelectedIndex(n4);
                this.gotoTab(n4);
            }
        }
        this.enterCurrentTraversable();
        this._tabbedPane.addChangeListener(this._listener);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        this._tabbedPane.removeChangeListener(this._listener);
        super.onExit(traversableContext);
        this.exitCurrentTraversable();
        traversableContext.putDesignTimeObject(DEFAULT_TAB_INDEX, new Integer(this._tabbedPane.getSelectedIndex()));
    }

    public void updateImage(Image image) {
        this._curImage = image;
    }

    protected void refreshUI(TraversableContext traversableContext) {
        this._tabbedPane.removeAll();
        Navigable[] navigableArray = this.getRootNavigables();
        if (navigableArray != null) {
            int n = navigableArray.length;
            if (n >= 0) {
                this._traversables = new Traversable[n];
            }
            int n2 = 0;
            while (n2 < n) {
                Navigable navigable = navigableArray[n2];
                if (navigable != null) {
                    Component component;
                    Traversable traversable;
                    this._traversables[n2] = traversable = navigable.newTraversable(this);
                    if (this._curImage != null) {
                        ImageWizardPage imageWizardPage = new ImageWizardPage(traversable.getComponent(), this._curImage, null);
                        component = imageWizardPage.getContent();
                    } else {
                        component = traversable.getComponent();
                    }
                    this._tabbedPane.addTab(navigable.getShortLabel(), component);
                    String string = navigable.getRawShortLabel();
                    int n3 = StringUtils.getMnemonicIndex((String)string);
                    if (n3 != -1) {
                        this._tabbedPane.setDisplayedMnemonicIndexAt(n2, n3);
                        this._tabbedPane.setMnemonicAt(n2, StringUtils.getMnemonicKeyCode((String)string));
                    }
                }
                ++n2;
            }
        }
    }

    protected Navigable getCurrentNavigable() {
        return this.getRootNavigables()[this._curIndex];
    }

    protected Traversable getCurrentTraversable() {
        return this._traversables[this._curIndex];
    }

    private void gotoTab(int n) {
        if (n == this._curIndex) {
            return;
        }
        try {
            this.exitCurrentTraversable();
        }
        catch (TraversalException traversalException) {
            traversalException.showMessageDialog(this);
            this._tabbedPane.setSelectedIndex(this._curIndex);
            return;
        }
        this._curIndex = n;
        WaitCursor waitCursor = new WaitCursor(this);
        waitCursor.show();
        this.enterCurrentTraversable();
        waitCursor.hide();
    }

    private void enterCurrentTraversable() {
        if (this._curIndex >= 0 && this._curIndex < this._traversables.length) {
            Traversable traversable = this._traversables[this._curIndex];
            try {
                traversable.onEntry(this.newTraversableContext());
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Component)this, (Throwable)exception, (String)"An exception occurred while entering this panel.");
                exception.printStackTrace();
            }
        }
    }

    private void exitCurrentTraversable() throws TraversalException {
        if (this._curIndex >= 0 && this._curIndex < this._traversables.length) {
            Traversable traversable = this._traversables[this._curIndex];
            try {
                traversable.onExit(this.newTraversableContext());
            }
            catch (TraversalException traversalException) {
                throw traversalException;
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Component)this, (Throwable)exception, (String)"An exception occurred while exiting this panel.");
                exception.printStackTrace();
            }
        }
    }

    static JTabbedPane ra$_tabbedPane(TabbedPanel tabbedPanel) {
        return tabbedPanel._tabbedPane;
    }

    static void mav$gotoTab(TabbedPanel tabbedPanel, int n) {
        tabbedPanel.gotoTab(n);
    }

    public final class 1
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            TabbedPanel.mav$gotoTab(TabbedPanel.this, TabbedPanel.ra$_tabbedPane(TabbedPanel.this).getSelectedIndex());
        }
    }
}

