/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.panels;

import java.util.HashMap;
import oracle.ide.panels.DialogCallbacks;
import oracle.ide.panels.MetaTraversable;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.NavigableContext;
import oracle.ide.panels.NavigableUIContainer;
import oracle.ide.util.Namespace;
import oracle.ide.wizard.WizardCallbacks;

public final class TraversableContext
extends Namespace {
    public static final int RANDOM_ACCESS_TRAVERSAL = 0;
    public static final int FORWARD_TRAVERSAL = 1;
    public static final int BACKWARD_TRAVERSAL = 2;
    public static final int FOCUS_TRAVERSAL = 3;
    private final MetaTraversable _metaTraversable;
    private final int _direction;
    private HashMap _dtObjects;
    private TraversableContext _dtParent;
    private static final String WizardCallbacks_DT_NAME = "wizard-callbacks";
    private static final String DialogCallbacks_DT_NAME = "dialog-callbacks";

    public TraversableContext(Navigable navigable, int n) {
        this((MetaTraversable)navigable, navigable.getDataScope(), n);
    }

    public TraversableContext(Namespace namespace, int n) {
        this(null, namespace, n);
    }

    TraversableContext(MetaTraversable metaTraversable, TraversableContext traversableContext, int n) {
        this(metaTraversable, (Namespace)traversableContext, n);
        this._dtParent = traversableContext;
    }

    TraversableContext(MetaTraversable metaTraversable, Namespace namespace, int n) {
        super(namespace, false);
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException();
        }
        this._metaTraversable = metaTraversable;
        this._direction = n;
    }

    public int getDirection() {
        return this._direction;
    }

    public WizardCallbacks getWizardCallbacks() {
        return (WizardCallbacks)this.getDesignTimeObject(WizardCallbacks_DT_NAME);
    }

    public void setWizardCallbacks(WizardCallbacks wizardCallbacks) {
        this.putDesignTimeObject(WizardCallbacks_DT_NAME, wizardCallbacks);
    }

    public DialogCallbacks getDialogCallbacks() {
        return (DialogCallbacks)this.getDesignTimeObject(DialogCallbacks_DT_NAME);
    }

    public void setDialogCallbacks(DialogCallbacks dialogCallbacks) {
        this.putDesignTimeObject(DialogCallbacks_DT_NAME, dialogCallbacks);
    }

    public Object getDesignTimeObject(String string) {
        Namespace namespace = this;
        while (true) {
            TraversableContext traversableContext = null;
            if (namespace instanceof TraversableContext) {
                Object v;
                traversableContext = namespace;
                if (traversableContext._dtObjects != null && (v = traversableContext._dtObjects.get(string)) != null) {
                    return v;
                }
            }
            if (namespace.isRoot()) break;
            if (traversableContext != null && traversableContext._dtParent != null) {
                namespace = traversableContext._dtParent;
                continue;
            }
            namespace = namespace.getParent();
        }
        return null;
    }

    public void putDesignTimeObject(String string, Object object) {
        if (this._dtObjects == null) {
            this._dtObjects = new HashMap(11);
        }
        this._dtObjects.put(string, object);
    }

    public NavigableContext newNavigableContext() {
        NavigableUIContainer navigableUIContainer = (NavigableUIContainer)this.getDesignTimeObject("navigable-ui-container");
        return new NavigableContext(this, navigableUIContainer != null && navigableUIContainer.displayDetailNodesAsChildren());
    }

    protected String translateKey(String string) {
        return this._metaTraversable != null ? this._metaTraversable.getNameLink(string) : string;
    }

    void setDesignTimeParent(TraversableContext traversableContext) {
        this._dtParent = traversableContext;
    }
}

