/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.performance;

import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import oracle.ide.performance.PerformanceLogRecord;

final class PerformanceFormatter
extends Formatter {
    private static final int TIME_DIGITS = 7;

    public String format(LogRecord logRecord) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Timing:");
        if (logRecord instanceof PerformanceLogRecord) {
            PerformanceLogRecord performanceLogRecord = (PerformanceLogRecord)logRecord;
            String string = String.valueOf(performanceLogRecord.getElapsedTime());
            int n = 7 - string.length();
            int n2 = 0;
            while (n2 < n) {
                stringBuffer.append(' ');
                ++n2;
            }
            stringBuffer.append('[');
            stringBuffer.append(string);
            stringBuffer.append("ms] ");
            int n3 = performanceLogRecord.getDepth();
            int n4 = n3 * 2;
            int n5 = 0;
            while (n5 < n4) {
                stringBuffer.append(' ');
                ++n5;
            }
            stringBuffer.append(performanceLogRecord.getMessage());
            stringBuffer.append('\n');
        } else {
            stringBuffer.append(logRecord.getMessage());
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    PerformanceFormatter() {
    }
}

