/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.performance;

import java.util.logging.ConsoleHandler;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import oracle.ide.Version;
import oracle.ide.performance.PerformanceFormatter;

final class PerformanceHandler
extends ConsoleHandler {
    private static final String TRACING_PROPERTY = "ide.AssertTracingDisabled";
    private static final boolean tracing = Boolean.getBoolean("ide.AssertTracingDisabled") ^ true;

    public PerformanceHandler() {
        this.setFormatter(this.getFormatter("formatter", new PerformanceFormatter()));
        this.setFilter(this.getFilter("filter", new DebugBuildFilter(null)));
    }

    private Formatter getFormatter(String string, Formatter formatter) {
        return (Formatter)this.getPropertyObject(string, formatter);
    }

    private Filter getFilter(String string, Filter filter) {
        return (Filter)this.getPropertyObject(string, filter);
    }

    private Object getPropertyObject(String string, Object object) {
        String string2 = PerformanceHandler.class.getName() + "." + string;
        String string3 = LogManager.getLogManager().getProperty(string2);
        try {
            if (string3 != null) {
                Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass(string3);
                Object obj = clazz.newInstance();
                return obj;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return object;
    }

    static boolean ra$tracing() {
        return tracing;
    }

    private static final class DebugBuildFilter
    implements Filter {
        public boolean isLoggable(LogRecord logRecord) {
            return Version.DEBUG_BUILD == 1 && PerformanceHandler.ra$tracing();
        }

        private DebugBuildFilter() {
        }

        DebugBuildFilter(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

