/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.performance;

import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.performance.PerformanceHandler;
import oracle.ide.performance.PerformanceLogRecord;

public final class PerformanceLogger {
    private static Map _loggersByThread;
    private final Map _startTimes;
    private static Logger s_realLogger;
    private int _depth;

    void $init$() {
        this._startTimes = new HashMap();
        this._depth = 0;
    }

    static {
        s_realLogger = null;
    }

    private PerformanceLogger() {
        this.$init$();
        if (s_realLogger == null) {
            s_realLogger = Logger.getLogger(PerformanceLogger.class.getName());
            s_realLogger.setUseParentHandlers(false);
            s_realLogger.addHandler(new PerformanceHandler());
        }
    }

    private synchronized Logger getLogger() {
        return s_realLogger;
    }

    public static synchronized PerformanceLogger get() {
        Thread thread;
        PerformanceLogger performanceLogger;
        if (_loggersByThread == null) {
            _loggersByThread = new WeakHashMap();
        }
        if ((performanceLogger = (PerformanceLogger)_loggersByThread.get(thread = Thread.currentThread())) == null) {
            performanceLogger = new PerformanceLogger();
            _loggersByThread.put(thread, performanceLogger);
        }
        return performanceLogger;
    }

    public void log(Level level, String string) {
        this.getLogger().log(new PerformanceLogRecord(level, string, this._depth));
    }

    public void log(Level level, String string, long l) {
        this.getLogger().log(new PerformanceLogRecord(level, string, this._depth, l));
    }

    public void startTiming(String string) {
        this.startTiming(string, null);
    }

    public void startTiming(String string, String string2) {
        if (string2 != null) {
            this.log(Level.INFO, string2);
        }
        ++this._depth;
        this._startTimes.put(string, new Long(System.currentTimeMillis()));
    }

    public void stopTiming(String string, String string2) {
        long l = System.currentTimeMillis();
        --this._depth;
        Long l2 = (Long)this._startTimes.get(string);
        if (l2 == null) {
            throw new IllegalArgumentException("Unknown id " + string);
        }
        long l3 = l - l2;
        this._startTimes.remove(string);
        if (string2 != null) {
            this.log(Level.INFO, string2, l3);
        }
    }
}

