/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.persistence;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import oracle.ide.persistence.Page;
import oracle.ide.persistence.ProfileConstants;
import oracle.ide.persistence.RefPage;
import oracle.ide.persistence.StorageFile;
import oracle.ide.util.IdeProfile;
import oracle.ide.util.IntHashMap;

final class BPageCache {
    private static final int PAGE_IN_CACHE = 200;
    private static final int MAX_PAGE_IN_CACHE = 500;
    private StorageFile _store;
    private IntHashMap _cache;
    private RefPage _oldestPage;
    private RefPage _newestPage;
    private int _syncLevel;
    private int _nload;
    private int _nsave;
    private int _nacc;
    private int _nhits;
    private int _nfree;
    private int _nnew;
    static int cleanupRover = 0;

    void $init$() {
        this._syncLevel = 0;
        this._nload = 0;
        this._nsave = 0;
        this._nacc = 0;
        this._nhits = 0;
        this._nfree = 0;
        this._nnew = 0;
    }

    BPageCache(StorageFile storageFile) {
        this.$init$();
        this._store = storageFile;
        this._oldestPage = new RefPage();
        this._oldestPage._next = this._newestPage = new RefPage();
        this._newestPage._prev = this._oldestPage;
        this._cache = new IntHashMap(250);
    }

    void unlinkPage(RefPage refPage) {
        if (refPage._next != null) {
            refPage._next._prev = refPage._prev;
            refPage._prev._next = refPage._next;
        }
    }

    void setNewest(RefPage refPage) {
        if (refPage == this._newestPage._prev) {
            return;
        }
        this.unlinkPage(refPage);
        refPage._prev = this._newestPage._prev;
        refPage._next = this._newestPage;
        refPage._prev._next = refPage;
        this._newestPage._prev = refPage;
    }

    synchronized Page getPage(int n, int n2) {
        int n3 = -1;
        if (ProfileConstants.OK_PCGET) {
            n3 = IdeProfile.startEvent(3810, "Grp " + n2 + " addr " + n);
        }
        RefPage refPage = (RefPage)this._cache.get(n);
        ++this._nacc;
        if (refPage == null) {
            refPage = new RefPage();
            refPage._ref = new Page(null);
            refPage._group = n2;
            this._cache.put(n, refPage);
            refPage._addr = n;
            int n4 = -1;
            if (ProfileConstants.OK_PCLOAD) {
                n4 = IdeProfile.startEvent(3811, "Grp " + n2 + " addr " + n);
            }
            InputStream inputStream = this._store.getISFromRec(n);
            refPage._ref.loadFromBlob(inputStream);
            if (ProfileConstants.OK_PCLOAD) {
                IdeProfile.endEvent(n4);
            }
            ++this._nload;
        } else {
            ++this._nhits;
        }
        this.setNewest(refPage);
        if (ProfileConstants.OK_PCGET) {
            IdeProfile.endEvent(n3);
        }
        return refPage._ref;
    }

    synchronized void freePage(int n) {
        int n2 = -1;
        if (ProfileConstants.OK_PCDELETE) {
            n2 = IdeProfile.startEvent(3813, " addr " + n);
        }
        RefPage refPage = (RefPage)this._cache.get(n);
        ++this._nfree;
        if (refPage != null) {
            this.unlinkPage(refPage);
            this._cache.remove(n);
        }
        this._store.deleteBlob(n);
        if (ProfileConstants.OK_PCDELETE) {
            IdeProfile.endEvent(n2);
        }
    }

    synchronized int getNewPage(int n) {
        int n2 = -1;
        if (ProfileConstants.OK_PCNEW) {
            n2 = IdeProfile.startEvent(3814, " grp " + n);
        }
        int n3 = this._store.getFreePage();
        RefPage refPage = new RefPage();
        ++this._nnew;
        refPage._ref = new Page(null);
        refPage._group = n;
        OutputStream outputStream = this._store.getNewOSFromRec(n3, n);
        refPage._ref.saveToBlob(outputStream);
        this._cache.put(n3, refPage);
        refPage._addr = n3;
        this.setNewest(refPage);
        if (ProfileConstants.OK_PCNEW) {
            IdeProfile.endEvent(n2, " addr " + n3);
        }
        return n3;
    }

    synchronized void startTrans() {
        ++this._syncLevel;
    }

    synchronized void endTrans() {
        --this._syncLevel;
        if (this._syncLevel == 0) {
            this.cleanup();
        }
    }

    private void savePage(RefPage refPage) {
        block2: {
            if (!refPage._ref.isDirty()) break block2;
            int n = -1;
            if (ProfileConstants.OK_PCSAVE) {
                n = IdeProfile.startEvent(3812, "Grp " + refPage._group + " addr " + refPage._addr);
            }
            OutputStream outputStream = this._store.getOSFromRec(refPage._addr, refPage._group);
            refPage._ref.saveToBlob(outputStream);
            ++this._nsave;
            if (ProfileConstants.OK_PCSAVE) {
                IdeProfile.endEvent(n);
            }
        }
    }

    private void cleanup() {
        if (this._cache.size() < 500) {
            return;
        }
        int n = -1;
        if (ProfileConstants.OK_PCCLEANUP) {
            n = IdeProfile.startEvent(3815);
        }
        ArrayList<RefPage> arrayList = new ArrayList<RefPage>();
        while (this._cache.size() > 200) {
            RefPage refPage = this._oldestPage._next;
            this.unlinkPage(refPage);
            if (refPage._ref.isDirty()) {
                arrayList.add(refPage);
            }
            this._cache.remove(refPage._addr);
        }
        Object[] objectArray = arrayList.toArray(new RefPage[arrayList.size()]);
        Arrays.sort(objectArray);
        int n2 = 0;
        while (n2 < objectArray.length) {
            this.savePage((RefPage)objectArray[n2]);
            ++n2;
        }
        if (ProfileConstants.OK_PCCLEANUP) {
            IdeProfile.endEvent(n, "Pages saved " + objectArray.length);
        }
    }

    synchronized void flush(int n) {
        int n2 = -1;
        if (ProfileConstants.OK_PCFLUSH) {
            n2 = IdeProfile.startEvent(3819, " group " + n);
        }
        RefPage refPage = this._oldestPage._next;
        ArrayList<RefPage> arrayList = new ArrayList<RefPage>();
        while (refPage != this._newestPage) {
            if (refPage._group == n && refPage._ref.isDirty()) {
                arrayList.add(refPage);
            }
            refPage = refPage._next;
        }
        Object[] objectArray = arrayList.toArray(new RefPage[arrayList.size()]);
        Arrays.sort(objectArray);
        int n3 = 0;
        while (n3 < objectArray.length) {
            this.savePage((RefPage)objectArray[n3]);
            ++n3;
        }
        if (ProfileConstants.OK_PCFLUSH) {
            IdeProfile.endEvent(n2, "Pages saved " + objectArray.length);
        }
    }

    synchronized void cleanGroup(int n) {
        int n2 = -1;
        if (ProfileConstants.OK_PCCLEAN) {
            n2 = IdeProfile.startEvent(3816, " group " + n);
        }
        RefPage refPage = this._oldestPage._next;
        int n3 = 0;
        while (refPage != this._newestPage) {
            if (refPage._group == n) {
                this.unlinkPage(refPage);
                ++n3;
                this._cache.remove(refPage._addr);
            }
            refPage = refPage._next;
        }
        if (ProfileConstants.OK_PCCLEAN) {
            IdeProfile.endEvent(n2, "Pages cleaned " + n3);
        }
    }
}

