/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.persistence;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import oracle.ide.persistence.NameSpace;
import oracle.ide.persistence.UniqueIdFactory;

public class CrossIndex {
    private UniqueIdFactory _uid;
    private NameSpace _directNS;
    private NameSpace _reverseNS;
    private char _sep;
    String[] _directPool;
    int _directPoolSize;
    String[] _reversePool;
    int _reversePoolSize;
    HashMap _keyMap;
    private static final int DPOOLSIZE = 200;
    private static final int RPOOLSIZE = 150000;
    private String SEPS;
    int total;

    public CrossIndex(String string, String string2) {
        this.$init$();
        this._sep = (char)124;
        this._uid = new UniqueIdFactory(string + "_UID", '|');
        this._directNS = NameSpace.getNameSpace(string2 + "_DAT_D");
        this._reverseNS = NameSpace.getNameSpace(string2 + "_DAT_R");
        this._directPool = new String[200];
        this._reversePool = new String[150000];
        this._keyMap = new HashMap();
    }

    private void flushDirectPool() {
        System.out.println(">> Flushing " + this._directPoolSize + " records in direct pool ");
        Arrays.sort(this._directPool, 0, this._directPoolSize);
        int n = 0;
        while (n < this._directPoolSize) {
            this._directNS.putRecord(this._directPool[n], null);
            ++n;
        }
        System.out.println("<< done");
        this._directPoolSize = 0;
    }

    private void addInDirectPool(String string) {
        if (this._directPoolSize == 200) {
            this.flushDirectPool();
        }
        this._directPool[this._directPoolSize++] = string;
    }

    private void flushReversePool() {
        System.out.println(">> Flushing " + this._reversePoolSize + " records in reverse pool ");
        Arrays.sort(this._reversePool, 0, this._reversePoolSize);
        int n = 0;
        while (n < this._reversePoolSize) {
            this._reverseNS.putRecord(this._reversePool[n], null);
            ++n;
        }
        System.out.println("<< done");
        this._reversePoolSize = 0;
    }

    private void addInReversePool(String string) {
        if (this._reversePoolSize == 150000) {
            this.flushReversePool();
        }
        this._reversePool[this._reversePoolSize++] = string;
    }

    private String getKeyUid(String string) {
        String string2 = (String)this._keyMap.get(string);
        if (string2 == null) {
            string2 = this._uid.getUID(string);
            this._keyMap.put(string, string2);
        }
        return string2;
    }

    private HashSet getFileKeys(String string) {
        String string2 = this._uid.getUID(string);
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = this._directNS.getKeyIterator(string2 + this._sep);
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            StringTokenizer stringTokenizer = new StringTokenizer(string3, "|", false);
            string2 = stringTokenizer.nextToken();
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                hashSet.add(string4);
            }
            this._directNS.delRecord(string3);
        }
        return hashSet;
    }

    public void printKeyRef(String string) {
        String string2 = this._uid.getUID(string);
        Iterator iterator = this._reverseNS.getKeyIterator(string2 + this._sep);
        System.out.println(" key [" + string + "] in : -------");
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            int n = string3.indexOf(this._sep);
            String string4 = string3.substring(n + 1);
            System.out.println(this._uid.keyFromUID(string4));
        }
    }

    void $init$() {
        this.SEPS = " \t\r\n1234567890!@#$%^&*()|\\/+-=\"'<>,.;':{}[]?";
        this.total = 0;
    }

    void parseFile(String string) {
        HashSet hashSet = this.getFileKeys(string);
        HashSet<String> hashSet2 = new HashSet<String>();
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, this.SEPS, false);
                while (stringTokenizer.hasMoreTokens()) {
                    hashSet2.add(stringTokenizer.nextToken());
                }
                string2 = bufferedReader.readLine();
            }
            bufferedReader.close();
            HashSet<String> hashSet3 = new HashSet<String>();
            String string3 = this._uid.getUID(string);
            Iterator iterator = hashSet2.iterator();
            this.total += hashSet2.size();
            StringBuffer stringBuffer = new StringBuffer(6 * hashSet2.size());
            stringBuffer.append(string3);
            while (iterator.hasNext()) {
                String string4 = (String)iterator.next();
                String string5 = this.getKeyUid(string4);
                hashSet3.add(string5);
                stringBuffer.append(this._sep);
                stringBuffer.append(string5);
                if (hashSet.contains(string5)) continue;
                this.addInReversePool(string5 + this._sep + string3);
            }
            this.addInDirectPool(stringBuffer.toString());
            for (String string6 : hashSet) {
                if (hashSet3.contains(string6)) continue;
                this._reverseNS.delRecord(string6 + this._sep + string3);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void parseDirectory(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        try {
            File file = new File(string);
            File[] fileArray = file.listFiles();
            if (fileArray != null) {
                int n = 0;
                while (n < fileArray.length) {
                    if (fileArray[n].isFile() && fileArray[n].getName().endsWith(".java")) {
                        BufferedReader bufferedReader = new BufferedReader(new FileReader(fileArray[n]));
                        String string2 = bufferedReader.readLine();
                        while (string2 != null) {
                            StringTokenizer stringTokenizer = new StringTokenizer(string2, this.SEPS, false);
                            while (stringTokenizer.hasMoreTokens()) {
                                hashSet.add(stringTokenizer.nextToken());
                            }
                            string2 = bufferedReader.readLine();
                        }
                        bufferedReader.close();
                    }
                    ++n;
                }
            }
            String string3 = this._uid.getUID(string);
            Iterator iterator = hashSet.iterator();
            this.total += hashSet.size();
            while (iterator.hasNext()) {
                String string4 = (String)iterator.next();
                String string5 = this.getKeyUid(string4);
                this.addInDirectPool(string3 + this._sep + string5);
                this.addInReversePool(string5 + this._sep + string3);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void flush() {
        this.flushDirectPool();
        this.flushReversePool();
        this._uid.flush();
        this._directNS.flush();
        this._reverseNS.flush();
    }
}

