/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.persistence;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import oracle.ide.persistence.StorageFile;

final class DataPage {
    int _address;
    int _nstag;
    byte _tag;
    byte[] _buffer;
    byte _flags;
    int _sz;
    int _idxlpge;
    int _fullsize;
    int _nidxs;
    int _nextidx;
    int[] _idxs;
    private static final byte ISFIRST = 1;
    private static final byte ISPGINDEXMAP = 2;

    DataPage(int n, byte[] byArray) {
        int n2 = 10;
        this._address = n;
        this._tag = byArray[0];
        this._flags = byArray[1];
        this._nstag = StorageFile.intFromArray(byArray, 2);
        this._sz = StorageFile.intFromArray(byArray, 6);
        if ((this._flags & 1) != 0) {
            this._idxlpge = StorageFile.intFromArray(byArray, 10);
            this._fullsize = StorageFile.intFromArray(byArray, 14);
            n2 = 18;
        }
        this._buffer = new byte[this._sz];
        System.arraycopy(byArray, n2, this._buffer, 0, this._sz);
        n2 += this._sz;
        if ((this._flags & 2) != 0) {
            this._nidxs = StorageFile.intFromArray(byArray, n2);
            this._nextidx = StorageFile.intFromArray(byArray, n2 += 4);
            n2 += 4;
            this._idxs = new int[this._nidxs];
            int n3 = 0;
            while (n3 < this._nidxs) {
                this._idxs[n3] = StorageFile.intFromArray(byArray, n2);
                n2 += 4;
                ++n3;
            }
        }
    }

    DataPage() {
    }

    static DataPage getPageFromStorage(StorageFile storageFile, int n) {
        byte[] byArray = new byte[1024];
        storageFile.readBytesFromOffset(byArray, n * 1024);
        return new DataPage(n, byArray);
    }

    private static void freePageGroup(StorageFile storageFile, int n, boolean bl) {
        DataPage dataPage;
        DataPage dataPage2 = dataPage = DataPage.getPageFromStorage(storageFile, n);
        if (dataPage._idxlpge != n) {
            dataPage2 = DataPage.getPageFromStorage(storageFile, dataPage._idxlpge);
        }
        while (dataPage2 != null) {
            int n2 = 0;
            while (n2 < dataPage2._nidxs) {
                if (bl || dataPage2._idxs[n2] != n) {
                    storageFile.releasePage(dataPage2._idxs[n2]);
                }
                ++n2;
            }
            dataPage2 = dataPage2._nextidx != 0 ? DataPage.getPageFromStorage(storageFile, dataPage2._nextidx) : null;
        }
    }

    static ArrayList getPageGroup(int n, int n2) {
        ArrayList<DataPage> arrayList = new ArrayList<DataPage>();
        DataPage dataPage = new DataPage();
        arrayList.add(dataPage);
        dataPage._flags = (byte)(dataPage._flags | 1);
        dataPage._nstag = n;
        dataPage._address = n2;
        dataPage._buffer = new byte[1006];
        dataPage._tag = (byte)3;
        return arrayList;
    }

    static OutputStream newPageGroup(StorageFile storageFile, int n, int n2) {
        return new BlobWriter(storageFile, n, n2);
    }

    static OutputStream updatePageGroup(StorageFile storageFile, int n, int n2) {
        DataPage.freePageGroup(storageFile, n2, false);
        return new BlobWriter(storageFile, n, n2);
    }

    static InputStream readPageGroup(StorageFile storageFile, int n) {
        DataPage dataPage = null;
        if (n != 0) {
            dataPage = DataPage.getPageFromStorage(storageFile, n);
        }
        BlobReader blobReader = new BlobReader(storageFile, dataPage);
        return blobReader;
    }

    static byte[] readFullPageGroup(StorageFile storageFile, int n) {
        DataPage dataPage = DataPage.getPageFromStorage(storageFile, n);
        byte[] byArray = new byte[dataPage._fullsize];
        BlobReader blobReader = new BlobReader(storageFile, dataPage);
        try {
            blobReader.read(byArray);
            blobReader.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return byArray;
    }

    static void deletePageGroup(StorageFile storageFile, int n) {
        DataPage.freePageGroup(storageFile, n, true);
    }

    static void writeBytesToGroup(StorageFile storageFile, int n, ArrayList arrayList, byte[] byArray) {
        DataPage.writeBytesToGroup(storageFile, n, arrayList, byArray, 0, byArray.length);
    }

    static void writeBytesToGroup(StorageFile storageFile, int n, ArrayList arrayList, byte[] byArray, int n2, int n3) {
        DataPage dataPage = (DataPage)arrayList.get(arrayList.size() - 1);
        while (n3 > dataPage.availableBytes()) {
            int n4 = dataPage.availableBytes();
            System.arraycopy(byArray, n2, dataPage._buffer, dataPage._sz, n4);
            n2 += n4;
            dataPage._sz += n4;
            n3 -= n4;
            dataPage = new DataPage();
            arrayList.add(dataPage);
            dataPage._nstag = n;
            dataPage._address = storageFile.getFreePage();
            dataPage._buffer = new byte[1014];
            dataPage._tag = (byte)3;
        }
        System.arraycopy(byArray, n2, dataPage._buffer, dataPage._sz, n3);
        dataPage._sz += n3;
    }

    static void writeByteToGroup(StorageFile storageFile, int n, ArrayList arrayList, int n2) {
        DataPage dataPage = (DataPage)arrayList.get(arrayList.size() - 1);
        while (1 > dataPage.availableBytes()) {
            dataPage = new DataPage();
            arrayList.add(dataPage);
            dataPage._nstag = n;
            dataPage._address = storageFile.getFreePage();
            dataPage._buffer = new byte[1014];
            dataPage._tag = (byte)3;
        }
        dataPage._buffer[dataPage._sz] = (byte)(n2 & 0xFF);
        ++dataPage._sz;
    }

    static void finalizeGroup(StorageFile storageFile, int n, ArrayList arrayList) {
        int n2;
        DataPage dataPage = (DataPage)arrayList.get(arrayList.size() - 1);
        int n3 = arrayList.size() - 1;
        int n4 = arrayList.size();
        int n5 = dataPage.availableBytes();
        DataPage dataPage2 = dataPage;
        if (n5 < 12) {
            n2 = 0;
            dataPage2 = null;
            ++n3;
        } else {
            n2 = (n5 - 8) / 4;
            dataPage2._idxs = new int[n2];
        }
        while (n4 > n2) {
            n4 -= n2;
            DataPage dataPage3 = new DataPage();
            arrayList.add(dataPage3);
            ++n4;
            dataPage3._nstag = n;
            dataPage3._flags = (byte)(dataPage3._flags | 2);
            dataPage3._address = storageFile.getFreePage();
            if (dataPage2 != null) {
                dataPage2._nextidx = dataPage3._address;
            } else {
                dataPage = dataPage3;
            }
            dataPage2 = dataPage3;
            n5 = 1014;
            n2 = (n5 - 8) / 4;
            dataPage3._idxs = new int[n2];
        }
        DataPage dataPage4 = (DataPage)arrayList.get(0);
        dataPage4._idxlpge = dataPage._address;
        dataPage2 = dataPage;
        dataPage2._flags = (byte)(dataPage2._flags | 2);
        int n6 = 0;
        int n7 = 0;
        while (n7 < arrayList.size()) {
            DataPage dataPage5 = (DataPage)arrayList.get(n7);
            dataPage4._fullsize += dataPage5._sz;
            if (n6 >= dataPage2._idxs.length) {
                dataPage2 = (DataPage)arrayList.get(++n3);
                dataPage2._flags = (byte)(dataPage2._flags | 2);
                n6 = 0;
            }
            ++dataPage2._nidxs;
            dataPage2._idxs[n6++] = dataPage5._address;
            ++n7;
        }
    }

    static void saveGroup(StorageFile storageFile, ArrayList arrayList) {
        int n = 0;
        while (n < arrayList.size()) {
            DataPage dataPage = (DataPage)arrayList.get(n);
            dataPage.saveToStorage(storageFile);
            ++n;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("NameGroup : ");
        stringBuffer.append(this._nstag);
        stringBuffer.append(" DataSize : ");
        stringBuffer.append(this._sz);
        if ((this._flags & 1) != 0) {
            stringBuffer.append(" MapIdx : ");
            stringBuffer.append(this._idxlpge);
            stringBuffer.append(" FullSize : ");
            stringBuffer.append(this._fullsize);
        }
        if ((this._flags & 2) != 0) {
            stringBuffer.append(" Nidx : ");
            stringBuffer.append(this._nidxs);
            stringBuffer.append(" Next : ");
            stringBuffer.append(this._nextidx);
            stringBuffer.append("\n    Map : ");
            int n = 0;
            while (n < this._nidxs) {
                stringBuffer.append(this._idxs[n]);
                stringBuffer.append(", ");
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    void saveToStorage(StorageFile storageFile) {
        int n = 10;
        if ((this._flags & 1) != 0) {
            n += 8;
        }
        byte[] byArray = new byte[n];
        byArray[0] = 3;
        byArray[1] = this._flags;
        StorageFile.intToArray(this._nstag, byArray, 2);
        StorageFile.intToArray(this._sz, byArray, 6);
        if ((this._flags & 1) != 0) {
            StorageFile.intToArray(this._idxlpge, byArray, 10);
            StorageFile.intToArray(this._fullsize, byArray, 14);
        }
        int n2 = this._address * 1024;
        storageFile.writeBytesFromOffset(byArray, n2);
        n2 += n;
        if (this._sz != 0) {
            storageFile.writeBytesFromOffset(this._buffer, 0, this._sz, n2);
            n2 += this._sz;
        }
        if ((this._flags & 2) != 0) {
            byArray = new byte[8 + this._nidxs * 4];
            int n3 = 0;
            StorageFile.intToArray(this._nidxs, byArray, n3);
            StorageFile.intToArray(this._nextidx, byArray, n3 += 4);
            n3 += 4;
            int n4 = 0;
            while (n4 < this._nidxs) {
                StorageFile.intToArray(this._idxs[n4], byArray, n3);
                n3 += 4;
                ++n4;
            }
            storageFile.writeBytesFromOffset(byArray, n2);
        }
    }

    private int availableBytes() {
        return this._buffer.length - this._sz;
    }

    static class BlobReader
    extends InputStream {
        private DataPage _cdp;
        private DataPage _cip;
        private int _curOfs;
        private int _curIdx;
        private StorageFile _store;

        BlobReader(StorageFile storageFile, DataPage dataPage) {
            this._store = storageFile;
            this._cip = this._cdp = dataPage;
            if (this._cdp != null && this._cdp._idxlpge != dataPage._address) {
                this._cip = DataPage.getPageFromStorage(storageFile, this._cdp._idxlpge);
            }
            this._curOfs = 0;
            this._curIdx = 1;
        }

        private void getNextPage() {
            if (this._curIdx == this._cip._nidxs) {
                if (this._cip._nextidx == 0) {
                    this._cdp = null;
                    return;
                }
                this._cip = DataPage.getPageFromStorage(this._store, this._cip._nextidx);
                this._curIdx = 0;
            }
            this._cdp = DataPage.getPageFromStorage(this._store, this._cip._idxs[this._curIdx]);
            this._curOfs = 0;
            if (this._cdp._sz == 0) {
                this._cdp = null;
            }
            ++this._curIdx;
        }

        public int read() throws IOException {
            while (true) {
                if (this._cdp == null) {
                    throw new IOException("End of record reached");
                }
                int n = this._cdp._sz - this._curOfs;
                if (1 <= n) {
                    int n2 = this._cdp._buffer[this._curOfs] & 0xFF;
                    ++this._curOfs;
                    return n2;
                }
                this.getNextPage();
            }
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = 0;
            if (this._cdp == null) {
                return -1;
            }
            do {
                int n4;
                if (n2 <= (n4 = this._cdp._sz - this._curOfs)) {
                    System.arraycopy(this._cdp._buffer, this._curOfs, byArray, n, n2);
                    this._curOfs += n2;
                    return n3 += n2;
                }
                System.arraycopy(this._cdp._buffer, this._curOfs, byArray, n, n4);
                n3 += n4;
                n2 -= n4;
                n += n4;
                this.getNextPage();
            } while (this._cdp != null);
            return n3;
        }
    }

    static class BlobWriter
    extends OutputStream {
        private int _nameSpace;
        private StorageFile _store;
        private ArrayList _blobMap;
        private boolean _closed;

        BlobWriter(StorageFile storageFile, int n, int n2) {
            this._blobMap = DataPage.getPageGroup(n, n2);
            this._store = storageFile;
            this._nameSpace = n;
            this._closed = false;
        }

        public void write(int n) throws IOException {
            if (this._closed) {
                throw new IOException("Storage Stream closed");
            }
            DataPage.writeByteToGroup(this._store, this._nameSpace, this._blobMap, n);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            if (this._closed) {
                throw new IOException("Storage Stream closed");
            }
            DataPage.writeBytesToGroup(this._store, this._nameSpace, this._blobMap, byArray, n, n2);
        }

        public void close() throws IOException {
            if (this._closed) {
                throw new IOException("Storage Stream already closed");
            }
            DataPage.finalizeGroup(this._store, this._nameSpace, this._blobMap);
            DataPage.saveGroup(this._store, this._blobMap);
        }
    }
}

