/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.persistence;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.TimerTask;
import oracle.ide.Ide;
import oracle.ide.persistence.ProfileConstants;
import oracle.ide.persistence.StorageFile;
import oracle.ide.util.IdeProfile;
import oracle.javatools.util.NamedTimer;

public class NameSpace {
    protected static StorageFile _store;
    private static final String DEFSTOREDIR = "oracle.javatools.cache";
    private static final String DEFSTORENAME = "persist";
    private static NamedTimer _flushTimer;
    int _pindex;
    int _btreeindex;
    String _name;
    boolean _dirty;
    int _dirtyEventHandle;
    long _autoDelay;
    TimerTask _flushTask;
    long _timeLimit;
    public static final int NSTYPE_NORMAL = 0;
    public static final int NSTYPE_PACKED = 1;

    static void init(String string) {
        int n = 0;
        while (!(_store = new StorageFile(string + "_" + n++)).open()) {
        }
    }

    static boolean setStorage(String string) {
        _store = new StorageFile(string);
        return _store.open();
    }

    static void checkInit() {
        if (_store != null) {
            return;
        }
        String string = System.getProperty("persistence.directory");
        if (string == null) {
            string = Ide.getSystemDirectory();
        }
        NameSpace.init(string + DEFSTOREDIR + File.separator + DEFSTORENAME);
    }

    public static Iterator getNameSpaceIterator() {
        return NameSpace.getNameSpaceIterator("", false);
    }

    public static Iterator getReverseNameSpaceIterator() {
        return NameSpace.getReverseNameSpaceIterator("", false);
    }

    public static Iterator getNameSpaceIterator(String string) {
        return NameSpace.getNameSpaceIterator(string, false);
    }

    public static Iterator getReverseNameSpaceIterator(String string) {
        return NameSpace.getReverseNameSpaceIterator(string, false);
    }

    public static Iterator getNameSpaceIterator(String string, boolean bl) {
        NameSpace.checkInit();
        return _store.getNameSpaceIterator(string, bl);
    }

    public static Iterator getReverseNameSpaceIterator(String string, boolean bl) {
        NameSpace.checkInit();
        return _store.getReverseNameSpaceIterator(string, bl);
    }

    public static NameSpace getNameSpace(String string, int n) {
        NameSpace.checkInit();
        NameSpace nameSpace = _store.getNameSpace(string, n);
        nameSpace._name = string;
        return nameSpace;
    }

    public static NameSpace getNameSpace(String string) {
        return NameSpace.getNameSpace(string, 0);
    }

    NameSpace(int n, int n2) {
        this._pindex = n;
        this._btreeindex = n2;
        this._dirty = false;
    }

    public static void deleteNameSpace(String string) {
        NameSpace.checkInit();
        NameSpace nameSpace = _store.getNameSpace(string, 0);
        _store.deleteNameSpace(nameSpace);
    }

    public InputStream getRecordStream(String string) {
        int n = -1;
        if (ProfileConstants.OK_NSGETS) {
            n = IdeProfile.startEvent(3832, this._name + " key = [" + string + "]");
        }
        InputStream inputStream = _store.getISFromKey(this._pindex, this._btreeindex, string);
        if (ProfileConstants.OK_NSGETS) {
            IdeProfile.endEvent(n);
        }
        return inputStream;
    }

    public static synchronized NamedTimer getFlushTimer() {
        if (_flushTimer == null) {
            _flushTimer = new NamedTimer("Persistence Auto Flusher", 5, true);
        }
        return _flushTimer;
    }

    public synchronized void setAutoFlush(long l) {
        this._autoDelay = l;
    }

    public synchronized void cancelAutoFlush() {
        if (this._flushTask != null) {
            this._flushTask.cancel();
            this._flushTask = null;
            this._autoDelay = 0L;
        }
    }

    public byte[] getRecord(String string) {
        byte[] byArray = _store.getISBytesFromKey(this._pindex, this._btreeindex, string);
        return byArray;
    }

    private synchronized void checkDirty() {
        if (this._dirty) {
            if (this._flushTask != null) {
                this._timeLimit = System.currentTimeMillis() + this._autoDelay;
            }
            return;
        }
        if (this._autoDelay != 0L) {
            this._timeLimit = System.currentTimeMillis() + this._autoDelay;
            this._flushTask = new AutoFlusher();
            NameSpace.getFlushTimer().scheduleAtFixedRate(this._flushTask, this._autoDelay, 1000L);
        }
        if (ProfileConstants.OK_NSDIRTY) {
            this._dirtyEventHandle = IdeProfile.startEvent(3835, this._name);
        }
        _store.incDirty(this._pindex);
        this._dirty = true;
    }

    public synchronized void flush() {
        int n = -1;
        if (ProfileConstants.OK_NSFLUSH) {
            n = IdeProfile.startEvent(3839, this._name);
        }
        if (this._dirty) {
            _store.decDirty(this._pindex);
        }
        if (ProfileConstants.OK_NSFLUSH) {
            IdeProfile.endEvent(n);
        }
        if (ProfileConstants.OK_NSDIRTY) {
            IdeProfile.endEvent(this._dirtyEventHandle);
        }
        this._flushTask = null;
        this._dirty = false;
    }

    public void close() {
        this.flush();
    }

    public void delRecord(String string) {
        int n = -1;
        if (ProfileConstants.OK_NSDEL) {
            n = IdeProfile.startEvent(3834, this._name + " key [" + string + "]");
        }
        this.checkDirty();
        _store.deleteFromKey(this._pindex, this._btreeindex, string);
        if (ProfileConstants.OK_NSDEL) {
            IdeProfile.endEvent(n);
        }
    }

    public OutputStream putRecordStream(String string) {
        return this.putRecordStreamInternal(string);
    }

    private OutputStream putRecordStreamInternal(String string) {
        int n = -1;
        if (ProfileConstants.OK_NSPUTS) {
            n = IdeProfile.startEvent(3833, this._name + " key [" + string + "]");
        }
        this.checkDirty();
        OutputStream outputStream = _store.getOSFromKey(this._pindex, this._btreeindex, string);
        if (ProfileConstants.OK_NSPUTS) {
            IdeProfile.endEvent(n);
        }
        return outputStream;
    }

    public boolean checkRecord(String string) {
        return _store.checkKey(this._pindex, this._btreeindex, string);
    }

    public void putRecord(String string, byte[] byArray) {
        int n = -1;
        if (ProfileConstants.OK_NSPUTB) {
            n = IdeProfile.startEvent(3831, this._name + " key [" + string + "] dlen " + (byArray == null ? "null" : Integer.toString(byArray.length)));
        }
        if (byArray != null && byArray.length != 0) {
            OutputStream outputStream = this.putRecordStreamInternal(string);
            try {
                outputStream.write(byArray);
                outputStream.close();
            }
            catch (Exception exception) {}
        } else {
            this.checkDirty();
            _store.updateEmptyKey(this._pindex, this._btreeindex, string);
        }
        if (ProfileConstants.OK_NSPUTB) {
            IdeProfile.endEvent(n);
        }
    }

    public Iterator getKeyIterator() {
        return this.getKeyIterator("", false);
    }

    public Iterator getReverseKeyIterator() {
        return this.getReverseKeyIterator("", false);
    }

    public Iterator getKeyIterator(String string) {
        return this.getKeyIterator(string, false);
    }

    public Iterator getReverseKeyIterator(String string) {
        return this.getReverseKeyIterator(string, false);
    }

    public Iterator getKeyIterator(String string, boolean bl) {
        return _store.getKeyIterator(this._pindex, this._btreeindex, string, bl);
    }

    public Iterator getReverseKeyIterator(String string, boolean bl) {
        return _store.getReverseKeyIterator(this._pindex, this._btreeindex, string, bl);
    }

    void checkTree(String string) {
        _store.checkTree(string, this._pindex, this._btreeindex);
    }

    void printTree() {
        _store.printTreePages(this._pindex, this._btreeindex);
    }

    public class AutoFlusher
    extends TimerTask {
        public void run() {
            if (System.currentTimeMillis() > NameSpace.this._timeLimit) {
                NameSpace.this.flush();
                this.cancel();
            }
        }

        AutoFlusher() {
        }
    }
}

