/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.persistence;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import oracle.ide.persistence.NameSpace;

public class PackedNameSpace
extends NameSpace {
    private static final char DEFAULT_DATA_SEPARATOR = '|';
    private static final int SIZE_THREESOLD = 16384;
    private char _dataSeparator;

    public PackedNameSpace(int n, int n2, char c) {
        super(n, n2);
        this._dataSeparator = c;
    }

    public PackedNameSpace(int n, int n2) {
        this(n, n2, '|');
    }

    public byte[] getRecord(String string) {
        String string2 = string + this._dataSeparator;
        byte[] byArray = super.getRecord(string2);
        if (byArray != null) {
            return byArray;
        }
        String string3 = NameSpace._store.getNextKey(this._pindex, this._btreeindex, string2);
        if (string3 == null || !string3.startsWith(string2)) {
            return null;
        }
        byArray = this.dataFrom(string3);
        return byArray;
    }

    public void putRecord(String string, byte[] byArray) {
        this.putRecordNoCache(string, byArray);
    }

    public OutputStream putRecordStream(String string) {
        return new watchedByteArrayOutputStream(string);
    }

    public InputStream getRecordStream(String string) {
        byte[] byArray = this.getRecord(string);
        if (byArray != null) {
            return new ByteArrayInputStream(byArray);
        }
        return null;
    }

    private void putRecordNoCache(String string, byte[] byArray) {
        String string2 = string + this._dataSeparator;
        String string3 = NameSpace._store.getNextKey(this._pindex, this._btreeindex, string2);
        if (string3 != null && string3.startsWith(string2)) {
            super.delRecord(string3);
        }
        if (string2.length() + byArray.length > 16384) {
            super.putRecord(string2, byArray);
        } else {
            super.putRecord(string2 + PackedNameSpace.encode(byArray), null);
        }
    }

    public void delRecord(String string) {
        String string2 = string + this._dataSeparator;
        String string3 = NameSpace._store.getNextKey(this._pindex, this._btreeindex, string2);
        if (string3 != null && string3.startsWith(string2)) {
            super.delRecord(string3);
        }
    }

    public synchronized void flush() {
        super.flush();
    }

    public Iterator getKeyIterator(String string, boolean bl) {
        return new filterIterator(NameSpace._store.getKeyIterator(this._pindex, this._btreeindex, string, bl));
    }

    public Iterator getReverseKeyIterator(String string, boolean bl) {
        return new filterIterator(NameSpace._store.getReverseKeyIterator(this._pindex, this._btreeindex, string, bl));
    }

    String keyFrom(String string) {
        return new String(string.substring(0, string.indexOf(this._dataSeparator)));
    }

    byte[] dataFrom(String string) {
        return PackedNameSpace.decode(string.substring(string.indexOf(this._dataSeparator) + 1));
    }

    static void encelem(char[] cArray, int n, byte[] byArray, int n2) {
        cArray[n++] = (char)((byArray[n2] >> 1 & 0x7F) + 1);
        cArray[n++] = (char)(((byArray[n2] << 6 & 0x40 | byArray[++n2] >> 2 & 0x3F) & 0x7F) + 1);
        cArray[n++] = (char)(((byArray[n2] << 5 & 0x60 | byArray[++n2] >> 3 & 0x1F) & 0x7F) + 1);
        cArray[n++] = (char)(((byArray[n2] << 4 & 0x70 | byArray[++n2] >> 4 & 0xF) & 0x7F) + 1);
        cArray[n++] = (char)(((byArray[n2] << 3 & 0x78 | byArray[++n2] >> 5 & 7) & 0x7F) + 1);
        cArray[n++] = (char)(((byArray[n2] << 2 & 0x7C | byArray[++n2] >> 6 & 3) & 0x7F) + 1);
        cArray[n++] = (char)(((byArray[n2] << 1 & 0x7E | byArray[++n2] >> 7 & 1) & 0x7F) + 1);
        cArray[n++] = (char)((byArray[n2] & 0x7F) + 1);
    }

    static void decelem(byte[] byArray, int n, byte[] byArray2, int n2) {
        byArray[n] = (byte)(byArray2[n2] << 1 | byArray2[++n2] >> 6 & 1);
        byArray[++n] = (byte)(byArray2[n2] << 2 | byArray2[++n2] >> 5 & 3);
        byArray[++n] = (byte)(byArray2[n2] << 3 | byArray2[++n2] >> 4 & 7);
        byArray[++n] = (byte)(byArray2[n2] << 4 | byArray2[++n2] >> 3 & 0xF);
        byArray[++n] = (byte)(byArray2[n2] << 5 | byArray2[++n2] >> 2 & 0x1F);
        byArray[++n] = (byte)(byArray2[n2] << 6 | byArray2[++n2] >> 1 & 0x3F);
        byArray[++n] = (byte)(byArray2[n2] << 7 | byArray2[++n2] & 0x7F);
    }

    public static String encode(byte[] byArray) {
        int n = byArray.length;
        int n2 = 64;
        while (n % 7 != 0) {
            ++n;
            n2 = (byte)(n2 + 1);
        }
        char[] cArray = new char[1 + 8 * (n / 7)];
        cArray[0] = (char)(n2 + 1);
        int n3 = 1;
        int n4 = 0;
        int n5 = byArray.length - 6;
        while (n4 < n5) {
            PackedNameSpace.encelem(cArray, n3, byArray, n4);
            n4 += 7;
            n3 += 8;
        }
        int n6 = byArray.length - n4;
        if (n6 != 0) {
            byte[] byArray2 = new byte[7];
            int n7 = 0;
            while (--n6 >= 0) {
                byArray2[n7++] = byArray[n4++];
            }
            while (n7 < 7) {
                byArray2[n7++] = 1;
            }
            PackedNameSpace.encelem(cArray, n3, byArray2, 0);
        }
        return new String(cArray);
    }

    public static byte[] decode(String string) {
        byte[] byArray;
        byte[] byArray2 = new byte[string.length()];
        int n = 0;
        while (n < string.length()) {
            byArray2[n] = (byte)(string.charAt(n) - '\u0001');
            ++n;
        }
        int n2 = byArray2[0] - 64;
        int n3 = 7 * ((byArray2.length - 1) / 8) - n2;
        byte[] byArray3 = byArray = new byte[n3];
        if (n3 < 7) {
            byArray3 = new byte[7];
        }
        int n4 = byArray2.length;
        if (n2 != 0) {
            PackedNameSpace.decelem(byArray3, 0, byArray2, n4 - 8);
            int n5 = 0;
            n2 = 7 - n2;
            while (n2 > 0) {
                byArray[n3 - n2--] = byArray3[n5++];
            }
            n4 -= 8;
        }
        int n6 = 0;
        int n7 = 1;
        while (n7 < n4) {
            PackedNameSpace.decelem(byArray, n6, byArray2, n7);
            n7 += 8;
            n6 += 7;
        }
        return byArray;
    }

    public class watchedByteArrayOutputStream
    extends ByteArrayOutputStream {
        String _key;

        public watchedByteArrayOutputStream(String string) {
            this._key = string;
        }

        public void close() {
            PackedNameSpace.this.putRecord(this._key, this.toByteArray());
        }
    }

    public class filterIterator
    implements Iterator {
        Iterator basit;

        filterIterator(Iterator iterator) {
            this.basit = iterator;
        }

        public Object next() {
            String string = (String)this.basit.next();
            return PackedNameSpace.this.keyFrom(string);
        }

        public boolean hasNext() {
            return this.basit.hasNext();
        }

        public void remove() {
            this.basit.remove();
        }
    }
}

