/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.persistence;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import oracle.ide.persistence.BPageCache;
import oracle.ide.persistence.ProfileConstants;
import oracle.ide.util.IdeProfile;

class Page {
    private static final int ORDER = 128;
    private static final int HALFORDER = 64;
    static boolean _flipflop;
    private Record[] _records = new Record[128];
    private int _count;
    private Page _parent;
    private int _uplink;
    private boolean _dirty = true;

    boolean isDirty() {
        return this._dirty;
    }

    Page(Page page) {
    }

    void saveToBlob(OutputStream outputStream) {
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        try {
            dataOutputStream.writeInt(this._count);
            dataOutputStream.writeInt(this._uplink);
            int n = 0;
            while (n < this._count) {
                Record record = this._records[n];
                dataOutputStream.writeUTF(record.key);
                dataOutputStream.writeInt(record.link);
                dataOutputStream.writeInt(record.dataAddress);
                ++n;
            }
            dataOutputStream.close();
            this._dirty = false;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void loadFromBlob(InputStream inputStream) {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        try {
            this._count = dataInputStream.readInt();
            this._uplink = dataInputStream.readInt();
            int n = 0;
            while (n < this._count) {
                Record record = new Record();
                record.key = dataInputStream.readUTF();
                record.link = dataInputStream.readInt();
                record.dataAddress = dataInputStream.readInt();
                this._records[n] = record;
                ++n;
            }
            dataInputStream.close();
            this._dirty = false;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void printPage(BPageCache bPageCache, int n, String string) {
        string = string + "| ";
        System.out.println(string + "---------" + this._parent + "------------");
        int n2 = 0;
        while (n2 < this._count) {
            int n3;
            if (this._records[n2].link != 0) {
                bPageCache.getPage(this._records[n2].link, n).printPage(bPageCache, n, string);
            }
            String string2 = (n3 = this._records[n2].key.indexOf(124)) != -1 ? this._records[n2].key.substring(0, n3) : this._records[n2].key;
            System.out.println(string + n2 + " " + string2);
            ++n2;
        }
        if (this._uplink != 0) {
            bPageCache.getPage(this._uplink, n).printPage(bPageCache, n, string);
        }
        System.out.println(string + "--------------------------------------");
    }

    String allKeys(BPageCache bPageCache, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < this._count) {
            if (this._records[n2].link != 0) {
                stringBuffer.append(bPageCache.getPage(this._records[n2].link, n).allKeys(bPageCache, n));
            }
            stringBuffer.append(this._records[n2].key);
            ++n2;
        }
        if (this._uplink != 0) {
            stringBuffer.append(bPageCache.getPage(this._uplink, n).allKeys(bPageCache, n));
        }
        return stringBuffer.toString();
    }

    static int findIPointInPage(Page page, String string) {
        int n = 0;
        while (n < page._count && string.compareTo(page._records[n].key) > 0) {
            ++n;
        }
        return n;
    }

    static void splitPage(BPageCache bPageCache, int n, Page page) {
        if (page._count < 128) {
            return;
        }
        int n2 = bPageCache.getNewPage(n);
        Page page2 = bPageCache.getPage(n2, n);
        page2._uplink = page._uplink;
        int n3 = 0;
        while (n3 < 64) {
            page2._records[n3] = page._records[64 + n3];
            page._records[64 + n3] = null;
            ++n3;
        }
        page2._count = 64;
        page2._dirty = true;
        page._dirty = true;
        page._count = 64;
        page._uplink = n2;
    }

    static Page findFromPage(BPageCache bPageCache, int n, Page page, String string) {
        Page page2 = page;
        Page page3 = null;
        do {
            int n2 = Page.findIPointInPage(page2, string);
            int n3 = 0;
            if (n2 < page2._count) {
                if (string.compareTo(page2._records[n2].key) != 0) {
                    n3 = page2._records[n2].link;
                }
            } else {
                n3 = page2._uplink;
            }
            if (n3 != 0) {
                Page page4 = bPageCache.getPage(n3, n);
                page4._parent = page2;
                page2 = page4;
                continue;
            }
            page3 = page2;
        } while (page3 == null);
        return page3;
    }

    static Page addRecordInPage(BPageCache bPageCache, Page page, int n, Record record) {
        Page page2 = null;
        int n2 = Page.findIPointInPage(page, record.key);
        page._dirty = true;
        if (page._count < 128) {
            if (n2 < page._count) {
                System.arraycopy(page._records, n2, page._records, n2 + 1, page._count - n2);
            }
            ++page._count;
            page._records[n2] = record;
        } else {
            Record[] recordArray = new Record[129];
            System.arraycopy(page._records, 0, recordArray, 0, n2);
            recordArray[n2] = record;
            System.arraycopy(page._records, n2, recordArray, n2 + 1, page._count - n2);
            Page page3 = page._parent;
            if (page3 == null) {
                if (_flipflop) {
                    _flipflop = false;
                    int n3 = bPageCache.getNewPage(n);
                    Page page4 = bPageCache.getPage(n3, n);
                    page4._parent = page;
                    int n4 = 0;
                    while (n4 < 64) {
                        page4._records[n4] = recordArray[n4];
                        page._records[n4] = recordArray[n4 + 64];
                        page._records[64 + n4] = null;
                        ++n4;
                    }
                    page._records[64] = recordArray[128];
                    page._count = 65;
                    page4._uplink = page._records[0].link;
                    if (page4._uplink != 0) {
                        bPageCache.getPage((int)page4._uplink, (int)n)._parent = page4;
                    }
                    page4._count = 64;
                    page._records[0].link = n3;
                    page4._dirty = true;
                } else {
                    _flipflop = true;
                    int n5 = bPageCache.getNewPage(n);
                    Page page5 = bPageCache.getPage(n5, n);
                    page5._parent = page;
                    int n6 = 0;
                    while (n6 < 64) {
                        page5._records[n6] = recordArray[n6 + 64];
                        page._records[n6] = recordArray[n6];
                        page._records[64 + n6] = null;
                        ++n6;
                    }
                    page5._records[64] = recordArray[128];
                    page5._count = 65;
                    page5._uplink = page._uplink;
                    if (page5._uplink != 0) {
                        bPageCache.getPage((int)page5._uplink, (int)n)._parent = page5;
                    }
                    page._uplink = n5;
                    page._count = 64;
                    page5._dirty = true;
                }
            } else {
                int n7 = bPageCache.getNewPage(n);
                Page page6 = bPageCache.getPage(n7, n);
                page6._parent = page;
                int n8 = 0;
                while (n8 < 64) {
                    page._records[n8] = recordArray[65 + n8];
                    page._records[64 + n8] = null;
                    page6._records[n8] = recordArray[n8];
                    ++n8;
                }
                page6._dirty = true;
                Record record2 = recordArray[64];
                page._count = 64;
                page6._count = 64;
                page6._uplink = record2.link;
                if (record2.link != 0) {
                    bPageCache.getPage((int)record2.link, (int)n)._parent = page6;
                }
                record2.link = n7;
                page2 = Page.addRecordInPage(bPageCache, page3, n, record2);
            }
        }
        return page2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this._count) {
            Record record = this._records[n];
            stringBuffer.append(record.key);
            stringBuffer.append("->");
            stringBuffer.append(record.link);
            stringBuffer.append(", ");
            ++n;
        }
        stringBuffer.append(" =>");
        stringBuffer.append(this._uplink);
        stringBuffer.append(" ");
        stringBuffer.append(this._dirty);
        return stringBuffer.toString();
    }

    static void addEntry(BPageCache bPageCache, int n, int n2, String string, int n3) {
        Page page = bPageCache.getPage(n2, n);
        Record record = new Record();
        record.key = string;
        record.dataAddress = n3;
        Page page2 = Page.findFromPage(bPageCache, n, page, string);
        Page page3 = Page.addRecordInPage(bPageCache, page2, n, record);
    }

    static void updateEntry(BPageCache bPageCache, int n, int n2, String string, int n3) {
        Page page = bPageCache.getPage(n2, n);
        Page page2 = Page.findFromPage(bPageCache, n, page, string);
        int n4 = Page.findIPointInPage(page2, string);
        if (n4 < page2._count && string.equals(page2._records[n4].key)) {
            page2._records[n4].dataAddress = n3;
            page2._dirty = true;
        }
    }

    static int getEntry(BPageCache bPageCache, int n, int n2, String string) {
        Page page;
        Page page2;
        int n3;
        int n4 = -1;
        if (ProfileConstants.OK_PGGET) {
            n4 = IdeProfile.startEvent(3820, " grp " + n + " idx " + n2 + " [" + string + "]");
        }
        if ((n3 = Page.findIPointInPage(page2 = Page.findFromPage(bPageCache, n, page = bPageCache.getPage(n2, n), string), string)) < page2._count && string.equals(page2._records[n3].key)) {
            if (ProfileConstants.OK_PGGET) {
                IdeProfile.endEvent(n4, " found " + page2._records[n3].dataAddress);
            }
            return page2._records[n3].dataAddress;
        }
        if (ProfileConstants.OK_PGGET) {
            IdeProfile.endEvent(n4, " Not found ");
        }
        return -1;
    }

    static String getPreviousEntry(BPageCache bPageCache, int n, int n2, String string) {
        String string2;
        int n3 = -1;
        if (ProfileConstants.OK_PGGETPREV) {
            n3 = IdeProfile.startEvent(3821, " grp " + n + " idx " + n2 + " [" + string + "]");
        }
        Page page = bPageCache.getPage(n2, n);
        int n4 = page._uplink;
        int n5 = page._count - 1;
        while (n5 >= 0 && string.compareTo(page._records[n5].key) <= 0) {
            n4 = page._records[n5].link;
            --n5;
        }
        if (n4 != 0 && (string2 = Page.getPreviousEntry(bPageCache, n, n4, string)) != null) {
            if (ProfileConstants.OK_PGGETPREV) {
                IdeProfile.startEvent(n3, " found [" + string2 + "]");
            }
            return string2;
        }
        if (n5 < 0) {
            if (ProfileConstants.OK_PGGETPREV) {
                IdeProfile.startEvent(n3, " Not found");
            }
            return null;
        }
        Record record = page._records[n5];
        if (ProfileConstants.OK_PGGETPREV) {
            IdeProfile.startEvent(n3, " found [" + record.key + "]");
        }
        return record.key;
    }

    private static String getNextEntryInt(BPageCache bPageCache, int n, int n2, String string) {
        String string2;
        Page page = bPageCache.getPage(n2, n);
        int n3 = 0;
        while (n3 < page._count && string.compareTo(page._records[n3].key) >= 0) {
            ++n3;
        }
        if (n3 == page._count) {
            if (page._uplink != 0) {
                return Page.getNextEntryInt(bPageCache, n, page._uplink, string);
            }
            return null;
        }
        Record record = page._records[n3];
        if (record.link != 0 && (string2 = Page.getNextEntryInt(bPageCache, n, record.link, string)) != null) {
            return string2;
        }
        return record.key;
    }

    static String getNextEntry(BPageCache bPageCache, int n, int n2, String string) {
        int n3 = -1;
        if (ProfileConstants.OK_PGGETNEXT) {
            n3 = IdeProfile.startEvent(3822, " grp " + n + " idx " + n2 + " [" + string + "]");
        }
        String string2 = Page.getNextEntryInt(bPageCache, n, n2, string);
        if (ProfileConstants.OK_PGGETNEXT) {
            if (string2 == null) {
                IdeProfile.endEvent(n3, " not found");
            } else {
                IdeProfile.endEvent(n3, " Found [" + string2 + "]");
            }
        }
        return string2;
    }

    static String getPreviousEntryIgnoreCase(BPageCache bPageCache, int n, int n2, String string) {
        Page page = bPageCache.getPage(n2, n);
        int n3 = page._uplink;
        int n4 = page._count - 1;
        while (n4 >= 0 && string.compareToIgnoreCase(page._records[n4].key) < 0) {
            n3 = page._records[n4].link;
            --n4;
        }
        if (n3 != 0) {
            return Page.getPreviousEntryIgnoreCase(bPageCache, n, n3, string);
        }
        if (n4 < 0) {
            return null;
        }
        Record record = page._records[n4];
        return record.key;
    }

    static String getNextEntryIgnoreCase(BPageCache bPageCache, int n, int n2, String string) {
        String string2;
        Page page = bPageCache.getPage(n2, n);
        int n3 = 0;
        while (n3 < page._count && string.compareToIgnoreCase(page._records[n3].key) >= 0) {
            ++n3;
        }
        if (n3 == page._count) {
            if (page._uplink != 0) {
                return Page.getNextEntryIgnoreCase(bPageCache, n, page._uplink, string);
            }
            return null;
        }
        Record record = page._records[n3];
        if (record.link != 0 && (string2 = Page.getNextEntryIgnoreCase(bPageCache, n, record.link, string)) != null) {
            return string2;
        }
        return record.key;
    }

    static Record findLeftMostRecord(BPageCache bPageCache, int n, int n2) {
        Page page = bPageCache.getPage(n2, n);
        Record record = page._records[0];
        if (record.link == 0) {
            return record;
        }
        return Page.findLeftMostRecord(bPageCache, n, record.link);
    }

    static Record findRightMostRecord(BPageCache bPageCache, int n, int n2) {
        Page page = bPageCache.getPage(n2, n);
        if (page._uplink == 0) {
            Record record;
            Record record2 = page._records[page._count - 1];
            if (record2.link == 0) {
                --page._count;
                page._records[page._count] = null;
                page._dirty = true;
                if (page._count != 0) {
                    record2.link = n2;
                } else {
                    bPageCache.freePage(n2);
                }
                return record2;
            }
            Page page2 = bPageCache.getPage(record2.link, n);
            page2._parent = page;
            page._records[page._count - 1] = record = Page.findRightMostRecord(bPageCache, n, record2.link);
            page._dirty = true;
            if (record.link == 0) {
                bPageCache.freePage(record2.link);
            }
            record2.link = n2;
            return record2;
        }
        Page page3 = bPageCache.getPage(page._uplink, n);
        page3._parent = page;
        Record record = Page.findRightMostRecord(bPageCache, n, page._uplink);
        if (record.link == 0) {
            bPageCache.freePage(page._uplink);
            page._uplink = 0;
        }
        record.link = n2;
        page._dirty = true;
        return record;
    }

    static Record findAndRemove(BPageCache bPageCache, int n, Page page, String string) {
        int n2 = Page.findIPointInPage(page, string);
        if (n2 < page._count) {
            Record record = page._records[n2];
            if (string.equals(record.key)) {
                page._dirty = true;
                if (record.link != 0) {
                    Record record2;
                    bPageCache.getPage((int)record.link, (int)n)._parent = page;
                    page._records[n2] = record2 = Page.findRightMostRecord(bPageCache, n, record.link);
                    return null;
                }
                --page._count;
                System.arraycopy(page._records, n2 + 1, page._records, n2, page._count - n2);
                page._records[page._count] = null;
                if (page._count != 0) {
                    return null;
                }
                if (page._uplink != 0) {
                    Record record3;
                    page._records[0] = record3 = Page.findRightMostRecord(bPageCache, n, page._uplink);
                    ++page._count;
                    page._uplink = 0;
                    return null;
                }
                return record;
            }
            if (record.link != 0) {
                Page page2 = bPageCache.getPage(record.link, n);
                page2._parent = page;
                Record record4 = Page.findAndRemove(bPageCache, n, page2, string);
                if (record4 != null) {
                    bPageCache.freePage(record.link);
                    record.link = 0;
                    page._dirty = true;
                }
                return null;
            }
        } else if (page._uplink != 0) {
            Page page3 = bPageCache.getPage(page._uplink, n);
            page3._parent = page;
            Record record = Page.findAndRemove(bPageCache, n, page3, string);
            if (record != null) {
                bPageCache.freePage(page._uplink);
                page._uplink = 0;
                page._dirty = true;
            }
            return null;
        }
        return null;
    }

    static void removeString(BPageCache bPageCache, int n, int n2, String string) {
        int n3 = -1;
        if (ProfileConstants.OK_PGREMOVE) {
            n3 = IdeProfile.startEvent(3825, " grp " + n + " idx " + n2 + " [" + string + "]");
        }
        Page page = bPageCache.getPage(n2, n);
        Page.findAndRemove(bPageCache, n, page, string);
        if (ProfileConstants.OK_PGREMOVE) {
            IdeProfile.endEvent(n3);
        }
    }

    static void checkPage(String string, BPageCache bPageCache, int n, int n2, String string2, boolean bl) {
        Page page = bPageCache.getPage(n2, n);
        String string3 = null;
        int n3 = 0;
        while (n3 < page._count) {
            Record record = page._records[n3];
            if (string2 != null) {
                if (bl) {
                    if (string2.compareTo(record.key) <= 0) {
                        System.out.println("OOPS " + n + "/" + n2 + " key " + record.key + " not smaller than " + string2 + string);
                        System.err.println("got structure errors" + string);
                    }
                } else if (string2.compareTo(record.key) >= 0) {
                    System.out.println("OOPS " + n + "/" + n2 + " key " + record.key + " not bigger than " + string2 + string);
                    System.err.println("got structure errors " + string);
                }
            }
            if (record.link != 0) {
                Page.checkPage(string, bPageCache, n, record.link, record.key, true);
            }
            string3 = record.key;
            ++n3;
        }
        if (page._uplink != 0) {
            Page.checkPage(string, bPageCache, n, page._uplink, string3, false);
        }
    }

    static void printAllPages(BPageCache bPageCache, int n, int n2) {
        Page page = bPageCache.getPage(n2, n);
        page.printPage(bPageCache, n, "");
    }

    static class Record {
        String key;
        int link;
        int dataAddress;

        Record() {
        }
    }
}

