/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.persistence;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.util.Iterator;
import oracle.ide.persistence.BPageCache;
import oracle.ide.persistence.DataPage;
import oracle.ide.persistence.FreePageMap;
import oracle.ide.persistence.NameSpace;
import oracle.ide.persistence.PackedNameSpace;
import oracle.ide.persistence.Page;
import oracle.ide.persistence.ProfileConstants;
import oracle.ide.util.IdeProfile;
import oracle.ide.util.IntHashMap;

final class StorageFile {
    private static final int MAJORVERSION = 0;
    private static final int MINORVERSION = 1;
    static final int BLKSIZE = 1024;
    private static final byte PAGE_TYPE_FREEPAGEMAP = 1;
    private static final byte PAGE_TYPE_FREEBITSET = 2;
    static final byte PAGE_TYPE_DATAPAGE = 3;
    private static final int FILEHEADERSIZE = 26;
    private static final byte[] MAGIC = new byte[]{75, 82, 54, 52, 77, 82, 54, 53};
    private String _fname;
    private RandomAccessFile _file;
    private FileLock _fileLock;
    private byte _majorVersion;
    private byte _minorVersion;
    private int _endPage;
    private FreePageMap _freeMap;
    private int[] _freeMapStorage;
    private int _blkSize;
    private BPageCache _pc;
    private int _nsBIndex;
    private int _nsBpindex;
    private int _firstNS;
    private IntHashMap _openTrans;
    private IntHashMap _groupLocks;
    static final Integer[] INT_CST_LIST = new Integer[10];
    private static byte[] NULL_BYTES = new byte[0];

    StorageFile(String string) {
        this._fname = string;
    }

    long getmsize() {
        return this._endPage;
    }

    void dumpFile() {
        int n = 1;
        byte[] byArray = new byte[1024];
        while (n < this._endPage) {
            this.readBytesFromOffset(byArray, 0, 1, n * 1024);
            if (!this._freeMap.isFree(n)) {
                switch (byArray[0]) {
                    case 1: {
                        System.out.print("Page " + n + " ");
                        System.out.println("Free Pages Map Indexes");
                        this.readBytesFromOffset(byArray, 0, 4 * this._freeMapStorage.length, 1 + n * 1024);
                        int n2 = 0;
                        int n3 = 0;
                        while (n3 < this._freeMapStorage.length) {
                            System.out.print(StorageFile.intFromArray(byArray, n2) + ",");
                            if ((n2 += 4) % 80 == 0) {
                                System.out.println();
                            }
                            ++n3;
                        }
                        System.out.println();
                        break;
                    }
                    case 2: {
                        System.out.print("Page " + n + " ");
                        System.out.println("Freepage Bitset");
                        this.readBytesFromOffset(byArray, 0, 1023, 1 + n * 1024);
                        int n4 = 0;
                        while (n4 < 1023) {
                            int n5 = byArray[n4] & 0xFF;
                            System.out.print(Integer.toHexString(n5 + 256).substring(1).toUpperCase());
                            if (n4 % 64 == 63) {
                                System.out.println();
                            }
                            ++n4;
                        }
                        System.out.println();
                        break;
                    }
                    case 3: {
                        break;
                    }
                    default: {
                        System.out.println("UNKNOW TYPE " + byArray[0]);
                    }
                }
            }
            ++n;
        }
    }

    boolean open() {
        if (this._file == null) {
            try {
                File file = new File(this._fname + ".stf");
                file = file.getParentFile();
                if (file != null) {
                    file.mkdirs();
                }
                this._file = new RandomAccessFile(this._fname + ".stf", "rw");
                this._fileLock = this._file.getChannel().tryLock();
                if (this._fileLock == null) {
                    boolean bl = false;
                    return bl;
                }
                this.initDataStructures();
                boolean bl = true;
                return bl;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean readBytesFromOffset(byte[] byArray, int n) {
        int n2 = -1;
        if (ProfileConstants.OK_LLREAD) {
            n2 = IdeProfile.startEvent(3801, "Ofs " + n + " Bytes " + byArray.length);
        }
        try {
            RandomAccessFile randomAccessFile = this._file;
            synchronized (randomAccessFile) {
                this._file.seek(n);
                this._file.readFully(byArray);
            }
            if (ProfileConstants.OK_LLREAD) {
                IdeProfile.endEvent(n2);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            if (ProfileConstants.OK_LLREAD) {
                IdeProfile.endEvent(n2, " FAILED");
            }
            boolean bl = false;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean readBytesFromOffset(byte[] byArray, int n, int n2, int n3) {
        int n4 = -1;
        if (ProfileConstants.OK_LLREAD) {
            n4 = IdeProfile.startEvent(3801, "Ofs " + n3 + " Bytes " + n2);
        }
        try {
            RandomAccessFile randomAccessFile = this._file;
            synchronized (randomAccessFile) {
                this._file.seek(n3);
                this._file.readFully(byArray, n, n2);
            }
            if (ProfileConstants.OK_LLREAD) {
                IdeProfile.endEvent(n4);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            if (ProfileConstants.OK_LLREAD) {
                IdeProfile.endEvent(n4, " FAILED");
            }
            boolean bl = false;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean writeBytesFromOffset(byte[] byArray, int n) {
        int n2 = -1;
        if (ProfileConstants.OK_LLWRITE) {
            n2 = IdeProfile.startEvent(3802, "Ofs " + n + " Bytes " + byArray.length);
        }
        try {
            RandomAccessFile randomAccessFile = this._file;
            synchronized (randomAccessFile) {
                this._file.seek(n);
                this._file.write(byArray);
            }
            if (ProfileConstants.OK_LLWRITE) {
                IdeProfile.endEvent(n2);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            if (ProfileConstants.OK_LLWRITE) {
                IdeProfile.endEvent(n2, "FAILED");
            }
            boolean bl = false;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean writeBytesFromOffset(byte[] byArray, int n, int n2, int n3) {
        int n4 = -1;
        if (ProfileConstants.OK_LLWRITE) {
            n4 = IdeProfile.startEvent(3802, "Ofs " + n3 + " Bytes " + n2);
        }
        try {
            RandomAccessFile randomAccessFile = this._file;
            synchronized (randomAccessFile) {
                this._file.seek(n3);
                this._file.write(byArray, n, n2);
            }
            if (ProfileConstants.OK_LLWRITE) {
                IdeProfile.endEvent(n4);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            if (ProfileConstants.OK_LLWRITE) {
                IdeProfile.endEvent(n4, " FAILED");
            }
            boolean bl = false;
            return bl;
        }
    }

    static int intFromArray(byte[] byArray, int n) {
        return ((byArray[n++] & 0xFF) << 24) + ((byArray[n++] & 0xFF) << 16) + ((byArray[n++] & 0xFF) << 8) + (byArray[n] & 0xFF);
    }

    static long longFromArray(byte[] byArray, int n) {
        return ((long)StorageFile.intFromArray(byArray, n) << 32) + ((long)StorageFile.intFromArray(byArray, n + 4) & (long)-1);
    }

    static void intToArray(int n, byte[] byArray, int n2) {
        byArray[n2++] = (byte)(n >>> 24 & 0xFF);
        byArray[n2++] = (byte)(n >>> 16 & 0xFF);
        byArray[n2++] = (byte)(n >>> 8 & 0xFF);
        byArray[n2++] = (byte)(n & 0xFF);
    }

    static void longToArray(long l, byte[] byArray, int n) {
        byArray[n++] = (byte)(l >>> 56 & 0xFFL);
        byArray[n++] = (byte)(l >>> 48 & 0xFFL);
        byArray[n++] = (byte)(l >>> 40 & 0xFFL);
        byArray[n++] = (byte)(l >>> 32 & 0xFFL);
        byArray[n++] = (byte)(l >>> 24 & 0xFFL);
        byArray[n++] = (byte)(l >>> 16 & 0xFFL);
        byArray[n++] = (byte)(l >>> 8 & 0xFFL);
        byArray[n++] = (byte)(l & 0xFFL);
    }

    void flushFreePages(boolean bl) {
        boolean bl2 = bl;
        byte[] byArray = new byte[]{2};
        int n = this._freeMap.getDirtyIndex();
        while (n != -1) {
            int n2 = this._freeMapStorage[n];
            if (n2 == 0) {
                this._freeMapStorage[n] = this.getFreePage();
                bl2 = true;
            } else {
                this.writeBytesFromOffset(byArray, n2 * 1024);
                this.writeBytesFromOffset(this._freeMap.getPageDatas(n), 1 + n2 * 1024);
                this._freeMap.clearDirty(n);
            }
            n = this._freeMap.getDirtyIndex();
        }
        if (bl2) {
            byArray = new byte[1024];
            byArray[0] = 1;
            int n3 = 1;
            int n4 = 0;
            while (n4 < this._freeMapStorage.length) {
                StorageFile.intToArray(this._freeMapStorage[n4], byArray, n3);
                n3 += 4;
                ++n4;
            }
            this.writeBytesFromOffset(byArray, 1024);
        }
    }

    void loadFreePages(int n) {
        this._freeMap = new FreePageMap();
        this._freeMapStorage = new int[255];
        byte[] byArray = new byte[1024];
        byte[] byArray2 = new byte[1024];
        this.readBytesFromOffset(byArray, n * 1024);
        if (byArray[0] != 1) {
            System.err.println("OOPS wrong FreePageMap page tag");
        }
        int n2 = 1;
        int n3 = 0;
        int n4 = StorageFile.intFromArray(byArray, n2);
        n2 += 4;
        while (n4 != 0) {
            this._freeMapStorage[n3] = n4;
            this.readBytesFromOffset(byArray2, n4 * 1024);
            if (byArray2[0] != 2) {
                System.err.println("OOPS wrong FreePage BitSet page tag");
            }
            this._freeMap.setPageDatas(n3, byArray2, 1, 1023);
            ++n3;
            n4 = StorageFile.intFromArray(byArray, n2);
            n2 += 4;
        }
    }

    void initDataStructures() {
        boolean bl = true;
        this._pc = new BPageCache(this);
        this._openTrans = new IntHashMap();
        this._groupLocks = new IntHashMap();
        byte[] byArray = new byte[26];
        if (this.readBytesFromOffset(byArray, 0)) {
            int n = 0;
            int n2 = 0;
            while (n2 < MAGIC.length) {
                if (byArray[n++] != MAGIC[n2]) {
                    bl = false;
                }
                ++n2;
            }
            if (bl) {
                this._majorVersion = byArray[n++];
                this._minorVersion = byArray[n++];
                this._blkSize = StorageFile.intFromArray(byArray, n);
                int n3 = StorageFile.intFromArray(byArray, n += 4);
                this._nsBIndex = StorageFile.intFromArray(byArray, n += 4);
                this._firstNS = StorageFile.intFromArray(byArray, n += 4);
                n += 4;
                this.loadFreePages(n3);
                try {
                    this._endPage = (int)((this._file.length() + 1023L & 0xFFFFFFFFFFFFFC00L) / 1024L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.checkNameSpaces();
            }
        } else {
            bl = false;
        }
        if (!bl) {
            this._endPage = 2;
            this._blkSize = 1024;
            this._freeMap = new FreePageMap();
            this._freeMapStorage = new int[255];
            this._firstNS = 0;
            this.flushFreePages(true);
            this._nsBIndex = this.createTreeIndex("$$root$$");
            this.saveHeader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getGroupLock(int n) {
        IntHashMap intHashMap = this._groupLocks;
        synchronized (intHashMap) {
            Object object = this._groupLocks.get(n);
            if (object == null) {
                object = new Object();
                this._groupLocks.put(n, object);
            }
            Object object2 = object;
            return object2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanGroup(int n) {
        int n2 = 1;
        this._pc.cleanGroup(n);
        IntHashMap intHashMap = this._groupLocks;
        synchronized (intHashMap) {
            this._groupLocks.remove(n);
        }
        byte[] byArray = new byte[1024];
        while (n2 < this._endPage) {
            this.readBytesFromOffset(byArray, 0, 1, n2 * 1024);
            if (!this._freeMap.isFree(n2)) {
                switch (byArray[0]) {
                    case 3: {
                        this.readBytesFromOffset(byArray, n2 * 1024);
                        int n3 = StorageFile.intFromArray(byArray, 2);
                        if (n != n3) break;
                        this.releasePage(n2);
                    }
                }
            }
            ++n2;
        }
        this.flush();
    }

    private boolean checkNameSpace(int n) {
        NsPageDesc nsPageDesc = new NsPageDesc(n);
        if (!nsPageDesc._clean) {
            this.cleanGroup(n);
            this._pc.startTrans();
            nsPageDesc._rootpage = this._pc.getNewPage(n);
            this._pc.flush(n);
            this._pc.endTrans();
            nsPageDesc.save(false);
            this.flush();
        }
        return nsPageDesc._clean;
    }

    private void checkNameSpaces() {
        int n;
        if (!this.checkNameSpace(this._nsBIndex)) {
            NsPageDesc nsPageDesc = new NsPageDesc(this._nsBIndex);
            this._nsBpindex = nsPageDesc._rootpage;
            n = this._firstNS;
            this._pc.startTrans();
            while (n != 0) {
                NsPageDesc nsPageDesc2 = new NsPageDesc(n);
                Page.addEntry(this._pc, this._nsBIndex, nsPageDesc._rootpage, nsPageDesc2._name, nsPageDesc2._addr);
                n = nsPageDesc2._next;
            }
            this._pc.flush(this._nsBIndex);
            this._pc.endTrans();
            this.flush();
            nsPageDesc._clean = true;
            nsPageDesc.save(false);
            this.flush();
        } else {
            NsPageDesc nsPageDesc = new NsPageDesc(this._nsBIndex);
            this._nsBpindex = nsPageDesc._rootpage;
        }
        n = this._firstNS;
        while (n != 0) {
            NsPageDesc nsPageDesc = new NsPageDesc(n);
            this.checkNameSpace(n);
            n = nsPageDesc._next;
        }
    }

    synchronized void deleteNameSpace(NameSpace nameSpace) {
        NsPageDesc nsPageDesc = new NsPageDesc(nameSpace._pindex);
        nsPageDesc._clean = false;
        nsPageDesc.save(false);
        this.cleanGroup(nameSpace._pindex);
        NsPageDesc nsPageDesc2 = new NsPageDesc(this._nsBIndex);
        nsPageDesc2._clean = false;
        nsPageDesc2.save(false);
        this.flush();
        this._pc.startTrans();
        Page.removeString(this._pc, this._nsBIndex, this._nsBpindex, nsPageDesc._name);
        this._pc.flush(this._nsBIndex);
        this._pc.endTrans();
        if (nsPageDesc._next != 0) {
            NsPageDesc nsPageDesc3 = new NsPageDesc(nsPageDesc._next);
            nsPageDesc3._prev = nsPageDesc._prev;
            nsPageDesc3.save(false);
        }
        if (nsPageDesc._prev != 0) {
            NsPageDesc nsPageDesc4 = new NsPageDesc(nsPageDesc._prev);
            nsPageDesc4._next = nsPageDesc._next;
            nsPageDesc4.save(false);
        } else {
            this._firstNS = nsPageDesc._next;
        }
        this.saveHeader();
        this.deleteBlob(nsPageDesc._addr);
        nsPageDesc2._clean = true;
        nsPageDesc2.save(false);
        this.flush();
    }

    Iterator getNameSpaceIterator(String string, boolean bl) {
        return new nsIterator(string, this._nsBIndex, this._nsBpindex, bl);
    }

    Iterator getKeyIterator(int n, int n2, String string, boolean bl) {
        return new nsIterator(string, n, n2, bl);
    }

    Iterator getReverseNameSpaceIterator(String string, boolean bl) {
        return new nsReverseIterator(string, this._nsBIndex, this._nsBpindex, bl);
    }

    Iterator getReverseKeyIterator(int n, int n2, String string, boolean bl) {
        return new nsReverseIterator(string, n, n2, bl);
    }

    synchronized NameSpace getNameSpace(String string, int n) {
        this._pc.startTrans();
        int n2 = Page.getEntry(this._pc, this._nsBIndex, this._nsBpindex, string);
        this._pc.endTrans();
        if (n2 == -1) {
            NsPageDesc nsPageDesc = new NsPageDesc();
            n2 = nsPageDesc._addr = this.getFreePage();
            nsPageDesc._name = string;
            nsPageDesc._clean = true;
            NsPageDesc nsPageDesc2 = new NsPageDesc(this._nsBIndex);
            nsPageDesc2._clean = false;
            nsPageDesc2.save(false);
            this.flush();
            this._pc.startTrans();
            nsPageDesc._rootpage = this._pc.getNewPage(nsPageDesc._addr);
            Page.addEntry(this._pc, this._nsBIndex, this._nsBpindex, string, nsPageDesc._addr);
            this._pc.flush(this._nsBIndex);
            this._pc.endTrans();
            if (this._firstNS != 0) {
                NsPageDesc nsPageDesc3 = new NsPageDesc(this._firstNS);
                nsPageDesc3._prev = nsPageDesc._addr;
                nsPageDesc3.save(false);
            }
            nsPageDesc._next = this._firstNS;
            this._firstNS = nsPageDesc._addr;
            this.saveHeader();
            nsPageDesc.save(true);
            nsPageDesc2._clean = true;
            nsPageDesc2.save(false);
            this.flush();
        }
        NsPageDesc nsPageDesc = new NsPageDesc(n2);
        switch (n) {
            case 0: {
                return new NameSpace(nsPageDesc._addr, nsPageDesc._rootpage);
            }
            case 1: {
                return new PackedNameSpace(nsPageDesc._addr, nsPageDesc._rootpage);
            }
        }
        return null;
    }

    private int createTreeIndex(String string) {
        int n = this.getFreePage();
        DataOutputStream dataOutputStream = new DataOutputStream(this.getNewOSFromRec(n, 0));
        this._pc.startTrans();
        int n2 = this._pc.getNewPage(n);
        try {
            dataOutputStream.writeBoolean(true);
            dataOutputStream.writeInt(0);
            dataOutputStream.writeInt(0);
            dataOutputStream.writeInt(n2);
            this._nsBpindex = n2;
            dataOutputStream.writeUTF(string);
            dataOutputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._pc.flush(n);
        this._pc.endTrans();
        this.flush();
        return n;
    }

    private boolean saveHeader() {
        byte[] byArray = new byte[26];
        int n = 0;
        System.arraycopy(MAGIC, 0, byArray, 0, MAGIC.length);
        n += 8;
        byArray[n++] = 0;
        byArray[n++] = 1;
        StorageFile.intToArray(1024, byArray, n);
        StorageFile.intToArray(1, byArray, n += 4);
        StorageFile.intToArray(this._nsBIndex, byArray, n += 4);
        StorageFile.intToArray(this._firstNS, byArray, n += 4);
        n += 4;
        return this.writeBytesFromOffset(byArray, 0);
    }

    boolean close() {
        if (this._file != null) {
            try {
                this.flushFreePages(false);
                this._file.close();
                this._file = null;
                boolean bl = true;
                return bl;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    byte[] getFullPage(int n) {
        byte[] byArray = new byte[1024];
        this.readBytesFromOffset(byArray, n * 1024);
        return byArray;
    }

    int getFreePage() {
        int n = this._freeMap.getFreePos();
        if (n == -1) {
            n = this._endPage++;
        }
        return n;
    }

    void releasePage(int n) {
        this._freeMap.setFree(n);
    }

    OutputStream getOSFromRec(int n, int n2) {
        return DataPage.updatePageGroup(this, n2, n);
    }

    OutputStream getNewOSFromRec(int n, int n2) {
        return DataPage.newPageGroup(this, n2, n);
    }

    InputStream getISFromRec(int n) {
        return DataPage.readPageGroup(this, n);
    }

    private Integer getSmallInteger(int n) {
        if (n < INT_CST_LIST.length) {
            if (INT_CST_LIST[n] == null) {
                StorageFile.INT_CST_LIST[n] = new Integer(n);
            }
            return INT_CST_LIST[n];
        }
        return new Integer(n);
    }

    synchronized void incDirty(int n) {
        Integer n2 = (Integer)this._openTrans.get(n);
        if (n2 == null) {
            NsPageDesc nsPageDesc = new NsPageDesc(n);
            nsPageDesc._clean = false;
            nsPageDesc.save(false);
            this.flush();
            this._openTrans.put(n, this.getSmallInteger(1));
        } else {
            this._openTrans.put(n, this.getSmallInteger(n2 + 1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void decDirty(int n) {
        Object object = this.getGroupLock(n);
        synchronized (object) {
            Integer n2 = (Integer)this._openTrans.get(n);
            if (n2 != null) {
                if (n2 <= 1) {
                    NsPageDesc nsPageDesc = new NsPageDesc(n);
                    nsPageDesc._clean = true;
                    this._pc.flush(n);
                    nsPageDesc.save(false);
                    this.flush();
                    this._openTrans.remove(n);
                } else {
                    this._openTrans.put(n, this.getSmallInteger(n2 - 1));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InputStream getISFromKey(int n, int n2, String string) {
        Object object = this.getGroupLock(n);
        synchronized (object) {
            this._pc.startTrans();
            int n3 = Page.getEntry(this._pc, n, n2, string);
            this._pc.endTrans();
            if (n3 == -1) {
                InputStream inputStream = null;
                return inputStream;
            }
            InputStream inputStream = this.getISFromRec(n3);
            return inputStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteFromKey(int n, int n2, String string) {
        Object object = this.getGroupLock(n);
        synchronized (object) {
            this._pc.startTrans();
            int n3 = Page.getEntry(this._pc, n, n2, string);
            this._pc.endTrans();
            if (n3 == -1) {
                return;
            }
            this._pc.startTrans();
            Page.removeString(this._pc, n, n2, string);
            this._pc.endTrans();
            if (n3 != 0) {
                this.deleteBlob(n3);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] getISBytesFromKey(int n, int n2, String string) {
        Object object = this.getGroupLock(n);
        synchronized (object) {
            this._pc.startTrans();
            int n3 = Page.getEntry(this._pc, n, n2, string);
            this._pc.endTrans();
            if (n3 == 0) {
                byte[] byArray = NULL_BYTES;
                return byArray;
            }
            if (n3 == -1) {
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = DataPage.readFullPageGroup(this, n3);
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getNextKey(int n, int n2, String string) {
        Object object = this.getGroupLock(n);
        synchronized (object) {
            this._pc.startTrans();
            String string2 = Page.getNextEntry(this._pc, n, n2, string);
            this._pc.endTrans();
            String string3 = string2;
            return string3;
        }
    }

    void checkTree(String string, int n, int n2) {
        this._pc.startTrans();
        Page.checkPage(string, this._pc, n, n2, null, true);
        this._pc.endTrans();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OutputStream getOSFromKey(int n, int n2, String string) {
        OutputStream outputStream;
        Object object = this.getGroupLock(n);
        synchronized (object) {
            this._pc.startTrans();
            int n3 = Page.getEntry(this._pc, n, n2, string);
            if (n3 == -1) {
                n3 = this.getFreePage();
                outputStream = this.getNewOSFromRec(n3, n);
                Page.addEntry(this._pc, n, n2, string, n3);
            } else if (n3 == 0) {
                n3 = this.getFreePage();
                outputStream = this.getNewOSFromRec(n3, n);
                Page.updateEntry(this._pc, n, n2, string, n3);
            } else {
                outputStream = this.getOSFromRec(n3, n);
            }
            this._pc.endTrans();
        }
        return outputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateEmptyKey(int n, int n2, String string) {
        Object object = this.getGroupLock(n);
        synchronized (object) {
            this._pc.startTrans();
            int n3 = Page.getEntry(this._pc, n, n2, string);
            if (n3 == -1) {
                Page.addEntry(this._pc, n, n2, string, 0);
            } else if (n3 != 0) {
                this.deleteBlob(n3);
                Page.updateEntry(this._pc, n, n2, string, n3);
            }
            this._pc.endTrans();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkKey(int n, int n2, String string) {
        int n3;
        Object object = this.getGroupLock(n);
        synchronized (object) {
            this._pc.startTrans();
            n3 = Page.getEntry(this._pc, n, n2, string);
            this._pc.endTrans();
        }
        return n3 != -1;
    }

    int addBlob(byte[] byArray, int n) {
        int n2 = this.getFreePage();
        OutputStream outputStream = DataPage.newPageGroup(this, n, n2);
        try {
            outputStream.write(byArray);
            outputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n2;
    }

    void updateBlob(byte[] byArray, int n, int n2) {
        OutputStream outputStream = DataPage.updatePageGroup(this, n2, n);
        try {
            outputStream.write(byArray);
            outputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void deleteBlob(int n) {
        DataPage.deletePageGroup(this, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flush() {
        this.flushFreePages(false);
        int n = -1;
        if (ProfileConstants.OK_LLFLUSH) {
            n = IdeProfile.startEvent(3803);
        }
        try {
            RandomAccessFile randomAccessFile = this._file;
            synchronized (randomAccessFile) {
                this._file.getChannel().force(false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (ProfileConstants.OK_LLFLUSH) {
            IdeProfile.endEvent(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void printTreePages(int n, int n2) {
        Object object = this.getGroupLock(n);
        synchronized (object) {
            this._pc.startTrans();
            Page.printAllPages(this._pc, n, n2);
            this._pc.endTrans();
        }
    }

    static BPageCache ra$_pc(StorageFile storageFile) {
        return storageFile._pc;
    }

    static class SingleWrite
    implements Comparable {
        int _offset;
        byte[] _buff;

        public SingleWrite(int n, byte[] byArray) {
            this._offset = n;
            this._buff = byArray;
        }

        public int compareTo(Object object) {
            SingleWrite singleWrite = (SingleWrite)object;
            return singleWrite._offset - this._offset;
        }
    }

    class NsPageDesc {
        int _addr;
        boolean _clean;
        int _next;
        int _prev;
        int _rootpage;
        String _name;

        NsPageDesc(int n) {
            this._addr = n;
            DataInputStream dataInputStream = new DataInputStream(StorageFile.this.getISFromRec(this._addr));
            try {
                this._clean = dataInputStream.readBoolean();
                this._next = dataInputStream.readInt();
                this._prev = dataInputStream.readInt();
                this._rootpage = dataInputStream.readInt();
                this._name = dataInputStream.readUTF();
                dataInputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        NsPageDesc() {
        }

        void save(boolean bl) {
            DataOutputStream dataOutputStream = bl ? new DataOutputStream(StorageFile.this.getNewOSFromRec(this._addr, 0)) : new DataOutputStream(StorageFile.this.getOSFromRec(this._addr, 0));
            try {
                dataOutputStream.writeBoolean(this._clean);
                dataOutputStream.writeInt(this._next);
                dataOutputStream.writeInt(this._prev);
                dataOutputStream.writeInt(this._rootpage);
                dataOutputStream.writeUTF(this._name);
                dataOutputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class nsIterator
    implements Iterator {
        private String _prefix;
        private String _curkey;
        private String _last;
        private int _group;
        private int _root;
        private boolean _ignoreCase;

        nsIterator(String string, int n, int n2, boolean bl) {
            this(string, string, n, n2, bl);
        }

        nsIterator(String string, String string2, int n, int n2, boolean bl) {
            this._prefix = string;
            this._curkey = string2;
            this._group = n;
            this._root = n2;
            this._ignoreCase = bl;
            if (bl) {
                StorageFile.ra$_pc(StorageFile.this).startTrans();
                this._last = this.getNextIgnoreCase(StorageFile.ra$_pc(StorageFile.this), this._group, this._root, this._curkey);
                StorageFile.ra$_pc(StorageFile.this).endTrans();
                if (this.keyBad(this._last)) {
                    this._last = null;
                }
            }
        }

        protected String getNext(BPageCache bPageCache, int n, int n2, String string) {
            return Page.getNextEntry(bPageCache, n, n2, string);
        }

        protected String getNextIgnoreCase(BPageCache bPageCache, int n, int n2, String string) {
            return Page.getNextEntryIgnoreCase(bPageCache, n, n2, string);
        }

        private boolean keyBad(String string) {
            return this._ignoreCase ? string != null && (this._prefix.length() > string.length() || this._prefix.compareToIgnoreCase(string.substring(0, this._prefix.length())) != 0) : string != null && !string.startsWith(this._prefix);
        }

        public boolean hasNext() {
            if (this._curkey == null) {
                return false;
            }
            StorageFile.ra$_pc(StorageFile.this).startTrans();
            this._last = this.getNext(StorageFile.ra$_pc(StorageFile.this), this._group, this._root, this._curkey);
            StorageFile.ra$_pc(StorageFile.this).endTrans();
            if (this.keyBad(this._last)) {
                this._last = null;
            }
            return this._last != null;
        }

        public Object next() {
            if (this._curkey == null) {
                return null;
            }
            if (this._last != null) {
                this._curkey = this._last;
            } else {
                StorageFile.ra$_pc(StorageFile.this).startTrans();
                this._curkey = this.getNext(StorageFile.ra$_pc(StorageFile.this), this._group, this._root, this._curkey);
                StorageFile.ra$_pc(StorageFile.this).endTrans();
            }
            this._last = null;
            if (this.keyBad(this._curkey)) {
                this._curkey = null;
            }
            return this._curkey;
        }

        public void remove() {
        }
    }

    class nsReverseIterator
    extends nsIterator {
        nsReverseIterator(String string, int n, int n2, boolean bl) {
            super(string, string + "\u20000", n, n2, bl);
        }

        protected String getNext(BPageCache bPageCache, int n, int n2, String string) {
            return Page.getPreviousEntry(bPageCache, n, n2, string);
        }

        protected String getNextIgnoreCase(BPageCache bPageCache, int n, int n2, String string) {
            return Page.getPreviousEntryIgnoreCase(bPageCache, n, n2, string);
        }
    }
}

