/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.persistence;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import oracle.ide.persistence.CrossIndex;
import oracle.ide.persistence.NameSpace;
import oracle.ide.persistence.UniqueIdFactory;

public class Tests {
    static void dumpFile(String string) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            String string2 = bufferedReader.readLine();
            int n = 0;
            while (string2 != null) {
                System.out.println(n++ + " : " + string2);
                string2 = bufferedReader.readLine();
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static void loadTestFile(String string) {
        try {
            NameSpace nameSpace = null;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            String string2 = bufferedReader.readLine();
            int n = 0;
            byte[] byArray = new byte[1];
            while (string2 != null) {
                String string3;
                if (string2.startsWith("+++")) {
                    int n2 = string2.lastIndexOf(92);
                    if (n2 == -1) {
                        n2 = 3;
                    }
                    String string4 = "LIB:" + string2.substring(n2 + 1);
                    nameSpace = NameSpace.getNameSpace(string4);
                    System.out.println("NameSpace created for " + string4);
                } else if (string2.startsWith("---")) {
                    System.out.println("NameSpace flushed " + n + " elements");
                    n = 0;
                    nameSpace.flush();
                } else if (string2.endsWith(".class") && (string3 = string2.substring(0, string2.length() - 6)).indexOf(36) == -1) {
                    string3 = string3.replace('/', '.');
                    int n3 = string3.lastIndexOf(46);
                    String string5 = "";
                    String string6 = string3;
                    if (n3 != -1) {
                        string5 = string3.substring(0, n3);
                        string6 = string3.substring(n3 + 1);
                    }
                    nameSpace.putRecord(string5 + "|" + string6, byArray);
                    nameSpace.putRecord("@" + string6 + "@" + string5, null);
                    ++n;
                }
                string2 = bufferedReader.readLine();
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static void recAdd(String string, CrossIndex crossIndex, String string2) {
        File file = new File(string2);
        String[] stringArray = file.list();
        if (stringArray != null) {
            long l = System.currentTimeMillis();
            int n = 0;
            while (n < stringArray.length) {
                if (!stringArray[n].startsWith(".")) {
                    Tests.recAdd(string, crossIndex, string2 + File.separatorChar + stringArray[n]);
                }
                ++n;
            }
            System.out.println(string + string2 + " parsed in " + (System.currentTimeMillis() - l) + " ms");
        } else if (string2.endsWith(".java")) {
            crossIndex.parseFile(string2);
        }
    }

    static void test2(String string, String string2) {
        long l = System.currentTimeMillis();
        CrossIndex crossIndex = new CrossIndex("TCI", string);
        Tests.recAdd("", crossIndex, string2);
        crossIndex.flush();
        System.out.println(" Total time " + (System.currentTimeMillis() - l) + " ms");
    }

    static void recAddDir(String string, CrossIndex crossIndex, String string2) {
        File file = new File(string2);
        String[] stringArray = file.list();
        if (stringArray != null) {
            long l = System.currentTimeMillis();
            crossIndex.parseDirectory(string2);
            string = string + "  ";
            int n = 0;
            while (n < stringArray.length) {
                Tests.recAddDir(string, crossIndex, string2 + File.separatorChar + stringArray[n]);
                ++n;
            }
            System.out.println(string + string2 + " parsed in " + (System.currentTimeMillis() - l) + " ms");
        }
    }

    static void testDirect(String string) {
        long l = System.currentTimeMillis();
        CrossIndex crossIndex = new CrossIndex("TCI", "TCI");
        Tests.recAddDir("", crossIndex, string);
        crossIndex.flush();
        System.out.println(" Total time " + (System.currentTimeMillis() - l) + " ms");
    }

    static void look(String string, String string2) {
        CrossIndex crossIndex = new CrossIndex("TCI", string2);
        crossIndex.printKeyRef(string);
        crossIndex.flush();
    }

    static void test3(String string) {
        System.out.println("Checking UID for " + string);
        UniqueIdFactory uniqueIdFactory = new UniqueIdFactory("testUID", '|');
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                String string3 = uniqueIdFactory.getUID(string2);
                System.out.println("[" + string2 + "] = [" + string3 + "]");
                string2 = bufferedReader.readLine();
            }
            uniqueIdFactory.flush();
            bufferedReader.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

