/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.persistence;

import java.util.Iterator;
import oracle.ide.persistence.NameSpace;
import oracle.ide.persistence.Tests;

public class Tools {
    static boolean isStorage = false;
    static NameSpace curNS;

    static void openStorageFile(String string) {
        isStorage = NameSpace.setStorage(string);
        if (!isStorage) {
            System.out.println("Can't open storage file " + string);
        } else {
            System.out.println("Storage file " + string + " opened");
        }
    }

    static void setNameSpace(String string) {
        if (isStorage) {
            curNS = NameSpace.getNameSpace(string);
            System.out.println("NameSpace " + string + " opened");
        } else {
            System.out.println("Can't get NameSpace " + string + " without storage file set");
        }
    }

    static void deleteNameSpace(String string) {
        if (isStorage) {
            NameSpace.deleteNameSpace(string);
            System.out.println("NameSpace " + string + " deleted");
        } else {
            System.out.println("Can't delete NameSpace " + string + " without storage file set");
        }
    }

    static void listNameSpaceName(String string, boolean bl) {
        if (isStorage) {
            Iterator iterator = bl ? NameSpace.getNameSpaceIterator(string) : NameSpace.getReverseNameSpaceIterator(string);
            System.out.println("NameSpace list (" + string + ")");
            int n = 0;
            while (iterator.hasNext()) {
                System.out.println("  " + iterator.next());
                ++n;
            }
            System.out.println(n + " NameSpaces");
        } else {
            System.out.println("Can't list NameSpace without storage file set");
        }
    }

    static void printTree() {
        if (isStorage) {
            if (curNS != null) {
                curNS.printTree();
            } else {
                System.out.println("Can't dump NameSpace keys without NameSpace set");
            }
        } else {
            System.out.println("Can't dump NameSpace keys without storage file set");
        }
    }

    static void listNameSpace(String string, boolean bl) {
        if (isStorage) {
            if (curNS != null) {
                Iterator iterator = bl ? curNS.getKeyIterator(string) : curNS.getReverseKeyIterator(string);
                System.out.println("NameSpace key list (" + string + ")");
                int n = 0;
                while (iterator.hasNext()) {
                    System.out.println("  " + iterator.next());
                    ++n;
                }
                System.out.println(n + " Keys");
            } else {
                System.out.println("Can't list NameSpace keys without NameSpace set");
            }
        } else {
            System.out.println("Can't list NameSpace keys without storage file set");
        }
    }

    static void addKey(String string, String string2) {
        if (isStorage) {
            if (curNS != null) {
                if (string2.equals("")) {
                    curNS.putRecord(string, null);
                } else {
                    curNS.putRecord(string, string2.getBytes());
                }
                System.out.println("Added key (" + string + ") = (" + string2 + ")");
            } else {
                System.out.println("Can't add keys without NameSpace set");
            }
        } else {
            System.out.println("Can't add keys without storage file set");
        }
    }

    static void dumpKey(String string) {
        if (isStorage) {
            if (curNS != null) {
                byte[] byArray = curNS.getRecord(string);
                if (byArray == null) {
                    System.out.println("Key (" + string + ") not found");
                } else {
                    System.out.print("Dumping key (" + string + ")");
                    int n = 0;
                    while (n < byArray.length) {
                        if (n % 32 == 0) {
                            System.out.println();
                        }
                        System.out.print(Integer.toHexString((0xFF & byArray[n]) + 256).substring(1) + " ");
                        ++n;
                    }
                }
            } else {
                System.out.println("Can't add keys without NameSpace set");
            }
        } else {
            System.out.println("Can't add keys without storage file set");
        }
    }

    static void flush() {
        if (isStorage) {
            if (curNS != null) {
                curNS.flush();
                System.out.println("NameSpace flushed");
            } else {
                System.out.println("Can't flush without NameSpace set");
            }
        } else {
            System.out.println("Can't flush without storage file set");
        }
    }

    public static void main(String[] stringArray) {
        System.out.println("Persistence system check tool");
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equalsIgnoreCase("-setfile")) {
                int n2 = ++n;
                ++n;
                Tools.openStorageFile(stringArray[n2]);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("-test")) {
                System.out.println("DUHH !!!");
                int n3 = ++n;
                int n4 = ++n;
                ++n;
                Tests.test2(stringArray[n3], stringArray[n4]);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("-look")) {
                System.out.println("DUHH !!!");
                int n5 = ++n;
                int n6 = ++n;
                ++n;
                Tests.look(stringArray[n5], stringArray[n6]);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("-listns")) {
                int n7 = ++n;
                ++n;
                Tools.listNameSpaceName(stringArray[n7], true);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("-rlistns")) {
                int n8 = ++n;
                ++n;
                Tools.listNameSpaceName(stringArray[n8], false);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("-list")) {
                int n9 = ++n;
                ++n;
                Tools.listNameSpace(stringArray[n9], true);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("-rlist")) {
                int n10 = ++n;
                ++n;
                Tools.listNameSpace(stringArray[n10], false);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("-setns")) {
                int n11 = ++n;
                ++n;
                Tools.setNameSpace(stringArray[n11]);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("-delns")) {
                int n12 = ++n;
                ++n;
                Tools.deleteNameSpace(stringArray[n12]);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("-addkey")) {
                int n13 = ++n;
                int n14 = ++n;
                ++n;
                Tools.addKey(stringArray[n13], stringArray[n14]);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("-dumpkey")) {
                int n15 = ++n;
                ++n;
                Tools.dumpKey(stringArray[n15]);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("-flush")) {
                ++n;
                Tools.flush();
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("-dumptree")) {
                ++n;
                Tools.printTree();
                continue;
            }
            if (!stringArray[n].equalsIgnoreCase("-?")) {
                System.out.println("Unknown arg : " + stringArray[n]);
            }
            System.out.println("Syntax :");
            System.out.println("  -setfile NAME    : Set storage file");
            System.out.println("  -(r)listNS  NAME : List nameSpaces names in current storage file (use \"\" as name to get all of them");
            System.out.println("  -setNS   NAME    : Set current NameSpace");
            System.out.println("  -delNS   NAME    : Delete NameSpace");
            System.out.println("  -(r)list    NAME : List all keys in current nameSpace (use \"\" as name to get all of them");
            ++n;
        }
    }
}

