/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.persistence;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.util.Iterator;
import oracle.ide.persistence.NameSpace;

public class UniqueIdFactory {
    private NameSpace _directNS;
    private NameSpace _reverseNS;
    private int curLastID;
    private char _sep;
    private static final String BASEDIGITS = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ,.<>?;':[]{}-=_+`~";

    public UniqueIdFactory(String string, char c) {
        this._sep = c;
        this._directNS = NameSpace.getNameSpace(string + "_D");
        this._reverseNS = NameSpace.getNameSpace(string + "_R");
        try {
            InputStream inputStream = this._directNS.getRecordStream("" + this._sep + this._sep + this._sep);
            if (inputStream != null) {
                DataInputStream dataInputStream = new DataInputStream(inputStream);
                this.curLastID = dataInputStream.readInt();
            } else {
                System.out.println("LastID not found, cleaning ...");
                NameSpace.deleteNameSpace(string + "_D");
                NameSpace.deleteNameSpace(string + "_R");
                this._directNS = NameSpace.getNameSpace(string + "_D");
                this._reverseNS = NameSpace.getNameSpace(string + "_R");
                this.curLastID = 1;
                this.updateLastID();
                this.flush();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void flush() {
        System.out.println("Flushing UID system");
        this.updateLastID();
        this._directNS.flush();
        this._reverseNS.flush();
    }

    private void updateLastID() {
        try {
            System.out.println("Saving lastID " + this.curLastID);
            DataOutputStream dataOutputStream = new DataOutputStream(this._directNS.putRecordStream("" + this._sep + this._sep + this._sep));
            dataOutputStream.writeInt(this.curLastID);
            dataOutputStream.flush();
            dataOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private String getNewUID() {
        int n = this.curLastID++;
        StringBuffer stringBuffer = new StringBuffer(15);
        int n2 = BASEDIGITS.length();
        while (n != 0) {
            stringBuffer.append(BASEDIGITS.charAt(n % n2));
            n /= n2;
        }
        return stringBuffer.toString();
    }

    public String getUID(String string) {
        String string2;
        Iterator iterator = this._directNS.getKeyIterator(string + this._sep);
        if (iterator.hasNext()) {
            string2 = (String)iterator.next();
            string2 = string2.substring(string2.lastIndexOf(this._sep) + 1);
        } else {
            string2 = this.getNewUID();
            this._directNS.putRecord(string + this._sep + string2, null);
            this._reverseNS.putRecord(string2 + this._sep + string, null);
        }
        return string2;
    }

    public String keyFromUID(String string) {
        String string2;
        Iterator iterator = this._reverseNS.getKeyIterator(string + this._sep);
        if (iterator.hasNext()) {
            string2 = (String)iterator.next();
            string2 = string2.substring(string2.lastIndexOf(this._sep) + 1);
        } else {
            string2 = null;
        }
        return string2;
    }
}

